#include	<stdio.h>
/*
 *	entab [infile [outfile] ]
 *		This program replaces all suitable strings of blanks by tabs
 *		in infile placing result in outfile.
 *		May be used as a filter.
 *		also see 'detab'
 */
#define	EOLN	'\n'
#define	CR	'\r'
#define	FF	'\f'
#define	TAB	'\t'
#define	BS	'\b'

FILE	*iptr, *optr;

main(argc, argv)
char *argv[];
{
	register int c, icol, ocol;

	if(argc > 3)
	{
		fprintf(stderr, "Usage: entab [ infile [ outfile ] ]\n");
		return 1;
	}
	if(argc > 1)
	{
		if((iptr = fopen(argv[1], "r")) == NULL)
		{
			perror( argv[1] );
			return 1;
		}
	}
	else
	{
		iptr = stdin;	/* use standard inputc */
	}
	if(argc > 2)
	{
		if((optr = fopen(argv[2], "w")) == NULL)
		{
			perror( argv[2] );
			return 1;
		}
	}
	else
	{
		optr = stdout;	/* use standard outputc */
	}
	/* here beginneth the program */ 

	icol = ocol = 0;
	while((c = getc(iptr)) != EOF)
	{
		switch(c)
		{
		case EOLN:
		case CR:
		case FF:
			putc(c, optr);
			icol = ocol = 0;
			break;
		case ' ':
			icol++;
			break;
		case TAB:
			icol = (icol+8)&~07;
			break;
		default:
			while(((ocol+8)&~07) <= icol && ocol+1 != icol)
			{
				putc(TAB, optr);
				ocol = (ocol+8)&~07;
			}
			while(ocol < icol)
			{
				putc(' ', optr);
				ocol++;
			}
			putc(c, optr);
			if(c == BS)
			{
				icol--;
				ocol--;
			}
			else
			{
				icol++;
				ocol++;
			}
		}
	}
	fflush(optr);
	return 0;
}
