/*
 *
 *	UNIX debugger
 *
 */

#include "defs.h"


char		NOFORK[];
char		ENDPCS[];
char		BADWAIT[];

char		*lp;
int		sigint;
int		sigqit;

/*
 * breakpoints
 */
struct bkpt	*bkpthead;

struct reglist	reglist[];

char		lastc;
unsigned	corhdr[];
unsigned	*endhdr;

int		fcor;
int		fsym;
char		*errflg;
int		errno;
int		signo;

long int	dot;
char		*symfil;
int		wtflag;
int		pid;
long int	expv;
int		adrflg;
long int	loopcnt;


/*
 * service routines for sub process control
 */
getsig(sig)
{
	return(expr(0) ? shorten(expv) : sig);
}

int		userpc = 1;

runpcs(runmode, execsig)
{
	int rc;
	register struct bkpt *bkpt;

	if (adrflg)
		userpc = shorten(dot);
	setbp();
	printf("%s: running\n", symfil);
	while (loopcnt-- > 0)
	{
#ifdef DEBUG
		printf("\ncontinue %d %d\n", userpc, execsig);
#endif
		stty(0, &usrtty);
		ptrace(runmode, pid, userpc, execsig);
		bpwait();
		chkerr();
		readregs();
		/*
		 * look for bkpt
		 */
		if (signo == 0 && (bkpt = scanbkpt(endhdr[pc] - 2)))
		{			/* stopped at bkpt */
			userpc = endhdr[pc] = bkpt->loc;
			if (bkpt->flag == BKPTEXEC ||
			    ((bkpt->flag = BKPTEXEC, command(bkpt->comm, ':')) && --bkpt->count))
			{
				execbkpt(bkpt);
				execsig = 0;
				loopcnt++;
				userpc = 1;
			}
			else
			{
				bkpt->count = bkpt->initcnt;
				rc = 1;
			}
		}
		else
		{
			rc = 0;
			execsig = signo;
			userpc = 1;
		}
	}
	return(rc);
}

endpcs()
{
	register struct bkpt *bkptr;

	if (pid)
	{
		ptrace(EXIT, pid, 0, 0);
		pid = 0;
		userpc = 1;
		for (bkptr = bkpthead; bkptr; bkptr = bkptr->nxtbkpt)
			if (bkptr->flag)
				bkptr->flag = BKPTSET;
	}
}

setup()
{
	close(fsym);
	fsym = -1;
	if ((pid = fork()) == 0)
	{
		ptrace(SETTRC, 0, 0, 0);
		signal(SIGINT, sigint);
		signal(SIGQUIT, sigqit);
		doexec();
		exit(0);
	}
	else if (pid == -1)
		error(NOFORK);
	else
	{
		bpwait();
		readregs();
		lp[0] = EOR;
		lp[1] = 0;
		fsym = open(symfil, wtflag);
		if (errflg)
		{
			printf("%s: cannot execute\n", symfil);
			endpcs();
			error(0);
		}
	}
}

execbkpt(bkptr)
struct bkpt *bkptr;
{
	int bkptloc;

#ifdef DEBUG
	printf("exbkpt: %d\n", bkptr->count);
#endif
	bkptloc = bkptr->loc;
	ptrace(WIUSER, pid, bkptloc, bkptr->ins);
	stty(0, &usrtty);
	ptrace(SINGLE, pid, bkptloc, 0);
	bpwait();
	chkerr();
	ptrace(WIUSER, pid, bkptloc, BPT);
	bkptr->flag = BKPTSET;
}

doexec()
{
	char *argl[MAXARG];
	char args[LINSIZ];
	char *p, **ap, *filnam;

	ap = argl;
	p = args;
	*ap++ = symfil;
	do
	{
		if (rdc() == EOR)
			break;
		*ap = p;
		while (lastc != EOR && lastc != SP && lastc != TB)
		{
			*p++ = lastc;
			readchar();
		}
		*p++ = 0;
		filnam = *ap + 1;
		if (**ap == '<')
		{
			close(0);
			if (open(filnam, 0) < 0)
			{
				printf("%s: cannot open\n", filnam);
				exit(0);
			}
		}
		else if (**ap == '>')
		{
			close(1);
			if (creat(filnam, 0660) < 0)
			{
				printf("%s: cannot create\n", filnam);
				exit(0);
			}
		}
		else
			ap++;
	} while (lastc != EOR);
	*ap++ = 0;
	execv(symfil, argl);
}

struct bkpt *
scanbkpt(adr)
{
	register struct bkpt *bkptr;

	for (bkptr = bkpthead; bkptr; bkptr = bkptr->nxtbkpt)
		if (bkptr->flag && bkptr->loc == adr)
			break;
	return(bkptr);
}

delbp()
{
	register int a;
	register struct bkpt *bkptr;

	for (bkptr = bkpthead; bkptr; bkptr = bkptr->nxtbkpt)
	{
		if (bkptr->flag)
		{
			a = bkptr->loc;
			ptrace(WIUSER, pid, a, bkptr->ins);
		}
	}
}

setbp()
{
	register int a;
	register struct bkpt *bkptr;

	for (bkptr = bkpthead; bkptr; bkptr = bkptr->nxtbkpt)
	{
		if (bkptr->flag)
		{
			a = bkptr->loc;
			bkptr->ins = ptrace(RIUSER, pid, a, 0);
			ptrace(WIUSER, pid, a, BPT);
			if (errno)
			{
				prints("cannot set breakpoint: ");
				psymoff(leng(bkptr->loc), ISYM, "\n");
			}
		}
	}
}

bpwait()
{
	register int w;
	int stat;

	signal(SIGINT, 1);
	while ((w = wait(&stat)) != pid && w != -1);
	signal(SIGINT, sigint);
	gtty(0, &usrtty);
	stty(0, &adbtty);
	if (w == -1)
	{
		pid = 0;
		errflg = BADWAIT;
	}
	else if ((stat & 0177) != 0177)
	{
		if (signo = stat & 0177)
			sigprint();
		if (stat & 0200)
		{
			prints(" - core dumped");
			close(fcor);
			setcor();
		}
		pid = 0;
		errflg = ENDPCS;
	}
	else
	{
		signo = stat >> 8;
		if (signo != SIGTRAP)
			sigprint();
		else
			signo = 0;
		flushbuf();
	}
}

/*
 * get register values from pcs
 */
readregs()
{
	register i;
	register int *ip0, *ip1;

	for (i = 0; i < 9; i++)
		endhdr[reglist[i].roffs] = ptrace(RUREGS, pid, 2 * (512 + reglist[i].roffs), 0);
	ip0 = &(0->u_fps);
	ip1 = &corhdr[0].u_fps;
	for (i = 0; i < 25; i++)
		*ip1++ = ptrace(RUREGS, pid, ip0++, 0);
}
