/*
**	netstop [-a] [-qhostname] [lname]
**
**	Stop file queued for transmission
**
**		default:	stop first job found owned by user
**		-a		stop all jobs owned by user
**		-qhostname	stop user's job on queue hostname
**		-a -qhostname	stop all user's jobs on queue hostname
**		lname		set user under consideration
**
**	Bugs and comments to:	Piers Lauder
**				Dept of Comp Sci
**				Sydney University
**	January '81.
*/


#include	<local-system>
#ifdef	Aus2
#include	<types.h>
#include	<dir.h>
#include	<stat.h>
#endif	Aus2
#ifdef	Aus1
#include	<stat16.h>
#include	<dir.h>
#endif	Aus1
#include	<passwd.h>
#include	<signal.h>
#include	<stdio.h>
#include	<sgtty.h>
#ifdef	Aus1
#include	"lvl7.h"
#endif	Aus1
#include	"net.h"
#include	"neth.h"


#define		NETS		10		/* maximum hosts expected */

char		spooldir[]	= SPOOLDIR;
char *		netdir;
char		lockfile[HOSTSIZE+(DIRSIZ+1)];
struct lock	lock;

struct
{
	ino_t	nd_ino;
	char	nd_name[HOSTSIZE];
}
		netdirs[NETS];
short		nets;

short		ffound;
uid_t		uid;
char		all;
char *		name;
struct pwent	p;

extern char *	strncat();
extern char *	strcat();
extern char *	strncpy();
extern char *	strcpy();
extern long	atol();

#define		dots(A)		(A[0]=='.'&&(A[1]==0||(A[1]=='.'&&A[2]==0)))



main(argc, argv)
	register int	argc;
	register char *	argv[];
{
	register	i;

	name = *argv;

	if ( chdir(spooldir) == SYSERROR )
		neterror("\"chdir\" error - %s", spooldir);

	uid = getuid();

	while ( --argc )
		if ( **++argv == '-' )
		{
			switch ( (*argv)[1] )
			{
			 case 'a':
				all++;
				break;

			 case 'h':	/* alt. for 'q' */
			 case 'q':
				if ( nets >= NETS )
					neterror("too many hosts!");
				strncpy(netdirs[nets].nd_name, &(*argv)[2], DIRSIZ);
				if ( access(netdirs[nets].nd_name, 0) == SYSERROR )
					neterror("unrecognised host \"%s\"", netdirs[nets].nd_name);
				else
					nets++;
				break;

			 default:
				neterror("unrecognised flag '%c'", (*argv)[1]);
			}
		}
		else
		{
			if ( uid )
				neterror("No permission.");

			p.pw_strings[LNAME] = *argv;

			if ( getpwuid(&p, (char *)0, 0) == PWERROR )
				neterror("who?");
			else
				uid = p.pw_uid;
		}

	if ( nets == 0 && findnets("", 1) == 0 )
		neterror("no hosts found");

	for ( i = 0 ; i < nets ; i++ )
	{
		netdir = netdirs[i].nd_name;

		strncat(strncpy(lockfile, netdir, DIRSIZ), LOCKFILE, DIRSIZ);

		if ( access(lockfile, 0) != SYSERROR )
			rdlkfile();
		
		if ( chdir(netdir) == SYSERROR )
			perror(netdir);
		else
		{
			searchqueue();
			chdir(spooldir);
		}
	}

	if ( !ffound )
	{
		fprintf(stderr, "Nothing spooled!\n");
		return 1;
	}

	return 0;
}




/*
**	Fatal error exit
*/

/*VARARGS1*/

neterror(s, a)
	char *		s;
	char *		a;
{
	extern		errno;

	fprintf(stderr, "%s: ", name);
	fprintf(stderr, s, a);
	if ( errno )
		perror(" ");
	fprintf(stderr, "\nUsage: \"%s [-a] [-qhostname] [lname]\"\n", name);
	exit(1);
}



/*
**	Search spooldir for network directories
*/

findnets(path, level)
	char *		path;
	int		level;
{
	register FILE *	fd;
	register	found = 0;

	if ( (fd = fopen(".", "r")) == NULL )
		perror(spooldir);
	else
	{
		struct direct	dir;

		while ( fread((char *)&dir, sizeof dir, 1, fd) == 1 )
			if ( dir.d_ino && dir.d_name[0] != '~' && !dots(dir.d_name) )
			{
				register	i;

				for ( i = 0 ; i < nets ; i++ )
					if ( netdirs[i].nd_ino == dir.d_ino )
						break;
				if ( i == nets )
				{
#					ifdef	Aus2
					struct stat	dstat;
#					endif	Aus2
#					ifdef	Aus1
					struct statbuf	dstat;
#					endif	Aus1
					char		d[DIRSIZ+1];

					strncpy(d, dir.d_name, DIRSIZ);
					d[DIRSIZ] = '\0';

					if ( stat(d, &dstat) != SYSERROR
						&& (dstat.st_mode & S_IFMT) == S_IFDIR
						&& nets < NETS
					   )
					{
						if ( level < HLEVELS )
							if ( chdir(d) != SYSERROR )
							{
								char	p[HOSTSIZE];

								if ( access(LOCKFILE, 0) == SYSERROR )
									i = findnets(strcat(strcat(strcpy(p, path), d), "/"), level+1);
								else
									i = 0;
								chdir("..");
								if ( i )
								{
									found += i;
									continue;
								}
							}
						strcat(strcpy(netdirs[nets].nd_name, path), d);
						netdirs[nets].nd_ino = dir.d_ino;
						nets++;
						found++;
					}
				}
			}

		fclose(fd);
	}

	return found;
}



/*
**	Read lockfile
*/

rdlkfile()
{
	register FILE *	fd;

	if ( (fd = fopen(lockfile, "r")) == NULL
		|| fread((char *)&lock, sizeof lock, 1, fd) != 1
	   )
	{
		lock.lk_file[0] = '\0';

		if ( fd != NULL )
			fclose(fd);
	}
	else
		fclose(fd);
}




/*
**	Search queue directory for user's jobs
*/

searchqueue()
{
	register FILE *	fd;

	if ( (fd = fopen(".", "r")) == NULL )
		perror(netdir);
	else
	{
		struct direct	dir;

		while ( fread((char *)&dir, sizeof dir, 1, fd) == 1 )
			if ( dir.d_ino && dir.d_name[0] != '.' )
			{
				register FILE *	efd;
				char		efile[DIRSIZ+1];

				strncpy(efile, dir.d_name, DIRSIZ);
				efile[DIRSIZ] = '\0';

				if ( (efd = fopen(efile, "r+")) != NULL )
				{
					if ( ok(efd) )
					{
						rewind(efd);
						putc(NC_NOGO, efd);
						if ( strncmp(efile, lock.lk_file, sizeof lock.lk_file) == 0 )
							kill(lock.lk_pid, NS_STOP);

						if ( !all )
						{
							fclose(efd);
							break;
						}
					}
					fclose(efd);
				}
				else
					perror(efile);
			}

		fclose(fd);
	}
}


/*
**	Check that file described by spool commands is ok
*/

int
ok(fd)
	FILE *		fd;
{
	struct netr	netrec;
	char		netlname[NETDATASIZE+1];
	char		netname[NETDATASIZE+1];
	char		nethost[NETDATASIZE+1];
	char		message[NETDATASIZE+1];
	long		netsize;
	register char *	type;
	register	c;
	register	val;

	netlname[0] = '\0';
	netname[0] = '\0';
	nethost[0] = '\0';
	netsize = 0;
	type = "Unknown";

	while ( fread((char *)&netrec, sizeof netrec, 1, fd) == 1 )
		switch ( netrec.nr_flag )
		{
		 case NC_NOGO:
			return 0;

		 case NC_MAIL:	type = "Mail";	break;
		 case NC_FILE:	type = "File";	break;
		 case NC_PRINT:	type = "Print";	break;
		 case NC_HSTUP:	type = "Host up";	break;
		 case NC_HSTDN:	type = "Host down";	break;
		 case NC_REMOVE:type = "Host remove";	break;
		 case NC_STATE:	type = "Net state";	break;

		 case NC_UID:
			if ( (uid_t)atoi(netrec.nr_data) != uid )
				return 0;
			break;

		 case NC_LNAME:
			strncpy(netlname, netrec.nr_data, NETDATASIZE);
			break;

		 case NC_NAME:
			strncpy(netname, netrec.nr_data, NETDATASIZE);
			break;

		 case NC_HOST:
			strncpy(nethost, netrec.nr_data, NETDATASIZE);
			break;

		 case NC_SIZE:
			netsize = atol(netrec.nr_data);
			break;

		 case NC_MESSAGE:
			strncpy(message, netrec.nr_data, NETDATASIZE);
			type = message;
			break;
		}

	printf("%9s from %-8.8s for %-8.8s at %-10.*s %6ld bytes (y or n) ? "
			,type
			,netlname
			,netname
			,HOSTSIZE
			,nethost
			,netsize
		);

	val = (c = getc(stdin)) == 'y';
	while ( c != '\n' )
		c = getc(stdin);

	ffound++;

	return val;
}
