/*
 *	prstop/restart - stop or restart the currently printing job
 *
 *	should be setuid to root
 */

#include	<signal.h>
#include	<sgtty.h>
#include	<printers.h>

struct lpdlock lpdlock;
struct printer *prp;

char lock[] = "lock0";
#define	LPOSN	4

main(ac, av)
char **av;
{
	register i;

	if (ac == 2)
	{
		if ((i = av[1][0]) == '-')
			i = av[1][1];		/* skip leading '-' */
		for (prp = printer; prp < &printer[NPRINTERS]; prp++)
			if (prp->ident == i)
				break;
		if (prp == &printer[NPRINTERS])
		{
			prints("Illegal printer number\n");
			exit(1);
		}
		lock[LPOSN] = i;
		ac--;
	}
#ifdef	PR_DFLT
	else prp = &printer[PR_DFLT];
#else
	else
	{
		prints("Usage: ");
		if (av[0][0] == 'p')
			prints("prstop");
		else
			prints("restart");
		prints(" [printer-number]\n");
		exit(1);
	}
#endif
	if (chdir(LPDDIR) == -1)
	{
		prints("lpd directory screwed\n");
		exit(1);
	}
	if ((i = open(lock, 0)) == -1 || read(i, &lpdlock, sizeof lpdlock) != sizeof lpdlock)
	{
		prints("Can't read lock file\n");
		exit(1);
	}
	if (lpdlock.lpd_state == IDLE)
	{
		prints("Printer inactive\n");
		exit(1);
	}
	i = getuid();
	if (lpdlock.lpd_uid != i && i != 0)
	{
		prints("Permission denied\n");
		exit(1);
	}
	if (av[0][0] == 'p')
		i = kill(lpdlock.lpd_pid, SIGSTOP);
	else
		i = kill(lpdlock.lpd_pid, SIGRESTART);
	if (i == -1)
	{
		prints("Unable to signal lpd\n");
		exit(1);
	}
	exit(0);
}

prints(s)
char *s;
{
	write(2, s, strlen(s));
}
