/	SUBTITLE	b-start.s	the intialization routine
/	Written by Steven Hardy on 29 April 1976
/
	.text
etext:
	.data				/ this all goes in the data division (to become part of the heap)
	estart-.
fstart:
	ksfunction
	br	start
	false
	false
	rts	pc
start:
	mov	$end+2,r5		/ set user stack pointer
	mov	$heap+2,bhplo		/ set bottom of heap
	mov	$heap+2,bhphi		/ and top of heap
	add	$75,r5			/ move r5 to real top of space
	bic	$77,r5
	mov	r5,br5hi		/ set top of user stack
	mov	$1,r4			/ initialize r4
	mov	sp,bsphi		/ set top of system stack
	mov	$2*ozone,br5zn		/ set safe stack zone
	mov	br5hi,br5lo
	sub	br5zn,br5lo		/ set bottom of user stack
	mov	$ospyellow,bsplo	/ set bottom of auxiliary stack
	sys	44.;btime;2;0;2		/ set clock ticking
	sys	signal; 13.; 1		/ keep control on write on broken pipe
	.if	real
	sys	signal; 4; fptrap	/ activate real simulator
	setd
	.endif
	mov	$fsetpop,-(sp)		/ make out we are already in a call of setpop
	clr	r0			/ find out if standard input is a teletype
	sys	gtty; bgtty		/ get teletype charactersistics
	bcs	1f			/ br on error
	inc	bfrmtt			/ set 'from teletype` flag
	br	2f
1:
2:
	mov	r4,r0			/ is output a tty?
	sys	gtty; bgtty
	bcs	1f			/ br if not
	bit	$4,bgtty+4		/ upper case only?
	beq	2f			/ br if not
	mov	$true,pupcase		/ set 'upper case obly flag to be true'
	br	3f
1:
	clr	btott			/ clear 'to eteleype flag`
	inc	bttcnl			/ set tty output channel to 2 (diagnostic)
2:
	cmpb	bgtty,$7		/ is speed 30cps?
	bne	3f			/ br if not
	add	$2*30.,poutmx		/ assume we are on the DEcwriter and increase paper width flag
	add	$2*30.,poutlw
3:
	sys	signal; 10.; ssgbus	/ set bus error trap
	sys	signal; 11.; ssgmem	/ segmentation trap
	sys	signal; 2; ssgint	/ set interrupt trap
	bit	r4,r0			/ were interrupts being ignored?
	beq	1f			/ br if not
	mov	$fidentfn,winterrupt	/ set interrupt function to be identfn
1:
	mov	$wordslo+2,pvar1	/ set up to insert words into dictionary
1:
	cmp	pvar1,$wordshi+2	/ any more?
	beq	2f			/ br if not
	mov	pvar1,-(r5)		/ push next word
	jsr	pc,scwinsert		/ insert it
	add	$10.,pvar1		/ updater pvar1
	br	1b
2:
	jsr	pc,sarglist		/ get arglist
	mov	(r5)+,parglist		/ set arglist
	sys	open; clibfl; 0		/ open library file
	mov	r0,-(r5)
	mov	$clibfl,-(r5)
	jsr	pc,sdevice
	mov	$nil,-(r5)
	jsr	pc,scnpair
	mov	(r5)+,plblist
	mov	$cintfl,-(r5)		/ 'init.p'
	jsr	pc,sgetfile		/ try and get the file
	cmp	$false,(r5)+		/ succesful?
	beq	1f			/ br if not
	jsr	pc,scompile		/ compile the file
1:
	cmp	parglist,$nil		/ any args?
	beq	3f			/ br if not
	mov	parglist,-(r5)		/ push arglist
	jsr	pc,sdest		/ dest()
	mov	(r5)+,parglist		/ pop tl back to arglist
	mov	(r5),pvar1		/ store in pvar1 as well
	jsr	pc,sgetfile		/ can open file?
	cmp	(r5)+,$false		/ succesful?
	beq	1f			/ br if failed
	jsr	pc,scompile		/ compile file
	br	2f			/ continue processing
1:					/ here if not a file
	mov	pvar1,-(r5)		/ push 'file name'
	mov	$cdotp,-(r5)		/ '.p'
	jsr	pc,sjnstring		/ ><
	jsr	pc,sgetfile		/ try and get it
	cmp	(r5)+,$false		/ okay?
	beq	1f			/ br if not
	jsr	pc,scompile		/ compile it
	br	2f			/ continue processing
1:					/ here if not a file at all
	mov	pvar1,-(r5)		/ push library file name
	jsr	pc,slib			/ get library file
/ here at end of processing command line
2:
	jsr	pc,skill		/ exit()
/ Here if no command line
3:
	tst	bfrmtt			/ input from a teletype?
	beq	1f			/ br if not
	mov	(sp),winterrupt		/ set interrupt function be setpop
	mov	$fprttych,wcucho	/ output to teletype
	mov	$cgreet,-(r5)		/ push '\nSussex POP11 System, version-'
	jsr	pc,sprstring
	mov	pversion,-(r5)
	jsr	pc,spr
	.if	draft
	mov	$cdraft,-(r5)		/ ' (draft)'
	jsr	pc,sprstring
	.endif
1:
	mov	$fstart,bhplo		/ alter low point of heap to include this code
	rts	pc
/
/	This function returns the arguments of the POP11 system
/	as a list.
sarglist:
	mov	bsphi,pvar1		/ pvar points to number of args
	add	$4,pvar1		/ pvar1 points to first (not zeroth) arg.
	mov	$cstack,-(r5)		/ push a stack mark
/ beginning of main loop
1:
	mov	pvar1,r1		/ address of next arg to r1
	add	$2,pvar1		/ update arg pointer
	mov	(r1),r1			/ next arg to r1
	tst	r1			/ is it the last?
					/ was cmp r1,$-1 under Level 6
	beq	3f			/ br if so
	mov	r4,r2			/ count of chars in this arg to r2
/ beginning of inner loop
2:
	movb	(r1)+,r0		/ next byte of this arg to r0
	beq	2f			/ br if done
	asl	r0			/ convert byte to POP11 format
	inc	r0
	mov	r0,-(r5)		/ and push onto stack
	add	$2,r2			/ updater byte count
	br	2b			/ back to beginning of inner loop
/ end of inner loop
2:
	mov	r2,-(r5)		/ push byte count
	jsr	pc,scnstring		/ make a string
	br	1b			/ back to start of main loop
/ end of main loop
3:
	jmp	scnlist			/ make a list of args
estart:
/
	.bss
heap:
	.=.+14300			/ space for heap and user stack
end:
