/	SUBTITLE	c-cmparse.s	Parse to closing bracket
/	Written by Steven Hardy on 24th February 1977
/
/	This function is the 'heart` of the compiler. It compiles
/	text up to the given closing bracket.
/
	ksfunction
fcmparse:
	br	scmparse
	false
	false
exit=.
/ restore local variables
	mov	(sp)+,pexpr		/ is this an expression?
	mov	(sp)+,pclose		/ required closing bracket
	mov	(sp)+,pcnbny		/ a flag (non zero allows unary + and -)
	mov	(sp)+,pmsbop		/ a flag (non zero implies we need an operator)
	mov	(sp)+,popstk		/ a triple-list of operators and their precedences.
	mov	(sp)+,pelbnd		/ a flag (non zero implies we need a label at the end of the current expression)
	mov	(sp)+,pelab		/ an integer (the label to go at the end of the current expression, if necessary)
	rts	pc
scmparse:
/ save local variables
	mov	pelab,-(sp)
	mov	pelbnd,-(sp)
	mov	popstk,-(sp)
	mov	pmsbop,-(sp)
	mov	pcnbny,-(sp)
	mov	pclose,-(sp)
	mov	pexpr,-(sp)
/ bind formal parameters
	mov	(r5)+,pexpr		/ expression or command sequence?
	mov	(r5)+,pclose		/ pop closing bracket to pclose
/ initialize local variables
	jsr	pc,sgnlabel		/ generate unique label
	mov	(r5)+,pelab		/ to go at end of this expression (if necessary)
	clr	pelbnd			/ not needed yet
	mov	$dtrple,popstk		/ initialise operator stack
	inc	pcnbny			/ + or - will be unary
	clr	pmsbop			/ next item needn't be an operator
/ beginning of main loop (execute once per item)
1:
	jsr	pc,srditem		/ read next item
	mov	(r5)+,r0		/ pop to register zero
	mov	r0,pitem		/ and store in variable as well
/ is item the required closing bracket?
	cmp	r0,pclose		/ is item required closing bracket?
	bne	2f			/ br if not
	jsr	pc,scmclear		/ clear operator stack
	cmp	pitem,$termin		/ is item termin?
	bne	exit			/ exit if not
	jsr	pc,sexecute		/ otherwise execute code compiled so far
	br	exit
/ is item an unknown word?
2:
	bit	r4,r0			/ is it an integer?
	jne	4f			/ br if so
	cmp	okey(r0),$kword		/ is it a word?
	jne	4f			/ br if not
	tst	pcnbny			/ is a label allowable?
	beq	2f			/ br if not
	bit	$msyntax,oidentprops(r0)	/ is it a syntax word?
	bne	2f			/ br if so
	jsr	pc,srdpeek		/ but - is it a label
	cmp	(r5)+,$wcolon		/ is next item a ":"?
	bne	2f			/ br if not a label
	jsr	pc,srditem		/ read the colon (for real this time)
	mov	pitem,(r5)		/ replace it on top of stack by current item
	jsr	pc,saslabel		/ ask the assembler to plant a label.
	jbr	1b			/ goto beginning of item loop
/ here if a word but not a label
2:
	mov	pitem,r0		/ rdpeek will have upset r0
	mov	oidentprops(r0),r1		/ get identprops of item to r1
	cmp	r1,r4			/ is the word unknown?
	bne	2f			/ br if not
	mov	r0,-(r5)		/ get valof to force a declaration of the word
	jsr	pc,svalof
	tst	(r5)+			/ we are not really interested in value
	mov	pitem,-(r5)		/ unread the item
	jsr	pc,srdundo
	mov	plitem,pitem		/ reset current item for missing sep error
	br	1b			/ back to start of main loop
/ is the item a bad closing bracket?
2:
	bit	$mcloser,r1		/ is word a closing bracket?
	beq	2f			/ br if not
	mov	r0,-(r5)		/ current item
	mov	pclose,-(r5)		/ required closing bracket
	jsr	pc,serror11		/ shouldn't ever return
/ is the word a separator?
2:
	bit	$mseperator,r1		/ is word a separator?
	beq	2f			/ br if not
	jsr	pc,scmclear		/ clear operator stack
	mov	*pitem,r0		/ get action rotuine of item to r0
	jsr	pc,(r0)			/ apply it
	inc	pcnbny			/ + or - will be unary
	clr	pmsbop			/ needn't be an operator
	jbr	1b			/ back to start of loop
/ is it a missing seperator error?
2:
	tst	pmsbop			/ do we need an operator?
	beq	2f			/ br if not
	bit	$moperator,r1		/ have we got one?
	bne	2f			/ br if so
	mov	plitem,-(r5)		/ last item
	mov	r0,-(r5)		/ this item
	mov	#2012.,-(r5)		/ Error 12, two culprits
	jsr	pc,serror		/ shouldn't ever return
/ have we got an opening bracket?
2:
	bit	$mopener,r1		/ is word an openeing bracket?
	beq	2f			/ br if not
	mov	(r0),r0			/ action routine to r0
	jsr	pc,(r0)			/ apply it
	clr	pcnbny			/ + or - will not be unary
	inc	pmsbop			/ we need an operator
	jbr	1b			/ back to main loop
/ is the word an operator?
2:
	bit	$moperator,r1		/ is item an operator
	beq	3f			/ br if not
	clr	pmsbop			/ next item needn't be an operator
	tst	pcnbny			/ can it be a unary + or - ?
	beq	2f			/ br if not
/ here on (possibly) unary operator
	clr	pcnbny			/ next operator can't be unary
	cmp	r0,$wnmadd		/ is item "+"
	jeq	1b			/ ignore unary "+" (back to main loop)
	cmp	r0,$wnmsub		/ is item "-"
	bne	2f			/ br if not
/ here on unary -
	mov	r4,-(r5)		/ plant 'pushq 0'
	jsr	pc,saspushq
	mov	r4,-(r5)		/ precdence zero (very high)
	mov	$wnmsub,-(r5)		/ operator is minus (unary minus)
	mov	popstk,-(r5)		/ current operater stack
	jsr	pc,scntrp		/ make a triple
	mov	(r5)+,popstk		/ the new operator stack
	jbr	1b			/ back to main loop
/ here on normal operator
2:
	bic	$mbutprecedence,r1		/ clear all but precdence of identprops
	mov	r1,-(r5)		/ push precedence
	jsr	pc,scmpump		/ remove lower precedence operators from op stack
	mov	pitem,-(r5)		/ push item
	mov	popstk,-(r5)		/ and current opstack
	jsr	pc,scntrp		/ make new op stack
	mov	(r5)+,popstk		/ and store in variable
	jbr	1b			/ back to main loop
/ here on non operation identifier
3:
	mov	r0,-(r5)		/ push word
	jsr	pc,saspush		/ plant a push instruction
	inc	pmsbop			/ next item must be an operator
	clr	pcnbny			/ but not a unary one
	jbr	1b			/ back to main loop
/ here on non word
4:
	cmp	r0,$termin		/ is item termin?
	bne	2f			/ br if not
	mov	r0,-(r5)		/ push item
	mov	pclose,-(r5)		/ required closing bracket
	jsr	pc,serror11		/ shouldn't ever return
/ here if not termin
2:
	tst	pmsbop			/ should it be an operator?
	beq	3f			/ br if not
	bit	r4,r0			/ is item an integer?
	beq	2f			/ br to error if not
	tst	r0			/ is it a negative integer?
	bge	2f			/ br if not
/ here on erroneous missing separator error caused by things
/ like 'x-1' which reads as two items 'x' and '-1' rather than
/ three items 'x', '-' and '1'.
	mov	r0,-(r5)		/ push the number
	jsr	pc,snegate		/ negate it
	jsr	pc,srdundo		/ unread it
	mov	$wnmsub,-(r5)		/ push "-"
	jsr	pc,srdundo		/ unread that as well
	jbr	1b			/ back to main loop
/ here on missing separator caused by non-word
2:
	mov	plitem,-(r5)		/ push last item
	mov	r0,-(r5)		/ push this item
	mov	#2012.,-(r5)		/ Error 12, two culprits
	jsr	pc,serror		/ shouldn't ever return
/ here on normal non-word
3:
	mov	r0,-(r5)		/ push item
	jsr	pc,saspushq		/ plant a pushq instrcutiom
	inc	pmsbop			/ next item should be an operator
	clr	pcnbny			/ but not a unary one
	jbr	1b			/ back to main loop
