/	SUBTITLE	b-lbfind.s	Find a library file
/	Written by Steven Hardy on 7th January 1977
/	Modifications arising from change of "seek" to "lseek" made
/	by Michael Wise on 24/6/1981
/
/ This function takes as argument a word or string specifying a
/ wanted library file. The function's task is to search the
/ libraries known to the system for relevant subfile and, when found,
/ to compile it. If succesfu; the function returns TRUE, and otherwise
/ FALSE.
/ The variable 'plblist' (accesible to the user with a popmess{LIBLIST})
/ command) contains alist of device records, each of which corresponds
/ to a file created by the PAR command. Initially the only element of
/ plblist corresponds to the file /lib/pop.l - the system library.
/ The majority of POP11 users do not alter plblist.
/
slbfind:
	mov	(r5)+,r0		/ pop word or string to r0
	cmp	okey(r0),$kword		/ is it a word?
	bne	1f			/ br if not (assume its a string)
	mov	oname(r0),r0		/ if its a word get associated string
1:
	mov	r0,blbname		/ store string in a variable
	mov	plblist,blbtemp		/ get a copy of library file list
1:					/ beginning of main loop
	mov	blbtemp,r0		/ get current sublist
	cmp	r0,$nil			/ is it nil?
	beq	5f			/ br if so
	mov	*(r0)+,r3		/ move channel number to r3
					/ as r1 is clobbered by lseek
	mov	(r0),blbtemp		/ update stored sublist
	mov	r3,r0			/ set up channel number for sys call
	sys	lseek; 0; 0; 0		/ seek to beginning of file (should already be there)
	bcs	1b			/ ignore this libfile on error
	mov	r3,r1			/ restore r1, free r3
	mov	r1,r0			/ set up channel number for sys call
	sys	read; blbdir; 16.	/ read index descriptor
	bcs	1b			/ br on error
	mov	blbsize,blbndxsz	/ store size of index
	clr	blboffset		/ initialize offset of wanted subfile
2:					/ beginning of inner loop
	add	blbsize,blboffset	/ update offset to allow for last file
	sub	$16.,blbndxsz		/ any subfiles left?
	blt	4f			/ br if not
	mov	r1,r0			/ set up channel number for sys call
	sys	read; blbdir; 16.	/ read next index entry
	bcs	4f			/ br on error
	mov	$blbdir,r2		/ set up for matching of names
	mov	blbname,r3
3:					/ beginning of matching loop
	cmpb	(r2)+,(r3)		/ next chars the same?
	bne	2b			/ loop back to next subfile if not
	tstb	(r3)+			/ any chars left?
	bne	3b			/ continue matching if so
					/ wanted subfile found at this point
	mov	blboffset,iseek+2	/ set seek address
	mov	r1,r3			/ save r1 in r3
	mov	r1,r0			/ set up channel number for sys call
	sys	0; iseek		/ seek to beginning of wanted sub file
	bcs	4f			/ br on error
	mov	r3,-(r5)		/ save channel number
	mov	blbsize,-(r5)		/ save size
	asl	(r5)			/ but convert to POP11 format
	inc	(r5)			/ so as not to fool garbage collector
	mov	(r5),-(r5)		/ dup() (for initc)
	add	$4,(r5)			/ allow space for control information
	jsr	pc,sinitc		/ create buffer
	mov	(r5)+,r2		/ pop buffer to r2
	mov	r2,iread+2		/ store in read command buffer
	add	$4,iread+2		/ allow  two words at beginning of buffer for control info
	asr	(r5)			/ convert size of file back to DEC format
	mov	(r5)+,iread+4		/ and store in command buffer
	mov	(r5)+,r3		/ retreive channel number
	mov	r3,r0			/ set up channel number for sys call
	sys	0; iread		/ issue read command
	bcs	4f			/ br on error
	mov	r3,r0			/ set up  channel number for sys call
	sys	lseek; 0; 0; 0		/ rewind file ready for next call of lbfindd
	mov	$3,(r2)			/ set offset of last char taken
	mov	iread+4,2(r2)		/ set offset of max char
	add	$3,2(r2)		/ allow space for control info etc
	mov	$6f,-(r5)		/ push char rep func
	mov	r2,-(r5)		/ and buffer
	jsr	pc,sprtp1		/ partapplyone()
	jsr	pc,scompile		/ compile the file
	mov	$true,-(r5)		/ push TRUE
	rts	pc			/ and return
4:					/ current libfile no good here
	mov	r3,r0			/ set up channel number for sys call
	sys	lseek; 0; 0; 0		/ rewind file ready for next call of lbfind
	br	1b			/ loop back for next libfile
5:					/ end of main loop - subfile not found
	mov	$false,-(r5)		/ push FALSE
	rts	pc			/ and return
/
/ The following function gets a character from a lbfind buffer
/
	ksfunction
6:	br	1f
	false; false; rts pc
1:
	mov	(r5)+,r0		/ pop buffer to r0
	inc	(r0)			/ inc offset of nextbyte
	cmp	(r0),2(r0)		/ too big?
	bgt	1f			/ br if so
	add	(r0),r0			/ compute address of next byte
	movb	(r0),-(r5)		/ pushb byte
	jbr	scnbyte			/ convert to POP11 format
1:
	mov	$termin,-(r5)		/ push termin
	rts	pc			/ and return
