; This program tests EM-1 implementations, both compiled and interpreted.
; The program needs one extra instruction, in addition to the normal EM-1
; instruction set.  This instruction,  OUT, takes an unsigned integer from 
; ext 0 and prints it,  followed by a new line character. If the EM-1 im-
; plementation is correct, the program will list all the integers from  0
; to XXX.  If an error is detected, the program will print xxx and halt.

lowcore con 10,12,14,16,18,20,22,24,26,28,30,32
 con 34,36,38,40,42,44,46,48,50,52,54,56,58,60
 con 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 con 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,00,0,0,0,0,0,0

 pro emtest,0,0
 beg 100
 loc 1723   ;after all tests done, this should still be on stack
 loc 11944  ;ditto

 loc 0
 ste 0
 out ; 0 ok

; this code is needed to test long jumps, later on
 brf 1
 brf 9999
19
 brf 18
1

; test loc, bne
 loc 0
 loc 0
 bne 9999
 lni
 out ; 1 ok

 loc 1
 loc 1
 bne 9999
 lni
 out ; 2 ok

 loc -1
 loc -1
 bne 9999
 lni
 out ; 3 ok

 loc 255
 loc 255
 bne 9999
 lni
 out ; 4 ok

 loc 256
 loc 256
 bne 9999
 lni
 out ; 5 ok

 loc 257
 loc 257
 bne 9999
 lni
 out ; 6 ok

 loc 32767
 loc 32767
 bne 9999
 lni
 out ; 7 ok

 loc -32767
 loc -32767
 bne 9999
 lni
 out ; 8 ok

; test lol, stl
 loc 257
 stl 4
 lol 4
 loc 257
 bne 9999
 lni
 out ; 9 ok

 loc 32767
 stl 50
 loc 32767
 lol 50
 bne 9999
 lni
 out ; 10 ok

 loc -32767
 stl 60
 lol 60
 loc -32767
 bne 9999
 lni
 out ; 11 ok

; test lnc
 lnc 100
 loc -100
 bne 9999
 lni
 out ; 12 ok

 loc -30000
 lnc 30000
 bne 9999
 lni
 out ; 13 ok

; test loe, ste
 loc 100
 ste 40
 loe 40
 loc 100
 bne 9999
 lni
 out ; 14 ok

 loc -300
 ste 42
 loe 42
 lnc 300
 bne 9999
 lni
 out ; 15 ok

; test lal, lop
 lal 0
 stl 2
 loc 352
 stl 0
 lop 2
 loc 352
 bne 9999
 lni
 out ; 16 ok

; test stp
 loc 110
 stp 2
 lol 0
 loc 110
 bne 9999
 lni
 out ; 17 ok

; test lof
 lal 2
 loc 120
 stl 6
 lof 4
 loc 120
 bne 9999
 lni
 out ; 18 ok

; test stp
 loc 29
 stl 60
 lal 60
 stl 80
 loc 130
 stp 80
 lol 60
 loc 130
 bne 9999
 lni
 out ; 19 ok

; test loi 2
 loc 140
 stl 20
 lal 20
 loi 2
 loc 140
 bne 9999
 lni
 out ; 20 ok

; test loi 1
 loc 519
 stl 40
 lal 40
 loi 1
 loc 7
 bne 9999
 lni
 out ; 21 ok

; test loi 4
 loc 777
 stl 42
 lal 40
 loi 4
 loc 777
 bne 9999
 loc 519
 bne 9999
 lni
 out ; 22 ok

; test loi 8
 loc 150
 stl 50
 loc 152
 stl 52
 loc 154
 stl 54
 loc 156
 stl 56
 lal 50
 loi 8
 loc 156
 bne 9999
 loc 154
 bne 9999
 loc 152
 bne 9999
 loc 150
 bne 9999
 lni
 out ; 23 ok

; test los with 2 
 lal 40
 loc 1
 los
 loc 7
 bne 9999
 lni
 out ; 24 ok

; test los with 1 
 lal 40
 loc 2
 los
 loc 519
 bne 9999
 lni
 out ; 25 ok

; test los with 4 
 lal 40
 loc 4
 los
 loc 777
 bne 9999
 loc 519
 bne 9999
 lni
 out ; 26 ok

; test ldl
  ldl 40
  loc 777
  bne 9999
  loc 519
  bne 9999
 lni
 out ; 27 ok

; test ldf
  lal 22
  ldf 18
  loc 777
  bne 9999
  loc 519
  bne 9999
 lni
 out ; 28 ok

; test lde
 loc 170
 ste 44
 loc 171
 ste 46
 lde 44
 loc 171
 bne 9999
 loc 170
 bne 9999
 lni
 out ; 29 ok

; test ldf
 loc 175
 stl 30
 loc 177
 stl 32
 lal 22
 ldf 8
 loc 177
 bne 9999
 loc 175
 bne 9999
 lni
 out ; 30 ok

; test stf
 loc 180
 lal 6
 stf 10
 lol 16
 loc 180
 bne 9999
 lni
 out ; 31 ok

; test sti 1
 loc 1034
 stl 60
 loc 4136
 lal 60
 sti 1
 loc 1064
 lol 60
 bne 9999
 lni
 out ; 32 ok

; test sti 2
 loc 190
 lal 60
 sti 2
 lol 60
 loc 190
 bne 9999
 lni
 out ; 33 ok

; test sti 6
 loc 200
 loc 201
 loc 202
 lal 60
 sti 6
 lol 60
 loc 200
 bne 9999
 loc 201
 lol 62
 bne 9999
 loc 202
 lol 64
 bne 9999
 lni
 out ; 34 ok

; test sts with 1
 loc 260
 stl 10
 loc 20
 lal 10
 loc 1
 sts
 lol 10
 loc 276
 bne 9999
 lni
 out ; 35 ok

; test sts with 2
 loc 210
 lal 60
 loc 2
 sts
 lol 60
 loc 210
 bne 9999
 lni
 out ; 36 ok

; test sts with 6
 loc 220
 loc 221
 loc 222
 lal 60
 loc 6
 sts
 lol 60
 loc 220
 bne 9999
 lol 62
 loc 221
 bne 9999
 lol 64
 loc 222
 bne 9999
 lni
 out ; 37 ok

; test sdl
 loc 230
 loc 231
 sdl 60
 lol 60
 loc 230
 bne 9999
 lol 62
 loc 231
 bne 9999
 lni
 out ; 38 ok

; test sde
 loc 240
 loc 241
 sde 46
 loe 46
 loc 240
 bne 9999
 loe 48
 loc 241
 bne 9999
 lni
 out ; 39 ok

; test sdf
 loc 250
 loc 251
 lae 40
 sdf 10
 loe 50
 loc 250
 bne 9999
 loc 251
 loe 52
 bne 9999
 lni
 out ; 40 ok

; test add
 loc 1
 loc 1
 add
 loc 2
 bne 9999
 lni
 out ; 41 ok

 loc 5
 loc -6
 add
 loc -1
 bne 9999
 lni
 out ; 42 ok

 loc -1007
 loc +999
 add
 loc -8
 bne 9999
 lni
 out ; 43 ok

 loc -1300
 loc +1405
 add
 loc 105
 bne 9999
 lni
 out ; 44 ok

 loc -30000
 loc -20
 add
 loc -30020
 bne 9999
 lni
 out ; 45 ok

; test sub
 loc 1
 loc 1
 sub
 loc 0
 bne 9999
 lni
 out ; 46 ok

 loc 5
 loc -6
 sub
 loc 11
 bne 9999
 lni
 out ; 47 ok

 loc -1007
 loc +999
 sub
 loc -2006
 bne 9999
 lni
 out ; 48 ok

 loc -1300
 loc +1405
 sub
 loc -2705
 bne 9999
 lni
 out ; 49 ok

 loc -30000
 loc -20
 sub
 loc -29980
 bne 9999
 lni
 out ; 50 ok

; test mul
 loc 5
 loc 9
 mul
 loc 45
 bne 9999
 lni
 out ; 51 ok

 loc -99
 loc 7
 mul
 loc -693
 bne 9999
 lni
 out ; 52 ok

 loc 0
 loc 10
 mul
 loc 0
 bne 9999
 lni
 out ; 53 ok

 loc -100
 loc -90
 mul
 loc 9000
 bne 9999
 lni
 out ; 54 ok

; test div
 loc 15
 loc 5
 div
 loc 3
 bne 9999
 lni
 out ; 55 ok

 loc 100
 loc -7
 div
 loc -14
 bne 9999
 lni
 out ; 56 ok

 loc -100
 loc 7
 div
 loc -14
 bne 9999
 lni
 out ; 57 ok

 loc -1000
 loc -201
 div
 loc 4
 bne 9999
 lni
 out ; 58 ok

; test mod
 loc 100
 loc 7
 mod
 loc 2
 bne 9999
 lni
 out ; 59 ok

 loc -100
 loc 7
 mod
 loc -2
 bne 9999
 lni
 out ; 60 ok

 loc 100
 loc -7
 mod
 loc 2
 bne 9999
 lni
 out ; 61 ok

 loc -100
 loc -7
 mod
 loc -2
 bne 9999
 lni
 out ; 62 ok

; test neg
 loc 100
 neg
 loc -100
 bne 9999
 lni
 out ; 63 ok

 loc -100
 neg
 loc 100
 bne 9999
 lni
 out ; 64 ok

; test shl
 loc 5
 loc 3
 shl
 loc 40
 bne 9999
 lni
 out ; 65 ok

 loc -2
 loc 4
 shl
 loc -32
 bne 9999
 lni
 out ; 66 ok

; test shr
 loc 64
 loc 5
 shr
 loc 2
 bne 9999
 lni
 out ; 67 ok

 loc -3
 loc 2
 shr
 loc -1
 bne 9999
 lni
 out ; 68 ok

 loc -16
 loc 3
 shr
 loc -2
 bne 9999
 lni
 out ; 69 ok

; test rol
 loc 1
 loc 3
 rol
 loc 8
 bne 9999
 lni
 out ; 70 ok

 loc 16384
 loc 15
 rol
 loc 8192
 bne 9999
 lni
 out ; 71 ok

 loc -2
 loc 15
 rol
 loc 32767
 bne 9999 
 lni
 out ; 72 ok

; test ror
 loc 4
 loc 5
 ror
 loc 8192
 bne 9999
 lni
 out ; 73 ok

 loc 32767
 loc 15
 ror
 loc -2
 bne 9999
 lni
 out ; 74 ok

; test inc
 loc 20
 inc
 loc 21
 bne 9999
 lni
 out ; 75 ok

 loc -50
 inc
 loc -49
 bne 9999
 lni
 out ; 76 ok

; test dec
 loc 66
 dec
 loc 65
 bne 9999
 lni
 out ; 77 ok

 loc -44
 dec
 loc -45
 bne 9999
 lni
 out ; 78 ok

; test exg
 loc 52
 loc 199
 exg
 loc 52
 bne 9999
 loc 199
 bne 9999
 lni
 out ; 79 ok

; test adi
 lal 60
 adi 2
 lal 62
 bne 9999
 lni
 out ; 80 ok

 loc 519
 stl 60
 lal 60
 adi 1
 loi 1
 loc 2
 bne 9999
 lni
 out ; 81 ok

; test inn
 loc 0
 loc 0
 loc 8
 loc 0
 loc 35
 inn 8
 loc 1
 bne 9999
 lni
 out ; 82 ok

 loc 0
 loc 0
 loc 8
 loc 0
 loc 34
 inn 8
 loc 0
 bne 9999
 lni
 out ; 83 ok

 loc -5
 loc 2
 inn 2
 loc 0
 bne 9999
 lni
 out ; 84 ok

 loc -5
 loc 3
 inn 2
 loc 1
 bne 9999
 lni
 out ; 85 ok
; test ins
 loc 0
 loc 0
 loc 8
 loc 0
 loc 35
 loc 8
 ins
 loc 1
 bne 9999
 lni
 out ; 86 ok

 loc 0
 loc 0
 loc 8
 loc 0
 loc 34
 loc 8
 ins
 loc 0
 bne 9999
 lni
 out ; 87 ok

; test set
 loc 3
 set 2
 loc 8
 bne 9999
 lni
 out ; 88 ok

 loc 16
 set 6
 loc 0
 bne 9999
 loc 1
 bne 9999
 loc 0
 bne 9999
 lni
 out ; 89 ok

 loc 0
 set 8
 loc 0
 bne 9999
 loc 0
 bne 9999
 loc 0
 bne 9999
 loc 1
 bne 9999
 lni
 out ; 90 ok

; test ses
 loc 13
 loc 4
 ses
 loc 0
 bne 9999
 loc 8192
 bne 9999
 lni
 out ; 91 ok

 loc 17
 loc 8
 ses
 loc 0
 bne 9999
 loc 0
 bne 9999
 loc 2
 bne 9999
 loc 0
 bne 9999
 lni
 out ; 92 ok

; test aar 
 loc 5
 ste 44
 loc 2
 ste 46
 loc 4
 ste 48
 lal 60
 loc 5
 aar 44
 lal 60
 bne 9999
 lni
 out ; 93 ok

 loc 1
 ste 48
 lae 100
 loc 7
 aar 44
 lae 102
 bne 9999
 lni
 out ; 94 ok
; test aas
 loc 10
 ste 48
 lal 20
 loc 7
 lae 44
 aas
 lal 40
 bne 9999
 lni
 out ; 95 ok

; test lar
 loc 5
 ste 44
 loc 4
 ste 46
 loc 6
 ste 48
 loc 38
 stl 66
 loc 39
 stl 68
 loc 40
 stl 70
 lal 42
 loc 9
 lar 44
 loc 40
 bne 9999
 loc 39
 bne 9999
 loc 38
 bne 9999
 lni
 out ; 96 ok

 loc 1
 ste 48
 loc 519
 stl 70
 lal 68
 loc 8
 lar 44
 loc 2
 bne 9999
 lni
 out ; 97 ok

; test las
 lal 68
 loc 8
 lae 44
 las
 loc 2
 bne 9999
 lni
 out ; 98 ok

 loc 6
 ste 48
 lal 48
 loc 8
 lae 44
 las
 loc 519
 bne 9999
 loc 39
 bne 9999
 loc 38
 bne 9999
 lni
 out ; 99 ok

; test sar
 loc 30
 loc 31
 loc 32
 lal 42
 loc 9
 sar 44
 lol 66
 loc 30
 bne 9999
 lol 68
 loc 31
 bne 9999
 lol 70
 loc 32
 bne 9999
 lni
 out ; 100 ok

 loc 1
 ste 48
 loc 1027
 lal 64
 loc 8
 sar 44
 lol 66
 loc 798
 bne 9999
 lni
 out ; 101 ok

 loc 258
 stl 68
 loc 529
 lal 64
 loc 9
 sar 44
 lol 68
 loc 273
 bne 9999
 lni
 out ; 102 ok

; test sas
 loc 5
 lal 64
 loc 8
 lae 44
 sas
 lol 66
 loc 1310
 bne 9999
 lni
 out ; 103 ok

 loc 4
 ste 48
 loc 300
 loc 301
 lae 50
 loc 7
 lae 44
 sas
 loe 58
 loc 300
 bne 9999
 loe 60
 loc 301
 bne 9999
 lni
 out ; 104 ok

; test tlt
 loc 1
 tlt
 loc 0
 bne 9999
 lni
 out ; 105 ok

 loc 0
 tlt
 loc 0
 bne 9999
 lni
 out ; 106 ok

 loc -3
 tlt
 loc 1
 bne 9999
 lni
 out ; 107 ok

; test tle
 loc 8
 tle
 loc 0
 bne 9999
 lni
 out ; 108 ok

 loc 0
 tle
 loc 1
 bne 9999
 lni
 out ; 109 ok

 loc -19
 tle
 loc 1
 bne 9999
 lni
 out ; 110 ok

; test teq
 loc 17
 teq
 loc 0
 bne 9999
 lni
 out ; 111 ok

 loc 0
 teq
 loc 1
 bne 9999
 lni
 out ; 112 ok

 loc -100
 teq
 loc 0
 bne 9999
 lni
 out ; 113 ok

; test tne
 loc 76
 tne
 loc 1
 bne 9999
 lni
 out ; 114 ok

 loc 0
 tne
 loc 0
 bne 9999
 lni
 out ; 115 ok

 loc -199
 tne
 loc 1
 bne 9999
 lni
 out ; 116 ok

; test tge
 loc 1400
 tge
 loc 1
 bne 9999
 lni
 out ; 117 ok

 loc 0
 tge
 loc 1
 bne 9999
 lni
 out ; 118 ok

 loc -776
 tge
 loc 0
 bne 9999
 lni
 out ; 119 ok

; test tgt
 loc 200
 tgt
 loc 1
 bne 9999
 lni
 out ; 120 ok

 loc 0
 tgt
 loc 0
 bne 9999
 lni
 out ; 121 ok

 loc -66
 tgt
 loc 0
 bne 9999
 lni
 out ; 122 ok

; test cmi
 loc 10
 loc 20
 cmi
 tlt
 loc 1
 bne 9999
 lni
 out ; 123 ok

 loc 20
 loc 10
 cmi
 tgt
 loc 1
 bne 9999
 lni
 out ; 124 ok

 loc 44
 loc 44
 cmi
 loc 0
 bne 9999
 lni
 out ; 125 ok

; test cmp
 lal 40
 lal 50
 cmp
 tlt
 loc 1
 bne 9999
 lni
 out ; 126 ok

 lal 50
 lal 40
 cmp
 tlt
 loc 0
 bne 9999
 lni
 out ; 127 ok

 lal 40
 lal 40
 cmp
 loc 0
 bne 9999
 lni
 out ; 128 ok

 lal 40
 adi 10
 lal 50
 cmp
 loc 0
 bne 9999
 lni
 out ; 129 ok

 lal 40
 adi 10
 lal 48
 cmp
 tgt
 loc 1
 bne 9999
 lni
 out ; 130 ok

 loc 6
 loc 6
 cmu 2
 loc 0
 bne 9999
 lni
 out ; 131 ok

 loc 17
 loc 27
 cmu 2
 tlt
 loc 1
 bne 9999
 lni
 out ; 132 ok

 loc 17
 loc 6
 loc 27
 loc 6
 cmu 4
 tlt
 loc 1
 bne 9999
 lni
 out ; 133 ok

 loc 6
 loc 27
 loc 6
 loc 17
 cmu 4
 tgt
 loc 1
 bne 9999
 lni
 out ; 134 ok

 loc 6
 loc -10
 loc -32765
 loc 30
 loc 6
 loc -10
 loc -32766
 loc 30
 cmu 8
 tgt
 loc 1
 bne 9999
 lni
 out ; 135 ok

; test cms
 loc 6
 loc -10
 loc -32765
 loc 30
 loc 6
 loc -10
 loc -32766
 loc 30
 loc 8
 cms
 tgt
 loc 1
 bne 9999
 lni
 out ; 136 ok

 ; test brf and brb

 brf 16
 brf 9999
11
 brf 15
 brf 9999
12
 brf 14
 brf 9999
13
 brf 17
 brf 9999
14
 brb 13
 brf 9999
15
 brb 12
 brf 9999
16
 brb 11
 brf 9999
17
 brb 19
 brf 9999
18
 lni
 out ; 137 ok

; test blt
 loc 3
 loc 4
 blt 20
 brf 9999
20
 loc 4
 loc 3
 blt 9999

 loc -5
 loc -4
 blt 21
 brf 9999
21

 loc -4
 loc -5
 blt 9999

 loc 4
 loc 4
 blt 9999
 lni
 out ; 138 ok

; test ble
 loc 3
 loc 4
 ble 22
 brf 9999
22

 loc 4
 loc 3
 ble 9999

 loc -99
 loc -5
 ble 23
 brf 9999
23

 loc -99
 loc -99
 ble 24
 brf 9999
24

 loc 100
 loc -100
 ble 9999
 lni
 out ; 139 ok

; test beq
 loc 3
 loc 3
 beq 25
 brf 9999
25

 loc 3
 loc 4
 beq 9999

 loc -188
 loc -187
 beq 9999

 loc 0
 loc 0
 beq 26
 brf 9999
26
 lni
 out ; 140 ok

; test bne
 loc 50
 loc 50
 bne 9999

 loc 50
 loc 51
 bne 27
 brf 9999
27

 loc 0
 loc 0
 bne 9999
 lni
 out ; 141 ok

; test bge
 loc 100
 loc 101
 bge 9999

 loc 101
 loc 100
 bge 28
 brf 9999
28

 loc -100
 loc -99
 bge 9999

 loc -100
 loc 100
 bge 9999

 loc 0
 loc 0
 bge 29
 brf 9999
29

 loc 50
 loc 50
 bge 30
 brf 9999
30
 lni
 out ; 142 ok

; test bgt
 loc 3
 loc 10
 bgt 9999

 loc 10
 loc 3
 bgt 31
 brf 9999
31

 loc -100
 loc -50
 bgt 9999

 loc -100
 loc 50
 bgt 9999

 loc 5
 loc 5
 bgt 9999
 lni
 out ; 143 ok

; test zlt
 loc 4
 zlt 9999

 loc -4
 zlt 32
 brf 9999
32

 loc 0
 zlt 9999
 lni
 out ; 144 ok

; test zle
 loc 4
 zle 9999

 loc -4
 zlt 33
 brf 9999
33

 loc 0
 zle 34
 brf 9999
34
 lni
 out ; 145 ok

; test zeq
 loc 4
 zeq 9999

 loc -4
 zeq 9999

 loc 0
 zeq 35
 brf 9999
35
 lni
 out ; 146 ok

; test zne
 loc 4
 zne 36
 brf 9999
36

 loc -4
 zne 37
 brf 9999
37

 loc 0
 zne 9999
 lni
 out ; 147 ok

; test zge
 loc 4
 zge 38
 brf 9999
38
 loc -4
 zge 9999

 loc 0
 zge 39
 brf 9999
39
 lni
 out ; 148 ok

; test zgt
 loc 4
 zgt 40
 brf 9999
40

 loc -4
 zgt 9999

 loc 0
 zgt 9999
 lni
 out ; 149 ok

; test mrk and cal
 loc 10
 stl 0
 loc 20
 stl 2
 loc 40
 stl 4
 loc 9800
 stl 98
 loc 0
 ste 40
 mrk 0
 cal zero
 loe 40
 loc 364
 bne 9999
 lni
 out ; 150 ok

 lol 98
 loc 9800
 bne 9999
 lni
 out ; 151 ok

 loc 14529
 loc -4766
 mrk 0
 loc 90
 loc 92
 loc 94
 cal one
 lin 172
 out ; 172 ok

 loc -4766
 bne 9999
 loc 14529
 bne 9999
 lni
 out ; 173 ok

; test cas
 loc 0
 ste 40
 mrk 0
 loc $zero
 cas
 loe 40
 loc 364
 bne 9999
 lni
 out ; 174 ok

; test pad
 lal 60
 loc 20
 pad
 lal 80
 bne 9999
 lni
 out ; 175 ok

 lal 60
 loc -20
 pad
 lal 40
 bne 9999
 lni
 out ; 176 ok

; test psb
 lal 60
 lal 40
 psb
 loc 20
 bne 9999
 lni
 out ; 177 ok

 lae 70
 lae 100
 psb
 loc -30
 bne 9999
 lni
 out ; 178 ok

; test lor
 lor 0
 lal 0
 bne 9999
 lni
 out ; 179 ok

 lor 1
 lal 102
 bne 9999
 lni
 out ; 180 ok

; test beg
 loc 1204
 loc 4
 loc 5
 loc 6
 beg -4
 stl 60
 loc 1204
 bne 9999
 lni
 out ; 181 ok

 lor 1
 stl 10
 beg 4
 lor 1
 stl 12
 beg -4
 lol 12
 lol 10
 psb
 loc 4
 bne 9999
 lni
 out ; 182 ok

; test bes
 loc 1304
 loc 40
 loc 50
 loc 60
 loc -4
 bes
 stl 70
 loc 1304
 bne 9999
 lni
 out ; 183 ok

 lor 1
 stl 10
 loc 18
 bes
 lor 1
 stl 12
 loc -18
 bes
 lol 12
 lol 10
 psb
 loc 18
 bne 9999
 lni
 out ; 184 ok

; test blm
 loc 161
 ste 40
 loc 0
 stl 4
 lae 40
 lal 4
 blm 2
 lol 4
 loc 161
 bne 9999
 lni
 out ; 185 ok

 loc 41
 loc 42
 loc 43
 loc 44
 lal 10
 sti 8
 lal 10
 lae 40
 blm 8
 loe 40
 loc 41
 bne 9999
 loe 42
 loc 42
 bne 9999
 loe 44
 loc 43
 bne 9999
 loe 46
 loc 44
 bne 9999
 lni
 out ; 186 ok

; test bls
 loc 55
 stl 6
 loc 56
 stl 8
 lal 6
 lae 40
 loc 4
 bls
 loe 40
 loc 55
 bne 9999
 loe 42
 loc 56
 bne 9999
 lni
 out ; 187 ok

; test dup
 loc 199
 dup 2
 bne 9999
 lni
 out ; 188 ok

 loc 130
 loc 150
 dup 4
 loc 150
 bne 9999
 loc 130
 bne 9999
 loc 150
 bne 9999
 loc 130
 bne 9999
 lni
 out ; 189 ok

 loc 400
 loc 399
 loc 4
 dus
 loc 399
 bne 9999
 loc 400
 bne 9999
 loc 399
 bne 9999
 loc 400
 bne 9999
 lni
 out ; 190 ok

; test exg
 loc 299
 loc 680
 exg
 loc 299
 bne 9999
 loc 680
 bne 9999
 lni
 out ; 191 ok

; test lin
 lin 192
 loe 0
 loc 192
 bne 9999
 out ; 192 ok

; test nop
 nop
 lni
 out ; 193 ok

; test rck
 loc 10
 ste 40
 loc 14
 ste 42
 loc 10
 rck 40
 inc
 rck 40
 inc
 rck 40
 inc
 rck 40
 inc
 rck 40
 lni
 out ; 194 ok

; test rcs
 lae 40
 rcs
 stl 4
 lni
 out ; 195 ok

; test csa
cstab con $emtest,-1,4,2,*74,*75,*76

 loc 5
 lae cstab
 csa
 brf 9999
74
 brf 9999
75
 brf 77
76
 brf 9999
77
 lni
 out ; 196 ok

; now test loi again, because it is so tricky
 loc 256
 stl 4
 loc 517
 stl 6
 loc 1030
 stl 8
 lal 4
 loi 1
 loc 0 
 bne 9999
 lni
 out ; 197 ok

 lal 4
 adi 1
 loi 1
 loc 1
 bne 9999
 lni
 out ; 198 ok

 lal 4
 adi 2
 loi 1
 loc 5
 bne 9999
 lni
 out ; 199 ok

 lal 4
 adi 3
 loi 1
 loc 2
 bne 9999
 lni
 out ; 200 ok

 lal 4
 adi 4
 loi 1
 loc 6
 bne 9999
 lni
 out ; 201 ; ok

 lal 6
 adi 3
 loi 1
 loc 4
 bne 9999
 lni
 out ; 202 ok

; now test sti 1 again
 loc 3
 loc 2
 loc 1
 loc 7
 loc 8
 loc 10
 lal 4
 sti 1
 lal 4
 adi 1
 sti 1
 lal 4
 adi 2
 sti 1
 lal 4
 adi 3
 sti 1
 lal 4
 adi 4
 sti 1
 lal 4
 adi 5
 sti 1
 lol 4
 loc 2058
 bne 9999
 lni
 out ; 203 ok

 lol 6
 loc 263
 bne 9999
 lni
 out ; 204 ok

 lol 8
 loc 770
 bne 9999
 lni
 out ; 205 ok

; ok
 loc 11944  ; have we messed the stack up?
 bne 9999
 loc 1723
 bne 9999
 loc 1000
 loe 0
 add
 ste 0
 loc 0
 hlt
9999
 loc 1
 loc 0
 div

 end


 pro zero,0,1
 loc 364
 ste 40
 loc 0
 res
 end

 pro one,6,1
 beg 10
 lol 0
 loc 90
 bne 9999
 lol 2
 loc 92
 bne 9999
 lol 4
 loc 94
 bne 9999
 lni
 out ; 152 ok

 loc 1706
 loc 1708
 loc 1710
 loc 1712
 loc 1714
 lal 6
 sti 10
 loc 179
 mrk 0
 loc 330
 loc 332
 loc 334
 loc 336
 cal two
 lin 169
 out ; 169

 loc 717
 bne 9999
 lni
 out ; 170

 loc 179
 bne 9999
 lni
 out ; 171

 ret 0
9999
 loc 1
 loc 0
 div
 end

 pro two,8,1
 lol 0
 loc 330
 bne 9999
 lol 6
 loc 336
 bne 9999
 lni
 out ; 153 ok

 loc 3006
 mrk 0
 loc 500
 loc 502
 cal three
 lin 165
 out ; 165 ok
 loc 613
 bne 9999
 loc 612
 bne 9999
 loc 611
 bne 9999
 loc 610
 bne 9999
 lni
 out ; 166 ok

 loc 3006
 bne 9999
 lni
 out ; 167 ok

 lal 0
 loi 8
 loc 336
 bne 9999
 loc 334
 bne 9999
 loc 332
 bne 9999
 loc 330
 bne 9999
 lni
 out ; 168 ok

 loc 717
 ret 2

9999
 loc 1
 loc 0
 div
 end

 pro three,4,1
 beg 6
 lol 0
 loc 500
 bne 9999
 lni
 out ; 154 ok

 loc 504
 stl 4
 loc 506
 stl 6
 loc 508
 stl 8

; test lex
 lol 0
 loc 500
 bne 9999
 lni
 out ; 155 ok

 lex 0
 loi 2
 loc 500
 bne 9999
 lni
 out ; 156 ok

 lex 1
 loi 2
 loc 330
 bne 9999
 lni
 out ; 157 ok

 lex 1
 lof 4
 loc 334
 bne 9999
 lni
 out ; 158 ok

 lex 2
 loi 4
 loc 92
 bne 9999
 loc 90
 bne 9999
 lni
 out ; 159 ok

 lex 2
 ldf 4
 loc 1706
 bne 9999
 loc 94
 bne 9999
 lni
 out ; 160 ok

 lex 3
 loi 6
 loc 40
 bne 9999
 loc 20
 bne 9999
 loc 10
 bne 9999
 lni
 out ; 161 ok
 loc 610
 loc 611
 loc 612

; test mrk 1
 mrk 1
 cal four

; test mrk 2
 mrk 2
 cal five

; test mrk 3
 mrk 3
 cal six

 ret 8
9999
 loc 1
 loc 0
 div
 end

 pro four,0,1
 lex 1
 loi 2
 loc 330
 bne 9999
 lni
 out ; 162 ok
 ret 0
9999
 loc 1
 loc 0
 div
 end

 pro five,0,1
 lex 1
 loi 2
 loc 90
 bne 9999
 lni
 out ; 163 ok
 ret 0
9999
 loc 1
 loc 0
 div
 end

 pro six,0,1
 lex 1
 loi 2
 loc 10
 bne 9999
 lni
 out ; 164 ok
 loc 613
 loc 2
 res
9999
 loc 1
 loc 0
 div
 end

 mes 4,300
 eof
