#include	"../h/local.h"
#include	"opt00.h"
#include	"optex.h"
#include	"../h/em1.h"
/*
** utilities of EM1-optimiser.
*/
#define MAXERR 50

int glolkup,glosrch,globstep;

int glohash(aname) char *aname; {
	register char *p;
	register i;
	register sum;
	int size;

	for(sum=i=0,p=aname;*p;i =+ 3)
		sum =+ (*p++)<<(i&07);
	sum =& 077777;
	size = oursize->n_glab;
	globstep = (sum / size) + 7;
	return(sum % size);
}

/*
 * lookup idname in labeltable , if it is not there enter it
 * return index in labeltable
 */

glob_t *glolookup(name,status) char *name; {
	register glob_t *gbp;
	register rem;

	if (nglobs > oursize->n_glab - 10 )
		fatal("global label table overflow");
	++glolkup;++glosrch;
	rem = glohash(name);
	gbp = &globlabel[rem];
	while (gbp->g_name[0] != 0 && strcmp(name,gbp->g_name) != 0) {
		rem = (rem + globstep) % oursize->n_glab;
		gbp = &globlabel[rem];
		++glosrch;
	}
	if (gbp->g_name[0] == 0) {
		strcpy(gbp->g_name,name);
		++nglobs;
	}
	switch(status) {
	case IMPORT:
		if ((gbp->g_status&DEFINED) == 0)
			gbp->g_status =| IMPORT;
		break;
	case EXPORT:
		gbp->g_status =| EXPORT;
		if (makelib) {
			if (write(libfil,"g",1) < 0)
				;
			if (write(libfil,name,MAXIDENT) < 0)
				;
		}
		break;
	case DEFINING:
		if (gbp->g_status&DEFINED)
			error("global symbol redefined",0);
		else {
			gbp->g_status =| DEFINED;
			gbp->g_status =& ~IMPORT;
		}
		break;
	case OCCURRING:
		if ((gbp->g_status&(DEFINED|IMPORT)) == 0)
			error("undefined global reference",0);
		break;
	}
	return(gbp);
}

/*
 * glohash returns an index in globlabel and leaves a stepsize in globstep
 *
 */

#define locstep 1

#define lochash(n) (((n)-1)%oursize->n_llab)

locl_t *loclookup(n,status) {
	register locl_t *lbp;
	register num,i;

	if (nlocs == oursize->n_llab)
		fatal("local label table overflow");
	num = n;
	i = lochash(num);
	lbp = &loclabel[i];
	while (lbp->l_num != num && lbp->l_num != 0) {
		i = (i + locstep) % oursize->n_llab;
		lbp = &loclabel[i];
	}
	if (lbp->l_num == 0) {
		lbp->l_num=num;
		++nlocs;
	} 
	if (status == DEFINING) {
		if (lbp->l_status&DEFINED)
			error("local label redefined",0);
		else lbp->l_status =| DEFINED;
	} else
		lbp->l_status =| OCCURRED;
	return(lbp);
}

proc_t *prolookup(name,status) char *name; {
	register proc_t *prptr;

	prptr=procdesc;
	while (prptr < last_proc)
		if (strcmp(name,prptr->p_name) == 0)
			break;
		else
			prptr++;
	if (prptr == last_proc) {
		if (++last_proc > &procdesc[oursize->n_proc])
			fatal("proc table overflow");
		strcpy(prptr->p_name,name);
	}
	switch (status) {
/*	case IMPORT:
/*		if(prptr->p_status & DEFINED)
/*			error("pro redeclared",0);
/*		else prptr->p_status =| IMPORT;
/*		break;
/*	case EXPORT:
/*		prptr->p_status =| EXPORT;
/*		break;
/**/	case DEFINING:
		if(prptr->p_status & DEFINED)
			error("pro redeclared",0);
		else {
			prptr->p_status =| DEFINED;
			prptr->p_status =& ~IMPORT;
		}
		break;
	case OCCURRING:
		prptr->p_status =| (IMPORT|OCCURRED);
		break;
	}
	return(prptr);
}
