#include	"../h/local.h"
#include	"opt00.h"
#include	"optex.h"
#include	"../h/em1.h"

#define	OP_CONS	0
#define OP_COPY	1
#define OP_REL	2
#define OP_ARIT	3
#define OP_IGN	4

char optab[256]	EQ {	/* contains OP_ANYTHING's */
	4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,2,2,2,2,2,2,2,2,1,2,2,2,2,2,
	2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,
	2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,
	2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,
	2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,
	3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
	3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
	3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
	3,3,3,3,3,3,9,9,9,9,9,9,9,9,9,9,
	9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
	9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
	9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9
};

int value(n) {

	if(types[n]==CONST)
		return(addrs[n].ad_i);
	if(types[n]==GLOSYM)
		return(addrs[n].ad_gp->g_val);
	return(-1);
}

int opval(oper) char oper; {
	register o,val1,val2;

	o = oper&0377;
	switch(optab[o]) {
		case OP_CONS:
			result_type = CONST;
			return(o-EXCESS);
		case OP_COPY:
			o =- CONLIM;
			result_type = types[o/ARANGE];
			repaddr = addrs[o/ARANGE].ad_i;
			return(value(o/ARANGE));
		case OP_REL:
			result_type = CONST;
			o =- CONLIM;
			return(value(o/ARANGE)+(o%ARANGE)-ARANGE/2);
		case OP_ARIT:
			result_type = CONST;
			o =- ARITBASE;
			val1 = value((o&014)>>2);
			val2 = value(o&03);
			switch((o&060)>>3) {
				case 0:	return(val1+val2);
				case 2:	return(val1-val2);
				case 4:	return(val1*val2);
				case 6:	return(val1/val2);
			}
		default:	fatal("bad optab");
		case OP_IGN:
			break;
	}
	result_type = MISSING;
	return(0);
}

struct pattern *reducible(length) int *length; {
	register struct pattern *pat;
	register i,o;
	struct pattern *last_pattern;
	int found;
	int op1,op2,op3,op4,addrok;
	int ad1,ad2,val1,val2,vali,off;

	found = 0; addrok = 0;
	op1 = lps[0]->instr_num;
	op2 = lps[1]->instr_num;
	op3 = lps[2]->instr_num;
	op4 = lps[3]->instr_num;
	pat = &pattern[(firstopt[op1&0377])-1];
	last_pattern = pat + optcount[op1&0377] ;
	while (!found && ++pat<= last_pattern) {
		if (pat->sub[1].instr == 0) {
				++found; *length = 1;
		} else if (op2==pat->sub[1].instr)
			if (pat->sub[2].instr==0) {
				++found; *length = 2;
		} else if (op3==pat->sub[2].instr)
			if (pat->sub[3].instr==0) {
				++found; *length = 3;
		} else if (op4==pat->sub[3].instr ) {
				++found; *length = 4;
		}
		if (found) {
			if (!addrok) {
				addrok=1;
				addrs[0].ad_i = lps[0]->ad.ad_i;
				types[0] = lps[0]->type1;
				addrs[1].ad_i = lps[1]->ad.ad_i;
				types[1] = lps[1]->type1;
				addrs[2].ad_i = lps[2]->ad.ad_i;
				types[2] = lps[2]->type1;
				addrs[3].ad_i = lps[3]->ad.ad_i;
				types[3] = lps[3]->type1;
			}
			for (i=0;i< *length;i++) {
				o = pat->sub[i].operand&0377;
				if ((pat->optbits&(1<<i)) && inreg(addrs[i].ad_i))
					found=0;
				else switch(optab[o]) {
/*	<<<<<<<<<<<<<<<<<<<< */
	case OP_CONS:
		if (types[i]!=CONST || addrs[i].ad_i!=o-EXCESS)
			found = 0;
		break;
	case OP_COPY:
		o =- CONLIM;
		o =/ ARANGE;
		if (types[i] != types[o] || addrs[i].ad_i != addrs[o].ad_i)
			found = 0;
		break;
	case OP_REL:
		o =- CONLIM;
		off = o%ARANGE-ARANGE/2;
		o =/ ARANGE;
		if (types[i]==types[o])
			switch(types[i]) {
			default: found = 0;break;
			case CONST:
				if (addrs[i].ad_i!=addrs[o].ad_i+off)
					found = 0;
				break;
			case GLOSYM:
				if (!(addrs[i].ad_gp->g_status&DEFINED)
				|| !(addrs[o].ad_gp->g_status&DEFINED )
				|| addrs[i].ad_gp->g_val!=addrs[o].ad_gp->g_val+off)
					found = 0;
				break;
			}
		else
			found = 0;
		break;
	case OP_ARIT:
		o =- ARITBASE;
		ad1 = (o&014)>>2;
		ad2 = o&03;
		if (types[i] != types[ad1] ||
			types[i] != CONST && types[i] != GLOSYM ||
			types[i] != CONST && ((o&040)||
				!(addrs[i].ad_gp->g_status&DEFINED) ||
				!(addrs[ad1].ad_gp->g_status&DEFINED)))
			found = 0;
		else {
			val1 = value(ad1);
			val2 = value(ad2);
			vali = value(i);
			switch (o&060) {
			case 000:
				if (val1+val2!=vali)
					found = 0;
				break;
			case 020:
				if (val1-val2!=vali)
					found = 0;
				break;
			case 040:
				if (val1*val2!=vali)
					found = 0;
				break;
			case 060:
				if (val1/val2!=vali)
					found = 0;
				break;
			}
		}
		break;
	case OP_IGN:
		break;
/*	>>>>>>>>>>>>>>> */
				}
			}
			for(i=4;found&&i<7;i++) {
				o=pat->sub[i].operand&0377;
				if(optab[o]==OP_ARIT) {
					o =- ARITBASE;
					if(types[(o&014)>>2]==GLOSYM ||
					   types[o&03]==GLOSYM)
						found=0;
				}
			}
		}
	}
	if (!found)
		pat = 0;
	return(pat);
}

pass_2() {
	register struct pattern *pat;
	register before_this_pass;
	register line_t *ln;
	int length;

	pass = 2;
	for (ln=line; ln<=last_line; ln++)
		if(ln->instr_num==op_lab && ln->ad.ad_lp->l_status==DEFINED)
			rement(ln);
	(last_line+1)->instr_num=ABSENT;
	if (optimizing) {
		subst_made = 0;
		do {
		before_this_pass = subst_made;
		fill_lps(line,0);
		while (lps[0] < (last_line+1)) {
			subst_ok = 0;
			if (pat = reducible(&length)) {  /* = NOT == */
				substitute(pat,length);
				dump(-1);
				if(!subst_ok) {
					bmove(chp_cast &lps[1],
						chp_cast &lps[0], 6);
					fill_lps(lps[2]+1,3);
				}
			} else {
				bmove(chp_cast &lps[1], chp_cast &lps[0], 6);
				fill_lps(lps[2]+1,3);
			}
		}
		} while(subst_made != before_this_pass);
	}
}

/*
** Search for a pattern that matches the intructions  from this line.
** A pattern consists of 7 elements, 4 to match, 3 for replacement.
*/

int extension(apat) struct pattern *apat; {
	register line_t *lnp;
	register i;
	register struct pattern *pat;
	int found,length;
	glob_t *gbp;

	lnp=lps[3]+1;
	i=found=0;
	pat = apat;
	while(lnp<=(last_line+1) && i<3) {
		while(lnp->type1 == PSEUDO)
			lnp++;
		xlps[i] = lnp;
		if(lnp->type1==GLOSYM) {
			gbp=lnp->ad.ad_gp;
			xvalue[i++]=gbp->g_val;
		} else 
			xvalue[i++]=lnp->ad.ad_i;
		lnp++;
	}
	while(i<3)
		xlps[i++] = (last_line+1);
	if(pat->sub[4].instr == 0) {
		++found; length=0;
	} else if (xlps[0]->instr_num==pat->sub[4].instr)
		if(pat->sub[5].instr==0) {
		++found; length=1;
	} else if (xlps[1]->instr_num==pat->sub[5].instr)
		if(pat->sub[6].instr==0) {
		++found; length=2;
	} else if (xlps[2]->instr_num==pat->sub[6].instr) {
		++found; length=3;
	}

	if(found) {
		for(i=0;i<length;i++)
			if(xvalue[i]!=opval(pat->sub[i+4].operand&0377)
				&& result_type!=MISSING) {
					found=0;
					break;
			}
	}
	if(found)
		return(length+4);
	return(0);
}

#define	FIRST_TXX	6
#define	FIRST_ZXX	12
#define	FIRST_BXX	18
#define	FIRST_OP2	27

extern	void	(*subtswitch[])();
extern	int	swsize;

substitute(pat,length) struct pattern *pat; {
	register kind;

	if ((kind = pat->optkind) >= swsize)
		fatal("optkind too large");
	(*subtswitch[kind])(pat,length,kind);
}

plain_substitute(pat,length,kind) struct pattern *pat; {
	register struct element *elt;
	register line_t   *lnp;
	register i;

	for (i=0,elt= &pat->sub[4];i<length;i++,elt++)
		if (i<=2 && elt->instr!=0) {
			lnp = lps[i];
			lnp->instr_num = elt->instr;
			lnp->ad.ad_i = opval(elt->operand&0377);
			lnp->type1 = result_type;
			if(result_type!=CONST && result_type!=MISSING)
				lnp->ad.ad_i=repaddr;
		}
		else
			rement(lps[i]);
	oksub();	/* this substitute always succeeds */
}

adi1_substitute(pat,length,kind) struct pattern *pat; {

	/*
	 * this procedures checks optimizations of the form
	 * adi   loi  ,   ,    lof  ,  ,
	 * to make sure the operand of adi is even
	 */

	if( odd(value(0)))
		return;
	plain_substitute(pat,length,kind);
}

adi2_substitute(pat,length,kind) struct pattern *pat; {
	register n;

	/*
	 * this procedure makes optimizations such as:
	 * lae adi ,  ,  lae A0+A1 , ,	if A1 is even,otherwise
	 * lae adi ,  ,  lae A0+A1-1 adi 1 ,
	 */

	n = value(1);
	lps[0]->ad.ad_i = value(0);
	lps[0]->type1 = CONST;
	if(n==1) /* no sense in doing anything */
		return;
	if (odd(n)) {
		lps[0]->ad.ad_i =+ n-1;
		lps[1]->ad.ad_i = 1;
	} else {
		lps[0]->ad.ad_i =+ n;
		rement(lps[1]);
	}
	oksub();
}

xar_substitute(pat,length,kind) struct pattern *pat; {
	register *p,n;
	register line_t *lps1;

	/*
	 * This procedure makes optimizations of the form:
	 * loc   xar  ,   ,  into adi  nul/loi/sti   ,
	 * This works for xar = aar/lar/sar
	 * Also loc rck is optimized.
	 * If index is out of bounds no optimization is done.
	 */

	lps1 = lps[1];
	if(lps1->type1!=GLOSYM)
		return;
	if ((p = lps1->ad.ad_gp->g_rom) == 0)
		return;
	n = value(0);
	if (lps1->instr_num == op_rck) {
		if(n>=p[0] || n<=p[1]) {
			rement(lps1);
			oksub();
		}
		return;
	}
	if ( n<p[0] || (n =- p[0])>p[1])
		return;	/* index out of bounds */
	lps[0]->instr_num = op_adi;
	lps[0]->type1 = CONST;
	lps[0]->ad.ad_i = n * p[2];
	if (lps1->instr_num == op_aar) {
		rement(lps1);
	} else if(lps1->instr_num == op_lar) {
		lps1->instr_num = op_loi;
		lps1->type1 = CONST;
		lps1->ad.ad_i = p[2];
	} else if(lps1->instr_num == op_sar) {
		lps1->instr_num = op_sti;
		lps1->type1 = CONST;
		lps1->ad.ad_i = p[2];
	} else fatal("bad xar");
	oksub();
}

neg_substitute(pat,length,kind) struct pattern *pat; {
	register n;
	register line_t *p;

	/*
	 * optimizes:	loc	neg	,	,
	 */
	p=lps[0];
	n=value(0);
	p->type1=CONST;
	p->ad.ad_i= -n;
	rement(lps[1]);
	oksub();
}

com_substitute(pat,length,kind) struct pattern *pat; {
	register n;
	register line_t *p;

	/*
	 * optimizes:	loc	com	,	,
	 */
	p=lps[0];
	n=value(0);
	p->type1=CONST;
	p->ad.ad_i= ~n;
	rement(lps[1]);
	oksub();
}

txx_substitute(pat,length,kind) struct pattern *pat; {
	register n;
	register line_t *p;

	/*
	 * optimizes:	loc	txx	,	,
	 * xx= lt,le,eq,ne,ge,gt
	 * depending on which
	 */

	p=lps[0];
	n=value(0);
	p->type1 = CONST;
	switch(kind - FIRST_TXX) {
	case 0:	p->ad.ad_i= ( n < 0 );	break;
	case 1:	p->ad.ad_i= ( n <=0 );	break;
	case 2:	p->ad.ad_i= ( n ==0 );	break;
	case 3:	p->ad.ad_i= ( n !=0 );	break;
	case 4:	p->ad.ad_i= ( n >=0 );	break;
	case 5:	p->ad.ad_i= ( n > 0 );	break;
	}
	rement(lps[1]);
	oksub();
}

cmi_substitute(pat,length,kind) struct pattern *pat; {
	register n1,n2;
	register line_t *p;

	/*
	 * optimizes	loc	loc	cmi	,
	 */

	p=lps[0];
	n1=value(0);
	p->type1=CONST;
	n2=value(1);
	rement(lps[1]);
	rement(lps[2]);
	if (n1==n2) 
		p->ad.ad_i = 0;
	else if (n1>n2)
		p->ad.ad_i = 1;
	else
		p->ad.ad_i = -1;
	oksub();
}

zxx_substitute(pat,length,kind) struct pattern *pat; {
	register n;
	register line_t *p;

	/*
	 * optimizes	loc	zxx	,	,
	 * for meaning of xx see txx_substitute
	 */

	n=value(0);
	rement(lps[0]);
	p=lps[1];
	switch(kind - FIRST_ZXX) {
	case 0:	n = ( n < 0 );	break;
	case 1:	n = ( n <=0 );	break;
	case 2:	n = ( n ==0 );	break;
	case 3:	n = ( n !=0 );	break;
	case 4:	n = ( n >=0 );	break;
	case 5:	n = ( n > 0 );	break;
	}
	if ( n ) 
		gen_brf(p);
	else
		rement(p);
	oksub();
}

bxx_substitute(pat,length,kind) struct pattern *pat; {
	register n1,n2;
	register line_t *p;

	/*
	 * optimizes	loc	loc	bxx	,
	 * for meaning of xx see txx_substitute
	 */

	n1=value(0);
	n2=value(1);
	rement(lps[0]);
	rement(lps[1]);
	p=lps[2];
	switch(kind - FIRST_BXX) {
	case 0:	n1 = (n1 < n2);	break;
	case 1:	n1 = (n1 <=n2);	break;
	case 2:	n1 = (n1 ==n2);	break;
	case 3:	n1 = (n1 !=n2);	break;
	case 4:	n1 = (n1 >=n2);	break;
	case 5:	n1 = (n1 > n2);	break;
	}
	if ( n1 )
		gen_brf(p);
	else
		rement(p);
	oksub();
}

ini_substitute(pat,length,kind) struct pattern *pat; {
	register line_t *p;
	register glob_t *gbp;

	/*
	 * optimizes :	lae  lae  blm  lde a0+a2  sde a1+a2
	 * into		lae a0  lae a1  blm a2+4
	 * 
	 * when arriving here first four instructions are matched,
	 * just check for 5'th one
	 */

	for(p=lps[3]+1;p<=(last_line+1) && p->type1 == PSEUDO;p++)
		;
	if (p>(last_line+1))
		return;
	if (p->instr_num != op_sde)
		return;
	if (p->type1 == CONST)  {
		if (p->ad.ad_i != value(1)+value(2))
			return;
	} else if(p->type1 == GLOSYM) {
		gbp = p->ad.ad_gp;
		if (gbp->g_val != value(1)+value(2))
			return;
	} else return;
	rement(p);
	plain_substitute(pat,length,kind);
}

gen_brf(alnp) line_t *alnp; {
	register line_t *lnp;

	lnp = alnp;
	lnp->instr_num = op_brf;
	lnp++;
	for ( ; lnp->instr_num != op_lab ; lnp++ )
		if ((lnp->instr_num&0377) != op_PSEU)
			rement(lnp);
}

line_t *searchback(alnp) line_t *alnp; {
	register line_t *lnp;

	lnp = alnp;
	while(lnp>line)
		if ((--lnp)->type1!=PSEUDO)
			return(lnp);
	return(0);
}

brf_substitute(pat,length,kind) struct pattern *pat; {
	register line_t *lnp;
	register *llp,*lllp;
	int llb[50];
	int labelfound;

	/*
	 * This procedure optimizes branches to branches
	 */

	for (lnp=lps[0],llp=llb;
		lnp!=0 && lnp->instr_num==op_lab && llp < &llb[50];
			) {
		*llp++ = lnp->ad.ad_i;
		lnp = searchback(lnp);
	}
	lllp=llp;	labelfound=0;
	for(lnp=line;lnp<=(last_line+1);lnp++) {
		if (lnp->instr_num == op_lab &&
			lnp->ad.ad_i==lps[1]->ad.ad_i)
			++labelfound;
		if ((mnemon[lnp->instr_num&0377].m_flags&MNABCEM)==MNB)
		for(llp=llb;llp<lllp;llp++) {
			if(lnp->ad.ad_i== *llp) {
				lnp->ad.ad_i = lps[1]->ad.ad_i;
				if(lnp->instr_num==op_brb &&
					!labelfound)
					lnp->instr_num = op_brf;
			}
		}
	}
}

ret_substitute(pat,length,kind) struct pattern *pat; {
	register line_t *lnp;
	register *llp,*lllp;
	int llb[50];

	/*
	 * This procedure optimizes branches to returns
	 */

	for (lnp=lps[0],llp=llb;
		lnp!=0 && lnp->instr_num==op_lab && llp < &llb[50];
			) {
		*llp++ = lnp->ad.ad_i;
		lnp = searchback(lnp);
	}
	lllp=llp;
	for(lnp=line;lnp<=(last_line+1);lnp++) {
		if (lnp->instr_num==op_brf)
		for(llp=llb;llp<lllp;llp++) {
			if(lnp->ad.ad_i== *llp) {
				lnp->instr_num=op_ret;
				lnp->type1=CONST;
				lnp->ad.ad_i=value(1);
			}
		}
	}
}

int maskar[] EQ {
	0177777,
	077777,
	037777,
	017777,
	007777,
	003777,
	001777,
	000777,
	000377,
	000177,
	000077,
	000037,
	000017,
	000007,
	000003,
	000001
};

int rol (n1,n2) {
	register mask1,mask2;

	mask1 = maskar[n2];
	mask2 = ~mask1;
	return( (((n1&mask2)>>(16-n2))|((n1&mask1)<<n2)) );
}

op2_substitute(pat,length,kind) struct pattern *pat; {
	register n1,n2;
	register line_t *p;

	/*
	 * this procedure optimizes loc loc opr  ,
	 * with opr as above 
	 */

	n1=value(0);
	n2=value(1);
	rement(lps[1]);
	rement(lps[2]);
	p=lps[0];
	p->type1=CONST;
	switch(kind - FIRST_OP2) {
	case 0:	p->ad.ad_i = n1&n2;	break;
	case 1:	p->ad.ad_i = n1|n2;	break;
	case 2:	p->ad.ad_i = n1%n2;	break;
	case 5:	p->ad.ad_i = n1<<n2;	break;
	case 6:	p->ad.ad_i = n1>>n2;	break;
	case 7:	p->ad.ad_i = n1^n2;	break;
	case 3:	p->ad.ad_i = rol(n1,n2&017);	break;
	case 4:	p->ad.ad_i = rol(n1,(-n2)&017);	break;
	}
	oksub();
}

blm_substitute(pat,length,kind) struct pattern *pat; {

	/*
	 * this procedure optimizes consecutive blm's
	 * e.g.:	lae 0 lal 0 blm 4 lae 4 lal 4 blm 8
	 * is optimized to lae 0 lal 0 blm 12
	 */

	if(!extension(pat))
		return;
	lps[2]->ad.ad_i = value(2) + xvalue[1];
	lps[2]->type1 = CONST;
	rement(lps[3]);
	rement(xlps[0]);
	rement(xlps[1]);
	oksub();
}

lai_substitute(pat,length,kind) struct pattern *pat; {
	register line_t *lnp;
	register instr,val;

	/*
	 * optimizes: lol dup adi stl loi   into   lal lai
	 *            lol dup adi stl sti   into   lal sai
	 *            loe dup adi ste loi   into   lae lai
	 *            loe dup adi ste sti   into   lae sai
	 * can't use extension because the first four are not unique
	 */
	lnp = lps[3]+1;
	while (lnp->type1 == PSEUDO)
		lnp++;
	instr = lnp->instr_num&0377;
	if (lnp->type1==GLOSYM)
		val = lnp->ad.ad_gp->g_val;
	else
		val = lnp->ad.ad_i;
	if (instr != op_loi && instr != op_sti)
		return;
	if (val != opval(pat->sub[4].operand&0377))
		return;
	if ((lps[0]->instr_num&0377) == op_lol)
		lps[0]->instr_num = op_lal;
	else
		lps[0]->instr_num = op_lae;
	if (instr == op_loi)
		lps[2]->instr_num = op_lai;
	else
		lps[2]->instr_num = op_sai;
	rement(lps[1]);
	rement(lps[3]);
	rement(lnp);
	oksub();
}

void	(*subtswitch[])() EQ {
/*  0 */plain_substitute,
	adi1_substitute,
	adi2_substitute,
	xar_substitute,
	neg_substitute,
	cmi_substitute,
	txx_substitute,
	txx_substitute,
	txx_substitute,
	txx_substitute,
/* 10 */txx_substitute,
	txx_substitute,
	zxx_substitute,
	zxx_substitute,
	zxx_substitute,
	zxx_substitute,
	zxx_substitute,
	zxx_substitute,
	bxx_substitute,
	bxx_substitute,
/* 20 */bxx_substitute,
	bxx_substitute,
	bxx_substitute,
	bxx_substitute,
	ini_substitute,
	brf_substitute,
	com_substitute,
	op2_substitute,
	op2_substitute,
	op2_substitute,
/* 30 */op2_substitute,
	op2_substitute,
	op2_substitute,
	op2_substitute,
	op2_substitute,
	ret_substitute,
	blm_substitute,
	lai_substitute
};

int	swsize	EQ 0+(sizeof subtswitch)/2;

rement(p) line_t *p; {	/* remove entry */
	register line_t *lnp;

	lnp = p;
	lnp->instr_num = op_nul;
	lnp->type1 = PSEUDO;
	lnp->ad.ad_i = 0;
}

fill_lps(alnp,i) line_t *alnp; {
	register line_t *lnp;

	lnp = alnp;
	while (lnp <= (last_line+1) && i<4) {
		while(lnp->type1 == PSEUDO)
			lnp++;
		lps[i++] = lnp++;
	}
	while (i<4) {
		lps[i++] = (last_line+1);
	}
}

oksub() {
	int backs;
	register line_t *t1,*t2,*t3;

	subst_made++; subst_ok++;
	if ((t1=searchback(lps[0]))!=0)
		if ((t2=searchback(t1))!=0)
			if ((t3=searchback(t2))!=0)
				backs=3;
			else	backs=2;
		else		backs=1;
	else			backs=0;
	switch (backs) {
	case 3:	lps[0] = t3;
		lps[1] = t2;
		lps[2] = t1;
		fill_lps(t1+1,3);
		break;
	case 2:	lps[0] = t2;
		lps[1] = t1;
		fill_lps(t1+1,2);
		break;
	case 1:	lps[0] = t1;
		fill_lps(t1+1,1);
		break;
	case 0:	fill_lps(lps[0],0);
		break;
	}
}

int inreg(n) {
	register int *p;

	for(p=regvar;p<regp;p++)
		if (*p == n)
			return(1);
	return(0);
}
