#include	"../h/local.h"
#include	"ass00.h"
#include	"assex.h"
#include	"../h/em1.h"
/*
 * read compact code and fill in tables
 */

int	tabval;

/* These constants are close to sp_cend for fast switches */
#define	INST	256
#define	PSEU	257
#define	ILBX	258
#define	DLBX	259
#define	CSTX	260

int table3(n) int n; {

	switch (n) {
	case sp_ilb1:	tabval = readbyte(); return(ILBX);
	case sp_ilb2:	tabval = readword(); return(ILBX);
	case sp_dlb1:	make_string(readbyte()); return(DLBX);
	case sp_dlb2:	make_string(readword()); return(DLBX);
	case sp_dnam:	inident(); return(DLBX);
	case sp_pnam:	inident(); return(n);
	case sp_cst1:	tabval = readbyte(); return(CSTX);
	case sp_cst2:	tabval = readword(); return(CSTX);
	case sp_cstm:	tabval = -readbyte(); return(CSTX);
	default:	return(n);
	}
}

int table1() {
	register n;

	n = readbyte();
	if ((n <= sp_lmnem) && (n >= sp_fmnem)) {
		tabval = n;
		return(INST);
	}
	if ((n <= sp_lpseu) && (n >= sp_fpseu)) {
		tabval = n;
		return(PSEU);
	}
	if ((n < sp_filb0 + sp_nilb0) && (n >= sp_filb0)) {
		tabval = n - sp_filb0;
		return(ILBX);
	}
	return(table3(n));
}

int table2() {
	register n;

	n = readbyte();
	if ((n < sp_fcst0 + sp_ncst0) && (n >= sp_fcst0)) {
		tabval = n - sp_fcst0;
		return(CSTX);
	}
	return(table3(n));
}

int getint() {
	if (table2() != CSTX)
		fatal("int expected");
	return(tabval);
}

glob_t *getlab(status) {
	if (table2() != DLBX)
		fatal("global label expected");
	return(glo2lookup(string,status));
}

char *inproname() {
	if (table2() != sp_pnam)
		fatal("procname expected");
	return(string);
}

read_compact() {
	register line_t *lnp,*limit;

	/*
	 * read procedure in compact EM1 code
	 */
	pass = 1;
	end_seen = 0;	lnp = line;	line_num = 1;
	limit = &line[oursize->n_lines];
	do {
		last_line = lnp;
		compact_line(lnp++);
		line_num++;
	} while (!end_seen && lnp < limit);
	if (!end_seen)
		fatal("line table overflow");
}

compact_line(alnp) line_t *alnp; {
	register line_t *lnp;

	/*
	 * read one "line" of compact code.
	 */
	lnp = alnp;
	lnp->format=UNDEF;
	lnp->length=0;
	curglosym=0;
	switch (table1()) {
	default:
		fatal("unknown byte at start of \"line\"");	return;
	case INST:
		lnp->instr_num = tabval;
		if ((mnemon[tabval].m_flags&MNXYZ)==MNZ) {
			lnp->type1 = MISSING;
			lnp->ad.ad_i = 0;
			return;
		}
		/*
		 * This instruction should have an opcode, so read it after
		 * this switch.
		 */
		break;
	case DLBX:
		curglosym = glo2lookup(string,DEFINING);
		if (curglosym->g_status&IMP) {
			if (!(curglosym->g_status&REL))
				error("wrong type of label",0);
		} else
			curglosym->g_status =| REL;
		curglosym->g_val = databytes;
		lastglosym = curglosym;
		if (table1() != PSEU)
			fatal("no pseudo after global label");
	case PSEU:
		lnp->instr_num = tabval;
		lnp->type1 = MISSING;
		lnp->ad.ad_i = 0;
		inpseudo(lnp);
		return;
	case ILBX:
		lnp->ad.ad_lp = loclookup(tabval,DEFINING);
		lnp->type1 = LOCSYM;
		lnp->instr_num = op_lab;
		return;
	}

	/*
	 * Now process argument
	 */

	switch(table2()) {
	default:
		fatal("unknown byte at start of offset");	return;
	case CSTX:
		lnp->ad.ad_i = tabval;
		lnp->type1 = CONST;
		return;
	case ILBX:
		lnp->ad.ad_lp = loclookup(tabval,OCCURRING);
		lnp->type1 = LOCSYM;
		return;
	case DLBX:
		lnp->ad.ad_gp = glo2lookup(string,OCCURRING);
		lnp->type1 = GLOSYM;
		return;
	case sp_pnam:
		lnp->ad.ad_pp=prolookup(string,PRO_OCC);
		lnp->type1=PROCNAME;
		break;
	}
}

inpseudo(alnp) line_t *alnp; {
	register glob_t *gbp,*gbp1;
	register a;
	proc_t *prptr;
	int b;
	int par1,par2,par3; char *pars;

	/*
	 * get operands of pseudo (if needed) and process it.
	 */

	switch (alnp->instr_num & 0377) {
	case ps_bss:
		a = getint();	/* number of bytes */
		extbss(a);
		break;
	case ps_rom:
	case ps_con:
		b = 0;	/* b = stopcondition */
		while(!b) {
			switch(table2()) {
			case CSTX:
				extint(tabval);
				break;
			case ILBX:
				extloc(loclookup(tabval,OCCURRING));
				break;
			case DLBX:
				extglob(glo2lookup(string,OCCURRING));
				break;
			case sp_pnam:
				extint(prolookup(string,PRO_OCC)->p_num);
				break;
			case sp_scon:
				extstring();
				break;
			case sp_rcon:
				extreal();
				break;
			case sp_lcon:
				extlong();
				break;
			case sp_cend:
				b = 1;	/* exit */
				break;
			}
		}
		break;
	case ps_end:
		++end_seen;
		break;
	case ps_eof:
		++end_seen;++eof_seen;
		break;
	case ps_mes:
		switch(getint()) {
		case 0:ertrap();
		case 2:fatal("VIR not implemented");
		case 4:sourcelines = getint(); break;
		case 5:intflags =| 020; break;	/*floats used*/
		}
		while (table2() != sp_cend)
			;
		break;
	case ps_exc:
		par1 = getint();
		par2 = getint();
		if (par1 == 0 || par2 == 0)
			break;
		if (alnp+par1 >= &line[oursize->n_lines])
			fatal("no room for exchange");
		bmove(chp_cast (alnp-(par1+par2)),
			chp_cast alnp,par1 * sizeof *line);
		bmove(chp_cast (alnp-par2),
			chp_cast (alnp-(par1+par2)),
			(par1+par2) * sizeof *line);
		break;
	case ps_exd:
		gbp = getlab(EXPORTING);
		break;
	case ps_imc:
		gbp = getlab(IMPORTING);
		break;
	case ps_ima:
		gbp = getlab(IMPORTING);
		gbp->g_status =| REL;
		break;
	case ps_fwa:
		gbp = getlab(FORWARDING);
		gbp->g_status =| REL;
		break;
	case ps_fwc:
		gbp = getlab(FORWARDING);
		break;
	case ps_hol:
		holsize=getint();
		holbase=databytes;
		extbss(holsize);
		break;
	case ps_let:
		gbp=getlab(DEFINING);
		switch (table2()) {
		case DLBX:
			gbp1=glo2lookup(string,OCCURRING);
			if (gbp1->g_status&DEF) {
				tabval=gbp1->g_val;
				if (gbp->g_status & IMP) {
					if ((gbp->g_status&REL)!=
					    (gbp1->g_status&REL))
					    error("wrong type of label in let",0);
				} else
					gbp->g_status =| (gbp1->g_status&REL);
			} else
				error("undefined global in LET",0);
		case CSTX:
			if ((gbp->g_status&(IMP|REL))==(IMP|REL))
				error("wrong type of label in let",0);
			break;
		default:	fatal("illegal second parameter of LET");
		}
		gbp->g_val=tabval;
		break;
	case ps_pro:
		pars = inproname();
		par2 = getint();
		par3 = getint();
		prptr = prolookup(pars,par3 ? PRO_DFX : PRO_DFL);
		proctab[prptr->p_num].pr_off = textbytes;
		proctab[prptr->p_num].pr_par = par2;
		if (procflag) {
			printf("%6l\t%6o\t%5d\t%-12s\t%s",textbytes,textbytes,
				prptr->p_num,pars,curfile);
			if (archmode)
				printf("(%.8s)",archhdr.ar_name);
			printf("\n");
		}
		strcpy(curproc,pars);
		break;
	case ps_fwp:
		prptr = prolookup(inproname(),PRO_LOC);
		break;
	default:
		fatal("unknown pseudo");
	}
	alnp->instr_num = op_nul;
	alnp->type1=CONST;
	alnp->ad.ad_i=0;
}

make_string(n) {
	string[0] = 255;
	string[1] = (n>>8)|0200;
	string[2] = n&0377;
	string[3] = 0;
}

instring() {
	register a;
	register char *p;

	a=readbyte();
	if(a==255)
		a=readword();
	if(a>MAXSTRING)
		fatal("string too long");
	strlngth=a;
	for(p=string;a--; ) {
		*p++ = readbyte();
	}
	*p++=0;
}

inident() {
	instring();
	string[IDLENGTH] = '\0';
}

extint(n) {

	setmode(DATA_CON);
	extword(n);
	databytes =+ 2;
}

extbss(n) {

	setmode(DATA_BSS);
	lastsize =+ n;
	databytes =+ n;
}

extloc(albp) locl_t *albp; {
	register locl_t *lbp;

	/*
	 * assemble a word constant from a local label.
	 * For example  con *1
	 */
	lbp=albp;
	setmode(DATA_CON);
	data_reloc(lbp,dataoff,RELLOC);
	extword(0);
	databytes =+ 2;
}

extglob(agbp) glob_t *agbp; {
	register glob_t *gbp;

	/*
	 * generate a word of data that is defined by a global symbol.
	 * Various relocation has to be prepared here in some cases
	 */
	gbp=agbp;
	switch(gbp->g_status&(DEF|REL)) {
	case DEF|REL:
		setmode(DATA_POINTER);
		extword(gbp->g_val);
		databytes =+ 2;
		break;
	case DEF:
		extint(gbp->g_val);
		break;
	case REL:
		setmode(DATA_POINTER);
		data_reloc(gbp,dataoff,RELGLO);
		extword(0);
		databytes =+ 2;
		break;
	case 0:
		setmode(DATA_CON);
		data_reloc(gbp,dataoff,RELGLO);
		extword(0);
		databytes =+ 2;
		break;
	}
}

extstring() {
	register char *s;
	register n;

	/*
	 * generate data for a string.
	 */
	setmode(DATA_CON);
	instring();
	if (odd(strlngth))
		strlngth++;
	for(n=strlngth,s=string; n--; )
		extbyte(*s++);
	databytes =+ strlngth;
}

extreal() {
	register char *s;
	register n;

	/*
	 * generate data for a real.
	 */

	setmode(DATA_REAL);
	instring();
	for (n=strlngth, s = string;n--;)
		extbyte(*s++);
	if (!odd(strlngth))
		extbyte(0);
	extbyte(0);
	lastsize++;
	databytes =+ SFLOAT ? 4 : 8;
}

extlong() {
	LONGTYPE l;
	register char *p;
	register i;

	/*
	 * generate data for long constants
	 */
	instring();
#ifdef V6
	atol(string, &l);
#endif
#ifndef V6
	l = atol(string);
#endif
	setmode(DATA_LONG);
	for (i=1,p = chp_cast &l; i <= sizeof l; i++)
		extbyte(*p++);
	lastsize++;
	databytes =+ sizeof l;
}
