#include	"../h/local.h"
#include	"ass00.h"
#include	"assex.h"

#ifdef DUMP
char	*typestr[] {"missing","const","procname","glosym","locsym","pseudo"};
char	*formstr[] {"UNDEF","F00","FNN","FEN","FNL","FEL","FNS","FES","FNM"};
char	*labstr[]  {"no","yes","reverse"};

int nicepr(typ,ap) addr_u *ap; char typ; {
	register proc_t *pl;

	switch (typ) {
		case CONST: case MISSING:
			return(ap->ad_i);
		case LOCSYM:
			return(ap->ad_lp->l_num);
		case GLOSYM:
			return(ap->ad_gp - mglobs);
		case PROCNAME:
			pl = ap->ad_pp;;
			if (pl->p_status&(EXP|IMP))
				return((pl-xprocs)+1000);
			else
				return(pl-mprocs);
	}
	return(0);
}

dump(n)
{
	register glob_t	*gb;
	register line_t	*ln;
	register locl_t	*lb;
	proc_t *pl;
	int i;

	if (silent) return;
	printf("\nEM1-assembler      *****   pass %1d complete:\n",n);
	printf("%4d %6d %6d %6d \n\n",
		(last_line - line) ,
		max_bytes, prog_size, rev_loc);
	printf("%9.9s%9.9s%8.8s%8.8s%8.8s\n", "instr_nr",
		"type1","addr1","length","format");
	for (ln = &line[0],i = 1 ; ln <= last_line ; ln++,i++) {
		printf("%4d  %3.3s%9.9s%8d%9d   %4s\n",
			i, mnemon[ln->instr_num&0377].m_name, typestr[ln->type1],
			nicepr(ln->type1,&ln->ad),
			ln->length,
			formstr[ln->format]);
	}
	printf("\n    %8s%8s%8s%8s%8s\n","labnum","minval","maxval",
		"labval","defined");
	for ( lb = locs ,i = 1;lb < &locs[oursize->n_llab] ; lb++,i++)
	    if (lb->l_num)
		printf("%4d%8d%8d%8d%8d  %-s\n", i, lb->l_num, lb->l_min,
			lb->l_max, lb->l_val, labstr[lb->l_defined]);
	if (n>1) return;
	printf("\n\t%8s%8s%8s\n","g_name","g_status","g_val");
	for (gb = mglobs,i = 0;gb < &mglobs[oursize->n_mlab]; gb++, i++)
	    if (gb->g_name[0] != 0) {
		printf("%5d\t",i);
		if(gb->g_name[0]!= '\377')
			printf("%8.6s",gb->g_name);
		else
			printf(".%-7d",gb->g_name[2]|((gb->g_name[1]&0177)<<8));
		printf("%8o%8d\n", gb->g_status,gb->g_val);
	    }
	printf("\n\n");
	printf("\n\t%8s%8s%8s\n","g_name","g_status","g_val");
	for (gb = xglobs,i = 0;gb < &xglobs[oursize->n_glab]; gb++, i++)
	    if (gb->g_name[0] != 0) {
		printf("%5d\t",i);
		if(gb->g_name[0]!= '\377')
			printf("%8.6s",gb->g_name);
		else
			printf(".%-7d",gb->g_name[2]|((gb->g_name[1]&0177)<<8));
		printf("%8o%8d\n", gb->g_status,gb->g_val);
	    }
	printf("\n\n");
	printf("\n\t%8s%8s%8s\t%8s%8s\n","name","status","num","off","par");
	for (pl=mprocs;pl< &mprocs[oursize->n_mproc]; pl++)
	    if (pl->p_name[0]) {
		printf("%4d\t%-8s%8o%8d",pl-mprocs,pl->p_name,pl->p_status,pl->p_num);
		if (pl->p_status&DEF)
			printf("\t%8d%8d",proctab[pl->p_num].pr_off,
				proctab[pl->p_num].pr_par);
		printf("\n");
	}
	printf("\n\t%8s%8s%8s\t%8s%8s\n","name","status","num","off","par");
	for (pl=xprocs;pl< &xprocs[oursize->n_xproc]; pl++)
	    if (pl->p_name[0]) {
		printf("%4d\t%-8s%8o%8d",pl-xprocs,pl->p_name,pl->p_status,pl->p_num);
		if (pl->p_status&DEF)
			printf("\t%8d%8d",proctab[pl->p_num].pr_off,
				proctab[pl->p_num].pr_par);
		printf("\n");
	}
}
#endif

#ifdef TIMING
timing(n) {
	int tvec[2];
	extern char *ctime();

	time(tvec);
	printf("Time after pass %d",n);
	if (curfile)
		printf(" of file %s",curfile);
	printf(": %s",ctime(tvec));
}
#endif
