/*
 * Character blocks are used to buffer i/o to/from terminal-type devices.
 * They are chained together in device lists as required.
 * cfreelist heads the free list. Clists are also borrowed for the timout list
 * (see alternate structure definition in callo.h).
 */
struct cblock
{
	struct cblock *c_next;		/* next cblock in chain */
	char c_info[CBSIZE];
};

/*
 * A clist structure is the head
 * of a linked list queue of characters.
 * The characters are stored in 4-word
 * blocks containing a link and several characters.
 * The routines getc and putc
 * manipulate these structures.
 */
struct clist
{
	short	c_cc;		/* character count */
	char	*c_cf;		/* pointer to first char */
	char	*c_cl;		/* pointer to last char */
};

/*
 * A tty structure is needed for
 * each UNIX character device that
 * is used for normal terminal IO.
 * The routines in tty.c handle the
 * common code associated with
 * these structures.
 * The definition and device dependent
 * code is in each driver. (kl.c dc.c dh.c)
 */
struct tty
{
	struct	clist t_rawq;	/* input chars right off device */
	struct	clist t_canq;	/* input chars after erase and kill */
	struct	clist t_outq;	/* output list to device */
	short	(* t_oproc)();	/* routine to start output */
	caddr_t	t_addr;		/* device address - used in kl.c */
	short	t_flags;	/* mode, settable by ioctl call */
	short	t_state;	/* internal state, not visible externally */
	short	t_pgrp;		/* process group name */
	char	t_delct;	/* number of delimiters in raw q */
	char	t_col;		/* printing column of device */
	char	t_erase;	/* erase character */
	char	t_kill;		/* kill character */
	char	t_char;		/* character temporary & delays */
	char	t_ispeed;	/* input speed */
	char	t_ospeed;	/* output speed */
	char	t_rtype;	/* redirection type */
	char	t_cchar;	/* master quit character */
	struct tty *t_redirect;	/* redirected tty struct */
};

#define	TTIPRI	28
#define	TTOPRI	29

/* limits */
#define	TTHIWAT	100
#define	TTLOWAT	50
#define	TTYHOG	256
#define	TTYBELL	8		/* ring bell when this many chars to go */

/* Internal state bits */
#define	TIMEOUT	01		/* Delay timeout in progress */
#define	WOPEN	02		/* Waiting for open to complete */
#define	ISOPEN	04		/* Device is open */
#define	FLUSH	010		/* outq has been flushed during DMA */
#define	CARR_ON	020		/* Software copy of carrier-present */
#define	BUSY	040		/* Output in progress */
#define	ASLEEP	0100		/* Wakeup when output done */
#define	XCLUDE	0200		/* exclusive-use flag against open */
#define	TTSTOP	0400		/* Output stopped by ctl-s */
#define	HUPCLS	01000		/* Hang up upon last close */
#define	TBLOCK	02000		/* tandem queue blocked */
#define	RAWSLEEP 04000		/* waiting for input in raw mode */

/*
 * Redirection types
 */
#define	TCONDIS    0
#define	TCONLOG    1
#define	TCONVIEW   2
#define	TCONSHARE  3
#define	TCONGRAB   4
#define	TMULTIPLEX 5
#define	TMASTER   0100	/* caution: 0200 will cause sign-bit propagation */
