/*
 *	structure for in core limits
 *
 *	used by the system and by programs such as "init" and "login"
 */

typedef unsigned int	dusage_t;
typedef unsigned short	dlimit_t;
typedef unsigned short	musage_t;

#define	BITSINMASK	8	/* really bitsinbyte */
#define	CLASSMASKSIZE	8	/* bytes in class mask */

struct	lnode
{
	uid_t		l_uid;		/* real uid for owner of this node */
	ushort		l_flags;	/* (see below) */
	ushort		l_shares;	/* allocated shares */
	short		l_nice;		/* nice for share scheduling */
	dlimit_t	l_dlimit;	/* disk limit in units */
	dlimit_t	l_doverflw;	/* disk limit overshoot allowed */
	ushort		l_plimit;	/* max number of processes allowed */
	ushort		l_refcount;	/* actual number of processes */
	musage_t	l_mlimit;	/* max number of pages that can be used by all procs */
	musage_t	l_mplimit;	/* max number of pages that can be used by any one process */
	musage_t	l_muse;		/* actual number of pages used */
	dusage_t	l_duse;		/* actual disk usage */
	long		l_usage;	/* current usage of resources */
	long		l_rate;		/* recent working rate */
	long		l_cost;		/* cost charged in current period */
	char		l_cmask[CLASSMASKSIZE];
};

/*
 * some useful defines for limits system call
 */
#define	L_MYLIM		0	/* get own limits structure */
#define	L_OTHLIM	1	/* get other user's limits structure */
#define	L_ALLLIM	2	/* get all active limits structures */
#define	L_SETLIM	3	/* set limits */
#define	L_DEADLIM	4	/* get zombie and limits structure of child */
#define	L_CHNGLIM	5	/* change active lnode (limits only) */

/*
 * values of limits flags
 */
#define	DAWARN		01	/* one warning given during term. sess. */
#define	DLIMIT		02	/* no further disc output allowed */
#define	ONCELOGIN	04	/* one login, nice async procs to background at log off */
#define	LOGGEDIN	010	/* once only login account is logged in */
#define	CLASSACC	020	/* regard this entry as a class account */
#define	NOEVICT		040	/* this person cannot be evicted */
#define	NOLOGIN		0100	/* this person may not log on */
#define	USELOG		0200	/* can "log" to other systems */
#define	ADMIN		0400	/* system administrator priviledges */
#define	TUTOR		01000	/* tutor priviledges */
#define	GROUPACC	02000	/* regard this entry as a group account */
#define	CURCLASS	04000	/* this account is in current active class */
#define	ASYNCKILL	010000	/* kill all async procs at logoff time */
#define	NEWPASSWD	020000	/* force a password change before login */
#define	CONNECTLIM	040000	/* connect time limits in force */
#define	TTYOPTS		0100000	/* allow user to set higher baud rate etc */

/*
 * usage calculations
 */
#define	IWEIGHT		1	/* disk units weight factor for inodes */
