; the use and distribution of the information
; contained herein may be restricted.
;
title	xfma2,<2-word xfuns>,24,22-jul-74,tph/jdm

.sbttl	load push-pop code for extended functions

	..	ppsin,sin
	..	ppcos,cos
	..	ppatan,atan
	..	ppsqrt,sqrt
	..	ppexp,exp
	..	ppln,log
	..	pplg10,log10
	..	pptan,tan
.sbttl	long route for a**b (a**b = exp(b*log(a)) )

	org	xf,0

xf:	jsr	pc,logf		;take log of number to exponentiate
	movflt	(sp)+,-(r1)	;exponent back to r1
	jsr	pc,mulf		;mult by log of number
	jmp	expf		;and exit thru exponential routine
	.if	ndf	fpu
;	poly4 is a polynomial evaluator to eval
;	c(n)*x**n+c(n-1)*x**n-1+...+c(1)*x+c(0)
;	call poly4 (via $polsh) with x (a 4-wd fl-pt no.)
;	on the r1 stack and c(r4)=a pointer to a pointer to a word
;	containing n+1, i.e., the no. of constants.
;	the constants themselves are stored (as 4-wd fl-pt
;	no's.) immed. before the word containing the n+1,
;	with c(n) at lowest addr and c(0) at highest.
;	e.g., to eval. 5*x**2+3*x+2, the const. table
;	looks like:
;		.word	...,...,...,...		;4-wd fl-pt 5, i.e. c(2)
;		.word	...,...,...,...		;4-wd fl-pt 3, i.e. c(1)
;		.word	...,...,...,...		;4-wd fl-pt 2, i.e. c(0)
;		.word	3			;no. of cons'ts
;
poly2:	;poly2 is like poly4 - but for 2-word stuff
poly4:	mov	(r4)+,r0	;pointer to number of coefficients, etc.
	mov	r4,-(sp)	;save return pointer
	mov	(r0),r4		;save the number of coefficients in r4
	mov	r4,-(sp)	;and on the stack
	mov	(r1)+,r2	;save x
	mov	(r1)+,r3
	.rept	fltlen-2
	mov	(r1)+,-(sp)
	.endr
	br	plp42		;go push a coefficient
plp41:	.if	eq	fltlen-4	;fetch x back to the r1 stack
	mov	(sp),-(r1)
	mov	2(sp),-(r1)
	.endc
	mov	r3,-(r1)
	mov	r2,-(r1)
plp42:	movflt	-(r0),-(r1)	;push one of the coefficients
	dec	r4		;decrement the coefficient count
	bgt	plp41		;around again if count not done
	.if	eq	fltlen-4
	cmp	(sp)+,(sp)+	;some garbage off the stack
	.endc
	dec	(sp)		;decrement 2nd copy of counter
plp43:	jsr	pc,mulf		;multiply top of stack by x
	jsr	pc,addf		;add in next coefficient
	dec	(sp)		;decrement coefficient count
	bgt	plp43		;br if more to do in loop
	tst	(sp)+		;pop the counter
	mov	(sp)+,r4	;restore polish pointer
	jmp	@(r4)+		;polish exit
;	up4 is a polish routine to move the 4 wds at the head
;	of the stack to a loc 8 wd's away inside the stack
up2:	;like up4 but 2 words at head get moved 4 words away
up4:	movflt	(r1)+,6*fltlen-2(r1)  ;move some words some distance
	jmp	@(r4)+
;
;	mspr1 is a polish routine that transfers the top 2 wds.
;	of the sp stack to the r1 stack
mspr1:	mov	(sp)+,-(r1)
	mov	(sp)+,-(r1)
	jmp	@(r4)+
;
	.endc
tan:	.if	df	decmap
	jsr	pc,dsctst	;get 'faf' arg and check for scaling
	.iff
	jsr	r5,intfun	;demand a floating arg
	args	faf
	.endc
	movflt	(r1)+,-(sp)	;copy arg on sp stack
	fltpp	-(r1)		;back up on r1 stack
	jsr	pc,sinf		;get sin(x)
	movflt	(sp)+,-(r1)	;get back the copy
	jsr	pc,cosf		;get cos(x)
	jmp	divf		;tan(x)=sin(x)/cos(x)
	.sbttl	2-wd fl-pt transcendental routines

;	sqrt	the square root function
;	calling sequence:
;	called with arg (2-word fl-pt no) on the r1 stack
;		jsr	pc,sqrt
;		(return)
;	returns the square root (2-wd fl-pt no.) on the r1 stack
;
sqrt:	jsr	r5,intfun	;demand floater
	+faf
	tst	(r1)		;set flags
	bpl	sqrt1		;br on nonnegative arg
	bic	#100000,(r1)	;positivize negative arg
	sqrerr			;signal error
sqrt1:	beq	exitsq		;fast exitsq if zero
	.if	ndf	fpu
	mov	#3,-(sp)	;push iteration count
	.endc
	mov	2(r1),-(sp)	;save low-order wd of arg
	mov	(r1),-(sp)	;save high-order wd of arg
	asr	(r1)		;form initial estimate
	add	#20100,(r1)
	clr	2(r1)		;use 0 for low-order part
				;to speed add,div
	.if	ndf	fpu
	clr	-(r1)		;push arg on r1,use 0 for low part
	mov	(sp),-(r1)	;push high-order wd of arg
	clr	-(r1)		;push est again (use 0 for low part)
loop:	mov	6(r1),-(r1)	;push high-order wd of estimate
	jsr	r4,$polsh	;enter polish mode
	.word	$dvr,$adr,unpol	;(x/e+e)
unpol:	sub	#200,@r1	;(x/e+e)/2
	dec	4(sp)		;count loop
	beq	rtn2		;leave if count exhausted
	mov	2(sp),-(r1)	;else push low-order wd of arg
	mov	(sp),-(r1)	;then high-order wd of arg
	mov	6(r1),-(r1)	;then low-order wd of estimate
	br	loop		;go for another iteration
rtn2:	add	#6,sp		;clean up sp stack
exitsq:	rts	pc		;return to caller
	.endc
	.if	df	fpu
	mov	#3,r0		;iteration count
	setf			;single precision fp
	ldf	(r1)+,f0	;get initial estimate
	ldf	(sp)+,f2	;get x
;
loop:	ldf	f0,f1		;e=e'
	ldf	f2,f0		;x
	divf	f1,f0		;x/e
	addf	f1,f0		;x/e+e
	dec	r0		;count
	divf	#2.0,f0		;e'=(x/e+e)/2
	bgt	loop
;
	stf	f0,-(r1)	;result to stack
exitsq:	rts	pc		;return to caller
	.endc
;	the log and log10 functions
;	calling sequence:
;	called with arg (2-word fl-pt no.) on r1 stack
;		jsr	pc,log	(or log10)
;		(return)
;	returns ln(arg) (or log10(arg)) (2-word fl-pt no.) on r1 stack
;
	.if	ndf	fpu
log:	jsr	r5,intfun	;demand floating arg
	+faf
logf:	mov	(r1)+,r2	;save x in r2,r3
	ble	error2		;jump if not positive
	mov	(r1)+,r3
	mov	#071030,-(r1)	;push -1/2*ln(2)
	mov	#137661,-(r1)
	cmp	-(r1),-(r1)	;push work space
	mov	r3,-(r1)	;push x
	mov	r2,-(r1)
	asl	(r1)+
	movb	-(r1),-(sp)	;get exponent
	movb	#200,(r1)	;transform x into (1/2,1)
	rorb	(r1)
	rorb	-(r1)
	mov	#002363,-(r1)	;push 1/2*root2
	mov	#040065,-(r1)
	mov	r3,-(r1)	;push modified  x
	mov	6(r1),-(r1)
	mov	#002363,-(r1)	;push 1/2*root2
	mov	#040065,-(r1)
	jsr	r4,$polsh	;enter polish mode
	.word	$sbr,up2,$adr,$dvr
				;get (x-root2)/(x+root2)
	.word	dup2,dup2	;get three copies
	.word	$mlr,poly2	;expand polynomial
	.word	const		;const. tab. ptr. for poly2
	.word	$mlr,$adr
	.word	scale1,$ir,pln2,$mlr	;get ln(exp)
	.word	$adr,logqz	;combine with fraction
				;and check if done
;
scale1:	clr	-(r1)
	bisb	(sp)+,(r1)	;get exponent
	sub	#200,(r1)	;remove excess 128
	jmp	@(r4)+
;
pln2:	mov	#071030,-(r1)	;push ln(2)
	mov	#040061,-(r1)
	jmp	@(r4)+
;
log10:	jsr	pc,log
	mov	#055731,-(r1)	;push log10(e)
	mov	#037736,-(r1)
	jmp	mulf
logqz:	rts	pc
;
error2:	mov	r2,-(r1)	;fix up r1 stack
	logerr			;log is infinite
	rts	pc
	.endc
	.if	df	fpu
log10:	jsr	r5,intfun	;demand floating arg
	+faf
	mov	pc,r4		;get non-zero as log10 flag
	br	logf1
log:	jsr	r5,intfun	;demand floating arg
	+faf
logf:	clr	r4		;get 0 as log flag
logf1:	setf			;single precision fp
	seti			;short integers
	mov	#fcons0,r0	;pointer to constants for routine
	ldf	(r1),f2		;get argument
	cfcc
	ble	error2		;jump if not positive
	stexp	f2,r2		;get exponent of arg
	ldcif	r2,f3		;convert to fp form
	mulf	(r0)+,f3	;scale factor=exponent*ln(2)
	ldexp	#0,f2		;transform arg to (1/2,1)
	ldf	f2,f1
	subf	(r0),f2		;x-1/2*sqrt(2)
	addf	(r0)+,f1	;x+1/2*sqrt(2)
	divf	f1,f2		;w=(x-root2)/(x+root2)
	ldf	f2,f1
	mulf	f1,f1		;y= w**2
;
	mov	#3,r2		;count of consts for polynomial
	ldf	(r0)+,f0	;initialize accumulator for polynomial
xpan0:	mulf	f1,f0
	dec	r2		;count
	addf	(r0)+,f0	;f0:=y*f0 + c(i)
	bgt	xpan0		;loop
;
	mulf	f2,f0
	addf	(r0)+,f0	;f0:= w*f0 - 1/2*ln(2)
	addf	f3,f0		;add scale factor for exponent
	tst	r4		;test log10 flag
	beq	logout
	mulf	(r0)+,f0	;log10:= log*log10(e)
;
logout:	stf	f0,(r1)		;move result to stack
	rts	pc		;exit
error2:	logerr			;log is infinite
	rts	pc		;exit
;	order-dependent constants for routine
;	r0 points at current constant in fpu version
;
fcons0:	.word	040061,071030	;ln(2)
;
	.word	040065,002363	;1/2*sqrt(2)
	.endc
;constants for polynomial expansion
;
	.word	037632,014525	;.300974506
	.word	037714,120036	;.399659100
	.word	040052,125332	;.666669471
	.word	040400,000000	;1.99999999
	.if	ndf	fpu
const:	.word	4
;
	.endc
	.if	df	fpu
;	more order-dependent constants
	.word	137661,071030	;-1/2*ln(2)
;
	.word	037736,055731	;log10(e)
	.endc
;	exp	the exponentiation routine
;	calling sequence:
;	called with arg (2-wd fl-pt no.) on r1 stack
;		jsr	pc,exp
;		(return)
;	returns exponential (2-wd fl-pt no.) on r1 stack
;
exp:	jsr	r5,intfun	;demand floating arg
	+faf
expf:	mov	(r1)+,r0	;pop high-order wd of arg to r0
	mov	(r1)+,r3	;pop low-order wd to r3
	mov	r0,r2		;high-order wd also to r2
	bgt	pos1		;jump if arg +
	cmp	r0,#141662
	bhi	zero2		;jump if exponent < -88.7
	br	smtst
pos1:	cmp	r0,#41660
	bhi	over4		;jump if exponent > 87
smtst:	asl	r0		;dump sign
	cmp	r0,#63000
	blo	one		;jump if exponent magnitude < 2**-28
	.if	ndf	fpu
	clr	-(r1)		;push a 1.
	mov	#40200,-(r1)
	.endc
	mov	r3,-(r1)	;get low order argument
	mov	r2,-(r1)	;high order
	.if	ndf	fpu
	jsr	r4,$polsh	;enter polish mode
	.word	dup2
	.word	pl2e		;push log2(e)
	.word	$mlr
	.word	$ri		;fix log2(e)*x
	.word	esave		;save exponent scale
	.word	$ir		;float it
	.word	pl2e		;push log2(e)
	.word	$dvr
	.word	$sbr
	.word	cfract		;push continued fraction constants
	.word	$mlr		;y*y
	.word	$adr		;b1+y*y
	.word	$dvr		;a1/(b1+y*y)
	.word	$adr		;y+a1/(b1+y*y)
	.word	$adr		;a0+y+a1/(b1+y*y)
	.word	$dvr		;y/(a0+y+a1/(b1+y*y))
	.word	inc		;-2*y/(a0+y+a1/(b1+y*y))
	.word	$adr		;1-2*y/.........
	.word	dup2		;duplicate it
	.word	$mlr		;(1-2*y/.....)**2
	.word	scale		;exit polish mode and scale result
inc:	add	#100200,(r1)	;multiply by -2.0
	jmp	@(r4)+		;go back to list
;
pl2e:	mov	#125073,-(r1)	;push log2(e)
	mov	#40270,-(r1)
	jmp	@(r4)+
;
esave:	mov	(r1),-(sp)	;save exponent scale
	jmp	@(r4)+
;
cfract:	rol	(r1)		;shift modified arg
	rol	r0		;save sign
	sub	#400,(r1)	;divide by 2.
	blos	zfract		;underflow. make arg 0
	ror	r0		;get sign back
	ror	(r1)
	mov	(r1),r0		;get modified argument
	mov	2(r1),r2	;in registers
	mov	#036602,-(r1)	;push -12.01501675 ***********
	mov	#141100,-(r1)
	mov	r2,-(r1)	;push modified arg
	mov	r0,-(r1)
	mov	#071571,-(r1)	;push 601.8042667 ***************
	mov	#042426,-(r1)
	mov	#056133,-(r1)	;push 60.0901907 ***********
	mov	#041560,-(r1)
	mov	r2,-(r1)	;push modif. arg again
	mov	r0,-(r1)
	mov	r2,-(r1)	;and again
	mov	r0,-(r1)
	jmp	@(r4)+
	.endc
;
	.if	df	fpu
	setd			;double precision argument reduction
	seti			;short integers
	mov	#fcons2,r0	;pointer to constants
	ldcfd	(r1)+,f2	;get argument
	modd	(r0)+,f2	;f2=fract(x*log2(e))
	stcdi	f3,r4		;r4=int (x*log2(e))
	ldd	#1.0,f0		;f0=1.0
	divd	(r0)+,f2	;y=f2/(2*log2(e))
	setf
	ldcdf	f2,f2		;rest in single precision
	cfcc			;test for underflow
	beq	scale1		;approximation result is 1.0
	ldf	f2,f3
	mulf	f3,f3		;y*y
	addf	(r0)+,f3	;b1+y*y
	ldf	(r0)+,f1
	divf	f3,f1		;a1/(b1+y*y)
	addf	f2,f1
	addf	(r0)+,f1	;a0+y+a1/(b1+y*y
	divf	f1,f2		;y/(a0+y+a1/(b1+y*y
	mulf	#2.0,f2
	subf	f2,f0		;1-2*y/. . .
	mulf	f0,f0		;(1-2*y. . . )**2
scale1:	stf	f0,-(r1)	;move approximation to stack
	mov	r4,r0
	.endc
	.if	ndf	fpu
zfract:	cmp	(r1)+,(r1)+	;flush cfract arg
;			result is 1.
scale:	mov	(sp)+,r0	;get integer part of x*log2(e)
	.endc
	swab	r0		;make it into exponent modifier
	clrb	r0
	asr	r0
	add	r0,(r1)		;add in approximation result
	bmi	over4
	rts	pc		;return to caller
one:	clr	-(r1)
	mov	#40200,-(r1)	;exp(tiny) = 1.
	rts	pc
over4: zero2:	experr
	clr	-(r1)		;return 0
	clr	-(r1)
	rts	pc
	.if	df	fpu
;	order-dependent constants
;
fcons2:	.word	040270,125073	;log2(e) double precision
	.word	024534,013761
;
	.word	040470,125073	;2*log2(e) double precision
	.word	024534,013761
;
	.word	041560,056133	;b1=60.0901907
;
	.word	042426,071571	;a1=601.8042667
;
	.word	141100,036602	;a0=-12.01501675
	.endc
;	sin	cos	the sin and cosine functions
;	calling sequence:
;	called with arg (2-wd fl-pt no.) on r1 stack
;		jsr	pc,sin	(or cos)
;		(return)
;	returns sin or cos of arg (2-wd fl-pt no.) on r1 stack
;
sin:	jsr	r5,intfun	;demand floating arg
	+faf
	br	sinf		;do the sine
cos:	jsr	r5,intfun	;demand floating arg
	+faf
	.if	ndf	fpu
cosf:	mov	#007733,-(r1)	;push pi/2
	mov	#040311,-(r1)
	jsr	r4,$polsh	;enter polish mode
	.word	$adr,sinf	;cos(x)=sin(x+pi/2)
sinf:	clr	-(sp)		;make room for quadrant flag
	asl	(r1)		;remove and save sign
	ror	(sp)		;in quadrant flag
	ror	(r1)		;shift arg back
	cmp	(r1),#026000	;very small?
	blo	rtn3		;yes
	mov	#007733,-(r1)	;push 2*pi
	mov	#040711,-(r1)
	jsr	r4,$polsh	;enter polish mode
	.word	$dvr		;x/2pi
	.word	dup2		;2 copies
	.word	$intr		;int(x/2pi)
	.word	$sbr		;fract(x/2pi)
	.word	x4		;4*fract(x/2pi)
	.word	dup2		;2 copies
	.word	$intr		;int(4*fract(x/2pi))
	.word	quad		;save int(......)
	.word	$sbr		;y=fract(4*fract(x/2pi))
	.word	qset		;reduce y to (-1,1)
qsetre:	.word	dup2		;2 copies
	.word	dup2		;3 copies
	.word	$mlr		;y*y
	.word	poly2		;push coefficients
	.word	consts		;const. tab. ptr. for poly2
	.word	$mlr
	.word	rtn3
rtn3:	tst	(sp)+		;pop quadrant flag
	bge	rtn1		;jump if argument was +
	add	#100000,(r1)	;sin(-x)=-sin(x)
rtn1:	rts	pc		;back to caller
;
x4:	tst	(r1)		;check for 0 fraction
	beq	rtn3		;quit now
	incb	1(r1)		;quadruple stack item
	jmp	@(r4)+
;
quad:	bis	(r1),(sp)	;save quadrant number
	jmp	@(r4)+
;
qset:	tstb	(sp)		;test quadrant
	beq	q13		;jump if first or third quad
	tst	(r1)		;if it's zero
	beq	qset1		;then don't negate it
	add	#100000,(r1)	;negate stack item
qset1:	clr	-(r1)		;push a floating 1.
	mov	#40200,-(r1)
	jsr	r4,$polsh	;enter polish
	.word	$adr,qsetr	;x=1.-x
qsetr:	mov	#qsetre,r4	;point back into list
q13:	asrb	1(sp)		;test quadrant
	bcc	qout		;jump if first or second
	tst	(r1)		;if it's zero
	beq	qout		;then don't negate it
	add	#100000,(r1)	;negate stack item
qout:	jmp	@(r4)+
	.endc
	.if	df	fpu
cosf:	setd			;double precision fp
	ldcfd	(r1)+,f0	;get argument
	addd	piov2,f0	;cos(x)= sin(x+pi/2)
	br	sincos		;
sinf:	setd			;double precision fp
	ldcfd	(r1)+,f0	;get argument
sincos:	seti			;short integers
	mov	#fconst,r0	;pointer to constants
	cfcc			;get sign of argument
	sxt	r4		;save the sign flag
	absd	f0		;remove argument sign
	cmpd	#026000,f0	;very small?
	cfcc
	blt	rtnx		;yes
	divd	(r0)+,f0	;x/(pi/2)
	modd	#0.25,f0	;f0=fract(x/2pi)
	setf			;single precision fp
	ldcdf	f0,f0		;convert argument
	cfcc			;
	beq	rtn3		;check for 0 fraction
	modf	#4.0,f0		;f0=fract(4*fract(x/2pi))
	stcfi	f1,r2		;quad=int(4*fract(x/2pi))
	ror	r2		;
	bcc	q13		;jump if first of third quad
	negf	f0		;
	addf	#1.0,f0		;y=1.0-x
q13:	ror	r2		;
	bcc	q12		;jump if first or second quad
	negf	f0		;y= -y
;
q12:	ldf	f0,f2		;
	mulf	f2,f2		;z=y**2
	mov	#4,r2		;count of constants for poly
	ldf	(r0)+,f1	;initialize accumulator
xpand:	mulf	f2,f1		;
	dec	r2		;count
	addf	(r0)+,f1	;f1:= z*f1 + c(i)
	bgt	xpand		;loop
	mulf	f1,f0		;f0:= y*f1
rtnx:	setf
	tst	r4		;test sign flag
	beq	rtn3		;
	negf	f0		;sin(-x) = -sin(x)
rtn3:	stf	f0,-(r1)	;mov result to stack
	rts	pc		;exit
;
fconst:
piov2:	.word	040311,007732	;pi/2 (double precision)
	.word	121041,064302	;
;
;	order-dependent constants
;
	.endc
	.word	035036,153672	;.00015148419
	.word	136231,023143	;-.00467376557
	.word	037243,032130	;.0796896793
	.word	140045,056741	;-.645963711
	.word	040311,007733	;1.570796318
	.if	ndf	fpu
consts:	.word	5
	.endc
;	the atan function
;	calling sequence for atan:
;	called with arg (2-wd fl-pt no.) on r1 stack
;		jsr	pc,atan
;		(return)
;	returns arctan(arg) (2-word fl-pt no.) on r1 stack
;
atan:	jsr	r5,intfun	;demand floating arg
	+faf
	.if	ndf	fpu
	clr	-(sp)		;clear sign flag
	clr	-(sp)		;clear quadrant bias
	clr	-(sp)
	tst	(r1) 		;test x
	bge	plusqz		;jump if quadrant 1 or 3
	add	#100000,(r1)	;get abs value 
	inc	4(sp)		;flag -
plusqz:	cmp	(r1),#40200	;check if <1.
	blo	le1		;jump if <1.
	bgt	gt1		;>1.
	tst	2(r1)		;check low order
	beq	le1		;=1.
gt1:	mov	#140311,2(sp)	;-pi/2
	mov	#007733,(sp)	;atan(x)=pi/2-atan(1/x)
	dec	4(sp)		;adjust sign
	mov	r1,r2
	jsr	pc,duplf
	mov	#40200,(r2)+	;insert 1.
	clr	(r2)+
	jsr	pc,divf
le1:	mov	r1,r2
	jsr	pc,duplf
	clr	(r2)+		;store zero
	clr	(r2)+
	cmp	(r1),#037611	;tan(15)
	blo	lt15		;jump if less than tan(15)
	bhi	trans		;jump if >
	cmp	2(r1),#030243	;check low order
	blos	lt15		;jump if =
trans:	mov	#005222,-(r2)	;insert pi/6
	mov	#040006,-(r2)
	mov	@r1,r0		;arg to regs
	mov	-(r2),r2
	mov	#131727,-(r1)	;push -root 3
	mov	#140335,-(r1)
	mov	r2,-(r1)	;push arg
	mov	r0,-(r1)
	clr	-(r1)		;push 1.
	mov	#40200,-(r1)
	mov	#131727,-(r1)	;push root3
	mov	#040335,-(r1)
	mov	r2,-(r1)	;push arg
	mov	r0,-(r1)
	jsr	r4,$polsh	;transform arg
;		(root3*x-1)/(root3 +x)
	.word	$mlr,$sbr,up2,$sbr,$dvr,lt15
lt15:	jsr	r4,$polsh
	.word	dup2,dup2,$mlr	;get arg**2
	.word	poly2		;expand polynomial
	.word	const1		;const. tab. ptr. for poly2
	.word	$mlr,$adr
	.word	mspr1		;move value from sp to r1
	.word	$adr		;p(x)+0 if x<=1, p(x)-pi/2 if x>1
	.word	sign3		;adjust sign 
	.word	exit2		;pop result to regs
exit2:	rts	pc		;return to user
;
sign3:	tst	(sp)+		;check sign flag
	beq	sign1
	add	#100000,(r1)	;negate result for (-1,0) & (1,inf)
sign1:	jmp	@(r4)+
	.endc
	.if	df	fpu
	setf			;set fp mode for fpu
	clrf	f3		;clear atan2 bias
	ldf	(r1)+,f0	;get argument
	clr	r4		;clear sign flag
	cfcc			;get sign of argument
	stf	f3,f5		;f5=atan2 bias
	clrf	f3		;clear quadrant bias
	bge	plusqz		;jump if quadrant 1 or 3
	absf    f0		;abs(x)
	inc	r4		;flag -
plusqz:	ldf	#1.0,f1		;1.0
	cmpf	f0,f1		;check if x<=1.0
	cfcc
	ble	le1		;
	dec	r4		;x>1.0, adjust sign flag
	divf	f0,f1		;1.0/x
	ldf	f1,f0		;atan(x)=pi/2-atan(1/x)
	ldf	pi2,f3		;quadrant bias=pi/2
;
le1:	stf	f3,f4		;f4=quadrant bias
	clrf	f3		;f3=0.0
	cmpf	tan15,f0	;compare tan(15) : x
	cfcc
	bge	lt15		;x<= tan(15)
	ldf	pi6,f3		;f3=pi/6
	ldf	f0,f1		;
	mulf	root3,f0	;
	subf	#1.0,f0		;x*root3-1.0
	addf	root3,f1	;x+root3
	divf	f1,f0		;(x*root3-1.0)/(x+root3)
;
lt15:	ldf	f0,f2		;x
	mulf	f0,f0		;x**2
	mov	#fcons1,r0	;pointer to polynomial constants
	mov	#4,r2		;count of coefficients
	ldf	(r0)+,f1	;initialize accumulator
xpand1:	mulf	f0,f1		;
	dec	r2		;count
	addf	(r0)+,f1	;f1:= f1* x**2 + c(i)
	bgt	xpand1		;loop
	mulf	f2,f1		;f1:= f1*x
	addf	f3,f1		;pi/6 or 0.0
	subf	f4,f1		;p(x)-quad bias
	tst	r4		;test sign flag
	beq	sign1		;no adjustment
	negf	f1		;negate result for (-1,0)&(1,inf)
sign1:	addf	f5,f1		;atan2 bias
;
	stf	f1,-(r1)	;move results to stack
	rts	pc		;exit
;
pi:	.word	040511,007733	;pi
pi2:	.word	040311,007733	;pi/2
tan15:	.word	037611,030243	;tan(15)
pi6:	.word	040006,005222	;pi/6
root3:	.word	040335,131727	;root3
	.endc
fcons1:	.word	037305,035302	;.0963034789
	.word	137421,056514	;-.1419574624
	.word	037514,143333	;.1999773201
	.word	137652,125244	;-.3333331319
	.word	040200,000000	;.9999999999
	.if	ndf	fpu
const1:	.word	5
	.endc

