MODULE test4;
{             Test x1 for WG2.4
              -----------------
  Computes transitive closure of a boolean matrix
  using Warshall's algorithm }

CONST size=70; { matrix size }
TYPE matrix=ARRAY 1:size, 1:size OF boolean;
VAR  a, b: matrix;
     n: integer;

PROCEDURE generate: integer;
{ Generate a slightly random number }
BEGIN
  n := 57*n+1;
  generate := n MOD size+1;
  n := n MOD 571
END generate;

PROCEDURE fill(VAR a: matrix; p: integer);
{ sets p elements of a true, the rest false }
  VAR i, j: integer;
BEGIN
  i := 1;
  REPEAT
    j := 1;
    REPEAT
      a[i,j] := false;
      inc(j)
    UNTIL j>size;
    inc(i)
  UNTIL i>size;
  i := 1;
  REPEAT
    a[generate, generate] := true;
    inc(i)
  UNTIL i>p
END fill;

PROCEDURE print(s: ARRAY integer OF char; b: matrix);
  VAR i, j: integer;
BEGIN
 writes(s); newline;
  i := 1;
  REPEAT
    j := 1;
    REPEAT
      IF b[i, j]
      THEN writec('+')
      ELSE writec('-')
      END;
      inc(j)
    UNTIL j>size;
    newline;
    inc(i)
  UNTIL i>size
END print;

PROCEDURE warshall(a: matrix; VAR b: matrix);
  VAR i, j, k: integer;
BEGIN
  b := a;
  i := 1;
  REPEAT
    j := 1;
    REPEAT
      IF b[j, i]
      THEN k := 1;
        REPEAT
          b[j, k] := b[j, k] OR b[i, k];
          inc(k)
        UNTIL k>size
      END;
      inc(j)
    UNTIL j>size;
    inc(i)
  UNTIL i>size
END warshall;

PROCEDURE bitsin(a: matrix): integer;
  VAR i, j, sum: integer;
BEGIN
  sum := 0;
  i := 1;
  REPEAT
    j := 1;
    REPEAT
      IF a[i, j] THEN sum := sum+1 END;
      inc(j)
    UNTIL j>size;
    inc(i)
  UNTIL i>size;
  bitsin := sum
END bitsin;

BEGIN { Test x1 }
  n := 1;
  fill(a, 125);
  warshall(a,b);
  rewrite('a.tst');
  writes('Warshalls Algorithm'); newline;
  writes('size: '); writen(size); newline;
  writes('input bits: '); writen(bitsin(a)); newline;
  writes('closure bits: '); writen(bitsin(b)); newline;
  print('Input matrix:', a);
  print('Transitive closure:', b)
END test4.
{
.bp
}
