; The use and distribution of the information
; contained herein may be restricted.
;
endinp:	mov	spda,r4		;get a data area pointer
	add	#base,r4	;point to the input buffer
	br	endi01		;and empty it

inputs:	jsr	pc,inputc	;see if any there etc,etc
	jsr	pc,builds	;go set up for a string
	mov	r3,-(sp)	;save destination address
	jsr	pc,inputc	;this time to get address of buffer
	mov	(sp)+,r3	;restore where it goes
	mov	r4,r2		;get location of input string
1$:	movb	(r2)+,r4	;get a character
	bic	#-177-1,r4	;mask off parity bits
	beq	1$		;ignore initial nulls
	cmpb	r4,#11		;tab?
	beq	1$		;ignore initial tabs
	cmpb	r4,#40		;space?
	beq	1$		;ignore initial spaces
	cmpb	r4,#''		;single quote (')?
	beq	2$		;yes, use it as delimiter
	cmpb	r4,#'"		;double quote (")?
	beq	2$		;yes, use it as delimiter
	mov	#100000+',,r4	;now use comma (,) as delimiter
	dec	r2		;and back up to get 1st character
2$:	movb	(r2),(r3)	;load the trial character
	bicb	#-177-1,(r3)	;and trim any parity bit
	cmpb	r4,(r3)		;delimiter found?
	beq	4$		;yes, call it quits
	mov	#inplst,r5	;no, get end-of-line list
3$:	cmpb	(r3),(r5)+	;match in list?
	beq	5$		;yes, end it
	tstb	(r5)		;more in list?
	bne	3$		;yes, continue through whole list
	cmpb	(r2)+,(r3)+	;now keep character and go to next trial
	br	2$		;try for more characters

4$:	tst	r4		;was the delimiter a comma?
	bmi	5$		;yes, so don't bypass it
	inc	r2		;else bypass closing ' or "
5$:	mov	r2,r4		;save pointer to input
	jsr	pc,@(sp)+	;return to builds
	mov	(sp)+,r5	;get ipc back
	mov	(r2),(r1)	;set up for push of string
	jsr	pc,pushs2	;put it on the list
	mov	r4,r2		;restore the input pointer
	jsr	pc,inputt	;check for terminator
	jmp	pstjs		;coroutine to remove header from string list

inplll:	.byte	',		;list of terminators
inplst:	.byte	012,015,000	;list of end-of-lines
.enabl	lsb

inpu00:	jsr	pc,inputc	;make sure there's input to be had
	mov	r4,r2		;point to the buffer
	jsr	pc,@(sp)+	;build a number as specified
	bvs	2$		;branch if bad format
inputt:	mov	spda,r0		;get the bias
	clr	nvtm(r0)	;set matinput flag to "false"
1$:	movb	(r2)+,r3	;get the next character
	bic	#-177-1,r3	;trim any parity bit
	beq	1$		;branch if null
	cmpb	r3,#040		;see if a space
	beq	1$		;loop for more if a space
	cmpb	r3,#011		;see if a tab character
	beq	1$		;skip tabs too
	cmpb	r3,#015		;the last ok non goodie is <cr>
	bne	3$		;br if not cr
	dec	nvtm(r0)	;if cr, set matinput flag to "true"
	br	1$		;then skip over cr

2$:	clr	r3		;baddy, so flag it
3$:	mov	spda,r4		;get back header for -1 buffer
	add	#base,r4	;at base + spda
	sub	r4,r2		;compute new curloc
	sub	curloc(r4),r2	;calculate bytes used
	add	r2,curloc(r4)	;store it away for next time
	sub	r2,bytcnt(r4)	;and adjust the count accordingly
	mov	#inplll,r2	;get terminator list
10$:	cmpb	r3,(r2)+	;comma is a good one
	beq	5$		;o.k., but don't clear the buffer
11$:	cmpb	r3,(r2)+	;end-of-line terminators match?
	beq	4$		;o.k., and clear the buffer
	tstb	(r2)		;more in list?
	bne	11$		;yes, continue checking
	neg	r3		;others are baddies
4$:	clr	bytcnt(r4)	;clear the minus 1 buffer
5$:	mov	(sp)+,r2	;pick up coroutine return
	movb	#bdnerr,iosts	;guess at a bad number error
	tst	r3		;see if all good or not
	bgt	inpc00		;branch if all ok
	bpl	20$		;branch if really bad number error
	movb	#fmterr,iosts	;other is bad format error
20$:	jsr	pc,(r2)		;remove item from r1 stack via coroutine
	cmp	(sp),#read01	;see if called from 'read'
	beq	8$		;branch if so
;**** warning: input & matinput both require removal of xtra word here
	tst	(r1)+		;remove extra channel # or matinp. addr
	ioterr			;bad format
	jsr	pc,inpc99	;see what slot number it is
	bne	7$		;branch if not the tty
	cmp	(sp),#interp	;check for normal input statement
	beq	6$		;br if normal
	tst	(sp)+		;if matinput, do
	mov	(sp)+,(sp)	;some housecleaning
6$:	mov	scth,r5		;get start of the statement
	jmp	ujx5		;and try it again until it's right

8$:	ioterr			;fatal bad numbers
7$:	emt	fatal		;to the editor

.dsabl	lsb
inputi:	jsr	pc,inpu00	;coroutine to start things off
	jsr	pc,atoi		;coroutine to convert input data to integer
	jsr	pc,@(sp)+	;coroutine return from conversion
	tst	(r1)+		;coroutine to clear stack if conversion error
	rts	pc		;and out

inputf:	jsr	pc,inpu00	;start things off by getting chars
	jsr	pc,atof		;now try to convert to floating
	jsr	pc,@(sp)+	;return after conversion
pftjs:	add	#fltle2,r1	;pop floater to j space
	rts	pc		;that's it

inputl:	jsr	pc,inputc		;get some goodies
	dec	r3			;ends either in <cr><lf> or <lf><cr><0>
	mov	r3,-(r1)
	clr	bytcnt(r2)
	jsr	pc,builds
	mov	(r1)+,r4		;byte count (almost)
	mov	r0,r2			;another pointer to spda
	add	#base,r2
	add	curloc(r2),r2		;point to start of string

	mov	r2,-(sp)		;point to last char
	add	r4,(sp)
	tstb	@(sp)+			;to see which type
	beq	1$			;end with _
	movb	(r2)+,(r3)+
	sob	r4,.-2
	br	2$
1$:	movb	(r2)+,(r3)+
	sob	r4,.-2
	movb	#'_,-2(r3)
2$:	movb	#12,-1(r3)
	br	num$02


inputc:	mov	spda,r2		;get a data area pointer
	add	#base,r2	;go to input buffer
	mov	r2,r4		;copy header address
	add	curloc(r2),r4	;compute current address
	mov	bytcnt(r2),r3	;get the length remaining
	bne	inpc00		;exit now if stuff there
	jsr	pc,inpc99	;see if slot 0 as source
	bne	inpc90		;if not 0 then an error
	clr	-(r1)		;slot # of 0
	jsr	pc,ssi		;get another line
	br	inputc		;and loop to exit

inpc90:	nederr	!fatal		;not enough data given

inpc99:	mov	spda,r2		;get a data area pointer
	add	currio(r2),r2	;go to the bufffer header
	tstb	slot(r2)	;see if zero
inpc00:	rts	pc		;let caller decide

val:	jsr	r5,intfun	;call the function fixer upper
	 +	fas		;one string is plenty
	mov	r1,r2		;copy the stack pointer
	mov	length(r1),r4	;get the length
	add	pntr(r1),r2	;get a pointer to the string
	add	r2,r4		;point to the end of the string
	jsr	pc,pstjs	;pop the string
	movb	(r4),-(sp)	;save the next character
	clrb	(r4)		;stop the scan
	mov	r4,-(sp)	;save its address
	jsr	pc,atof		;call for conversion
	bvc	2$		;conversion had no errors
	clr	r2		;was an error--force call below
2$:	mov	(sp)+,r4	;restore the end address
	movb	(sp)+,(r4)	;replace the end next character
	cmp	r4,r2		;see if all the string scanned
	beq	1$		;branch if ok
	bdnerr			;bad format
1$:	rts	pc		;and return

num$:	jsr	r5,intfun	;call the function entry dude
	 +	faf		;floater wanted
num$00:	mov	#maxsig+12.,r3	;maximum length
	jsr	pc,builds	;go make a string
	mov	r3,-(sp)	;save the address
	jsr	pc,printa	;do print conversion
	mov	(sp)+,r3	;restore the buffer address
1$:	movb	(r2)+,(r3)+	;store a character
	bne	1$		;loop till the end
	dec	r3		;back up to the null
num$02:	mov	spda,r0		;restore r0 to spda pointer
	jsr	pc,@(sp)+	;co-routine back to builds
	mov	(sp)+,r5	;restore ipc
	mov	(r2),(r1)	;set up link
	jmp	pushs2		;and push and exit

savem:	mov	r3,-(sp)	;save r4,r3,r2,r0
	mov	r2,-(sp)
	mov	r0,-(sp)
	mov	r4,pc

svacrg:	mov	r1,r1ring	;save r1 in relocation area
	mov	r5,r5ring	;ditto r5, so we can be swappable
	rts	pc		;now we can slide about freely
ssorec:	mov	(r1)+,-(sp)	;save "record" value
	jsr	pc,sso		;now do the real sso part
	add	r2,r3		;make pointer abs
	tst	-(r1)		;backup for later "pop"...
	mov	(sp)+,curblk(r3);now set the "record" value
	movb	#flgrnd/400+force,-(sp);for this to be legal
	bicb	flags(r3),(sp)+	;both of these bits must be on
	beq	ssore1		;both were on, so exit o.k.
	noracs	!fatal		;else fatal type error

sso:	cmp	(r1),#12.	;see if in range
	blos	sso01		;branch if user channel
	cmp	runlvl,#1	;only editor allowed up here
	beq	sso01		;this is him, so allow access
	bserr	!fatal		;user trying to screw us. not this time!

sso01:	mov	(r1),r3		;alternate entry point *****
	ash	#4,r3		;make it (slot * 8) and a word index
	add	#base+iolen,r3	;and skip over the constant stuff
	mov	spda,r2		;get the pda pointer
	mov	r3,currio(r2)	;store the buffer header address
	add	r2,r3		;make pointer abs
	bitb	#force,flags(r3);force type device?
	beq	ssore1		;nope, leave current block alone
	clr	curblk(r3)	;yep, so clear current block ("record" value)
ssore1:	sub	r2,r3		;make pointer rel again
clsr99:	tst	(r1)+		;pop off slot
clsr98:	rts	pc		;and exit

closer:	tst	(r1)		;see if tty
	beq	clsr99		;exit now if nothing to do
	jsr	pc,sso		;calculate buffer address
clsr09:	mov	r2,r0		;copy spda
	add	r3,r0		;absolute to iob
	tst	length(r0)	;see if slot is open
	beq	clsr98		;branch if no work to do
	mov	r3,-(sp)	;save relative address of header
	add	r2,r3		;make absolute
	mov	slot(r3),-(sp)	;save slot/flags on stack
	bit	#wrtary*256.,(sp);see if meddled bit is on
	beq	10$		;branch if easy this time
	tst	bytcnt(r3)	;check if random
	beq	11$
	clr	curblk(r3)	;sequential
	br	13$		;don't null pad!
11$:	bit	#force*400,(sp)	;line-by-line?
	bne	13$		;yes - no write at all
	mov	length(r3),bytcnt(r3)
13$:	tst	bytcnt(r3)	;any data to send?
	beq	10$		;nope, so don't try to output any...
	jsr	pc,prl14	;call for output service
10$:	jsr	pc,getbuf	;get a firqb
	clr	(r4)+		;clear the link word
	tstb	(r4)+		;skip job
	movb	#clsfq,(r4)+	;the function
	movb	(sp)+,(r4)+	;and the slot number
	jsr	pc,fipcal	;call fip processor
	beq	1$		;see if any trouble with close
	ioterr	!fatal		;there was...
1$:	clr	r0		;zero buffer length
	mov	(sp)+,r2	;set up r2 for buffer allocator
	jmp	thent		;de-allocate the buffer
ssi:	jsr	pc,sso		;go select and set up currio
ssix1:	add	r2,r3		;compute address of i/o header
	add	#base,r2	;r3 is for the input line
	tst	length(r2)	;see if file open
	bne	1$		;yes, ok
	notopn	!fatal		;not open!

1$:	tst	bytcnt(r2)	;see if it's empty
	bgt	3$		;branch if not quite empty
	mov	pntr(r2),curloc(r2)	;set up curloc for the exit
	clr	bytcnt(r2)	;zero the byte count
3$:	jsr	pc,ssi031	;now get the character
ssi01:	beq	10$		;flush away the nulls
	cmpb	#12,(r0)	;is it a <lf>?
	beq	ssi021		;branch if <lf>
	cmpb	#137,(r0)	;see if left arrow (_)
	beq	ssi300		;yes, special processing
	jsr	pc,ssi110	;stash away that character
10$:	jsr	pc,ssi001	;and get next character
	br	ssi01		;and go check it out

ssi110:	inc	r0		;go to the next character in the output buffer
	inc	bytcnt(r2)	;show the moved character
	cmp	bytcnt(r2),length(r2)	;see if any room left
	blo	11$		;branch if ok
	clr	bytcnt(r2)	;clear any tty input now
	jsr	pc,ssi11	;close out the creation of the buffer
	linerr			;tell people that it's too long
	tst	(sp)+		;dump the return and do final exit
11$:	rts	pc

ssi031:	mov	r2,r0		;copy the two
	mov	r3,r4		;  buffer header pointers
	add	curloc(r0),r0	;r0 has buffer address
	add	bytcnt(r2),r0	;adjust for partial buffer
	add	curloc(r4),r4	;r4 is for the line to be
ssi001:	dec	bytcnt(r3)	;see if any input left
	bge	2$		;branch if io not required
	jsr	pc,rdser	;get a buffer's worth
	br	ssi031		;and continue

2$:	movb	(r4)+,(r0)	;move the character
	bicb	#200,(r0)	;clear the parity bit on tape
	rts	pc		;else exit
ssi300:	jsr	pc,ssi001	;get the next character
	cmpb	#012,(r0)	;<nl> ? 
	bne	ssi310		;no...too bad.
	movb	#012,(r0)	;ok, first we
	jsr	pc,ssi110	;store a <nl>.
	movb	#015,(r0)	;and then we
	jsr	pc,ssi110	;store a <cr>.
	clrb	(r0)
	br	ssi08		;all done

ssi310:	movb	(r0),-(sp)	;store r0
	movb	#137,(r0)	;get the original arrow (_)
	jsr	pc,ssi110	;store it
	movb	(sp)+,(r0)	;recover following character
	jsr	pc,ssi110	;store it
	jsr	pc,ssi001	;ready again
	br	ssi01		;done


ssi021:	movb	#15,(r0)	;first we store a <cr>
	jsr	pc,ssi110
	movb	#12,(r0)	;put <cr> into buffer
	jsr	pc,ssi110	;stash the <cr> in the buffer also
	clrb	(r0)		;nullsville
	br	ssi11		;dont increase count though
ssi08:	inc	bytcnt(r2)	;show the final <lf>
ssi11:	sub	r3,r4		;the new curloc
	tst	bytcnt(r3)	;see if forced buffer(or empty)
	bgt	5$		;if still some there branch
	mov	pntr(r3),r4	;else show the start of the buffer
5$:	mov	r4,curloc(r3)	;store it away
	rts	pc		;and return

rdser:	clr	curblk(r3)	;serial read
ssi04:	clr	bytcnt(r3)	;empty out the buffer
	mov	#-1,r4		;set editor wait
	cmp	runlvl,#1	;see if editor or user
	bne	ssi06		;branch to output a ?
ssi07:	mov	pntr(r3),curloc(r3)	;start at the beginning of the line
	jsr	pc,read.	;get line
	mov	spda,-(sp)
	add	#recoun,(sp)
	mov	bytcnt(r3),@(sp)+
	clr	positn(r3)	;as good a guess as any
	mov	pntr(r3),curloc(r3);start at the beginning of the buffer
	bicb	#wrtary,flags(r3);say no meddling yet
	tstb	jobf		;see if ^c typed
	bmi	ssi10		;branch if time to exit
	tst	iosts		;see if eof-maybe
	beq	opnrts		;if no error, then exit
	clr	bytcnt(r3)	;if error, clear out buffer
	ioterr			;log the error and handle if so requested
ssi14:	jmp	ederrn		;go to terminate the old command


ssi06:	mov	spda,r4		;get data area pointer
	mov	waittm(r4),r4	;get user specified wait interval
	bpl	1$		;positive is ok
	clr	r4		;but not negative times
1$:	tstb	slot(r3)	;see if slot 0
	bne	ssi07		;if not then no ?
	mov	r2,-(sp)	;and save r2
	mov	#prompt,r2	;set up the ?
	clrb	xrb+xrci	;channel zero
	.ttclo			;and just reset control/O
	jsr	pc,printl	;print it
	tst	iosame		;input and output same?
	bne	12$		;yes
	jsr	pc,crlf		;no - answer our own prompt
12$:	mov	(sp)+,r2	;get buffer header pointer back
	br	ssi07		;and go get a buffer full

ssi10:	clr	bytcnt(r3)	;clear buffer if ctrl/c
	cmp	runlvl,#1	;see if editor calling
	beq	ssi14		;if editor leave this way
	cmp	-(r1),(sp)+	;back r1 for slot and dump return address
	dec	r5		;back up ipc like nathan does to us
	jmp	shutup		;and stop nicely

opnr10:	mov	(r1)+,-(sp)	;save mode
	mov	(r1)+,-(sp)	;save record size
	bic	#1,(sp)		;but make it even for thent
	mov	(r1),-(sp)	;save channel # for close
	jsr	pc,closer	;close the slot if open now
	mov	(sp)+,r2	;recover channel #
	asl	r2		;times 2 for channel index
	jsr	pc,opnr20	;open it
	mov	(sp)+,-(r1)	;we'll use the record size later
	mov	(sp)+,fqbits(r4)	;special mode bits
	mov	(r1),fqlksz(r4)	;save it for new type of open
opnrts:	rts	pc

fipcal:	jsr	pc,svacrg	;save the goood ones
	calfip			;do the monitor emt
rsacrg:	mov	r1ring,r1	;restore r1
	mov	r5ring,r5	;and r5 with any approiate adjustment
	br	ioert		;return useful bit

getbuf:	mov	#fqbsiz-2,r4		;to clear
	movb	job,-(sp)
1$:	clr	firqb(r4)	;clear one
	sub	#2,r4
	bpl	1$		;clear all
	mov	#firqb,r4	;return proper r4
	movb	(sp)+,fqjob(r4)	;restore job
	rts	pc

	.sbttl	read. and write. io routines
;	both are called with an absolute iob pointer in r3
;	they transfer all required parameters to the xrb
;	and execute the appropriate monitor call
;	they assume that the iob curblk is set to 0(serial) or block number
;	the block number is always left in the iob
;	call with jsr pc

io:	mov	r3,xrb+xrloc	;to make a relative pointer
	tst	(r3)+		;skip link
	add	(r3)+,xrb+xrloc	;now absolute
	mov	(r3)+,xrb+xrlen	;buffer length
	mov	(r3)+,xrb+xrbc	;byte count
	tst	(r3)+		;skip
	mov	(r3)+,xrb+xrci	;channel index
	tst	(r3)+		;skip to curblk
	mov	(r3),xrb+xrblk	;0 (serial) or block
	jsr	pc,@(sp)+	;inout selection
	bitb	#force,flags-curblk(r3);force type device?
	bne	1$		;yes, so don't remember returned value
	mov	xrb+xrblk,(r3)	;no, so remember the value
1$:	sub	#curblk,r3	;back up to top of iob
ioert:	tst	iosts		;return error indicator
	rts	pc

read.:	jsr	pc,io		;set xrb to iob parameters
	clr	xrb+xrbc	;none to start properly
	mov	r4,xrb+xrtime	;set tty input patience
	.read			;monitor service
	mov	xrb+xrbc,bytcnt-curblk(r3)	;returned bytes
	rts	pc

write.:	jsr	pc,io		;set up
	.write			;do it
	rts	pc		;back to io to finish
;thent creates and/or annihilates space for i-o buffers and arrays.
;the space that is creates is always just above the permanent variables
;in "string" space and just below any previously created stuff.
;on entry:	r0	size desired
;		r1	stack
;		r2	buffer or array header, relative spda
;		r3-r4	scratch
;		r5	ipc
;call:	jsr pc,thent
;on exit:	r0	size (evened up)
;		r1	stack
;		r2	buffer or array header, rel spda
;		r3	scratch
;		r4	spda
;		r5	ipc
thent:	mov	spda,r4		;get a pointer to the data area
	jsr	pc,svacrg	;save r1 and r5 for later
	bic	#1,r0		;make length even!
	mov	r0,-(sp)	;save length wanted in case of retry
	bpl	.+4		;no chance of allocating buffer>16k
	xcdcor	!fatal		;so tell him he ran out now
	mov	r2,-(sp)	;save buffer header address too.
	add	r4,r2		;calculate absolute address of header
	mov	length(r2),r5	;get the current length
	bne	opnr32		;branch if expand
	clr	pntr(r2)	;clear the pointer
opnr32:	mov	r0,r1		;store the new length
	sub	r5,r0		;compute size change
	blt	opnr40		;branch if a reduction
	beq	opnr50		;i don't expect to branch much at all
	mov	pld(r4),r3	;get + limit of storage
	sub	pdd(r4),r3	;compute that still free
	cmp	r0,r3		;see if we have enough room
	ble	opnr40		;branch if room to work
	mov	r0,-(sp)	;save the size change
	mov	r0,strnom(r4)	;show our dire need for core
	sub	r4,r2		;relativize buffer header
	mov	r1,-(sp)	;save this (it's no r1stack)
	mov	r1ring,r1	;post stack
	jsr	r5,econom	;call user core manager
	+	strnom
	mov	(sp)+,r1	;restore old stuff
	mov	r0,r4		;restore spda
	add	r4,r2		;absolutize buffer header
	mov	(sp)+,r0	;and recall the size change
opnr40:	mov	r1,length(r2)	;store the new length
	mov	pntr(r2),r3	;get the pointer
	bne	opnr41		;if by chance its there already
	mov	psd(r4),r3	;get static upper address
	add	r4,r3		;a little pussy-footing
	sub	r2,r3		;and we have a pntr
	mov	r3,pntr(r2)	;set it up in core
opnr41:	add	r3,r2		;point to the buffer
	add	r5,r2		;now to the end of the old buffer
	mov	pdd(r4),r3	;gets us the dynamic limit
	add	r4,r3		;makes absolute
	mov	r0,r5		;see if getting bigger or smaller
	blt	opnr43		;branch if collapse
	add	r3,r5		;compute new upper limit
	cmp	(r3)+,(r5)+	;a little busy work for the fast loop
opnr42:	mov	-(r3),-(r5)	;move a word
	cmp	r2,r3		;see if done
	blo	opnr42		;branch if job is not done
	br	opnr44		;now skip collapse

opnr43:	add	r2,r5		;compute lower buffer collapse address
	mov	r5,-(sp)	;save it
opnr51:	mov	(r2)+,(r5)+	;move(collapse) a word
	cmp	r2,r3		;see if done
	blos	opnr51		;loop if more to do
	mov	(sp)+,r2	;restore the position
opnr44:	add	r0,psd(r4)	;adjust data area
	add	r0,pdd(r4)	;base pointers
	mov	r4,r5		;copy pda pointer
opnr45:	tst	(r5)		;see if the end of the road
	beq	opnr46		;go to arra update if so
	mov	r5,r1		;copy the pointer
	add	(r5),r1		;see where the next string might be
	cmp	r1,r2		;see if affected by the juggling done
	bhis	opnr52		;branch if out there
	mov	r1,r5		;else update link pointer
	clr	r3		;no correction factor
	jsr	pc,opnr60	;kill strings in eliminated buffer
	bmi	opnr45		;only reloc pntr when crosses buffer
	add	r0,pntr(r5)	;adjust for its new position
	br	opnr45		;and loop for more

opnr52:	add	r0,(r5)		;link needs changing
	add	(r5),r5		;now it does the trick
opnr53:	clr	r3
	sub	r0,r3		;set correction factor
	jsr	pc,opnr60	;kill strings in eliminated buffer
	bpl	opnr54		;only reloc pntr when it crosses buffer
	sub	r0,pntr(r5)	;amount to reloc it by
opnr54:	tst	(r5)		;see if it ends out here
	beq	opnr46		;if so we can continue elsewhere
	mov	r5,r1		;copy the pointer
	add	(r1),r5		;skip down the link
	cmp	r5,r2		;see if back to home yet
	bhis	opnr53		;branch if more out here
	sub	r0,(r1)		;adjust the link thusly
	mov	r1,r5		;and put it in the right register
	br	opnr45		;and loop more down low
opnr46:	mov	r4,r5		;copy pda pointer again
	add	aryptr(r5),r5	;go to buffer link word
	br	opnr48		;go to handle first entry

opnr47:	tst	(r5)		;see if any left
	beq	opnr50		;branch if done
	add	(r5),r5		;skip the rope
opnr48:	mov	r5,r1		;copy header pointer
	add	pntr(r1),r1	;compute where it is (was)
	cmp	r1,r2		;see if above or below addition
	blos	opnr47		;branch if no adjustment needed
	add	r0,pntr(r5)	;else adjust accordingly
	bitb	#aryiob,flags(r5);is this an array or io header?
	beq	opnr47		;an array--it's reloacated now
	add	r0,curloc(r5)	;io header--fix curloc too
	br	opnr47		;loop for more

opnr60:	add	pntr(r5),r3	;pointer to string
	add	r5,r3		;absolute now
	sub	r2,r3		;relative to buffer
	blt	opnr61		;if lower than buffer
	mov	r3,-(sp)	;check against length
	add	r0,(sp)+	;this always seemed so useless
	bge	opnr61		;if higher or not into buffer
	clr	length(r5)	;reset string
opnr61:	tst	r3		;signal pntr above or below buffer
	rts	pc

openi:	jsr	pc,opnr10	;close old file and scan new one
	br	opni10		;do the open and allocate the buffer

opnr50:	mov	(sp)+,r2	;restore buffer header pointer
	mov	(sp)+,r0	;restore desired length
	jmp	rsacrg		;get active registers back
openo:	jsr	pc,opnr10	;close the slot first and scan the string
opno10:	movb	#crefq,fqfun(r4);create it
	br	opni11		;and go do it

opni10:	movb	#opnfq,fqfun(r4);try to open it
opni11:	jsr	pc,fipcal	;cal file processor
	bne	opni90		;if not zero is all over
opni20:	mov	firqb+fqbufl,r0	;get needed buffer size
	cmp	r0,(r1)+	;is his buffer smaller than ours would be?
	bge	2$		;if his is too small, use our's
	mov	-2(r1),r0	;his is bigger--use it
2$:	movb	r2,xcdchn	;stash ch# * 2 just in case...
	ash	#3,r2		;make slot index to buf hdr index pointer
	add	#base+iolen,r2	;get buffer address
	jsr	pc,thent	;go to the routine tim & i share
	clrb	xcdchn		;we got our buffer
	mov	firqb+fqflag,status(r4);save status at open time
	add	r4,r2		;goto absolute buffer address
	mov	pntr(r2),curloc(r2)	;move curloc
	clr	bytcnt(r2)	;and make it real empty
	movb	firqb+fqflag+1,r4	;get monitor flags
	bicb	#-1-flgfrc-flgrnd-flgpos/400,r4	;keep three of them
	bisb	#aryiob,r4	;keep this one
	movb	r4,flags(r2)	;now they are in iob
	clr	curblk(r2)	;no buffer contents
	rts	pc		;and return
openio:	jsr	pc,opnr10	;close scan etc
	movb	#opnfq,fqfun(r4);set to try open
	jsr	pc,fipcal	;let nat in on the action
	beq	opni20		;if ok do open
	cmpb	#nosuch,iosts	;see if not there error
	beq	opno10		;try to create it then
opni90:	ioterr	!fatal		;file not found

killer:	jsr	pc,opnr20	;get a firqb and scan the first name
	movb	#dlnfq,fqfun(r4);set up to delete by name
kill01:	jsr	pc,fipcal	;invoke the file system
iodie:	tst	iosts		;any error?
	bne	opni90		;branch if any error
	rts	pc		;and exit if ok

namer:	jsr	pc,opnr20		;scan first name
	mov	r4,-(sp)		;move to second slot
	add	#fqnam1,r4
	mov	#100,r2
	mov	r4,r3
	add	r2,r3
	movb	(r4)+,(r3)+
	sob	r2,.-2
	mov	(sp)+,r4
	mov	firqb+fqmode,-(sp)	;the mode we want is from second file
	jsr	pc,scan			;scan second name
	mov	(sp)+,firqb+fqmode	;restore mode now!
	movb	#renfq,fqfun(r4)	;rename function
	br	kill01			;call fip

sleep:	mov	(r1)+,xrb+xrlen	;get # seconds to snooze
	.sleep			;rock a bye baby
	rts	pc		;exit



uuocon:	jsr	r5,intfun		;call the function interpreter
	args	fas			;one string argument
	mov	r1,r3			;pointer to arg stack
	add	pntr(r1),r3		;point to string
	tst	length(r1)		;do we have a key-byte?
	beq	uuobad			;no - fatal
	movb	(r3)+,r2		;get key byte
	cmp	r2,#9.			;in range?
	blos	uuoco1			;yes

uuobad:	badfuo	!fatal			;shoot him down

uuoco1:	asl	r2			;to word index
	add	r2,pc			;dispatch
	br	uuoclo			;reset control O
	br	uuobad			;not assigned
	br	uuoech			;echo enable
	br	uuodch			;echo disable
	br	uuoodt			;enter odt mode
	br	uuoexe			;exit to editor without READY
	br	uuofip			;General FIP processing
	br	uuogcs			;get core common
	br	uuopcs			;put core common
	br	uuobye			;exit to editor and set up noname

uuoclo:	jsr	pc,uuotty		;common set-up
	.ttclo				;call pseudo monitor
	br	iodie

uuoech:	jsr	pc,uuotty
	.ttech
	br	iodie

uuodch:	jsr	pc,uuotty
	.ttnch
	br	iodie

uuoodt:	jsr	pc,uuotty
	.ttodt
	br	iodie

uuopcs:	mov	#corcmn,r2		;pointer to core common
	movb	length(r1),r4		;max length is 127.
	decb	r4			;how long?
	movb	r4,(r2)+		;save it
1$:	ble	2$			;return
	movb	(r3)+,(r2)+		;shove it in
	decb	r4			;tricky count-down
	br	1$
2$:	rts	pc

uuogcs:	mov	#corcmn,r4		;pointer to core common
	movb	(r4)+,r3		;length
	bpl	uuogo1			;must be positive and small
	clr	r3			;null string
	br	uuogo1			;go build a string

uuoexe:	bit	#jfonce,jobf		;does he pass this way but once?
	beq	1$			;no
	jmp	dobye			;zotall ....
1$:	jmp	rtsrer			;go to editor.
	jmp	rtsrer			;go to it

uuobye:	jmp	editor			;edit with NOname

uuotty:	clrb	xrb+xrci
	cmp	length(r1),#1
	blos	1$
	movb	(r3)+,xrb+xrci
1$:	aslb	xrb+xrci
	rts	pc

uuoexs:	jmp	dobye			;clean up files and go.

uuoctl:	bis	#jfccc,jobf		;enable control/c trap
	rts	pc			;easy

uuogem:	clrb	firqb+fqerno
	cmp	length(r1),#3
	blo	1$			;or its no good
	movb	(r3)+,firqb+fqerno	;get error message #
1$:	movb	#errfq,firqb+fqfun	;get error message function
	jsr	pc,kill01		;call system
	mov	#firqb+fqerno,r4	;where the message is
	clr	-(r4)			;return two bytes zero
	mov	#30.,r3			;length
uuogo1:	mov	r3,r2			;prepare to build string
	jsr	pc,builds		;co-routine
	add	#strlen,r1		;pop the string
	tst	r2			;see if done?
	ble	1$			;yes
2$:	movb	(r4)+,(r3)+		;move it in
	sob	r2,2$			;till done
1$:	jmp	mid6			;finish-up routine

uuofip:	cmp	length(r1),#1		;too short?
	blos	uuobad
	movb	(r3)+,r4		;get dispatch
	mov	#uuofdp,r2		;and search for it
2$:	tst	(r2)			;end of list?
	beq	uuobad			;yes - unknbown
	cmp	(r2)+,r4		;same?
	beq	1$			; yes - call
	tst	(r2)+			; past address
	br	2$
1$:	jmp	@(r2)+

uuofdp:					;list of fip calls
	.word	-7,	uuoctl		;enable interrupt catch
	.word	9.,	uuogem		;get error message
	.word	60.,	uuoexs		;exit to UNIX
	.word	61.,	uuodet		;detach (fork)
	.word	62.,	uuowai		;wait for all children
	.word	63.,	uuogps		;get child process status
	.word	64.,	uuoarg		;get an argument
	.word	0			;end of list


uuodet:	jsr	pc,doccox	;copy temp file, split, etc.
		br  1$		;child return - keep on ticking
	mov	#childp,r4	;return child's pid
	mov	#2,r3		;its two bytes
	br	uuogo1		;make into a string
1$:	clr	r3		;child return - null string
	br	uuogo1

uuowai:	clr	childp		;assume for everything
	cmp	length(r1),#4	;need 4 bytes otherwise
	blo	1$		;we don't have them
	movb	(r3)+,childp	;in with the low byte
	movb	(r3)+,childp+1	;and the high byte
1$:	.wait			;now wait for it
uuogps:	mov	#childs,r4	;move in two bytes
	mov	#2,r3		;we say here
	br	uuogo1		;do it

uuoarg:	clr	r4		;get n'th argument
	cmp	length(r1),#3	;did he give an arg
	blo	1$		;no - he means zero
	bisb	(r3)+,r4	;get a byte
1$:	tst	r4		;is it argument zero?
	bgt	2$		;no -ostensibly a real argument
	mov	@usrsp,childs	;return number of args
	br	uuogps		;give back two bytes
2$:	clr	r3		;find out how long argument is
	cmp	r4,@usrsp	;that many args?
	bhi	uuogo1		;no - return null string
	asl	r4		;into word offset
	add	usrsp,r4	;base
	mov	(r4),r4		;its a string pointer
	mov	r4,r2		;save in a volitile place
4$:	tstb	(r2)+		;its null-terminated
	beq	uuogo1		;end found
	inc	r3		;another byte
	br	4$		;just look for more

shelli:	.fork
		br sh02			;child return
sh00:	.wait				;child will die
	tst	childs			;see if child return good
	beq	2$			;yes
	prgerr				;tell user about it
2$:	rts	pc			;time to leave
sh02:	mov	#shella,r1		;how to call a shell
sh01:	mov	#shelln,r0		;the shell's name
	.exec				;no return

shells:	.fork				;the two plays start the same
		br 1$			;child
	br	sh00			;and end the same
1$:	mov	r1,r3			;but have a different middle act
	add	pntr(r1),r3		;be destructive.
	mov	r3,r4			;save pointer
	add	length(r1),r4		;zero the last byte
	clrb	(r4)			;its always there
	mov	r3,shellb+4		;save in its proper place
	mov	#shellb,r1		;the argument list
	br	sh01			;go execute

	.enabl	lc
shelln:	.asciz	+/bin/sh+
shellc:	.asciz	+-c+
shelld:	.asciz	+-+
	.even
	.dsabl	lc
shella:	.word	shelld
	.word	0

	tmporg	udata
shellb:	.word	shelln
	.word	shellc
	.blkw
	.word	0
	unorg



ascii:	jsr	r5,intfun	;call the pdp-11 function interpreter
	args	fas		;one string required
	mov	r1,r3		;copy the stack
	add	pntr(r3),r3	;pointe the the string
	clr	-(sp)		;possible 0 answer
	tst	length(r1)	;see if no string
	beq	1$
	movb	(r3)+,(sp)	;save the byte
1$:	jsr	pc,pstjs	;pop the string
	mov	(sp)+,-(r1)	;save the value
uuo999:	rts	pc		;and return the value as integer


waitf:	mov	spda,r2		;get data area pointer
	mov	(r1)+,waittm(r2);set the wait time
onerr9:	rts	pc		;and return

onerr:	movb	(r5)+,-(r1)	;get error statement header
	movb	(r5)+,-(r1)
	mov	spda,r2		;get data area pointer
	mov	(r1)+,oegtln(r2);store for error time
	bne	onerr9		;branch if non zero
	tst	runlvl		;see if handling an error
	bne	onerr9		;exit if not at the error level
	mov	resloc(r2),r3	;get old scth
	add	spta,r3		;make it absolute
	mov	r3,scth		;and stuff it into scth
	mov	#emt!fatal,-(sp)	;store a trap value
	bisb	errval(r2),(sp)	;add the error count
	mov	sp,pc		;wow
len:	jsr	r5,intfun	;go do function management
	args	fas		;one string wanted
lenp3:	jsr	pc,pstjs	;pop the string
	tst	-(r1)		;get back the length
	rts	pc		;and return


swapby:	jsr	r5,intfun	;get an integer
	args	fai
	swab	(r1)		;and swap bytes
prvtok:	rts	pc



atoi:	clr	r3		;clear the number to be
	clr	r4		;and the switches
1$:	movb	(r2)+,r0	;get a character
	bic	#-177-1,r0	;remove parity bit and side effect
	sub	#'0,r0		;reduce to binary if a number
	blt	10$		;branch if + or - (or other special one)
	cmpb	r0,#'9-'0	;see if out of range high
	bgt	10$		;branch if non-numeric
	bitb	r4,#4		;see if - switch
	beq	2$		;branch if + number
	neg	r0		;negate current digit
2$:	asl	r3		;n*2
	bvs	4$		;overflow check
	mov	r3,-(sp)	;save for latter
	asl	r3		;n*4
	bvs	5$		;overflow check
	asl	r3		;n*8
	bvs	5$		;overflow check
	add	(sp)+,r3	;n*8+n*2=n*10
	bvs	4$		;overflow check
	add	r0,r3		;include the current digit
	bvs	4$		;and a final overflow check
	bisb	#1,r4		;set numbers seen
	br	1$		;and resume the scan

10$:	cmpb	r0,#11-'0	;check character for <tab>
	beq	1$		;branch to ignore tab's
	cmpb	r0,#40-'0	;check character for <sp>
	beq	1$		;branch to ignore sp's
	cmpb	r0,#015-'0	;see if carriage return
	beq	1$		;ignore like spaces
	cmpb	r0,#'+-'0	;check character for <+>
	beq	20$		;branch if a + sign
	cmpb	r0,#'--'0	;check character for <->
	bne	3$		;exit if not recignized
	bisb	#4,r4		;set - number for scanner above
20$:	bitb	r4,#3		;see if sign is legal, i.e. only one - no #'s
	bne	3$		;branch if end of the line
	bisb	#2,r4		;set sign encountered
	br	1$		;resume the scan

5$:	tst	(sp)+		;remove temp saved value
4$:	bisb	#200,r4		;set v switch
3$:	dec	r2		;back up to bad character
	mov	r3,-(r1)	;store the value
	aslb	r4		;set v + c accordingly
	rts	pc		;and return

;integer next pushpops

nexti:	mov	#uj,-(sp)	;set up exit thru internal jump
	br	fxnext

nextix:	mov	#ujx,-(sp)	;set up exit thru external jump
fxnext:	mov	spda,r3		;r3 _ base
	if  nexdro(r3),hi,rpterm(r3),fxnex3  ;drop through if end of loop & drop set
	gwtxt	r0		;1st arg into r0
	ifzero	eq,r0,cmnext	;branch on no variable
	add	r3,r0		;bias addr of variable
	gwtxt	r2		;2nd arg into r2
	asr	r2		;set carry if increment of one
	bcc	fxnex1		;branch if not one
	ifzero	eq,rpterm(r3),fxnex6  ;br if done looping
	inc	(r0)		;increment variable
	bvs	fxnex7		;br if integer overflow
fxnex2:	mov	#-1,rpterm(r3)	;set looping flag
	clr	nexdro(r3)	;clear drop thru flag
	rts	pc

fxnex1:	asl	r2		;restore addr of increment
	add	r3,r2		;bias addr of increment
	ifzero	eq,rpterm(r3),fxnex5  ;br if done looping
	add	(r2),(r0)	;increment variable
	bvc	fxnex2		;br if ok
fxnex7:	iolerr	!fatal		;integer overflow

fxnex3:	add	#4,r5		;take ipc past arguments
fxnex4:	tst	(sp)+		;don't exit thru a jump
	br	cmnext		;just drop thru to interp

fxnex5:	sub	(r2),(r0)	;dec cntrl variable at end of for looping
	br	fxnex4		;and just drop thru

fxnex6:	dec	(r0)		;dec cntrl var at end of for looping
	br	fxnex4		;and just drop thru
;floating next pushpops

nextf:	mov	#uj,-(sp)	;set up exit thru internal jump
	br	flnext

nextfx:	mov	#ujx,-(sp)	;set up exit thru external jump
flnext:	mov	spda,r3		;r3 _ base
	if  nexdro(r3),hi,rpterm(r3),fxnex3  ;drop thru  if end of loop & drop set
	gwtxt	r0		;1st arg into r0
	ifzero	eq,r0,cmnext	;branch on no variable
	jsr	pc,pushf3	;push variable
	mov	r0,-(sp)	;save its absolute addr
	gwtxt	r0		;2nd arg into r0
	asr	r0		;set carry if increment of one
	bcc	flnex1		;branch if not one
	jsr	pc,pushf1	;push one
flnex2:	ifzero	eq,rpterm(r3),flnex5  ;br if done looping
	jsr	pc,addf		;increment variable
flnex6:	mov	spda,r3		;r3 is the base register
	mov	(sp)+,r0	;restore variable
	jsr	pc,popf1	;pop variable & exit
	br	fxnex2

flnex1:	asl	r0		;restore increment addr
	jsr	pc,pushf3	;push increment
	br	flnex2

flnex5:	jsr	pc,subf		;dec cntrl var at end of for looping
	mov	(sp)+,(sp)	;get rid of exit thru a jump
	cmpb	(r5)+,(r5)+	;skip over interp. jump addr
	br	flnex6		;restore variable and drop thru

cmnext:	cmpb	(r5)+,(r5)+	;kick ipc past one argument
	br	fxnex2		;br to general exit
;integer for pushpops

fori:	mov	#pifj,-(sp)	;set up return thru intern. false jump
	br	fxfor

forix:	mov	#pifjxn,-(sp)	;set up external "for" false jump
fxfor:	clr	-(r1)		;truth value to false
	gwtxt	r0		;variable addr into r0
	add	spda,r0		;bias it
	gwtxt	r2		;2nd arg into r2
