#


	/*
	 *  TABLET DEPENDANT ROUTINES OF GPAC
	 *  Bill Reeves  -  July 1975
	 */



#define NULL 0
#define OFF 0
#define ON 1

#define GW_XQT 0100001
#define GW_JUMP 0
#define GW_TERM 0100000
#define GW_SETXY 0100222
#define GW_LONG_FORMAT 0100062
#define GW_MED_FORMAT 0100061
#define LONG 2
#define MED 1

#define GW 0

#define TRACK 0
#define UNTRACK 01
#define ACTIVATE 02
#define GET_EVENT 03
#define INK 04
#define DEACTIVATE 05
#define ICURSOR 6
#define ECURSOR 7
#define RESOLUTION 8
#define WAIT_CLEAR 9


#define NEVENTS 16
#define INTRVL1 0
#define INTRVL2 1
#define INTRVL3 2
#define INKING 3
#define TIMEOUT 4
#define TTY 5
#define BUTTONS 6

#define Z_AXIS_DOWN 6
#define Z_AXIS_UP 7
#define BUTTON1_DOWN 8
#define BUTTON1_UP 9
#define BUTTON2_DOWN 10
#define BUTTON2_UP 11
#define BUTTON3_DOWN 12
#define BUTTON3_UP 13
#define RANGE_OUT 14
#define RANGE_IN 15
#define READPOSITION 16

#define EQUAL_SPACE 0
#define EQUAL_TIME 1
#define POINT 2

#define BUTTON3 0
#define OUTOFRANGE 1
#define TIMEO 2

#define SETEVENTCURSOR 0
#define SETINKCURSOR 1

#define MIN_TIME 20

#define TAB_OPEN(str) if(Gtablet.fd == 0) return(Gerror(TAB_OPEN_ERR, "str"))
struct xypair
	{
	int xx;
	int yy;
	};


struct curve
	{
	int npts;
	struct xypair pts[];
	};



struct curves
	{
	int ncurves;
	struct curve *c_ptr[];
	};


struct tablet
	{
	char state;
	char trk_seg;
	int *buf_addr;
	int curr_ink_size;
	int desired_ink_size;
	int fd;
	struct curves *edge_vec;
	int *bptr;
	int end;
	} Gtablet;
struct
	{
	int ldy;
	int ldx;
	};

struct
	{
	char mdy;
	char mdx;
	};

struct event
	{
	int type;
	int x;
	int y;
	int tablet_status;
	struct curves *ink_ptr;
	} Gevent;

struct inkmode
	{
	int mode;
	int sample_interval;
	int end_condition;
	int timeout_interval;
	} Ginkmode;

int Gactevnt[NEVENTS];
extern int *Gtabinkptr;

