


XTERM(1)            UNIX Programmer's Manual             XTERM(1)



NAME
     xterm - X window system terminal emulator

SYNOPSIS
     xterm [ option ] ...

DESCRIPTION
     _X_t_e_r_m is the _X window system terminal emulator.  It attempts
     to emulate a DEC VT102 terminal (not yet completely imple-
     mented) to provide a standard terminal type for programs not
     aware of the window system directly.  Under 4.3BSD and
     Ultrix 1.2, _x_t_e_r_m supports the terminal resizing facilities
     built into the system.

     When started, _x_t_e_r_m pops a small window onto the upper left
     corner, with the size in characters and rows of the window
     as you size it.  Once the window is created, a pseudo termi-
     nal is allocated and a shell is started on the slave side of
     the pty pair.

     _X_t_e_r_m understands the following options:

     -j      _X_t_e_r_m will `jump scroll'; when _x_t_e_r_m falls behind
             scrolling the screen, it will move multiple lines up
             at once.  This option is disabled by Tektronix mode.
             The VT100 escape sequences for smooth scroll can be
             used to enable/disable this feature from a program,
             or the `Mode Menu' can be used to set it interac-
             tively.

     -fn _f_o_n_t
             The specified _f_o_n_t will be used instead of the
             default font (which is vtsingle).  Any fixed width
             font may be used.

     -fb _f_o_n_t
             The specified _f_o_n_t will be used instead of the
             default bold font (which is vtbold).  This font must
             be the same height and width as the normal font.

     =_g_e_o_m_e_t_r_y
             _X_t_e_r_m will take a normal X geometry specification.
             This takes the form of ``=_w_i_d_t_hx_h_e_i_g_h_t+_x_o_f_f+_y_o_f_f''.
             See _X(_1) for details of this specification.

     _h_o_s_t:_d_i_s_p_l_a_y
             Normally, _x_t_e_r_m gets the host and display number to
             use from the environment variable ``DISPLAY''.  One
             can, however specify them explicitly.  The _h_o_s_t
             specifies which machine to create the window on, and
             the _d_i_s_p_l_a_y argument specifies the display number.
             For example, ``orpheus:1'' creates a shell window on



Printed 12/6/86          1 January 1985                         1






XTERM(1)            UNIX Programmer's Manual             XTERM(1)



             display one on the machine orpheus.

     -n _w_i_n_d_o_w_n_a_m_e
             Allows you to set the name of the window for use by
             a window manager.

     -bw _b_o_r_d_e_r_w_i_d_t_h
             Allows you to specify the width of the window border
             in pixels.

     -b _b_o_r_d_e_r
             _X_t_e_r_m maintains an inner border (distance between
             characters and the window's border) of one pixel.
             The -b option allows you to set the size of this
             border to _b_o_r_d_e_r.

     -rv     The screen will be displayed with white characters
             on a black background, rather than the default black
             on white.

     -fg _c_o_l_o_r
             On color displays, determines the color of the text.

     -bg _c_o_l_o_r
             On color displays, determines the color of the back-
             ground.

     -bd _c_o_l_o_r
             On color displays, determines the color of the
             border.

     -cr _c_o_l_o_r
             On color displays, determines the color of the text
             cursor; default is the text color.

     -ms _c_o_l_o_r
             On color displays, determines the color of the mouse
             cursor; default is the text cursor color.

     -i      asks _x_t_e_r_m to maintain a bitmap icon, rather than
             relying on a window manager for an icon (see
             _x_w_m(_1)).

     -t      selects _T_e_k_t_r_o_n_i_x _4_0_1_0 emulation in addition to nor-
             mal vt102 emulation.  In this mode, the default font
             is 6x10 and the default window size is 39x85.  If a
             key is hit during Tektronix graphics output, the
             display may become garbled (just like a real Tek-
             tronix).  The default screen size using the default
             font is one-fourth the resolution of a Tektronix
             4010; therefore, some graphics may have discontinui-
             ties or may be suppressed entirely.  Furthermore,



Printed 12/6/86          1 January 1985                         2






XTERM(1)            UNIX Programmer's Manual             XTERM(1)



             the font initially selected approximately represents
             the standard Tektronix font, at best.  If the window
             is subsequently enlarged or reduced, the font
             appears to shrink or grow, respectively.  Resizing
             the window also affects resolution, and if the
             aspect ratio (height/width) is altered,  Tektronix
             graphics will be restricted to the largest box with
             a 4010's aspect ratio that will fit in the window.
             This box is located in the upper left area of the
             window.  Text which is part of Tektronix graphics
             output may not be cut (see MOUSE USAGE).

     -e command arguments
             The specified _c_o_m_m_a_n_d will be executed in the win-
             dow, rather than starting a shell.  The command and
             and optional arguments must appear last on the xterm
             command line.

     -s      When this option is specified, xterm no longer
             scrolls synchronously with the display.  _X_t_e_r_m no
             longer attempts to keep the screen completely up to
             date while scrolling, but can then run faster when
             network latencies are very high.  This is typically
             useful when using _x_t_e_r_m across a very large internet
             or many hops.

     -L      indicates that _x_t_e_r_m is being called by _i_n_i_t(_8), and
             should presume that its file descriptors are already
             open on a slave pseudo-tty, and that _g_e_t_t_y should be
             run rather than the user's shell.  This option
             should only be used by _i_n_i_t.

MOUSE USAGE
     When using the mouse to create the window, a cursor and a
     rubber banding box will outline where the window will be
     created on the display.  If the left button is pressed, a
     HEIGHTxWIDTH (default 24x80) size window will be created.
     If the right button is pressed, a window the height of the
     display and WIDTH (default 80) characters wide will be
     created.  If the center button is pressed and held down, the
     upper left hand corner of the window will be set to that
     point on the display, and (while continuing to depress the
     center button) an outline of the window will be displayed
     and the pop up window in the upper left corner of the screen
     will display the size in characters of the window.

     Once the window is created, _x_t_e_r_m allows you to save text
     and restore it within the same or other windows.  The button
     functions are enabled when holding down the ``shift'' key.
     The left hand button takes the text from the cursor (at but-
     ton release) through the end of line (including the new
     line), saves it in the global cut buffer, and immediately



Printed 12/6/86          1 January 1985                         3






XTERM(1)            UNIX Programmer's Manual             XTERM(1)



     `retypes' the line, inserting it as keyboard input.  This
     provides a history mechanism.  The center button is used to
     save text into the cut buffer.  Move the cursor to beginning
     of the text, and then hold the button down while moving the
     cursor to the end of the region and releasing the button.
     The saved text will not include the character pointed by the
     mouse.  Furthermore, it is not possible to cut text which
     was part of Tektronix graphics output.  The right hand but-
     ton `types' the text from the cut buffer, inserting it as
     keyboard input.  By cutting and pasting pieces of text
     without trailing new lines, you can take text from several
     places in different windows and form a command to the shell,
     for example, or take output from a program and insert it
     into your favorite editor.  Since the cut buffer is globally
     shared among different applications, you should regard it as
     a `file' whose contents you know.  The terminal emulator and
     other text programs should be treating it as if it were a
     text file, i.e. the text is delimited by new lines.

X DEFAULTS
     _X_t_e_r_m allows you to preset defaults in a customization file
     in your home directory, called ._X_d_e_f_a_u_l_t_s.  The format of
     the file is ``programname.keyword:string''.  See _X(_1) for
     more details.  _X_t_e_r_m obeys the convention for `MakeWindow'
     defaults.  Keywords recognized by _x_t_e_r_m are listed below.

     JumpScroll
             If ``on'' jump scroll is enabled.

     BodyFont
             Set the default font.

     InternalBorder
             Set the space between the text and window border.
             This is called padding above.

     BorderWidth
             Set the border width of the window.

     ReverseVideo
             If `on', reverse the definition of foreground and
             background color.

     Foreground
             Set the text color.

     Background
             Set the background color.

     Border  Set the border color.





Printed 12/6/86          1 January 1985                         4






XTERM(1)            UNIX Programmer's Manual             XTERM(1)



     Cursor  Set the text cursor color.

     Mouse   Set the mouse cursor color.

     BitmapIcon
             If `on', use a bitmap icon for this window.

     BoldFont
             Specify a default bold font.

MODE MENU
     _X_t_e_r_m has a menu for changing the modes of the terminal.
     The appearance of the menu is controlled by the defaults
     defined in the _X_M_e_n_u(_3_x) manual page.  If you hold the
     ``control'' key down and press the middle mouse button, a
     pop-up menu appears.  When you let up on the mouse button,
     the operation will be invoked.  You can set the following
     modes of the emulator: ``Smooth Scroll'' vs. ``Jump
     Scroll'', ``Reverse Video'' vs. ``Normal Video'', ``no
     wrap'' vs. ``auto wrap'', ``auto linefeed'' vs. ``normal
     linefeed'', ``application cursors'' vs. ``normal cursors'',
     ``application pad'' vs. ``numeric pad'', and you can either
     ``soft reset'' or ``hard reset'' the emulator.

     The scroll entry lets you control the scrolling behavior of
     the emulator as defined above.  The video entry lets you
     change from normal to reverse video and back.  The wrap
     entry lets you change to wrap at end of line or truncate at
     end of line.  The linefeed entry lets you determine whether
     the emulator should provide a linefeed when the line wraps.
     The cursors entry lets you determine which escape sequences
     are generated by the cursor keys.  The pad entry lets you
     determine if  the numeric keypad should generate escape
     sequences or if it should generate numbers.  The soft reset
     entry will reset scroll regions.  This can be convenient
     when some program has left the scroll regions set
     incorrectly (often a problem when using VMS or TOPS-20).
     The full reset entry will clear the screen, reset tabs to
     every eight columns, and reset the terminal modes to wrap
     and smooth scroll.

ENVIRONMENT
     _X_t_e_r_m sets the environment variables ``TERM'' and
     ``TERMCAP'' properly for the size window you have created.
     It also uses and sets the environment variable ``DISPLAY''
     to specify which bit map display terminal to use.

SEE ALSO
     resize(1), xwm(1), X(1), pty(4), XMenu(3x)

DIAGNOSTICS
     The -d flag turns on reporting of not understood escape



Printed 12/6/86          1 January 1985                         5






XTERM(1)            UNIX Programmer's Manual             XTERM(1)



     sequences.

BUGS
     Does not perfectly emulate a VT102 (though it is pretty
     close).  While the 4010 emulation is  as complete as we wish
     to make it, the Tektronix 4014 emulation is incomplete.
     Many applications will run.  The display list for the Tek-
     tronix emulator needs more work.

AUTHORS
     Mark Vandevoorde (MIT-Athena), Bob McNamara (DEC-MAD), Jim
     Gettys (MIT-Athena), Bob Scheifler (MIT-LCS), Doug Mink
     (SAO), Jordan Hubbard (Berkeley).

     VMS and TOPS-20 are trademarks of Digital Equipment Corpora-
     tion.

     Copyright (c) 1984, 1985, 1986 by Massachusetts Institute of
     Technology.
     See _X(_1) for a full copyright notice.



































Printed 12/6/86          1 January 1985                         6



