#include "sys_time.h"

/* The Macintosh keeps a raw seconds count that begins at
	00:00:00 January 1, 1904 local time,
	UNIX uses 00:00:00 January 1, 1970 GMT */

/* seconds difference between EST & GMT time zones */
#define GMTzonedif	(5*60*60)

#define	TMacbaseyr	1904
#define	TUNIXbaseyr	1970

/* number of leap days between the two years -- Mac base was a leap year! */
#define	TLpD	((TUNIXbaseyr-TMacbaseyr-1)/4)

/* TimeBaseDif is the number of seconds between Mac and UNIX time (GMT) */
#define TimeBaseDif	((((TUNIXbaseyr-TMacbaseyr)*365)+TLpD)*24*60*60)

/* global variables for time computations */

long timezone = 0 /*GMTzonedif*/;	/* difference between GMT & local time */

int daylight = 0;			/* daylight savings time flag */

char *tzname[2] = {"EST", "EDT"};	/* names of time zones */

#line 0 time

/* This routine returns the time since Jan 1, 1970 00:00:00 GMT */

unsigned long time(clock)
unsigned long *clock;
{
	unsigned long GMTtimenow = Time-TimeBaseDif+timezone;

	if (clock)
		*clock = GMTtimenow;
		
	return (GMTtimenow);
}

gettimeofday(ptime, ptz)
struct timeval *ptime;
long *ptz;
{
	unsigned long t, ticks;
	
	time(&t);

	ticks = Ticks;
	ptime->tv_sec = ticks / 16;
	ptime->tv_usec = (ticks % 16) * (1000000L/16);
	return 0;
}

char *ctime(clock)
register unsigned long *clock;
{
static char timebuffer[26];
register char *tp;
DateTimeRec MacTimeRec;
register Intl1Hndl myHndl;
register int i;	

	Secs2Date((clock?(*clock+TimeBaseDif):(Time+timezone)),&MacTimeRec);
	
	myHndl = (Intl1Hndl)IUGetIntl(1);
	tp = timebuffer;
	
	for (i=1; i<4; i++)
		*tp++ = (*myHndl)->days[MacTimeRec.dayOfWeek-1][i]; /* make day of week */
	*tp++ = ' ';

	for (i=1; i<4; i++)
		*tp++ = (*myHndl)->months[MacTimeRec.month-1][i]; /* make month */
	*tp++ = ' ';

	sprintf(tp,"%02d ",MacTimeRec.day); /* now put in day of month */
	tp += 3;
	
	sprintf(tp,"%02d:%02d:%02d %d\n",
		MacTimeRec.hour,MacTimeRec.minute,MacTimeRec.second,MacTimeRec.year);

	return(timebuffer);
}

