#include "tests.h"

int trace = 0;
int debug = 0;

int Tflag = 1;		/* print timing */
int Hflag = 0;		/* print help message */
int Sflag = 0;		/* don't print non-error messages */
int Fflag = 0;		/* test function only;  set count to 1, negate -t */
int Nflag = 0;		/* Suppress directory operations */
int Iflag = 0;		/* Ignore non-test files dir entries */

char TESTDIR[256];

int DDIRS = 2;
int DLEVS = 5;
int DFILS = 5;

long DSIZE = 1048576;

#define	OFF		if (0)

extern void (*_echo_to_printer_)();	/* global Echo call variable for printer */

char **argv(arg)
int arg;
{
	static char *vector[32];
	char **p, **from;
	
	p = vector;
	from = (char **)&arg;
	while (*p++ = *from++);

	*p++ = (char *)0;
	return vector;
}

main()
{
	int start = 0;
	int more = TRUE;

	extern echo_to_file();
	extern char *ctime();

	extern int default_vrefnum;

	_echo_to_printer_ = (void *)echo_to_file;

	printf("Macintosh NFS Revision 2 BASIC test suite (V0.24)\t%s\n", ctime(0L));

	/* ask were we should test */
	if (!askfordir(TESTDIR, &default_vrefnum))
		return;

	if (debug)
		{
		DDIRS = 1;
		DLEVS = 2;
		DFILS = 1;

		DSIZE = 8192;
		}

	if (0)
		{
		rmdir_recurse(TESTDIR);
		return;
		}

#ifdef DEBUG
	start = 1;
	more = TRUE;
	printf("**DEBUG VERSION**\n");
#endif

#define	FLAGS	"-n",

	if (start <= 1)
		{
		test1(1, argv("test1", FLAGS (char *)0));
		if (!more) goto done;
		}
	if (start <= 2)
		{
		test2(1, argv("test2", FLAGS (char *)0));
		if (!more) goto done;
		}
	if (start <= 3)
		{
		test3(1, argv("test3", FLAGS (char *)0));
		if (!more) goto done;
		}
	if (start <= 4)
		{
		test4(1, argv("test4", (char *)0));
OFF		test4a(1, argv("test4a", (char *)0));
		if (!more) goto done;
		}
		
	if (start <= 5)
		{
		test5(1, argv("test5", FLAGS (char *)0));
OFF		test5a(1, argv("test5a", (char *)0));
OFF		test5b(1, argv("test5b", (char *)0));
		if (!more) goto done;
		}

	if (start <= 6)
		{
		test6(1, argv("test6", FLAGS (char *)0));
		if (!more) goto done;
		}

	if (start <= 7)
		{
		test7(1, argv("test7", FLAGS (char *)0));
OFF		test7a(1, argv("test7a", (char *)0));
OFF		test7b(1, argv("test7b", (char *)0));
		if (!more) goto done;
		}
		
	if (start <= 8)
		{
		test8(1, argv("test8", FLAGS (char *)0));
		if (!more) goto done;
		}

	if (start <= 9)
		{
		test9(1, argv("test9", FLAGS (char *)0));
		if (!more) goto done;
		}

done:
	printf("All tests completed.\t%s\n", ctime(0L));

	echo_to_file_done();
}

usage()
{
}

