#include <HFS.h>
#include "sys_stat.h"
#include "sys_vfs.h"
#include <stdio.h>

/* #define NOCWD */

char working_dir[1024] = '\0';
int default_vrefnum = 0;
unsigned long default_dir_id = 0;
int default_umask = 0;

extern int trace;

merror(result, where, what)
int result;
char *where;
char *what;
{
	char path[1024];
	
	extract_path(path);
	printf("**Mac I/O Error** result %d, in '%s', on '%s' (%s)\n",
		result, where, what, path);
	
	printf("                  default_vrefnum %d, default_dir_id 0x%lx\n",
		default_vrefnum, default_dir_id);
		
if (1)
	exit(-1);
}

StringPtr pname(cname)
char *cname;
{
	static char name[256];
	
	strcpy(name, cname);
	CtoPstr(name);
	return (StringPtr)name;
}

StringPtr pnamecpy(pname, cname)
StringPtr pname;
char *cname;
{	
	strcpy(pname, cname);
	CtoPstr((char *)pname);
	return pname;
}

statfs(path, pstat)
char *path;
struct statfs *pstat;
{
	HParamBlockRec iopb;
	
	iopb.volumeParam.ioNamePtr = (StringPtr)0;
	iopb.volumeParam.ioVRefNum = default_vrefnum;
	iopb.volumeParam.ioVolIndex = 0;
	PBHGetVInfo(&iopb, FALSE);
	
	pstat->f_type = 0;
	pstat->f_bsize = (unsigned)iopb.volumeParam.ioVAlBlkSiz;
	pstat->f_blocks = (unsigned)iopb.volumeParam.ioVNmAlBlks;
	pstat->f_bfree = (unsigned)iopb.volumeParam.ioVFrBlk;
	pstat->f_bavail = (unsigned)iopb.volumeParam.ioVFrBlk;
	pstat->f_files = (unsigned)iopb.volumeParam.ioVFilCnt;
	pstat->f_ffree = 0;

#ifdef NFS3_2
	pstat->f_fsid[0].val = iopb.volumeParam.ioVFSID;
	pstat->f_fsid[1].val = 0;
#else NFS3_2
	pstat->f_fsid[0] = iopb.volumeParam.ioVFSID;
	pstat->f_fsid[1] = 0;
#endif

	return 0;
};

fstat(fd, pstat)
int fd;
struct stat *pstat;
{
	register int		free_slot;

	/* look thru FILE array for slots in use	*/
	for (free_slot=STDERRNO+1;
		((free_slot<_NFILE));
		free_slot++)
		if (_file[free_slot].InUse && _file[free_slot].fileno == fd)
			{
			pstat->st_mode = 0;
			pstat->st_nlink = 1;
			pstat->st_size = 0;

			return 0;
			}
	
	return -1;
}

link(from, to)
char *from, *to;
{
	printf("\t[link] '%s' to '%s'\n", from, to);
}


umask(mask)
int mask;
{
	default_umask = mask;
}

int last_mode;

chmod(name, mode)
char *name;
int mode;
{
	last_mode = mode;
}

stat(name, pstat)
char *name;
struct stat *pstat;
{
	char path[256];
	CInfoPBRec iopb;
	int result;
	
	if (trace) printf("\t[stat] %s\n", name);
	unix_to_mac_path(path, name, TRUE);

	iopb.hFileInfo.ioNamePtr = pname(path);
	iopb.hFileInfo.ioVRefNum = default_vrefnum;
	iopb.hFileInfo.ioDirID = default_dir_id;
	
	iopb.hFileInfo.ioFDirIndex = 0;
	result = PBGetCatInfo(&iopb, FALSE);

	if (result == dirNFErr || result == fnfErr)
		return result;

	if (result != noErr)
		merror(result, "mkdir", path);

	pstat->st_mode = last_mode;
	pstat->st_nlink = 1;
	pstat->st_size = iopb.hFileInfo.ioFlLgLen;
	
	return 0;
}

mkdir(name, mode)
char *name;
int mode;
{
	char path[256];
	HParamBlockRec iopb;
	int result;

	if (trace) printf("\t[mkdir] %s, mode %o\n", name, mode);
	unix_to_mac_path(path, name, TRUE);

	iopb.ioParam.ioNamePtr = pname(path);
	iopb.ioParam.ioVRefNum = default_vrefnum;
	iopb.fileParam.ioDirID = default_dir_id;
	result = PBDirCreate(&iopb, FALSE);

	if (result != noErr)
		merror(result, "mkdir", path);
}

rmdir(name)
char *name;
{
	char path[256];
	HParamBlockRec iopb;
	int result;

	if (trace) printf("\t[rmdir] %s\n", name);
	unix_to_mac_path(path, name, TRUE);

	/* close default wd #2 */
	{
	WDPBRec cw_iopb;
	
	cw_iopb.ioVRefNum = 0x8013;
	result = PBCloseWD(&cw_iopb, FALSE);
    }

	/* reset default dir */
	{
	WDPBRec cd_iopb;
	
	cd_iopb.ioNamePtr = (StringPtr)0;
	cd_iopb.ioVRefNum = default_vrefnum;
	cd_iopb.ioWDDirID = default_dir_id;
	result = PBHSetVol(&cd_iopb, FALSE);

	if (result != noErr)
		merror(result, "rmdir - PBHSetVol", path);
    }

	iopb.ioParam.ioNamePtr = pname(path);
	iopb.ioParam.ioVRefNum = default_vrefnum;
	iopb.fileParam.ioDirID = default_dir_id;
	result = PBHDelete(&iopb, FALSE);

	if (result != noErr)
		merror(result, "rmdir", path);

	if (trace) printf("\t[rmdir] ok\n");
	return 0;
}

chdir(new)
char *new;
{
	char path[256];
	CInfoPBRec iopb;
	int result;
		
	unix_to_mac_path(path, new, FALSE);
	
#ifdef NOCWD
	if (path[0] != ':' && working_dir[ strlen(working_dir)-1 ] != ':')
		strcat(working_dir, ":");

	strcat(working_dir, path);
#endif

#ifdef NODOTDOT
	if (strcmp(path, "..") == 0)
		{
		iopb.hFileInfo.ioNamePtr = (StringPtr)0;
		iopb.hFileInfo.ioVRefNum = default_vrefnum;
		iopb.hFileInfo.ioDirID = default_dir_id;
		
		iopb.hFileInfo.ioFDirIndex = 0;
		result = PBGetCatInfo(&iopb, FALSE);
			
		{
		WDPBRec cd_iopb;
		
		cd_iopb.ioNamePtr = (StringPtr)0;
		cd_iopb.ioVRefNum = default_vrefnum;
		default_dir_id = cd_iopb.ioWDDirID = iopb.dirInfo.ioDrParID;
		result = PBHSetVol(&cd_iopb, FALSE);
	
		if (result != noErr)
			merror(result, "chdir - nodots PBHSetVol", path);
	    }			

		return 0;
		}
#endif

	iopb.hFileInfo.ioNamePtr = pname(path);
	iopb.hFileInfo.ioVRefNum = default_vrefnum;
	iopb.hFileInfo.ioDirID = default_dir_id;
	
	iopb.hFileInfo.ioFDirIndex = 0;
	result = PBGetCatInfo(&iopb, FALSE);

	if (result == dirNFErr || result == fnfErr)
		{
		if (trace) printf("\t[chdir] to '%s' failed\n", path);
		return result;
		}
		
	if (result != noErr)
		merror(result, "chdir - PBGetCatInfo", path);

	default_dir_id = iopb.hFileInfo.ioDirID;

	{
	WDPBRec cd_iopb;
	
	cd_iopb.ioNamePtr = (StringPtr)0;
	cd_iopb.ioVRefNum = default_vrefnum;
	cd_iopb.ioWDDirID = default_dir_id;
	result = PBHSetVol(&cd_iopb, FALSE);

	if (result != noErr)
		merror(result, "chdir - PBHSetVol", path);
    }
   
	if (trace)
		printf("\t[chdir] to '%s', dirID 0x%lx\n", path, default_dir_id);

	{
	WDPBRec cd_iopb;
	char path2[256];
	
	extract_path(path2);

	if (trace)
		printf("\t[chdir] trying hsetvol with path '%s'\n", path2);

	CtoPstr(path2);
	cd_iopb.ioNamePtr = (StringPtr)path2;
	cd_iopb.ioVRefNum = default_vrefnum;
	cd_iopb.ioWDDirID = 0 /* 2 */;
	result = PBHSetVol(&cd_iopb, FALSE);

	if (result != noErr)
		{
		PtoCstr(path2);
		merror(result, "chdir - PBHSetVol", path2);
		}
    }
   
	return 0;
}

char *getwd(name)
char *name;
{
	extract_path(working_dir);
	mac_to_unix_path(name, working_dir);
	if (trace) printf("\t[getwd] %s\n", name);
	return name;
}

unix_to_mac_path(new, old, add_default)
register char *new, *old;
int add_default;
{
	register char ch;
	char *result = new;
	int pos = 0;

#ifdef NOCWD
	if (add_default)
		{
		strcpy(new, working_dir);
		new += strlen(working_dir);
		if (working_dir[0])
			*new++ = ':';
		}
#endif

	if (strcmp(old, ".") == 0)
		{
		extract_path(new);
		}
	else
	if (strcmp(old, "..") == 0)
		{
		strcpy(new, "::");
		return;
		}
	else
		{	
		while (ch = *old++)
			{
			if (ch == '/' && pos > 0) ch = ':';
			*new++ = ch;
			pos++;
			}
	
		*new = '\0';
		}

	if (trace > 1) printf("\t[unix_to_mac_path] '%s'\n", result);
}

mac_to_unix_path(new, old)
register char *new, *old;
{
	register char ch;
	char *result = new;
	
	if (strcmp(old, "::") == 0)
		{
		strcpy(new, "..");
		}
	else
		{
		while (ch = *old++)
			{
			if (ch == ':') ch = '/';
			*new++ = ch;
			}
		
		*new = '\0';
		}

	if (trace > 1) printf("\t[mac_to_unix_path] '%s'\n", result);
}
