.TH MKMF 1P "22 June 1983"
.UC 4
.SH NAME
mkmf \- makefile editor
.SH SYNOPSIS
.B mkmf
[\fB\-cdil\fR] [\fB\-f \fRmakefile] [\fB\-F \fRtemplate] [macroname=value ...]
.SH DESCRIPTION
.I Mkmf
creates a makefile that tells the
.I make
command how to construct and maintain programs and libraries.
After gathering up all the source code file names in the current working
directory and inserting them into the makefile,
.I mkmf
scans source code files for included
files and generates dependency information which is appended to the makefile.
Source code files are identified by their file name suffixes.
.I Mkmf
knows about the following suffixes:
.LP
.nf
			.c		C
			.e		Efl
			.F		Fortran
			.f		Fortran
			.h		Include files
			.i		Pascal include files
			.l		Lex or Lisp
			.o		Object files
			.p		Pascal
			.r		Ratfor
			.s		Assembler
			.y		Yacc
.fi
.LP
.I Mkmf
checks for an existing makefile before creating one. If no
.B \-f
option is present, the makefiles `makefile' and `Makefile' are tried
in order.
.LP
After the makefile has been created, arbitrary changes can be made using
a regular text editor.
.I Mkmf
can also be used to re-edit the macro definitions in the makefile, regardless
of changes that may have been made since it was created.
.LP
By default,
.I mkmf
creates a program makefile. To create a makefile that deals with libraries,
the
.B \-l
option must be used.
.LP
\fBMake Requests\fR
.LP
Given a makefile created by
.I mkmf,
.I make
recognizes the following requests:
.IP \fBall\fR 15
Compile and load a program or library.
.IP \fBclean\fR
Remove all unnecessary files.
.IP \fBdepend\fR
Edit the makefile and regenerate the dependency information.
.IP \fBextract\fR
Extract all the object files from the library and place them in the
same directory as the source code files. The library is not altered.
.IP \fBindex\fR
Print an index of functions on standard output.
.IP \fBinstall\fR
Compile and load the program or library and move it to its destination
directory.
.IP \fBlibrary\fR
Compile and load a library.
.IP \fBprint\fR
Print source code files on standard output.
.IP \fBtags\fR
Create a tags file for the
.I ex
editor, for C, Pascal, and Fortran source code files.
.IP \fBprogram\fR
Compile and link a program.
.IP \fBupdate\fR
Recompile only those source code files that are newer than the program
or library, link and install the program or library. In the case of an
out-of-date library, all the object files are extracted from the
library before any recompilation takes place, and removed once the
library has been reinstalled.
.LP
Several requests may be given simultaneously. For example, to
compile and link a program,
move the program to its destination directory, and remove
any unnecessary object files:
.IP
make program install clean
.LP
\fBMacro Definitions\fR
.LP
.I Mkmf
understands the following macro definitions:
.IP CFLAGS 15
C compiler flags. After searching the current directory for included files
.I mkmf
searchs in directories named in
.B \-I
compiler options, and then in the `/usr/include' directory.
.IP DEST
Directory where the program or library is to be installed.
.IP EXTHDRS
List of included files external to the current directory.
.I Mkmf
automatically updates this macro definition in the makefile if dependency
information is being generated.
.IP FFLAGS
Fortran compiler flags. After searching the current directory for included files
.I mkmf
searchs in directories named in
.B \-I
compiler options.
.IP HDRS
List of included files in the current directory.
.I Mkmf
automatically updates this macro definition in the makefile.
.IP LIBRARY
Library name. This macro also implies the
.B \-l
option.
.IP LIBS
List of libraries needed by the link editor to resolve external references.
.IP MAKEFILE
Makefile name.
.IP OBJS
List of object files.
.I Mkmf
automatically updates this macro definition in the makefile.
.IP PROGRAM
Program name.
.IP SRCS
List of source code files.
.I Mkmf
automatically updates this macro definition in the makefile.
.IP SUFFIX
List of additional file name suffixes for
.I mkmf
to know about.
.LP
Both these and any other macro definitions already within the makefile may
be replaced by definitions on the command line in the form
.I "macroname=value".
For example, to change the C compiler flags, the program name, and the
destination directory in the makefile, the user might type the following line:
.LP
.nf
	mkmf  ``CFLAGS=\-I../include  \-O''  PROGRAM=mkmf  DEST=/usr/new
.fi
.LP
Note that macro definitions like CFLAGS with blanks in them
must be enclosed in double quote `"' marks.
.LP
\fBFile Name Suffixes\fR
.LP
.I Mkmf
can be instructed to recognize additional file name suffixes, or ignore ones
that it already knows about, by specifying suffix descriptions in
the SUFFIX macro definition. Each suffix description takes the
form `.\fIsuffix:tI\^\fR' where
.I t
is a character indicating the contents of the file (s = source file,
o = object file, h = header file, x = executable file) and
.I I
is an optional character indicating the include syntax for included
files (C = C syntax, F = Fortran, Efl, and Ratfor syntax, P = Pascal
syntax). The following table describes
the default configuration for
.I mkmf:

.nf
			.c:sC		C
			.e:sF		Efl
			.F:sF		Fortran
			.f:sF		Fortran
			.h:h		Include files
			.i:h		Pascal include files
			.l:s		Lex or Lisp
			.o:o		Object files
			.p:sP		Pascal
			.r:sF		Ratfor
			.s:s		Assembler
			.y:s		Yacc
.fi
.LP
For example, to change the object file suffix to .obj, undefine the Pascal
include file suffix, and prevent Fortran files from being scanned for
included files, the SUFFIX macro definition might look like:
.IP
\&"SUFFIX = .obj:o  .i:  .f:s"
.LP
\fBUser-Defined Templates\fR
.LP
If
.I mkmf
can not find a makefile within the current directory, it normally uses
one of the standard makefile templates, `p.Makefile' or `l.Makefile', in
/usr/new/lib unless the user has alternative `p.Makefile'
or `l.Makefile' template files in a directory \fIproject\fR/lib where
.I project
is the absolute pathname of the directory assigned to the PROJECT
environment variable.
.SH OPTIONS
.IP \fB\-c\fR
Suppress `creating
.I makefile
from ...' message.
.IP \fB\-d\fR
Turn
.B off
scanning of source code for `include' files. Old dependency information
is left untouched in the makefile.
.IP "\fB\-f \fImakefile\fR"
Specify an alternative
.I makefile
file name. The default file name is `Makefile'.
.IP \fB\-i\fR
Cause
.I mkmf
to prompt the user for the name of the program or library, and the
directory where it is to be installed. If a carriage return is typed
in response to each of these queries,
.I mkmf
will assume that the default program name is
.I a.out
or the default library name is
.I lib.a,
and the destination directory is the current directory.
.IP \fB\-l\fR
Force the makefile to be a library makefile.
.IP "\fB\-F \fItemplate\fR"
Specify an alternative makefile
.I template
file name. The default program makefile template is `p.Makefile'
and the default library makefile template is `l.Makefile'.
.I Mkmf
normally looks for
.I template 
in /usr/new/lib or \fIproject\fR/lib. However,
.I template
can be specified as an absolute pathname.
.SH FILES
.nf
.ta \w'/usr/new/lib/p.Makefile'u+.5i
/usr/new/lib/p.Makefile	Standard program makefile template.
/usr/new/lib/l.Makefile	Standard library makefile template.
\fIproject\fR/lib/p.Makefile	User-defined program makefile template.
\fIproject\fR/lib/l.Makefile	User-defined library makefile template.
.fi
.DT
.SH "SEE ALSO"
ar(1), ctags(1), ex(1), ld(1), ls(1), make(1)
.br
S. I. Feldman  \fIMake \- A Program for Maintaining Computer Programs\fP
.SH DIAGNOSTICS
Exit status 0 is normal. Exit status 1 indicates an error.
.SH AUTHOR
Peter J. Nicklin
.SH BUGS
The name of the makefile is included as a macro definition within the
makefile and must be changed if the makefile is renamed.
.LP
Since executable files are dependent on libraries, standard library
abbreviations must be expanded to full pathnames within the LIBS macro
definition in the makefile.
.LP
Generated dependency information appears after a line in the makefile
beginning with `###'. This line must
.B not
be removed, nor must any other information be inserted in the makefile
below this line.
