.if \n(xx .bp
.if !\n(xx \{\
.so tmac.p \}
.ND
.nr H1 4
.NH
Details on the components of the system
.NH 2
Options
.PP
The programs
.PI
and
.XP
take a number of options.\*(dg
.FS
\*(dgAs
.IX
uses
.PI
to translate Pascal programs,
it takes the options of
.PI
also.
We refer to them here, however, as
.PI
options.
.FE
There is a standard
.UX
convention for passing options to programs on the command line,
and this convention is followed by the
.UP
system programs.
As we saw in the examples above,
option related arguments consisted of the character `\-' followed
by a single character option name.
In fact, it is possible to place more than one option letter after
a single `\-', thus
.LS
% \*bpi -lz foo.p\fR
.LE
and
.LS
% \*bpi -l -z foo.p\fR
.LE
are equivalent.
.PP
There are 26 options, one corresponding to each lower case letter.
Except for the
.B b
option
which takes a single digit value,
each option may be set on (enabled)
or off (disabled.)
When an on/off valued option appears on the command line of
.PI
or
.PX
it inverts the default setting of that option.
Thus
.LS
% \*bpi -l foo.p\fR
.LE
enables the listing option
.B l ,
since it defaults off, while
.LS
% \*bpi -t foo.p\fR
.LE
disables the run time tests option
.B t ,
since it defaults on.
.PP
In additon to inverting the default settings of
.PI
options on the command line, it is also possible to control the
.PI
options 
within the body of the program by using comments of a special
form illustrated by
.LS
{$l-}
.LE
.PP
Here we see that the opening comment delimiter (which could also be a `(*')
is immediately followed by the character `$'.
After this `$', which signals the start of the option list,
we can place a sequence of letters and option controls, separated by `,'
characters\*(dd.
.FS
\*(ddThis format was chosen because it is used by Pascal 6000-3.4.
In general the options common to both implementations are controlled
in the same way so that comment control in options is mostly
portable.
It is recommended, however, that only one control be put per comment for
maximum portability, as the Pascal 6000-3.4
implementation will ignore controls
after the first one which it does not recognize.
.FE
The most basic actions for options are to set them, thus
.LS
{$l+ Enable listing}
.LE
or to clear them
.LS
{$t-,p- No run-time tests, no post mortem analysis}
.LE
Notice that `+' always enables an option and `\-' always disables it,
no matter what the default is.
Thus `\-' has a different meaning in an option comment than it has on the
command line.
As shown in the examples,
normal comment text may follow the option list.
.NH 2
Pi (and pix)
.PP
We now summarize the options of
.PI .
These options may also be specified on the command line to
.IX
before the name of the file to be translated.
Arguments to
.IX
after the name of the file to be translated are passed to
the executed program run by
.X .
With each option we give its default setting,
the setting it would have if it appeared on the command line,
and a sample command using the option.
Most options are on/off valued,
with the
.B b
option
taking a single digit value.
.SH
Buffering of the file output \- b
.PP
The
.B b
option controls the buffering of the file
.I output .
The default is line buffering, with flushing at
each reference to the file
.I input
and under certain other circumstances detailed in section 5
below.
Mentioning
.B b
on the command line, e.g.
.LS
% \*bpi -b assembler.p\fR
.LE
causes standard output to be block buffered,
where a block is 512 characters.
The
.B b
option may also be controlled in comments.
It, unique among the
.UP
options,
takes a single digit value rather than an on or off setting.
A value of 0, e.g.
.LS
	{$b0}
.LE
causes the file
.I output
to be unbuffered.
Any value 2 or greater causes block buffering and is equivalent
to the flag on the command line.
The option control comment setting
.B b
must precede the
.B program
statement.
.SH
Include file listing \- i
.PP
The
.B i
option takes a list of
.B include
files,
.B procedure
and
.B function
names and causes these portions of the
program to be listed while translating\*(dg.
.FS
\*(dg\*bInclude\fR files are discussed in section 5.9.
.FE
All arguments after the
.B \-i
flag up to the name of the file being translated,
which ends in `.p', are in this list.
Typical uses would be
.LS
% \*bpix -i scanner.i compiler.p\fR
.LE
to make a listing of the routines in the file scanner.i, and
.LS
% \*bpix -i scanner compiler.p\fR
.LE
to make a listing of only the routine
.I scanner .
This option is especially useful for conservation-minded programmers making
partial program listings.
.SH
Make a listing \- l
.PP
The
.B l
option enables a listing of the program.
The
.B l
option defaults off.
When specified on the command line, it causes
a header line identifying the version of the translator in use
and a line giving the modification time of the file being translated
to appear before the actual program listing.
The
.B l
option is pushed and popped by the
.B i
option at appropriate points in the program.
.SH
Eject new pages for include files \- n
.PP
The
.B n
option causes
.PI
to eject a new page in the listing and print a header line at
.B include
file boundaries, providing automatic pagination control.
To have effect, either the
.B l
or
.B i
option should also be specified,
or the input should contain listing control in comments.
An example would be
.LS
% \*bpi -in scan.i c.p\fR
.LE
.SH
Post-mortem dump \- p
.PP
The
.B p
option defaults on,
and causes the runtime system to initiate a post-mortem
backtrace when an error occurs.
It also cause
.X
to count statements in the executing program,
enforcing a statement limit to prevent infinite loops.
Specifying
.B p
on the command line disables these checks and the ability
to give this post-mortem analysis.
It does make smaller and faster programs, however.
It is also possible to control the
.B p
option in comments.
To prevent the post-mortem backtrace on error,
.B p
must be off at the end of the
.B program
statement.
Thus, the Pascal cross-reference program was translated with
.LS
% \*bpi -pbt pxref.p\fR
.LE
.SH
Standard Pascal only \- s
.PP
The
.B s
option causes many of the features of the
.SM UNIX
implementation which are not found in standard Pascal
to be diagnosed as `s' warning errors.
This option defaults off and is enabled when mentioned on the command line.
Some of the features which are diagnosed are:
non-standard
.B procedure s
and
.B function s,
extensions to the
.B procedure
.I write ,
and the padding of constant strings with blanks.
In addition, all letters are mapped to lower case except in
strings and characters so that the case of keywords and identifiers
is effectively ignored.
The
.B s
option is most useful when a program is to be transported, thus
.LS
% \*bpi -s isitstd.p\fR
.LE
.SH
Runtime tests \- t
.PP
The
.B t
option controls the generation of tests that subrange variable
values are within bounds at run time.
By default these tests are generated.
If the
.B t
option is specified on the command line,
or in a comment which turns it off,
then the tests are not generated.
Thus the first line of a program to run without tests might be
.LS
{$t- No runtime tests}
.LE
Disabling runtime tests also causes
.B assert
statements to be treated as comments.\*(dg
.FS
\*(dgSee section A.1 for a description of
.B assert
statements.
.FE
.SH
Card image, 72 column input \- u
.PP
Turning the
.B u
option on, either on the command line
or in a comment causes the input to be treated as
card images with sequence numbers and truncated to 72 columns.
Thus
.LS
% \*bpix -u cards.p\fR
.LE
.SH
Suppress warning diagnostics \- w
.PP
The
.B w
option, which defaults on,
allows the translator to print a number of warnings about inconsistencies
it finds in the input program.
Turning this option off with a comment of the form
.LS
{$w-}
.LE
or on the command line
.LS
% \*bpi -w tryme.p\fR
.LE
suppresses these usually useful diagnostics.
.SH
Generate counters for an execution profile \- z
.PP
The
.B z
option, which defaults off,
enables the production of execution profiles.
By specifying
.B z
on the command line, i.e.
.LS
% \*bpi -z foo.p\fR
.LE
or by enabling it in a comment before the
.B program
statement we cause
.PI
to insert operations in the interpreter code to
count the number of times each statement was executed.
An example of using
.XP
was given in section 2.6;
its options are described in section 5.5.
.NH 2
Px
.PP
The first argument to
.X
is the name of the file containing the program to be interpreted.
If no arguments are given, then the file
.I obj
is executed.
If more arguments are given, they are available to the Pascal
program by using the built-ins
.I argc
and
.I argv
as described in section 4.6.
.ne 7
.PP
.I Px
may also be invoked automatically.
In this case, whenever a Pascal object file name is given as a command,
the command will be executed with
.X
prepended to it; that is
.LS
% \*bobj primes\fR
.LE
will be converted to read
.LS
% \*bpx obj primes\fR
.LE
.NH 2
Pxp
.PP
.I Pxp
takes, on its command line, a list of options followed by the program file
name, which must end in `.p' as it must for
.PI
and
.IX .
.XP
will produce an execution profile if any of the
.B z
.B t
or
.B c
options are specified on the command line.
If none of these options are specified, then
.XP
functions as a program reformatter.
See section 5.5 for more details.
.PP
It is important to note that only the
.B z
option of
.XP ,
and the
.B n ,
.B u ,
and
.B w ,
options, which are common to
.PI
and
.XP
can be controlled in comments.
All other options must be specified on the command line to have any effect.
.PP
The following options are relevant to profiling with
.XP :
.SH
Include the bodies of all routines in the profile \- a
.PP
.I Pxp
normally suppresses printing the bodies of routines
which were never executed, to make the profile more compact.
This option forces all routine bodies to be printed.
.SH
Extract profile data from the file core \- c
.PP
This option causes
.XP
to extract the data from the file
.I core
in the current directory.
This is used in debugging the Pascal system, and should not
normally be needed.
When an abnormal termination occurs in
.X
it writes the data to the file
.I pmon.out .
The
.B z
option enables profiling with data from this file.
.SH
Suppress declaration parts from a profile \- d
.PP
Normally a profile includes declaration parts.
Specifying
.B d
on the command line suppresses declaration parts.
.SH
Eliminate include directives \- e
.PP
Normally,
.XP
preserves
.B include
directives to the output when reformatting a program,
as though they were comments.
Specifying
.B \-e
causes the contents of the specified files to be reformatted
into the output stream instead.
This is an easy way to eliminate
.B include
directives, e.g. before transporting a program.
.SH
Fully parenthesize expressions \- f
.PP
Normally
.XP
prints expressions with the minimal parenthesization necessary to
preserve the structure of the input.
This option causes
.I pxp
to fully parenthesize expressions.
Thus the statement which prints as
.LS
d := a + b mod c / e
.LE
with minimal parenthesization, the default, will print as
.LS
d := a + ((b mod c) / e)
.LE
with the
.B f
option specified on the command line.
.SH
Left justify all procedures and functions \- j
.PP
Normally, each
.B procedure
and
.B function
body is indented to reflect its static nesting depth.
This option prevents this nesting and can be used if the indented
output would be too wide.
.SH
Print a table summarizing procedure and function calls \- t
.PP
The
.B t
option causes
.XP
to print a table summarizing the number of calls to each
.B procedure
and
.B function
in the program.
It may be specified in combination with the
.B z
option, or separately.
.SH
Enable and control the profile \- z
.PP
The
.B z
profile option is very similar to the
.B i
listing control option of
.PI .
If
.B z
is specified on the command line, then all arguments up to the
source file argument which ends in `.p' are taken to be the names of
.B procedure s
and
.B function s
or
.B include
files which are to be profiled.
If this list is null, then the whole file is to be profiled.
A typical command for extracting a profile of part of a large program
would be
.LS
% \*bpxp -z test parser.i compiler.p\fR
.LE
This specifies that profiles of the routines in the file
.I parser.i
and the routine
.I test
are to be made.
.NH 2
Formatting programs using pxp
.PP
The program
.XP
can be used to reformat programs, by using a command of the form
.LS
% \*bpxp dirty.p > clean.p\fR
.LE
Note that since the shell creates the output file `clean.p' before
.XP
executes, so `clean.p' and `dirty.p' must not be the same file.
.PP
.I Pxp
automatically paragraphs the program, performing housekeeping
chores such as comment alignment, and
treating blank lines, lines containing exactly one blank
and lines containing only a form-feed character as though they
were comments, preserving their vertical spacing effect in the output.
.I Pxp
distinguishes between four kinds of comments:
.HP
.RS
.IP 1)
Left marginal comments, which begin in the first column of the
input line and are placed in the first column of an output line.
.IP 2)
Aligned comments, which are preceded by no input tokens on the
input line.
These are aligned in the output with the running program text.
.IP 3)
Trailing comments, which are preceded in the input line by a token with
no more than two spaces separating the token from the comment.
.IP 4)
Right marginal comments, which are preceded in the input line
by a token from which they are separated by at least three spaces or a tab.
These are aligned down the right margin of the output,
currently to the first tab stop after the 40th column from the current
``left margin''.
.RE
.LP
Consider the following program.
.LS
% \*bcat comments.p\fR
.so comments1.p
.LE
When formatted by
.XP
the following output is produced.
.LS
% \*bpxp comments.p\fR
.so commentsout
%
.LE
The following formatting related options are currently available in
.XP .
The options
.B f
and
.B j
described in the previous section may also be of interest.
.SH
Strip comments \-s
.PP
The
.B s
option causes
.XP
to remove all comments from the input text.
.SH
Underline keywords \- \_
.PP
A command line argument of the form
.B \-\_
as in
.LS
% \*bpxp -_ dirty.p\fR
.LE
can be used to cause
.XP
to underline all keywords in the output for enhanced readability.
.SH
Specify indenting unit \- [23456789]
.PP
The normal unit which
.XP
uses to indent a structure statement level is 4 spaces.
By giving an argument of the form
\fB\-\fId\fR
with
.I d
a digit,
2 \(<=
.I d
\(<= 9
you can specify that
.I d
spaces are to be used per level instead.
.NH 2
Pcc and carriage control
.PP
The
.UX
system printer driver does not implement
.SM FORTRAN
style carriage control.
Thus the function
.I page
on
.UX
does not output a character `1'
in column 1 of a line, but rather puts out a form-feed
character.
For those who wish to use carriage control, the filter
.I pcc
is available which interprets this control.
A sample usage is:
.LS
% \*bpx | pcc\fR
.LE
or
.LS
% \*bpix prog.p | pcc | lpr\fR
.LE
for printer copy.
.I Pcc
is fully described by its manual documentation
.I pcc
(6).
.NH 2
Pxref
.PP
The cross-reference program
.I pxref
may be used to make cross-referenced listings of Pascal
programs.
To produce a cross-reference of the program in the file
`foo.p'
one can execute the command:
.LS
% \*bpxref foo.p\fR
.LE
The cross-reference is, unfortunately, not block structured.
Full details on
.I pxref
are given in its manual section
.I pxref
(6).
.NH 2
Pascals
.PP
A version of Wirth's subset Pascal translator
.I pascals
is available on
.UX .
It was translated to interpreter code by
.PI
and is invoked by a command of the form:
.LS
% \*bpascals prog.p\fR
.LE
The program in the file given is translated to interpretive code
which is then immediately executed.
.I Pascals
is thus similar to
.I pix .
Only small programs can be handled.
.I Pascals
is most interesting to those wishing to study its error recovery techniques,
which are described in Wirth's book
.I "Algorithms + Data Structures = Programs" .
.NH 2
Multi-file programs
.PP
A text inclusion facility is available with
.UP .
This facility allows the interpolation of source text from other
files into the source stream of the translator.
It can be used to divide large programs into more manageable pieces
for ease in editing, listing, and maintenance.
.PP
The
.B include
facility is based on that of the
.SM
UNIX
.NL
C compiler.
To trigger it you can place the character `#' in the first portion of
a line and then, after an arbitrary number of blanks or tabs,
the word
`include'
followed by a filename enclosed in single `\(aa' or double `"' quotation
marks.
The file name may be followed by a semicolon `;' if you wish to treat
this as a pseudo-Pascal statement.
The filenames of included files must end in `.i'.
An example of the use of included files in a main program would be:
.LS
\*bprogram\fR compiler(input, output, obj);

#\*binclude\fR "globals.i"
#\*binclude\fR "scanner.i"
#\*binclude\fR "parser.i"
#\*binclude\fR "semantics.i"

\*bbegin\fR
    { main program }
\*bend\fR.
.LE
.PP
At the point the
.B include
pseudo-statement is encountered in the input, the lines from
the included file are interpolated into the input stream.
For the purposes of translate- and run-time diagnostics and
statement numbers in the listings and post-mortem backtraces,
the lines in the included file are numbered from 1.
Nested includes are possible up to 10 deep.
.PP
See the descriptions of the
.B i
and
.B n
options of
.PI
in section 5.2
above;
these can be used to control listing when
.B include
files are present.
.PP
.I Include
control lines are never printed in a listing.
If the
.B n
option is not set, they are replaced by a line containing
the file name and a `:' character.
This is the default setting.
If the
.B n
new page option is enabled then the 
.B include 
line is replaced with a banner line similar to the first line
of a listing.
This line is placed on a new page in the listing.
.PP
When a non-trivial line is encountered in the source text after an
.B include
finishes, the
`popped' filename is printed, in the same manner as above.
.PP
For the purposes of error diagnostics when not making a listing, the filename
will be printed before each diagnostic if the current
filename has changed since the last
filename was printed.
