.if \n(xx .bp
.if !\n(xx \{\
.so tmac.p \}
.if n 'ND
'nr H1 0
.NH
Sources of information
.PP
This section lists the resources available on the UC Berkeley
campus for information about
general features of
.UX ,
text editing,
the Pascal language,
and the
.UP
implementation,
concluding with a list of references.
The available documents include both so-called standard documents \-
those distributed with all
.UX
system \-
and documents (such as this one) written at Berkeley.
.NH 2
Where to get documentation
.PP
On the UC Berkeley campus, documentation is available at the Computer
Center Library, room 218B Evans Hall.
The library is open from 8:00 A.M. to 5:00 P.M. Monday through Friday.
Current documentation for most of the
.UX
system is also available ``on line'' at your terminal.
Details on getting such documentation interactively are given
in section 1.3.
.NH 2
Computer Center short courses
.PP
For those not enrolled in Computer Science Division courses, and
who have no prior experience using
.UX ,
the short-courses offered by the staff of the Computer Center
are highly recommended.
These courses are offered free of charge, and are usually held
at the beginning of each quarter.
The two most valuable short courses for the
Berkeley
Pascal user are the ones dealing with basic use of
.UX ,
and with
text editing.
If you are unable to attend the short courses, documents
for these courses are available at the Computer Center Library,
and are recommended.
The documents are in a tutorial format, so it is possible to use them on your
own.
.NH 2
Documentation describing UNIX
.PP
The following documents are those recommended as tutorial and
reference material about the
.UX
system.
We give the documents with the introductory and tutorial materials
first, the reference materials last.
.SH
UNIX For Beginners \- Second Edition
.PP
This document is the basic tutorial for 
.UX
available with the standard system.
.SH
Communicating with UNIX
.PP
This is also a basic tutorial on the system and assumes
no previous familiarity
with computers; it was written at Berkeley and is used in the short courses.
.SH
An introduction to the C shell
.PP
This document introduces
.I csh,
the shell in common use at Berkeley, and provides a good deal of general
description about the way in which the system functions.
It provides a useful glossary of terms used in discussing the system.
.SH
UNIX Programmer's Manual
.PP
This manual is the major source of details on the components of the
.UX
system.
It consists of an Introduction,
a permuted index,
and eight command sections.
Section 1 consists of descriptions of most of the ``commands''
of
.UX .
Most of the other sections have limited relevance to the user
of
Berkeley
Pascal, being of interest mainly to system programmers.
The manual is available from the Computer Center Library.
.PP
U\s-2NIX\s0
documentation often refers the reader to sections of the manual.
Such a reference consists of a command name and a section number or name.
An example of such a reference would be:
.I ed
(1).\(dg
.FS
\(dg Older systems may refer to the manual sections using roman numerals,
e.g. \fIpi\fR (6).
.FE
Here
.I ed
is a command name \- the standard
.UX
text editor, and `(1)' indicates that its documentation is in section 1 of the
manual.
.PP
The pieces of the
Berkeley
Pascal system are
.I pi
(6),
.X
(6),
the combined Pascal translator and interpretive executor
.IX
(6),
the Pascal execution profiler
.XP
(6),
the Pascal cross-reference generator
.I pxref
(6),
and the filter which interprets carriage control
.I pcc
(6).
.PP
It is possible to obtain a copy of a manual section
by using the
.I man
(1) command.
To get the Pascal documentation just described one could issue the
command:
.LS
% \*bman new pi\fP
.LE
to the shell.
The user input here is shown in
.B "bold face" ;
the `% ',
which was printed by the shell as a prompt,
is not.
Similarly the command:
.LS
% \*bman man\fP
.LE
asks the
.I man
command to describe itself.
.NH 2
Text editing documents
.PP
The following documents introduce the various
.UX
text editors.
Most Berkeley users will use a version of the text editor
.I ex;
either
.I edit,
which is a version of
.I ex
for new and casual users,
.I ex
itself,
or
.I vi
(visual) which focuses on the display editing portion of
.I ex.*
.FS
* Several other editors are available also.  The standard
.UX
editor
.I ed,
the \s-2RAND\s0 editor
.I re,
and an (undocumented) version of
.I teco.
.FE
.SH
A Tutorial Introduction to the UNIX Text Editor
.PP
This document, written by Brian Kernighan of Bell Laboratories,
is a tutorial for the standard
.UX
text editor
.I ed.
It introduces you to the basics of text editing,
and provides enough information to meet day-to-day editing needs,
for
.I ed
users.
.SH
Edit: A tutorial
.PP
This introduces the use of
.I edit,
an editor similar to
.I ed
which provides a more hospitable environment for beginning users.
The short courses on editing taught by the Computer Center use this
document.
.SH
Ex/edit Command Summary
.PP
This summarizes the features of the editors
.I ex
and
.I edit
in a concise form.  If you have used a line oriented editor before
this summary alone may be enough to get you started.
.SH
Ex Reference Manual \- Version 2.0
.PP
A complete reference on the features of
.I ex
and
.I edit.
.SH
An Introduction to Display Editing with Vi
.PP
.I Vi
is a display oriented text editor.  It can be used on most any \s-2CRT\s0
terminal,
and uses the screen as a window into the file you are editing.  Changes
you make to the file are reflected in what you see.  This manual serves
both as an introduction to editing with
.I vi
and a reference manual.
.SH
Vi Quick Reference
.PP
This reference card is a handy quick guide to
.I vi;
you should get one when you get the introduction to
.I vi.
.NH 2
Pascal documents \- The language
.PP
This section describes the documents on the Pascal language
which are likely to be most useful to the
Berkeley
Pascal user.
Complete references for these documents are given in section 1.7.
.SH
Pascal User Manual
.PP
By Kathleen Jensen and Niklaus Wirth, the
.I "User Manual"
provides a tutorial introduction to the features
of the language Pascal,
and serves as an excellent quick-reference to the language.
The reader with no familiarity with Algol-like languages 
may prefer one of the Pascal text books listed below,
as they provide more examples and explanation.
Particularly important here are pages 116-118 which define the syntax
of the language.
Sections 13 and 14 and Appendix F pertain only to the
6000-3.4 implementation of Pascal.
.SH
Pascal Report
.PP
By Niklaus Wirth, this document is bound with the
.I "User Manual."
It is the guiding reference for implementors and the fundamental
definition of the language.
Some programmers find this report too concise to be of practical use,
preferring the
.I "User Manual"
as a reference.
.SH
Books on Pascal
.PP
Several good books which teach Pascal or use it as a medium are
available.
The books by Wirth
.I "Systematic Programming"
and
.I "Algorithms + Data Structures = Programs"
use Pascal as a vehicle for teaching programming and data structure
concepts respectively.
They are both recommended.
Other books on Pascal are listed in the references below.
.NH 2
Pascal documents \- The Berkeley Implementation
.PP
This section describes the documentation which is available
describing the
Berkeley
implementation of Pascal.
.SH
User's Manual
.PP
The document you are reading is the 
.I "User's Manual"
for
.UP .
We often refer the reader to the
Jensen-Wirth
.I "User Manual"
mentioned above,
a different document with a similar name.
.SH
Manual sections
.PP
The sections relating to Pascal in the
.I "UNIX Programmer's Manual"
are
.IX
(6),
.PI
(6),
.I pcc
(6),
.X
(6),
.I pxp
(6),
and
.I pxref
(6).
These sections give a description of each program,
summarize the available options,
indicate files used by the program,
give basic information on the diagnostics produced 
and include a list of known bugs.
.SH
Implementation notes
.PP
For those interested in the internal organization of the
Berkeley
Pascal system there are a series of
.I "Implementation Notes"
describing these details.
The
.I "Berkeley Pascal PXP Implementation Notes"
describe the Pascal interpreter
.X \|;
and the
.I "Berkeley Pascal PX Implementation Notes"
describe the structure of the
execution profiler
.I pxp .
.br
.ne 8
.NH 2
References
.de re
.sp
.IP
'nf
..
.SH
UNIX Documents
.re
.I "Communicating With UNIX"
Computer Center
University of California, Berkeley
January, 1978.
.re
.I "Edit: a tutorial"
Ricki Blau and James Joyce
Computing Services Division, Computing Affairs
University of California, Berkeley
January, 1978.
.re
.I "Ex/edit Command Summary"
Computer Center
University of California, Berkeley
August, 1978.
.re
.I "Ex Reference Manual \- Version 2.0"
.I "An Introduction to Display Editing with Vi"
.I "Vi Quick Reference"
William Joy
Computer Science Division
Department of Electrical Engineering and Computer Science
University of California, Berkeley
April, 1979.
.re
.I "An Introduction to the C shell"
William Joy
Computer Science Division
Department of Electrical Engineering and Computer Science
University of California, Berkeley
January, 1979.
.re
Brian W. Kernighan
.I "UNIX for Beginners \- Second Edition"
Bell Laboratories
Murray Hill, New Jersey.
.re
Brian W. Kernighan
.I "A Tutorial Introduction to the UNIX Text Editor"
Bell Laboratories
Murray Hill, New Jersey.
.re
Dennis M. Ritchie and Ken Thompson
.I "The UNIX Time Sharing System"
Communications of the ACM
July 1974
365-378.
.re
B. W. Kernighan and M. D. McIlroy
.I "UNIX Programmer's Manual \- Seventh Edition"
Bell Laboratories
Murray Hill, New Jersey
December, 1978.
.ne 12
.SH
Pascal Language Documents
.re
Conway, Gries and Zimmerman
.I "A Primer on PASCAL"
Winthrop, Cambridge Mass.
1976, 433 pp.
.re
Kathleen Jensen and Niklaus Wirth
.I "Pascal \- User Manual and Report"
Springer-Verlag, New York.
1975, 167 pp.
.re
C. A. G. Webster
.I "Introduction to Pascal"
Heyden and Son, New York
1976, 129pp.
.re
Niklaus Wirth
.I "Algorithms + Data structures = Programs"
Prentice-Hall, New York.
1976, 366 pp.
.re
Niklaus Wirth
.I "Systematic Programming"
Prentice-Hall, New York.
1973, 169 pp.
.SH
Berkeley Pascal documents
.PP
The following documents are available from the Computer Center Library
at the University of California, Berkeley.
.nf
.re
William N. Joy, Susan L. Graham, and Charles B. Haley
.I "Berkeley Pascal User's Manual \- Version 1.1"
April, 1979.
.re
William N. Joy
.I "Berkeley Pascal PX Implementation Notes"
Version 1.1, April 1979.
.re
William N. Joy
.I "Berkeley Pascal PXP Implemetation Notex"
Version 1.1, April 1979.
