#include "playdefs.h"

Point	oldmouse;	/* Where the mouse was at last check	*/
Rectangle	botrect, /* Area of screen spider stays in. */
		playerrect; /* Area of screen player stays in.*/

Texture16	plain = {
	0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000
};

Texture16	fancy = {
	0x1000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000
};

short	mush_bits[] = { /* What a mushroom looks like	*/
	0x001F, 0xF000,
	0x007F, 0xFE00,
	0x03FF, 0x1F80,
	0x0FC3, 0x03C0,
	0x1F06, 0x00E0,
	0x1C06, 0x0030,
	0x3806, 0x0038,
	0x7805, 0x800C,
	0x6000, 0x800E,
	0xE001, 0x0006,
	0xE002, 0x0003,
	0xC000, 0x0003,
	0xC7F3, 0xFF43,
	0xC5DF, 0xDFBB,
	0xCF5D, 0xFCFA,
	0x7FFF, 0x3FFE,
	0x34FC, 0x2DEC,
	0x3FF6, 0x7F5C,
	0x1EDE, 0x76F8,
	0x03FE, 0x3BE0,
	0x00FC, 0x3F80,
	0x001E, 0x3800,
	0x0034, 0x1800,
	0x002C, 0x1800,
	0x006C, 0x4C00,
	0x00F8, 0xCC00,
	0x00F8, 0xC600,
	0x0171, 0xC700,
	0x01F9, 0xC300,
	0x03D7, 0xE180,
	0x02FF, 0xFFC0,
	0x07F8, 0x7DC0
};

Bitmap	mushlooks = { /* For displaying mushrooms	*/
	(Word *)mush_bits,
	shorts(2),
	{ { 0, 0 }, { 32, 32 } }
};

Bitmap	chunk1looks = { /* for displaying top mushroom chunk	*/
	(Word *)mush_bits,
	shorts(2),
	{ { 0, 0 }, { 32, 8 } }
};

Bitmap	chunk2looks = { /* for displaying 2nd mushroom chunk	*/
	(Word *)&mush_bits[16],
	shorts(2),
	{ { 0, 0 }, { 32, 8 } }
};

Bitmap	chunk3looks = { /* for displaying 3rd mushroom chunk	*/
	(Word *)&mush_bits[32],
	shorts(2),
	{ { 0, 0 }, { 32, 8 } }
};

Bitmap	chunk4looks = { /* for displaying bottom mushroom chunk	*/
	(Word *)&mush_bits[48],
	shorts(2),
	{ { 0, 0 }, { 32, 8 } }
};

short	glow_bits[] = { /* What full glowing mushroom looks like	*/
	0x001F, 0xF000,
	0x007F, 0xFE00,
	0x03FF, 0xFF80,
	0x0FFF, 0xFFC0,
	0x1F8F, 0xE7E0,
	0x1F0F, 0xC3F0,
	0x3F0F, 0xC3F8,
	0x7FFF, 0xFFFC,
	0x7FFF, 0xFFFE,
	0xFFFF, 0xFFFE,
	0xF3FF, 0xFFEF,
	0xF8FF, 0xFF8F,
	0xF87F, 0xFF0F,
	0xFC0F, 0xF81F,
	0xFC00, 0x007E,
	0x7E00, 0x007E,
	0x3F80, 0x00FC,
	0x3FE0, 0x07FC,
	0x1FFF, 0xFFF8,
	0x03FF, 0xFFE0,
	0x001F, 0xFF80,
	0x001F, 0xF000,
	0x003F, 0xF800,
	0x003F, 0xF800,
	0x007F, 0xFC00,
	0x00FF, 0xFC00,
	0x00FF, 0xFE00,
	0x01FF, 0xFF00,
	0x01FF, 0xFF00,
	0x03FF, 0xFF80,
	0x03FF, 0xFE00,
	0x03F8, 0x7C00
};

Bitmap	glowlooks = { /* For displaying full glowing mushroom	*/
	(Word *)glow_bits,
	shorts(2),
	{ { 0, 0 }, { 32, 32 } }
};

Bitmap	gl1looks = { /* For displaying top glowing mushroom chunk	*/
	(Word *)glow_bits,
	shorts(2),
	{ { 0, 0 }, { 32, 8 } }
};

Bitmap	gl2looks = { /* For displaying 2nd glowing mushroom chunk	*/
	(Word *)&glow_bits[16],
	shorts(2),
	{ { 0, 0 }, { 32, 8 } }
};

Bitmap	gl3looks = { /* For displaying 3rd glowing mushroom chunk	*/
	(Word *)&glow_bits[32],
	shorts(2),
	{ { 0, 0 }, { 32, 8 } }
};

Bitmap	gl4looks = { /* For displaying bottom glowing mushroom chunk	*/
	(Word *)&glow_bits[48],
	shorts(2),
	{ { 0, 0 }, { 32, 8 } }
};

short	me_bits[] = { /* What the player looks like	*/
	0x0001, 0x8000,
	0x0001, 0x8000,
	0x0003, 0xC000,
	0x0007, 0xE000,
	0x000E, 0x7000,
	0x001E, 0x7800,
	0x0038, 0x1C00,
	0x0070, 0x0E00,
	0x00E0, 0x0700,
	0x01C0, 0x0380,
	0x0380, 0x01C0,
	0x0700, 0x00E0,
	0x0E00, 0x0070,
	0x1C00, 0x0038,
	0x3800, 0x001C,
	0x7000, 0x000E,
	0xE180, 0x018F,
	0xE3C0, 0x03C7,
	0xE3C0, 0x03C7,
	0xE180, 0x0187,
	0xE000, 0x0007,
	0xE000, 0x0007,
	0xFFC0, 0x03FF,
	0x7FE0, 0x07FE,
	0x00E0, 0x0700,
	0x0060, 0x0600,
	0x0060, 0x0600,
	0x0060, 0x0600,
	0x0060, 0x0600,
	0x0060, 0x0600,
	0x007F, 0xFE00,
	0x007F, 0xFE00
};

Bitmap	melooks = { /* For displaying player	*/
	(Word *)me_bits,
	shorts(2),
	{ { 0, 0 }, { 32, 32 } }
};

short	scorp_bits[] = { /* What scorpion looks like	*/
	0x00E0, 0x0000, 0x0010, 0x0000,
	0x03FC, 0x0000, 0x0010, 0x0000,
	0x07FE, 0x0000, 0x0150, 0x0000,
	0x3FFE, 0x0000, 0x0150, 0x0000,
	0x3FFF, 0x0000, 0x01B0, 0x0000,
	0x3FC7, 0x0000, 0x00A8, 0x0000,
	0x7E07, 0x0000, 0x00B8, 0x0000,
	0x7C07, 0x0000, 0x0098, 0x0000,
	0x7C02, 0x0000, 0x01F8, 0x0000,
	0xF806, 0x0203, 0x01F8, 0x0000,
	0xF80E, 0x0383, 0x81F8, 0x0000,
	0xF838, 0x0286, 0x03F8, 0x0000,
	0xF800, 0x0604, 0x07F8, 0x0000,
	0xFC00, 0x4484, 0x0FF8, 0x0000,
	0xFE01, 0xE4C4, 0x1FF8, 0x0000,
	0x7F03, 0x25E4, 0x3FF8, 0x0000,
	0x7F80, 0x1D34, 0x7FF0, 0x0000,
	0x7FE0, 0x0C0C, 0xFFE0, 0x0000,
	0x3FFF, 0xFFFF, 0xFFC0, 0x0000,
	0x1FFF, 0xFFFF, 0xFF80, 0x0000,
	0x0FFF, 0xFFFF, 0xFF00, 0x0000,
	0x07FF, 0xFFFF, 0xFE00, 0x0000,
	0x03FF, 0xFFFF, 0xFC00, 0x0000,
	0x007F, 0xFFFF, 0xF000, 0x0000,
	};

Bitmap	scorplooks = { /* For displaying scorpion	*/
	(Word *)scorp_bits,
	shorts(4),
	{ { 0, 0 }, { 48, 24 } }
};

short	shot_bits[] = { /* What player's missile looks like	*/
	0xE000, 0x0000,
	0xE000, 0x0000,
	0xE000, 0x0000,
	0xE000, 0x0000,
	0xE000, 0x0000,
	0xE000, 0x0000,
	0xE000, 0x0000,
	0xE000, 0x0000,
	0xE000, 0x0000,
	0xE000, 0x0000,
	0x0000, 0x0000,
	0x0000, 0x0000,
	0xE000, 0x0000,
	0xE000, 0x0000,
	0xE000, 0x0000,
	0xE000, 0x0000,
	0xE000, 0x0000,
	0xE000, 0x0000,
	0xE000, 0x0000,
	0xE000, 0x0000,
	0xE000, 0x0000,
	0xE000, 0x0000,
	0xE000, 0x0000,
	0xE000, 0x0000,
	0xE000, 0x0000,
	0xE000, 0x0000,
};

Bitmap	shotlooks = { /* For displaying	player's missile	*/
	(Word *)shot_bits,
	shorts(2),
	{ { 0, 0 }, { 3, 26 } }
};

short	slug_bits[] = { /* What a slug (mushroom dropper) looks like	*/
	0x007F, 0xFE00,
	0x01FF, 0xFF80,
	0x7FFF, 0xFFFE,
	0xFFE1, 0xD3FF,
	0x0380, 0xC3C0,
	0x0378, 0x1EF0,
	0x07FC, 0x3FFA,
	0x0FCC, 0x33FA,
	0x1FB4, 0x2DFC,
	0x33B4, 0xADDC,
	0x7385, 0xE1CE,
	0x63CD, 0xB3C7,
	0xC1FD, 0x9F83,
	0xC1FD, 0x9F83,
	0xC0FB, 0x0F13,
	0xD803, 0x0013,
	0xC206, 0x0003,
	0xC31E, 0x0303,
	0xC01C, 0x0003,
	0xCC3C, 0x7023,
	0xC03C, 0xDB11,
	0xE23F, 0xF807,
	0xE200, 0x3007,
	0x7000, 0x001F,
	0x3EAD, 0xFFFE,
	0x1FFF, 0xFFFC,
	0x00E1, 0xC380,
	0x00F3, 0xE7C0,
	0x01FB, 0xE7E0,
	0x07BB, 0xEE70,
	0x0F0F, 0xFC38,
	0x0E07, 0xF83C
};

Bitmap	sluglooks = { /* For displaying slug (mushroom dropper) */
	(Word *)slug_bits,
	shorts(2),
	{ { 0, 0 }, { 32, 32 } }
};

short	spid_bits[] = { /* What spider looks like	*/
	0x0000, 0x1FFF, 0x8000, 0x0000,
	0x0000, 0x3FFF, 0xE000, 0x0000,
	0x0000, 0xFFFF, 0xE000, 0x0000,
	0x0001, 0xFFFF, 0xFFE0, 0x0000,
	0x0003, 0xFFFF, 0xFDF0, 0x0000,
	0x0003, 0xFFFF, 0xF038, 0x0000,
	0x001F, 0xFFFF, 0xF038, 0x0000,
	0x007F, 0xFFFF, 0xFC1C, 0x0000,
	0x01C7, 0xFFFF, 0xFF0C, 0x0000,
	0x0307, 0xFFFF, 0xFF8E, 0x0000,
	0x0607, 0xFFFF, 0xF8C6, 0x0000,
	0x040F, 0xFFFF, 0xF067, 0x0000,
	0x0C1B, 0xFFFF, 0xC063, 0x0000,
	0x0C3B, 0xFFFF, 0xE063, 0x0000,
	0x0873, 0xFFFC, 0x7831, 0x0000,
	0x1863, 0xBFFF, 0x7831, 0x0000,
	0x19C3, 0x33FB, 0x3C30, 0x0000,
	0x1106, 0x33FB, 0xBC30, 0x0000,
	0x330C, 0x73FB, 0x9C30, 0x0000,
	0x3718, 0x6369, 0x8C10, 0x0000,
	0x2610, 0x61F1, 0x8E18, 0x0000,
	0x6430, 0x60E1, 0x8E18, 0x0000,
	0xCC20, 0xE001, 0x8E18, 0x0000,
	0x4860, 0xE001, 0x0E18, 0x0000,
	0x1860, 0xE001, 0x0E18, 0x0000,
	0x1860, 0xC003, 0x0608, 0x0000,
	0x18E0, 0xC003, 0x0600, 0x0000,
	0x18C0, 0xC003, 0x0600, 0x0000,
	0x11C0, 0xC003, 0x0400, 0x0000,
	0x0080, 0x8001, 0x0000, 0x0000,
};

Bitmap	spiderlooks = { /* For displaying spider	*/
	(Word *)spid_bits,
	shorts(4),
	{ { 0, 0 }, { 48, 30 } }
};

short	face_bits[] = { /* Hard to display self portrait	*/
	0x0001, 0x8000, 0x0000, 0x0000,
	0x000F, 0xE000, 0x0000, 0x0000,
	0x003B, 0xB800, 0x0000, 0x0000,
	0x00EC, 0x8FF8, 0x0000, 0x0000,
	0x03FF, 0xD7CC, 0x0000, 0x0000,
	0x05F3, 0x9990, 0x0000, 0x0000,
	0x0DF7, 0x3F9C, 0x0000, 0x0000,
	0x1FFB, 0xFBF3, 0x0000, 0x0000,
	0x1FEA, 0x7B7F, 0x0000, 0x0000,
	0x1FE7, 0x3F4F, 0x0000, 0x0000,
	0x1FF1, 0x2F3F, 0x8000, 0x0000,
	0x3F59, 0xDE3F, 0xC000, 0x0000,
	0x3F3F, 0xFE3F, 0xC000, 0x0000,
	0x2DCF, 0xF0DB, 0xC000, 0x0000,
	0x2FFB, 0xC3ED, 0xC000, 0x0000,
	0x278E, 0x001E, 0xC000, 0x0000,
	0x7FF0, 0x0007, 0xE000, 0x0000,
	0x6E00, 0x0007, 0xF000, 0x0000,
	0x3CFF, 0x0FE3, 0xE000, 0x0000,
	0x39FF, 0x9FF1, 0xA000, 0x0000,
	0x3B01, 0xF818, 0xA000, 0x0000,
	0x3339, 0xFB98, 0xE000, 0x0000,
	0x7F39, 0x9B9F, 0xC000, 0x0000,
	0x7F39, 0x9B9F, 0xC000, 0x0000,
	0x2B07, 0x6C19, 0x4000, 0x0000,
	0x2BFE, 0x47F9, 0x4000, 0x0000,
	0x29FC, 0x93F1, 0x4000, 0x0000,
	0x2800, 0x1001, 0x4000, 0x0000,
	0x2800, 0x1001, 0x4000, 0x0000,
	0x1801, 0x0801, 0x4000, 0x0000,
	0x0801, 0x0801, 0x82F8, 0x0000,
	0x0800, 0xD803, 0x07BC, 0x0000,
	0x0C00, 0x0002, 0x0886, 0x0000,
	0x060D, 0xFE84, 0x0FFE, 0x0000,
	0x031B, 0x5FC4, 0x0FFE, 0x0000,
	0x011D, 0x018C, 0x0C06, 0x0000,
	0x0188, 0x0088, 0x7D56, 0x0000,
	0x00C1, 0xFC18, 0xFD56, 0x0000,
	0x0040, 0x0031, 0xDD56, 0x0000,
	0x0020, 0x0061, 0x8D56, 0x0000,
	0x0030, 0x00C1, 0x8D56, 0x0000,
	0xE010, 0x7081, 0x8D56, 0x0000,
	0xA018, 0x0081, 0x8D56, 0x0000,
	0xEEE4, 0x0181, 0xDD56, 0x0000,
	0x8AA7, 0x7F00, 0xFD56, 0x0000,
	0x8EE1, 0x8000, 0x2D56, 0x0000,
	0x8AA0, 0x0000, 0x0C06, 0x0000,
	0x0000, 0x0000, 0x0FFE, 0x0000,
};

Bitmap	facelooks = { /* For displaying silliness.	*/
	(Word *)face_bits,
	shorts(4),
	{ { 0, 0 }, { 48, 48 } }
};

short	worm_bits[] = { /* What a centipede non-head segment looks like	*/
	0x0007, 0xE000,
	0x003F, 0xF800,
	0x00FF, 0xEE00,
	0x03E0, 0x3F80,
	0x07BF, 0xF7C0,
	0x076D, 0xC9F0,
	0x0F8F, 0x0878,
	0x1E17, 0x3E38,
	0x3C75, 0x0ABC,
	0x34E8, 0x8B9C,
	0x77B0, 0x0B0E,
	0x67F8, 0x8E07,
	0xC41C, 0x9E3B,
	0xD827, 0x835B,
	0xDC46, 0xE4C3,
	0xF5C4, 0x48E3,
	0xE6E4, 0x1397,
	0xC29C, 0x3D93,
	0xFD9C, 0x6713,
	0xC7F8, 0x031F,
	0xC940, 0x80F9,
	0xF0C7, 0x8337,
	0xE283, 0x3E37,
	0x73CF, 0x803F,
	0x3EFD, 0xFFFE,
	0x1FFF, 0xFFFC,
	0x00E0, 0x0380,
	0x00F0, 0x07C0,
	0x01FC, 0x07E0,
	0x07BE, 0x0E70,
	0x0F0E, 0x1C38,
	0x0E06, 0x383C
};

Bitmap	wormlooks = { /* For displaying centipede non-head segments.	*/
	(Word *)worm_bits,
	shorts(2),
	{ { 0, 0 }, { 32, 32 } }
};

short	head_bits[] = { /* What a centipede head segment looks like	*/
	0x0000, 0x0000,
	0xF000, 0x000F,
	0xF800, 0x001F,
	0x1C07, 0xE038,
	0x0E3F, 0xF870,
	0x06FF, 0x7E60,
	0x03E6, 0x0FE0,
	0x0789, 0x03C0,
	0x0F01, 0xC9E0,
	0x3C00, 0x0078,
	0x78F8, 0x8F3E,
	0xE0FC, 0x1D8F,
	0xC186, 0x3EC3,
	0xC703, 0x7E63,
	0xC301, 0x7E63,
	0xD307, 0x7C6B,
	0xD31F, 0x7863,
	0xC31F, 0x4063,
	0xC7BF, 0x60E3,
	0xC5FE, 0x738B,
	0xC0FE, 0x3F03,
	0xC878, 0x1E03,
	0xE002, 0x8443,
	0x60C0, 0x0413,
	0x7001, 0x0027,
	0x380E, 0x3806,
	0x3D1E, 0x78CE,
	0x1E1E, 0x781C,
	0x070E, 0x387C,
	0x07E0, 0x01F0,
	0x01FF, 0xFFE0,
	0x007F, 0xFF80
};

Bitmap	headlooks = { /* For displaying centipede head segments	*/
	(Word *)head_bits,
	shorts(2),
	{ { 0, 0 }, { 32, 32 } }
};

struct	object	me = { {{0, 0}, {0, 0}},
		       {{0, 0}, {0, 0}}, 0, 0, 0, 0,
			personchoose,
			&melooks};
struct	object	slug = { {{0, 0}, {0, 0}},
			   {{0, 0}, {0, 0}}, 0, 0, 0, SLUGVALUE,
			slugchoose, &sluglooks};
struct	object	spider = { {{0, 0}, {0, 0}},
			   {{0, 0}, {0, 0}}, 0, 0, 0, SPIDERVALUE,
			spiderchoose, &spiderlooks};
struct	object	shot = { {{0, 0}, {0, 0}},
		       {{0, 0}, {0, 0}}, 0, SHOTSPEED, 0, 0,
			shotchoose, &shotlooks};
struct	object	scorpion = { {{0, 0}, {0, 0}},
		       {{0, 0}, {0, 0}}, 0, 0, 0, SCORPVALUE,
			scorpchoose, &scorplooks};
struct	object	worm[WORMMAX];	/* centipede objects	*/
char	glowmush[MUSHCOLS][MUSHROWS],/* TRUE at (x, y) if mush is glowing*/
	mushspace[MUSHCOLS][MUSHROWS],	/* number of chunks at scr. locs.*/
	spidbuf[4];	/* Score for last shot spider as shown on screen */
int	botmush_cnt,	/* Number of mushrooms at bottom of screen	*/
	firstworm,	/* The first existing centipede object	*/
	me_cnt,		/* No. of players remaining			*/
	mush_cnt, 	/* Number of mushrooms on screen		*/
	mushcols = MUSHCOLS,	/* Current # of columnss of mushrooms	*/
	mushrows = MUSHROWS,	/* Current # of rows of mushrooms	*/
	round_cnt,	/* Which Round of the game is it?	*/
	scorp_fuse,	/* countdown for next scorpion appearance	*/
	spider_fuse,	/* countdown for next spider appearance	*/
	start_over,	/* Start a new game?	*/
	topofbottom;	/* The top row in the player's region	*/
long	newmanat,	/* Score needed for next extra man	*/
	score;		/* Score					*/
