'\" Copyright 1989 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /sprite/src/lib/tcl/RCS/Tcl_Return.man,v 1.3 89/08/16 08:52:46 ouster Exp $ SPRITE (Berkeley)
'\" 
.so \*(]ltmac.sprite
.HS Tcl_Return tcl
.BS
.SH NAME
Tcl_Return \- set up a Tcl result string
.SH SYNOPSIS
.nf
\fB#include <tcl.h>\fR
.sp
\fBTcl_Return\fR(\fIinterp, string, status\fR)
.SH ARGUMENTS
.AP Tcl_Interp *interp out
Interpreter for which a return value is to be established.
.AP char *string in
String value to be returned, or \fBNULL\fR.
.AP int status in
Indicates the nature of \fIstring\fR.  Must be either \fBTCL_STATIC\fR,
\fBTCL_DYNAMIC\fR, or \fBTCL_VOLATILE\fR.
.BE

.SH DESCRIPTION
.PP
\fBTcl_Return\fR is a convenience routine used by several of the Tcl commands.  It
arranges for \fIstring\fR to be the return string for the current Tcl
command in \fIinterp\fR.  If \fIstatus\fR is \fBTCL_STATIC\fR it means that
\fIstring\fR
refers to an area of static storage that is guaranteed to remain
untouched until at least the next call to \fBTcl_Eval\fR.  If \fIstatus\fR
is \fBTCL_DYNAMIC\fR it means that \fIstring\fR was allocated with a call
to \fBmalloc()\fR and is now the property of the Tcl system.  \fBTcl_Return\fR
will arrange for the string's storage to be released by calling
\fBfree()\fR when it is no longer needed.  The third possibility is for
\fIstatus\fR to be \fBTCL_VOLATILE\fR.  This means that \fIstring\fR points
to an area of memory that is likely to be overwritten when \fBTcl_Return\fR
returns.  In this case \fBTcl_Return\fR makes a copy of the string and arranges
for the copy to be the return string for the current Tcl command.
.PP
If \fIstring\fR is \fBNULL\fR, then \fIstatus\fR is ignored and \fBTcl_Return\fR
re-initializes \fIinterp\fR's result to point to the pre-allocated result
area, with an empty string in the result area.
.PP
In any of the above cases, if \fIinterp\fR holds a dynamically-allocated
result at the time of the \fBTcl_Return\fR call, the old result's storage
is released by calling \fBfree()\fR.

.SH KEYWORDS
command, result, return value, interpreter
