






                             *      *      *





                        M A C R O   S P I T B O L
                        M A C R O   S P I T B O L

                        -------------------------



                    PROGRAM REFERENCE MANUAL (Rev. G)

                    ---------------------------------



                     VAX/VMS Version 3.5 (BCAB-2132)

                     -------------------------------





                  Copyright   (c)   1980    by    DEWAR
                  INFORMATION    SYSTEMS   CORPORATION.
                  This   manual   may   be   reporduced
                  provided  that this Dewar Information
                  Systems    Copyright    Notice     is
                  incorporated.



                  VAX,   VMS,  DECwriter  and  PDP  are
                  registered trademarks of the  Digital
                  Equipment Corporation.




                  DEWAR INFORMATION SYSTEMS CORPORATION
                           221 West Lake Street
                      Oak Park, Illinois USA  60302

                              (312) 524-1644








































           Please replace this page with the Table of Contents
           Please replace this page with the Table of Contents
                               (At the end)
                               (At the end)































    This  report  is  parallel  to  the  University of Leeds Technical
    Report Number 94, "Macro Spitbol - Decsystem 10 Version,"  McCann,
    Holden  and Dewar, Dec. 1976.  Differences will be found primarily
    in Section 12.


                             Revision History
                             ________ _______

    This document has been revised as follows :

    Dec 1976        to correspond with        SPITBOL Version 3.0
    Mar 1978        to correspond with        SPITBOL Version 3.3
    Sep 1978        to correspond with        SPITBOL Version 3.4
    Feb 1979        to correspond with        SPITBOL Version 3.5



    VAX/VMS MACRO SPITBOL Version BCAB-2132 is designed to operate  on
    the  VAX 11/780 and VAX 11/750 computers running the VMS operating
    system version 2.0, 2.1, 2.2, 2.3 or 2.4.







































         MACRO SPITBOL V3.5
                                                   PAGE 1 - [1]
         Introduction



                          *-------------------*
                            [1]  Introduction
                          | [1]  Introduction |
                          *-------------------*

    MACRO SPITBOL  is  an  implementation  of  the  SNOBOL4   computer
    language  which  was  coded  during 1974/75. In speed and external
    style  it resembles the earlier SPITBOL  implementations  for  the
    IBM 360   and  UNIVAC 1100  series  computers  but  internally  it
    differs  considerably  from  these  since  the  source   code   is
    converted  to  a reverse polish string which is then used to drive
    interpretive routines.  MACRO SPITBOL is  available  with  a  high
    degree  of  compatibility  on  a  range of computers running under
    widely differing operating  systems.   This  report  reflects  the
    above   fact   by  providing  in  its  first  nine  sections  such
    documentation  and  information  for  users  as  is  substantially
    machine   independent,  with  a  final  section  giving  essential
    information peculiar to each  particular  implementation.   It  is
    assumed  that  the  reader  is familiar with the standard version,
    referred to simply as SNOBOL4 in the remainder of the  report  and
    described   in   the   essential   reference   book  "The  SNOBOL4
    Programming Language" by Griswold,  Poage  and  Polonsky,  Addison
    Wesley,  1971.   Version  3.4  of SNOBOL4 is the reference version
    for comparison.  There are  several  minor  incompatibilities  and
    some  features  are  not implemented.  There are several additions
    to the language in this implementation.































         MACRO SPITBOL V3.5
                                                   PAGE 2 - [1]
         Introduction


    In  general  an  attempt  has   been   made   to   retain   upward
    compatibility  wherever  possible.   Most  SNOBOL4  programs which
    operate correctly using  SNOBOL4  should  operate  correctly  when
    compiled  and  executed  using MACRO SPITBOL.  For brevity, in the
    remainder of the report MACRO SPITBOL will be referred  to  simply
    as SPITBOL.


    SPITBOL was initially designed and implemented by:

    Professor Robert B. K. Dewar,
    Courant Institute of Mathematical Sciences,
    251 Mercer Street,
    NEW YORK, N.Y. 10012.
    U.S.A.

    It has been further developed and is now maintained by:

    Dr.  Anthony P. McCann,
    Department of Computer Studies,
    University of Leeds,
    LEEDS, LS2 9JT,
    England.


    The VAX/VMS Version is the work of and is maintained by:

    Steven G. Duff
    c/o Dewar Information Systems Corporation
    221 West Lake Street
    Oak Park, Illinois  60302

    which  should  be  contacted to report problems or for information
    on distribution.

    The implementor gratefully acknowledges the assistance of  Thagard
    Research  in  providing  development  facilities  for  the VAX/VMS
    Version of SPITBOL.



















         MACRO SPITBOL V3.5
                                                   PAGE 3 - [2]
         Summary of Differences



                     *-----------------------------*
                       [2]  Summary of Differences
                     | [2]  Summary of Differences |
                     *-----------------------------*

    The  principal  differences  between  SPITBOL  and   SNOBOL4   are
    summarised here.


 2.1  Features not Implemented
 2.1  Features not Implemented
 _____________ ___ ___________


     1.  The  capability  to  redefine  standard  system functions and
         predefined operators.  This restriction permits compile  time
         pre-evaluation  of  a wider range of expressions and patterns
         than would otherwise  be  possible.   It  affects  the  OPSYN
         function (see Section 5 for details).

     2.  The VALUE  and BACKSPACE functions.

     3.  The  keywords  &STFCOUNT  and  &FULLSCAN  .   The  heuristics
         associated with the QUICKSCAN mode of  pattern  matching  are
         complex  and for many programs do not result in a significant
         increase  in speed.  Accordingly only  FULLSCAN  matching  is
         provided  and  no  heuristics  are  applied.   In  particular
         deferred expressions are not assumed to match  at  least  one
         character.

     4.  The BLOCK datatype as in SNOBOL4B .

     5.  The  variable  PUNCH has no predefined association to a punch
         stream.   If  required,  the  programmer  should  include   a
         statement such as OUTPUT(.PUNCH,3) in his program.

     6.  SPITBOL does not permit exponentiation of two real numbers.

     7.  For  small  machines,  versions  of SPITBOL in which all real
         arithmetic capability is omitted are available - see  Section
         12.

     8.  Some  implementations  may  omit  a  few features.  A list is
         given in Section 12.















         MACRO SPITBOL V3.5
                                                   PAGE 4 - [2.2]
         Summary of Differences



 2.2  Features Implemented Differently
 2.2  Features Implemented Differently
 _____________ ___________ ___________

    Some of the differences here may necessitate program changes.


     1.  In SPITBOL the value of  &ANCHOR  is  obtained  only  at  the
         start  of the match.  In SNOBOL4, changing the value during a
         match can lead to unexpected results.

     2.  The pattern valued variables ABORT, ARB, BAL,  FAIL,   FENCE,
         REM,  SUCCEED  are write protected so that attempts to assign
         to them will fail.

     3.  The same stack is used for pattern matching and for  function
         calls.   Thus  the  diagnostic issued for an infinite pattern
         recursion is simply the standard stack overflow message.

     4.  Recovery from execution errors (see function SETEXIT ).

     5.  Input/Output.  In particular, FORTRAN I/O  is  not  provided.
         Dynamic  association  to  files is possible through the third
         argument and statement failure is possible if a  file  cannot
         be found as in
              INPUT(.IN,3,'INFIL')                :F(NOFILE)

     6.  The  TABLE function is implemented so that table elements can
         be rapidly accessed by the efficient  technique  of  hashing.
         In  order  to  set  a  suitable size for the hash table it is
         important to choose a reasonable value for  the  argument  of
         TABLE.   Use of an inappropriate value will not cause program
         failure but may delay access to elements or waste memory.

     7.  SPITBOL allows  some  datatype  conversions  not  allowed  in
         SNOBOL4.   For  example  a real value may be used in patterns
         and is converted to a string.  In  general  objects  will  be
         converted to an appropriate datatype if at all possible.

     8.  The  unary  .  (name)  operator applied to a natural variable
         yields  a NAME rather than a  STRING.   Since  this  NAME  is
         converted  to  a STRING when necessary, the difference is not
         normally noticed.  The only points at which   the  difference
         will  be  apparent  is  in  use  of  the  IDENT,  DIFFER  and
         DATATYPE functions  and when used as a TABLE subscript.

     9.  SPITBOL  permits  leading  and  trailing  blanks  on  numeric
         strings which are to be converted to  NUMERIC .

    10.  Several  of  the  built-in  functions are slightly different.
         They are identified by a * on their names in Section 5.

    11.  The count  of  statements  executed  includes  labelled  null
         statements and  the END statement.




         MACRO SPITBOL V3.5
                                                   PAGE 5 - [2.2]
         Summary of Differences

    12.  Constant  sub-expressions  and  patterns are pre-evaluated at
         compile time.  This  may  occasionally  result  in  execution
         errors   (e.g.   integer   overflow)  being  reported  during
         compilation.  Significant speed increases may be obtained  by
         ensuring  that in-line patterns are constant so that they may
         be  pre-evaluated.   Patterns  built  from   pattern   valued
         variables  (e.g.  ARB)  and  pattern  functions with constant
         arguments (e.g. ANY(*ARG), RTAB(0)) are themselves constant.

    13.  A compact and fast garbage collector is used which  needs  to
         distinguish   between  small  integers  and memory addresses.
         This effectively restricts the maximum size  of  any  SPITBOL
         object  (string,  array, table, code or expression block)  to
         be less than a value subsequently  referred  to  as  MXLEN  .
         This   is   in  practice  little  restriction  on  most  host
         computers.  Where, because of implementation needs, it  might
         prove  restrictive,  a  run time option is generally provided
         for setting this value to suit  a  user's  requirements  (see
         Section  12.  where  an  indication  of  the  default initial
         setting of MXLEN is also given).  Since the  value  of  MXLEN
         is  used  to initialise &MAXLNGTH , printing &MAXLNGTH during
         execution gives its exact value.   A  user  may  subsequently
         assign  a  smaller value to this keyword but values exceeding
         that of MXLEN may not be assigned to it.

    14.  A value of zero for &TRIM does  not  necessarily  imply  that
         trailing  blanks  will  be added to records in which they are
         not originally present - see Section 12.



 2.3  Additional Features
 2.3  Additional Features
 _______________ ________

    The following SPITBOL features are not found in SNOBOL4.


     1.  The  functions APPEND, BREAKX, CHAR, BUFFER,    EJECT,  EXIT,
         HOST,    INSERT,    LEQ,  LGE,        LLE,  LLT,  LNE,  LPAD,
         REVERSE, RPAD,      RSORT,  SETEXIT,  SORT,  SUBSTR   .   The
         sorting  functions,  the  extended  break pattern BREAKX, and
         the output formatting functions LPAD and RPAD are  especially
         useful.  See Section 5 for details of all these functions.

     2.  The keywords &ERRTEXT and &PROFILE.

     3.  The  symbolic  dump  optionally  includes elements of arrays,
         tables  and programmer defined datatypes. (See DUMP ).

     4.  An access trace mode is provided in  addition  to  the  other
         standard modes.  (See TRACE ).

     5.  A selection or alternative feature is provided.






         MACRO SPITBOL V3.5
                                                   PAGE 6 - [2.3]
         Summary of Differences

     6.  The second argument of CONVERT may be 'NUMERIC'.

     7.  The  assignment symbol , = , is treated as an ordinary binary
         operator  and the binary operator , ? , is  given  a  defined
         meaning as a pattern matching operator.

     8.  If  running  SPITBOL from an on-line terminal, options may be
         selected  to reduce the amount of  listing  information  sent
         to  the  terminal  or  to restrict this to compilation errors
         only. (See Section 12 for details).

     9.  Reflecting the fact that many current computer systems   have
         good  online  terminal  capabilities,  the  name  TERMINAL is
         available with pre-association for  input  and  output  to  a
         terminal on such systems - see Section 12.
         T     TERMINAL = EVAL(TERMINAL)     :S(T)
         acts  as a desk calculator.  TERMINAL may be detached but may
         not   then   be   re-associated.    If   this   feature    is
         unimplemented, TERMINAL acts as an ordinary variable.

    10.  Several  additional  control  cards  may  be  used  to select
         various compile time and run time options.

    11.  An   extended   character   set   is   available   in    some
         implementations.   Where  lower  case  letters  are  provided
         names such as "INPUT" and "input"  are  distinct.   In  gotos
         :f  and :s mean the same as :F and :S.  The Tab character, if
         available,  is  syntactically  identical  with  blank.    See
         Section 12.

    12.  The  assignment  &STLIMIT = -1 inhibits all checks on numbers
         of statements executed.

    13.  Built-in functions are available for sorting the elements  of
         tables and arrays.

    14.  A  additional datatype called a BUFFER is available.  Buffers
         are  character  arrays  with  a  fixed  allocation   and   an
         adjustable   size   which  may  vary  between  zero  and  the
         allocated size at any time.   Three  new  functions,  INSERT,
         APPEND  and BUFFER have been added to support the buffer type
         specifically,  and the CONVERT,  PROTOTYPE,  SIZE,  DATATYPE,
         SUBSTR,  COPY and pattern matching and replacement operations
         have been enhanced to provide support for buffers.














         MACRO SPITBOL V3.5
                                                   PAGE 7 - [2.4]
         Summary of Differences



 2.4  Syntax Differences
 2.4  Syntax Differences
 ___________ ___________

    This section describes differences in syntax between  SPITBOL  and
    SNOBOL4.  such  differences  should  not generally affect existing
    SNOBOL4 programs.


     1.  Reference  to  elements  of  arrays  which   are   themselves
         elements  of   arrays  is  possible  without  using  the ITEM
         function.  Thus the following are equivalent -
           A<J><K> = B<J><K>;       ITEM(A<J>,K) = ITEM(B<J>,K)

     2.  The compiler permits real  constants  to  be  followed  by  a
         FORTRAN style exponent E+xxx.

     3.  A  selection  or  alternative  construction  may  be  written
         anywhere that a value is permitted.  It consists of a  series
         of   expressions   separated   by   commas  and  enclosed  in
         parentheses:
           (e1,e2,e3,....,en)
         The semantics is to evaluate the  expressions  from  left  to
         right  until one succeeds and then use its value.  Failure is
         signalled if all evaluations fail.   This  feature  trivially
         provides  an  "or"  function for predicates and also has many
         other uses as shown by the following examples:
           A     = (EQ(B,3),GT(B,20)) B + 1
           NEXT  = (INPUT,'%EOF')
           MAXAB = (GT(A,B) A,B)
         The   alternative   structure   provides   an    IF-THEN-ELSE
         capability,  and  as  such  is  a useful programming feature.
         Note incidentally that the semantics of ordinary  parentheses
         is  a  correct  degenerate  case  of an alternative structure
         with one alternative.

     4.  The array brackets [] may be used instead of <>  if  desired.
         Thus X[I,J] and X<I,J> are equivalent.

     5.  By  treating  =  as  a  right  associative operator of lowest
         priority, multiple assignments within a single statement  may
         be  coded.   The  value  returned by an assignment is that of
         its right hand side.  After obeying
           A[I = INPUT] = INPUT
         I is the index of the element of the array  into  which  data
         has been read.

     6.  ?  is  defined  to  be an explicit pattern matching operator.
         It is left associative and has priority lower  than  that  of
         all  operators  except  =  .   It  returns  as  its value the
         substring matched from its left argument (a  string)  by  its
         right argument (a pattern).  Thus
           'ABCD' ? LEN(3) $ OUTPUT ? LEN(1) REM $ OUTPUT
         causes printing of
           ABC
           BC


         MACRO SPITBOL V3.5
                                                   PAGE 8 - [2.4]
         Summary of Differences



























































         MACRO SPITBOL V3.5
                                                   PAGE 9 - [3]
         Datatypes and Conversion



                    *-------------------------------*
                      [3]  Datatypes and Conversion
                    | [3]  Datatypes and Conversion |
                    *-------------------------------*

    This  section  details  the datatypes available in SPITBOL and the
    conversions which may be performed amongst them.


 3.1  Available Datatypes
 3.1  Available Datatypes
 ______________ _________


     1.  STRING
         Strings range  in  length  from  0  (null  string)  to  MXLEN
         characters   (subject  to  the  setting  of  &MAXLNGTH).  Any
         characters from the hardware set of the computer used to  run
         SPITBOL can appear in a string.

     2.  INTEGER
         Integers  are  generally  stored  in  the hardware complement
         form for the computer used to run SPITBOL and usually  occupy
         a single word.  See Section 12 for range.

     3.  REAL
         Available  if  floating  point  hardware  is  available  (sec
         10.2.4).  Stored according to the usual hardware  conventions
         of the computer on which SPITBOL is run.

     4.  ARRAY
         Arrays  may  not  exceed  MXLEN words in total size. 10 to 15
         words must be allowed for housekeeping information.

     5.  TABLE
         A table may have up to MXLEN elements.   Any  SPITBOL  object
         may  be  used  as  the name of a table element, including the
         null string.  See Section 5 for details.

     6.  PATTERN
         Pattern  structures  may  be  arbitrarily  large  within  the
         limits imposed by total available memory.

     7.  NAME
         A  name  can  be  obtained  from  any variable.  Note that in
         SPITBOL , the name operator (unary dot) applied to a  natural
         variable  yields  a  name,  not  a string as is the case with
         SNOBOL4.  Use  of  names  as  arguments  to  the  indirection
         operator  (unary  $)  is  much  faster than the use of string
         arguments.   Names  can  also  be  used   advantageously   in
         statements such as  INPUT(.IN)








         MACRO SPITBOL V3.5
                                                   PAGE 10 - [3.1]
         Datatypes and Conversion


     8.  EXPRESSION
         Any   expression  may  be  deferred  by  using  the  unary  *
         operator.

     9.  CODE
         A string representing a valid  program  can  be  compiled  at
         execution  time.   The  resulting CODE object may be executed
         in the same manner as the original program.

    10.  BUFFER
         The buffer type does not  exist  in  SNOBOL4;   it  has  been
         introduced  into  MACRO  SPITBOL  primarily to provide a more
         efficient mechanism for working with large strings.

         Buffers are packed character  arrays  created  with  a  fixed
         allocation  defining  the  maximum  number of characters they
         can ever contain.  Buffers are helpful in manipulating  large
         strings  efficiently.  The reason is that in-situ replacement
         of buffer  contents  is  possible  using  APPEND,  INSERT  or
         pattern  replacement, while any modification to a string must
         be achieved internally by first making a copy of the string.

         A buffer is like an array  in  that  it  cannot  be  extended
         beyond  its  allocation size.  The origin of the first buffer
         character is always one.   Buffer  creation  is  accomplished
         directly   with  the  BUFFER  function,  or  indirectly  with
         CONVERT.  In addition, every buffer  has  a  dynamic  defined
         size that can vary between zero and the maximum allocation.

         Once  a  buffer  has been created,  characters can be written
         into  specific  segments  using   the   INSERT   and   APPEND
         functions, or using pattern replacement.

         As  with  other aggregate types, two buffers are IDENTical if
         and only if they are the same object.

         Most standard functions will convert buffers to strings  when
         required.   Exceptions  to this are SUBSTR, which can be used
         to directly produce a string  from  a  section  of  a  buffer
         without  the  need  for  an intermediate conversion and SIZE,
         which  will  give  the  current  defined  size  of  a  buffer
         directly.   The  pattern  matching  and  pattern  replacement
         operations of the language will also accept a buffer name  as
         a  subject.   Pattern  matching  is  done  directly  from the
         buffer, and pattern replacement is  done  directly  into  the
         buffer as an INSERT function on the substring matched.

         In  addition,  PROTOTYPE  gives  the  prototype  string for a
         buffer, which is the integer allocation size  of  the  buffer
         object.   COPY  can be used to create a duplicate of a buffer
         to work with.  DATATYPE will, of course,  return  the  string
         "BUFFER" for any buffer object.





         MACRO SPITBOL V3.5
                                                   PAGE 11 - [3.2]
         Datatypes and Conversion



 3.2  Possible Datatype Conversions
 3.2  Possible Datatype Conversions
 _____________ ________ ___________

    As  far  as possible SPITBOL converts from one datatype to another
    as required.  The following  table  shows  which  conversions  are
    possible.    Blank  entries  indicate  that  the  conversions  are
    impossible, A indicates that conversion is always possible, and  U
    indicates  conversion  is usually possible, depending on the value
    involved.

                          CONVERT TO:

                       S I R A T P N E C B
                     +--------------------
                    S! A U U     A A U U U
                    I! A A A     A A A   A
                    R! A U A     A A A   A
            CONVERT A!       A U
             FROM:  T!       A A
                    P!           A
                    N! U U U     U A U U U
                    E!               A
                    C!                 A
                    B!                   A

            S       STRING
            I       INTEGER
            R       REAL
            A       ARRAY
            T       TABLE
            P       PATTERN
            N       NAME
            E       EXPRESSION
            C       CODE
            B       BUFFER






















         MACRO SPITBOL V3.5
                                                   PAGE 12 - [3.3]
         Datatypes and Conversion



 3.3  Conversion Details
 3.3  Conversion Details
 _______________ _______

    This section gives detailed descriptions for each of the  possible
    conversions.


     1.  STRING --> INTEGER

         Leading  and  trailing blanks are ignored.  A leading sign is
         optional.  The sign, if  present,  must  immediately  precede
         the  digits.   A  null  or  all  blank string is converted to
         zero.

     2.  STRING --> REAL

         Leading and trailing blanks are ignored.  A leading  sign  if
         present,  must  immediately  precede  the number.  The number
         itself may be written in standard FORTRAN  type  format  with
         an  optional  exponent.   The  conversion is always accurate,
         the last bit  being  correctly  rounded.   A  null  or  blank
         string is converted to 0.0 .

     3.  STRING --> PATTERN

         A pattern is created which will match the string value.

     4.  STRING --> NAME

         The  result is the name of the natural variable which has the
         given string as its name.  This is identical  to  the  result
         of  applying  the  unary  dot  operator  to  the  variable in
         question.  The null string cannot be converted to a name.

     5.  STRING --> EXPRESSION

         The string must represent a legal  SPITBOL  expression.   The
         compiler  is  used  to convert the string into its equivalent
         expression and the result can be used anywhere an  expression
         is permitted.

     6.  STRING --> CODE

         The  string  must represent a legal SPITBOL program, complete
         with labels, and using  semicolons  to  separate  statements.
         The  compiler  is  used to convert the string into executable
         code.  The resulting code can be executed by transferring  to
         it  with  a  direct  GOTO  or by a normal transfer to a label
         within the code.

     7.  STRING --> BUFFER






         MACRO SPITBOL V3.5
                                                   PAGE 13 - [3.3]
         Datatypes and Conversion

         A buffer is created with an  allocation  size  equal  to  the
         size  of  the string, and the string value is copied into the
         buffer.  The null string cannot be converted to a buffer.























































         MACRO SPITBOL V3.5
                                                   PAGE 14 - [3.3]
         Datatypes and Conversion


     8.  INTEGER --> STRING

         The result has no leading  or  trailing  blanks  and  leading
         zeros  are  suppressed.  A minus sign is prefixed to negative
         values.  Zero is converted to "0".

     9.  INTEGER --> REAL

         A real number is obtained by adding a zero  fractional  part.
         Note  that  it  is  possible  to  lose  significance  in this
         conversion if the mantissa of  the  real  representation  has
         fewer digits than are available for an integer.

    10.  INTEGER --> PATTERN

         First  convert   to  a  STRING  and  then  treat as STRING to
         PATTERN.

    11.  INTEGER --> NAME

         First convert to STRING and then treat as STRING to NAME.

    12.  INTEGER --> EXPRESSION

         The result is an EXPRESSION which when evaluated  yields  the
         INTEGER as its value.

    13.  INTEGER --> BUFFER

         The  integer  is  first  converted  to a STRING which is then
         converted to a buffer.

    14.  REAL --> STRING

         The real  number  is  converted  to  its  standard  character
         representation.   Fixed  type  format  is  used  if possible,
         otherwise  an  exponent  (using  E)   is   supplied.    Seven
         significant  digits  are  generated, the last being correctly
         rounded for all  cases.   Trailing  insignificant  zeros  are
         suppressed after rounding has taken place.

    15.  REAL --> INTEGER

         This  conversion is only possible if the REAL is in the range
         permitted  for  integers.   in  this  case,  the  result   is
         obtained by truncating the fractional part.

    16.  REAL --> PATTERN

         First convert to STRING and then treat as STRING to PATTERN.

    17.  REAL --> NAME





         MACRO SPITBOL V3.5
                                                   PAGE 15 - [3.3]
         Datatypes and Conversion

         First convert to STRING and then treat as STRING to NAME.

    18.  REAL --> EXPRESSION

         The  result  is an expression which when evaluated yields the
         REAL as its value.

    19.  REAL --> BUFFER

         First convert to STRING, then treat as STRING to BUFFER.

    20.  ARRAY --> TABLE

         The array must be two dimensional with a second dimension  of
         2   or  an  error  occurs.   For  each  value  of  the  first
         subscript, J , a table entry using the (J,1)  entry  as  name
         and  the  (J,2)  entry  as value is created.  The table built
         has a number of hash headers (see TABLE in Section  5)  equal
         to the first dimension.

    21.  TABLE --> ARRAY

         The  table  must  have at least one element which is non-null
         otherwise statement failure occurs.  The array  generated  is
         two  dimensional with the first dimension equal to the number
         of non-null entries in the table and the second dimension  is
         two.   For  each entry, the (J,1) element in the array is the
         the name and the (J,2) element is the value.

    22.  NAME --> STRING

         A NAME can be converted to a STRING only if it  is  the  name
         of   a   natural  variable.   The  resulting  string  is  the
         character name of the variable.

    23.  NAME --> INTEGER, REAL, PATTERN, EXPRESSION, CODE, BUFFER

         The NAME is first converted to a  STRING  (if  possible)  and
         then the conversion proceeds as described for STRING.



















         MACRO SPITBOL V3.5
                                                   PAGE 16 - [4]
         Operators



                            *----------------*
                              [4]  Operators
                            | [4]  Operators |
                            *----------------*

    SPITBOL  operators  are  listed  without any detailed descriptions
    since  they  correspond,  with  a  few  exceptions  noted  in  the
    description of differences, to those of SNOBOL4.


 4.1  Unary Operators
 4.1  Unary Operators
 __________ _________

    Unary  operators  all  have  equal  priority which is greater than
    that of any binary operator.

    OPERATOR                DESCRIPTION

    ?                Interrogation - null if operand succeeds
    &                Keyword
    +                Indicates postive numeric operand
    -                Negates numeric operand
    *                Defers evaluation of expression
    $                Indirection
    .                Returns a name
    ~                Negates failure or success of its operand
    @                Assigns cursor position to its operand

         Unused unary operator symbols are   ! % / # =





























         MACRO SPITBOL V3.5
                                                   PAGE 17 - [4.2]
         Operators



 4.2  Binary Operators
 4.2  Binary Operators
 ___________ _________

    Several of the associativites and priorities differ from those  of
    SNOBOL4.

    OP.     ASSOCY. PRIO.           DEFINITION

    =       right   0       Assignment
    ?       left    1       Pattern match
    |       right   3       Pattern alternation
    blank   right   4       Concatenation or pattern match
    +       left    6       Arithmetic addition
    -       left    6       Arithmetic subtraction
    /       left    8       Arithmetic division
    *       left    9       Arithmetic multiplication
    $       left    12      Immediate pattern assignment
    .       left    12      Conditional pattern assignment

    &       left    2       Undefined
    @       right   5       Undefined
    ~       left    7       Undefined
    %       left    10      Undefined
    _       right   13      Undefined

































         MACRO SPITBOL V3.5
                                                   PAGE 18 - [5]
         Functions



                            *----------------*
                              [5]  Functions
                            | [5]  Functions |
                            *----------------*

    This  section  defines  the  built-in  functions  of  SPITBOL, the
    descriptions being given in alphabetical order.   In  most  cases,
    the  arguments  are  pre-converted  to  some  particular datatype.
    This is indicated in the function header by the notation:
      FUNCTION(STRING,INTEGER,....)
    If  the  corresponding  argument  cannot  be  converted   to   the
    indicated  datatype,  an  error  occurs.   Sometimes  the range of
    arguments  permitted  is  restricted,  in  which  case   arguments
    outside  the  range  cause an error.  The usage "ARGUMENT" implies
    that the argument can be of any datatype. "NUMERIC"  implies  that
    either REAL or INTEGER arguments are acceptable.

    In  functions  such as ARRAY, DATA, DEFINE with a string prototype
    argument, the string should not contain non-significant blanks.


 5.1  ANY -- Pattern to Match Selected Character
 5.1  ANY -- Pattern to Match Selected Character
 ________ __ _______ __ _____ ________ _________

    ANY(STRING) or ANY(EXPRESSION)

    This function  returns   a  pattern  which  will  match  a  single
    character  selected from the characters in the argument string.  A
    null argument is not permitted.   If  an  expression  argument  is
    used,  then  the  expression  is evaluated during pattern matching
    and must yield a non-null string result.


 5.2  APPEND * -- Append string to buffer
 5.2  APPEND * -- Append string to buffer
 ___________ _ __ ______ ______ __ ______

    APPEND(BUFFER,STRING)

    APPEND is used to append a string to the contents of  an  existing
    buffer.     APPEND    is    defined    to    be    identical    to
    INSERT(BUFFER,SIZE(BUFFER)+1,0,STRING).  The first  argument  must
    be a buffer type or an error occurs.


 5.3  APPLY * -- Apply function
 5.3  APPLY * -- Apply function
 __________ _ __ _____ ________

    APPLY(NAME,ARG,ARG,...)

    The  first argument is the name of a function to be applied to the
    (possibly null) list  of  arguments  following.   Unlike  SNOBOL4,
    SPITBOL  does  not  require  the  number of arguments to match the
    function definition, extra arguments  being  ignored  and  missing
    arguments being supplied as null strings.






         MACRO SPITBOL V3.5
                                                   PAGE 19 - [5.4]
         Functions



 5.4  ARBNO -- Pattern for Iterated Match
 5.4  ARBNO -- Pattern for Iterated Match
 __________ __ _______ ___ ________ _____

    ARBNO(PATTERN)

    This  function  returns  a  pattern  which will match an arbitrary
    number of occurrences of  the  pattern  argument,  including  zero
    occurrences (this resulting in matching of the null string).


 5.5  ARG * -- Obtain Argument Name
 5.5  ARG * -- Obtain Argument Name
 ________ _ __ ______ ________ ____

    ARG(NAME,INTEGER)

    The  first  argument  represents  the  name  of  a  function.  The
    integer is the index of a formal argument to this  function.   The
    NAME  of the selected argument is returned (this is converted to a
    string on output).  ARG fails if the integer is out  of  range  of
    the number of formal arguments.


 5.6  ARRAY -- Generate Array Structure
 5.6  ARRAY -- Generate Array Structure
 __________ __ ________ _____ _________

    ARRAY(STRING,ARG) or ARRAY(INTEGER,ARG)

    The  string  represents  the protoype of an array to be allocated.
    This is in the form
       "LBD1:HBD1,LBD2:HBD2,...."
    where  LBD1,HBD1  etc.   are  integers  specifying  low  and  high
    bounds.   The  low  bound  (LBD) may be omitted for some or all of
    the dimensions, in which case the colon may also be omitted and  a
    low  bound of 1 is assumed.  The second argument (of any datatype)
    is the initial value of all the elements in the array.  If  it  is
    omitted,  the  initial  value of all the elements will be the null
    string.  The second form of the call may be  used  to  create  one
    dimensional  arrays  (vectors)  with  a  low  bound  of 1. SPITBOL
    optimises accesses to elements of vectors.


 5.7  BREAK -- Construct Scanning Pattern
 5.7  BREAK -- Construct Scanning Pattern
 __________ __ _________ ________ _______

    BREAK(STRING) or BREAK(EXPRESSION)

    This function returns a pattern which will match any string up  to
    the  point  preceding  any  character which occurs in the argument
    string.  A null argument  is  not  permitted.   If  an  expression
    argument  is given, the resulting pattern causes the expression to
    be  evaluated  during  pattern  matching.   In  this   case,   the
    evaluated result must be a non-null string.








         MACRO SPITBOL V3.5
                                                   PAGE 20 - [5.8]
         Functions



 5.8  BUFFER * -- Create buffer object
 5.8  BUFFER * -- Create buffer object
 ___________ _ __ ______ ______ ______

    BUFFER(INTEGER,STRING)

    This  function  creates  a buffer-type object (see the description
    in the datatype section).   The  first  argument  is  the  integer
    allocation  for  the  buffer  and  the second argument defines the
    initial contents of the buffer.  The defined size  of  the  buffer
    is  initialized  to  SIZE(STRING).  The allocation must be between
    between 1 and &MAXLNGTH, and the size of the string must  be  less
    than or equal to the allocated size, or an error will occur.


 5.9  BREAKX * -- Construct Scanning Pattern
 5.9  BREAKX * -- Construct Scanning Pattern
 ___________ _ __ _________ ________ _______

    BREAKX(STRING) or BREAKX(EXPRESSION)

    BREAKX  returns  a  pattern  whose  initial match is the same as a
    corresponding  BREAK  pattern.   However,  BREAKX   has   implicit
    alternatives  which  on  subsequent  match failure permit scanning
    past the first break character found and  up  to  the  next  break
    character.   Note  that BREAKX may be used to  replace ARB in many
    situations where BREAK cannot be used  easily.   For  example  the
    following replacement can be made -
       ARB ('CAT' ! 'DOG')  -->  BREAKX('CD') ('CAT' ! 'DOG')
    In   the  case  of  an  expression  argument,  the  expression  is
    evaluated during  pattern  matching  and  must  yield  a  non-null
    string.   Note  that  evaluation of the expression is not repeated
    on rematch attempts by extension.



























         MACRO SPITBOL V3.5
                                                   PAGE 21 - [5.10]
         Functions



 5.10  CHAR * -- Convert Character Code to String
 5.10  CHAR * -- Convert Character Code to String
 __________ _ __ _______ _________ ____ __ ______

    CHAR(INTEGER)

    The CHAR function returns a one-character  string  containing  the
    character  with  the  internal character code corresponding to the
    given   argument.    The   string    returned    is    necessarily
    machine-dependent.  In  general however, A = CHAR(N) is equivalent
    to:
       &ALPHABET (LEN(N) LEN(1) . A)

    If the given argument is not a non-negative integer in  the  range
    of the host machine character set, an error is issued.


 5.11  CLEAR * -- Clear Variable Storage
 5.11  CLEAR * -- Clear Variable Storage
 ___________ _ __ _____ ________ _______

    CLEAR(STRING)

    This  function  causes  the values of variables to be set to null.
    In the simple case, where the argument is  omitted  or  null,  the
    action  is  the  same as in SNOBOL4 (i.e. all variables cleared to
    null).  An extension is available in SPITBOL.  The first  argument
    may  be  a  string  which is a list of variable names separated by
    commas.  These represent the names of variables whose  values  are
    to be left unchanged.  For example -
       CLEAR('ABC,CDE,EFG')
    would  cause the value of all variables except ABC, CDE, EFG to be
    set to the null string.


 5.12  CODE * -- Compile Code
 5.12  CODE * -- Compile Code
 __________ _ __ _______ ____

    CODE(STRING)

    The effect of this function is to convert  the  argument  to  type
    CODE  as  described in the section on type conversion.  The STRING
    must represent a valid SPITBOL program complete  with  labels  and
    using  semicolons  (;)  to  separate statements.  The call to CODE
    fails if syntactic errors are found.  In this case it is  possible
    to inspect &ERRTEXT to find the error message.  e.g.
           C = CODE(CD)     :F<CODE(' OUTPUT = &ERRTEXT')>
    SETEXIT  may  also  be  used  to  intercept these errors.  Another
    extension over  SNOBOL4  is  that  the  code  string  may  contain
    embedded  control  cards  (notably  -LIST  to cause listing of the
    code) and comments delimited by semicolons.










         MACRO SPITBOL V3.5
                                                   PAGE 22 - [5.13]
         Functions



 5.13  COLLECT -- Initiate Storage Regeneration
 5.13  COLLECT -- Initiate Storage Regeneration
 _____________ __ ________ _______ ____________

    COLLECT(INTEGER)

    The COLLECT function forces a garbage collection  which  retrieves
    unused  storage  and returns it to the block of available storage.
    The integer argument represents a minimum number of  words  to  be
    made  available.   If  this  amount of storage cannot be obtained,
    the COLLECT function fails.  On successful return, the  result  is
    the   number   of   words   actually   obtained.    Although   the
    implementation of COLLECT is the same as in  SNOBOL4,  the  values
    obtained  will  be  quite different due to different internal data
    representations.  Furthermore,  the  organization  of  SPITBOL  is
    such  that  forcing  garbage  collections to occur before they are
    required increases execution time.


 5.14  CONVERT * -- Convert Datatypes
 5.14  CONVERT * -- Convert Datatypes
 _____________ _ __ _______ _________

    CONVERT(ARGUMENT,STRING)

    The returned result is obtained by converting the  first  argument
    to  the type indicated by the string name of the datatype given as
    the second argument.  The permitted conversions are  described  in
    the  section  on  type  conversion.  Any conversions which are not
    permitted cause failure of the CONVERT call.  The second  argument
    may  be  'NUMERIC'  ,  in  which case the argument is converted to
    INTEGER or REAL according to its form.


 5.15  COPY * -- Copy Structure
 5.15  COPY * -- Copy Structure
 __________ _ __ ____ _________

    COPY(ARGUMENT)

    The COPY function returns a distinct copy of the object  presented
    as  its argument.  This is only useful for arrays, tables, buffers
    and program defined datatypes.  Note that SPITBOL permits  copying
    of TABLES unlike SNOBOL4.


















         MACRO SPITBOL V3.5
                                                   PAGE 23 - [5.16]
         Functions



 5.16  DATA -- Create Datatype
 5.16  DATA -- Create Datatype
 __________ __ ______ ________

    DATA(STRING)

    The  argument  to  DATA  is  a  prototype  for  a  program defined
    datatype in the form  of  a  function  call  with  arguments  e.g.
    DATA('CMPLX(RE,IM)').   The  function  name  in  the string is the
    name of the new datatype.  The argument names in  the  string  are
    the  names  of  field selector functions used to access the fields
    of  the  new  datatype.   Increased  efficiency  is  obtained   by
    avoiding   the   use   of  duplicate  field  names  for  different
    datatypes, although such multiple use is not forbidden.


 5.17  DATATYPE * -- Obtain Datatype
 5.17  DATATYPE * -- Obtain Datatype
 ______________ _ __ ______ ________

    DATATYPE(ARGUMENT)

    DATATYPE returns the formal identification of the datatype of  its
    argument.


 5.18  DATE * -- Obtain Date
 5.18  DATE * -- Obtain Date
 __________ _ __ ______ ____

    DATE()

    DATE  returns  a  string giving the current date and possibly also
    clock-on-the-wall-time (see Section 12.)


 5.19  DEFINE -- Define a Function
 5.19  DEFINE -- Define a Function
 ____________ __ ______ _ ________

    DEFINE(STRING) or DEFINE(STRING,NAME)

    The DEFINE function is used to create  program  defined  functions
    according  to  the prototype supplied as the argument.  The second
    argument if  supplied,  names  the  label  at  the  entry  to  the
    function.


 5.20  DETACH -- Detach I/O Association
 5.20  DETACH -- Detach I/O Association
 ____________ __ ______ ___ ___________

    DETACH(NAME)

    NAME  is the name of a variable which has previously been input or
    output associated   by appearing as the first  argument  of  INPUT
    or  OUTPUT.   DETACH  cancels  the association of the variable but
    does not affect the file to which it was associated.








         MACRO SPITBOL V3.5
                                                   PAGE 24 - [5.21]
         Functions



 5.21  DIFFER * -- Test for Arguments Differing
 5.21  DIFFER * -- Test for Arguments Differing
 ____________ _ __ ____ ___ _________ _________

    DIFFER(ARGUMENT,ARGUMENT)

    DIFFER is a predicate function which fails if  its  two  arguments
    are identical objects.  In SPITBOL
       DIFFER(.ABC,'ABC')
    succeeds  since  .ABC  is  a  NAME.  DIFFER and IDENT are the only
    functions in  which  the  different  implementation  of  the  name
    operator (unary dot) may give rise to problems.

    DIFFER also works on object of type BUFFER (see IDENT).


 5.22  DUMP * -- Dump Storage
 5.22  DUMP * -- Dump Storage
 __________ _ __ ____ _______

    DUMP(INTEGER)

    The  DUMP  function  causes  a  dump  of  current values to occur.
    After the dump is complete, execution  continues  unaffected  (the
    DUMP  function  returns  the  null  string). If the argument is 1,
    then the dump includes values of  all  non-constant  keywords  and
    all  non-null  natural  variables.  If the argument is 2, then the
    dump also  includes  values  of  all   non-null  array  and  table
    elements  and  non-null field values of program defined datatypes.
    The format of the latter  dump  is  self  explanatory  and  avoids
    printing  any  structure  more  than  once.  A call to DUMP with a
    zero argument is ignored.  This  allows  use  of  a  switch  value
    which  can  be turned on and off globally.  A call to DUMP with an
    argument greater than 2 produces a core dump in  the  same  format
    as  that produced by a system abnormal end and should therefore be
    used with discretion.


 5.23  DUPL * -- Duplicate String or Pattern
 5.23  DUPL * -- Duplicate String or Pattern
 __________ _ __ _________ ______ __ _______

    DUPL(STRING,INTEGER) or DUPL(PATTERN,INTEGER)

    DUPL returns a result obtained by duplicating the  first  argument
    the  number  of  times  indicated by the second.  A null string is
    returned if INTEGER is zero and statement failure occurs if it  is
    negative.


 5.24  EJECT * -- Eject to new page
 5.24  EJECT * -- Eject to new page
 ___________ _ __ _____ __ ___ ____

    EJECT(INTEGER) or EJECT(STRING)

    The  argument must have previously appeared as the second argument
    of a call of  OUTPUT to identify an output channel.  An  eject  to
    the  top  of  the  next page of the output file occurs.  A null or
    absent argument causes an eject on the standard output file.




         MACRO SPITBOL V3.5
                                                   PAGE 25 - [5.25]
         Functions



 5.25  ENDFILE * -- Close a File
 5.25  ENDFILE * -- Close a File
 _____________ _ __ _____ _ ____

    ENDFILE(INTEGER) or ENDFILE(STRING)

    The argument must have previously appeared as the second  argument
    of  a  call  of    INPUT  or  OUTPUT  to  identify an input/output
    channel.  The file attached to the channel is  closed,  associated
    storage  is  released  and  all variables associated with the file
    are detached.  Thus ENDFILE should be used only  when  no  further
    use  is  to  be  made of the file.  If the file is to be reread or
    rewritten,  use  REWIND  (if  the  implementation  supports   this
    function - see Section 12).


 5.26  EQ -- Test for Equal
 5.26  EQ -- Test for Equal
 ________ __ ____ ___ _____

    EQ(NUMERIC,NUMERIC)

    EQ  is  a  predicate  function which succeeds if its two arguments
    are equal.


 5.27  EVAL * -- Evaluate Expression
 5.27  EVAL * -- Evaluate Expression
 __________ _ __ ________ __________

    EVAL(EXPRESSION)

    EVAL returns the result of  evaluating  its  expression  argument.
    Note  that  a  string  can  be  converted  into  an  expression by
    compiling it into CODE.  Thus EVAL in SPITBOL is  compatible  with
    SNOBOL4  and  handles strings in the same way.  If an error occurs
    in evaluating the argument,  &ERRTEXT is set and EVAL  fails.   To
    avoid  such  errors  passing   unnoticed,  it  may  be well to use
    SETEXIT to intercept them,  or use a FAIL  goto,  or  evaluate  in
    -NOFAIL  mode.


 5.28  EXIT * -- Exit to Save Load Module or to JCL
 5.28  EXIT * -- Exit to Save Load Module or to JCL
 __________ _ __ ____ __ ____ ____ ______ __ __ ___

    EXIT(INTEGER) or EXIT(STRING)

    This  function  resembles that introduced by Gimpel in SITBOL.  It
    permits the saving of a core image at any point in  the  execution
    of  a  SPITBOL  program  to  produce  a   load module  and in some
    implementations it may be permissible to exit  from  SPITBOL  into
    another  program.   For  an  often  executed program use of a load
    module saves translation  and  initialisation  time.    A  garbage
    collection  is  performed  in  order to compact store before it is
    saved.  If initialising code is  label  free,  it  is  collectable
    after  it  has  been  executed,  giving  a further opportunity for
    economy.  The argument, N, may have the following values -






         MACRO SPITBOL V3.5
                                                   PAGE 26 - [5.28]
         Functions



     1.  N > 0   Save the whole core  image  (includes  all  the  pure
         SPITBOL  code  and  unused  stack space, so is wasteful). The
         resulting load  module  is  free-standing  and  is  not  made
         obsolete by changes to SPITBOL.

     2.  N  =  0   Interrupt program execution and return to JCL level
         so  that  user  can  issue  JCL  commands  and  then   resume
         execution if wished.  Does not save a core image.

     3.  N  <  0  Save the impure areas of memory only so that program
         can be restarted by loading pure SPITBOL  code  +  the  saved
         areas.   The  resulting load modules are considerably smaller
         than for the case N = 1, but are made obsolete  and  must  be
         regenerated as new versions of SPITBOL are released.

     4.  N  =  "string".   If  this feature is available, (see Section
         12), then SPITBOL execution is  terminated  and  the  program
         named by "string" is entered.


    EXIT  returns  the null string and may occur in the program at any
    position syntactically valid for a function  call.   No  mechanism
    is  provided  for automatic re-attaching of files which are in use
    at the time an EXIT call terminates a run.  Hence EXIT  calls  are
    most  commonly  placed  after  initialising  code  and  before the
    opening of input/output files for the program proper.  In  general
    no  standard input file is available when a load module is run, so
    references  to  variable  INPUT  will  fail  unless  it  has  been
    detached  or  a  file is explicitly associated to it.  The absence
    of a standard output file may create problems  (in  reporting  run
    time  errors  in  particular).  SPITBOL  implementors will usually
    provide  a  means  of  attaching  such  a  file  at   load   time.
    Alternatively a user may prefer to include a statement

         OUTPUT(.OUTPUT,,'FILENAME')

    Failing  these  possibilities,  either  a default output file name
    should be allocated or execution should end with a  special  error
    code  if  printing  to  a non-existent standard file is attempted.
    Section  12  gives  details  for  this  implementation.    Certain
    listing options may be selected by choice of the argument value.
      N  =  +1  or  -1. The output file will be given a heading and in
    some implementations it  may  be  possible  to  re-specify  record
    length  (only  to  a  smaller  value  than during compilation) and
    other options.
      N = +2 or -2. Heading omitted but  re-specification  of  options
    may be possible.
      N = +3 or -3. Heading omitted and no option re-specification.








         MACRO SPITBOL V3.5
                                                   PAGE 27 - [5.29]
         Functions



 5.29  FENCE * -- Generate Fenced Pattern
 5.29  FENCE * -- Generate Fenced Pattern
 ___________ _ __ ________ ______ _______

    FENCE(PATTERN)

    FENCE(pattern)  returns  a  pattern value which is the same as the
    given pattern, except that alternatives  within  the  pattern  are
    only  seen  by  the  scanner  when  it  is  moving  in the forward
    direction.    Pattern   backup   will    always    pass    through
                                                                   not
    FENCE(pattern).  Note that backup through FENCE(pattern) does  ___
    cause  the  match to abort, as does the &FENCE pattern, it is that
    alternatives within the Fenced pattern are not examined  when  the
    scanner  is  backing  up.  For  example, this pattern will match a
    string of text up to the next comma, or if there is no  comma,  to
    the  end  of  the  string.   The text is put in STR, and the match
    will only succeed if STR is non-null.
            P = FENCE( BREAK(',') | REM ) $ STR  *DIFFER(STR)
    Without the FENCE, failure of  the  DIFFER(STR)  would  cause  the
    scanner  to try the REM alternative regardless of whether or not a
    comma is found.

    FENCE is not available in all implementations.  See Section 12.


 5.30  FIELD * -- Get Field Name
 5.30  FIELD * -- Get Field Name
 ___________ _ __ ___ _____ ____

    FIELD(NAME,INTEGER)

    FIELD returns the NAME  of  the  selected  field  of  the  program
    defined  datatype whose name is the first argument.  If the second
    argument is out of range (less than 1, or greater than the  number
    of fields), the FIELD function fails.


 5.31  GE -- Test for Greater or Equal
 5.31  GE -- Test for Greater or Equal
 ________ __ ____ ___ _______ __ _____

    GE(NUMERIC,NUMERIC)

    GE  is  a  predicate function which succeeds if the first argument
    is greater than or equal to the second.


 5.32  GT -- Test for Greater
 5.32  GT -- Test for Greater
 ________ __ ____ ___ _______

    GT(NUMERIC,NUMERIC)

    GT is a predicate function which succeeds if  the  first  argument
    is greater than the second.









         MACRO SPITBOL V3.5
                                                   PAGE 28 - [5.33]
         Functions

 5.33  HOST * -- Obtain Information about Host Computer
 5.33  HOST * -- Obtain Information about Host Computer
 __________ _ __ ______ ___________ _____ ____ ________

    HOST(ARGUMENT,ARGUMENT,ARGUMENT)

    SPITBOL  runs on different mainframes with differing file formats,
    file naming conventions etc.  which makes  it  desirable  in  some
    programs  to  know  on  what machine the program is running.  HOST
    called with null arguments returns a string of the form
       "<COMPUTER NAME>:<OPERATING SYSTEM NAME>:<SITE NAME>"
    which  satisfies  most  requirements  of  this   kind.    At   the
    discretion  of  the SPITBOL implementor, non-null arguments may be
    used to specify other features specific to the host.  See  Section
    12 for details.


 5.34  IDENT * -- Test for Identical
 5.34  IDENT * -- Test for Identical
 ___________ _ __ ____ ___ _________

    IDENT(ARGUMENT,ARGUMENT)

    IDENT  is a predicate function which succeeds if its two arguments
    are identical.  In SPITBOL,
       IDENT(.ABC,'ABC')
    fails since .ABC is a NAME in SPITBOL.  Also, two values  of  type
    BUFFER  will  be IDENTical if and only if they are the same buffer
    object.  Apart from this, IDENT is compatible with SNOBOL4.

































         MACRO SPITBOL V3.5
                                                   PAGE 29 - [5.35]
         Functions



 5.35  INPUT * -- Set Input Association
 5.35  INPUT * -- Set Input Association
 ___________ _ __ ___ _____ ___________

    INPUT(NAME,INTEGER,STRING) or INPUT(NAME,STRING,STRING)

    Rather than give a separate description of OUTPUT which  would  be
    almost  exactly  parallel with that for INPUT, a joint description
    is given  here.   Some  machine  dependency  is  likely  in  these
    functions   -   see  Section  12  for  details  relating  to  this
    implementation.

    The first argument is the name  of  a  variable  which  is  to  be
    input/output  associated  and  is required, whereas the others are
    optional.  The second argument  identifies  a  channel  which  may
    subsequently   be  used  to  refer  to  the  association.   It  is
    recommended that,  as  in  SNOBOL4,  the  second  argument  be  an
    integer  but  the  use  of  a more general string is not excluded.
    Different  channel  identifiers   are   required   for   accessing
    different  files.   The  second  argument  may be omitted in which
    case association is to the standard input  or  output  file.   The
    chief  divergence between SNOBOL4 and SPITBOL is in the use of the
    third argument, where SPITBOL permits the very useful  feature  of
    dynamic  file  assignment.  The general form of the third argument
    is a string

        <f>,R<r>,C<c>,I<i>,X<x>...      where

    <f> is an optional file name which is placed first;

    ,   is a delimiter used to mark  off  remaining  items  which  are
        optional and may occur in any order;

    <r> is  the  maximum  record  length  in  characters  for the file
        (default values are documented in Section 12);

    <c> is a carriage control  character  or  string  needed  in  some
        implementations;

    <i> is   additional   channel   identification   needed   in  some
        implementations  in  the  absence  of  <f>  to  associate  the
        variable  with  a file attached by job control commands at the
        start of a SPITBOL run;

    <x> symbolises   additional   fields    needed    in    particular
        implementations.

    If  <f>  is  non-null,  when  the  statement is obeyed file <f> is
    opened and assigned to the channel  corresponding  to  the  second
    argument  and  normally  this  assignment should be performed once
    only.  If several variables are  to  be  associated  to  the  same
    channel,  <f>  should  be  omitted  from  all but the first of the
    INPUT/OUTPUT calls.





         MACRO SPITBOL V3.5
                                                   PAGE 30 - [5.35]
         Functions

    Alternatively <f> can be omitted from all INPUT/OUTPUT  statements
    relating  to  a  channel  provided  the  necessary assignments are
    performed  by  suitable  job  control  commands  before  execution
    starts.  Thus -
       INPUT(.IN,2,'INFILE');    OUTPUT(.OU,7,'OUF')
       INPUT(.IN,2);             OUTPUT(.OU,7)
    will  have the same effect if in the latter case INFILE , OUF have
    been suitably attached by JCL commands.  A call in  which  <f>  is
    omitted  but  some  other  item  is present in the third argument,
    alters the association of the channel  in  respect  of  that  item
    only.   E.g.  INPUT(.X,,',R72')  sets the maximum record length to
    72 characters.

    Error  messages  are  given  for   syntactically   invalid   third
    arguments  but  in  the  case  where  the  file corresponding to a
    syntactically valid file name  cannot  be  found,  then  statement
    failure  occurs  and  may  be  tested  for  in  the usual way by a
    conditional goto.  For the sake of portability and  compatibility,
    programmers  are  strongly  urged  to use integer second arguments
    (as in SNOBOL4) and short alphanumeric file  names  in  the  third
    argument.   Further  details, particular to an implementation, are
    given in Section 12.


 5.36  INSERT * -- Insert string in buffer
 5.36  INSERT * -- Insert string in buffer
 ____________ _ __ ______ ______ __ ______

    INSERT(BUFFER,INTEGER,INTEGER,STRING)

    The function INSERT is defined to return null, but  has  the  side
    effect  of  replacing  characters (pos, pos+1, ..., pos+length) in
    the designated BUFFER with the characters  of  STRING.   "Pos"  is
    given  by  the first INTEGER argument, and "length" by the second.
    Note that if "length"  is  not  equal  to  SIZE(string)  then  the
    trailing  contents  of  the  buffer  following  the  section to be
    replaced will have  to  be  moved  by  INSERT  to  accomodate  the
    STRING.

    If  the  inserted  string  cannot  fit,  or if the insertion would
    leave a 'gap' of undefined characters  in  the  buffer,  then  the
    INSERT call fails.

    If  the first argument is not a buffer type, then an error occurs.
    (No conversion is attempted since it would be pointless).















         MACRO SPITBOL V3.5
                                                   PAGE 31 - [5.37]
         Functions



 5.37  INTEGER * -- Test for Integer
 5.37  INTEGER * -- Test for Integer
 _____________ _ __ ____ ___ _______

    INTEGER(NUMERIC)

    INTEGER is a predicate function which succeeds if its argument  is
    integral.   It  fails  if  the  argument  cannot  be  converted to
    numeric or has a non-integral value.


 5.38  ITEM -- Select Array or Table Element
 5.38  ITEM -- Select Array or Table Element
 __________ __ ______ _____ __ _____ _______

    ITEM(ARRAY,INTEGER,INTEGER,....) or  ITEM(TABLE,ARGUMENT)

    ITEM returns the selected array or table element  by  name.   Note
    that  the use of ITEM is never necessary in SPITBOL because of the
    extended syntax for array references.


 5.39  LE -- Test for Less or Equal
 5.39  LE -- Test for Less or Equal
 ________ __ ____ ___ ____ __ _____

    LE(NUMERIC,NUMERIC)

    LE is a predicate function which succeeds if  its  first  argument
    is less than or equal to the second argument.
































         MACRO SPITBOL V3.5
                                                   PAGE 32 - [5.40]
         Functions



 5.40  LEN -- Generate Specified Length Pattern
 5.40  LEN -- Generate Specified Length Pattern
 _________ __ ________ _________ ______ _______

    LEN(INTEGER) or LEN(EXPRESSION)

    LEN   generates  a  pattern  which  will  match  any  sequence  of
    characters of length  given  by  the  argument  which  must  be  a
    non-negative  integer.   If  the  argument is an expression, it is
    evaluated during pattern matching and must  yield  a  non-negative
    integer.


 5.41  LEQ * -- Test for Lexically Equal
 5.41  LEQ * -- Test for Lexically Equal
 _________ _ __ ____ ___ _________ _____

    LEQ(STRING,STRING)

    LEQ  is  a predicate which succeeds if its arguments are lexically
    equal.   LEQ  differs  from  IDENT  in  that  its  arguments   are
    converted to strings so that both the following succeed
       LEQ(10,'10')             LEQ(.ABC,'ABC')


 5.42  LGE * -- Test for Lexically Greater or Equal
 5.42  LGE * -- Test for Lexically Greater or Equal
 _________ _ __ ____ ___ _________ _______ __ _____

    LGE(STRING,STRING)

    LGE  is  a  predicate  which  succeeds  if  the  first argument is
    lexically greater than or equal to the second argument.


 5.43  LGT * -- Test for Lexically Greater
 5.43  LGT * -- Test for Lexically Greater
 _________ _ __ ____ ___ _________ _______

    LGT(STRING,STRING)

    LGT is a  predicate  which  succeeds  if  the  first  argument  is
    lexically greater than the second argument.


 5.44  LLE * -- Test for Lexically Less or Equal
 5.44  LLE * -- Test for Lexically Less or Equal
 _________ _ __ ____ ___ _________ ____ __ _____

    LLE(STRING,STRING)

    LLE  is  a  predicate  which  succeeds  if  the  first argument is
    lexically less than or equal to the second argument.













         MACRO SPITBOL V3.5
                                                   PAGE 33 - [5.45]
         Functions



 5.45  LLT * -- Test for Lexically Less
 5.45  LLT * -- Test for Lexically Less
 _________ _ __ ____ ___ _________ ____

    LLT(STRING,STRING)

    LLT is a  predicate  which  succeeds  if  the  first  argument  is
    lexically less than the second argument.


 5.46  LNE * -- Test for Lexically Not Equal
 5.46  LNE * -- Test for Lexically Not Equal
 _________ _ __ ____ ___ _________ ___ _____

    LNE(STRING,STRING)

    LNE  is  a predicate which succeeds if its arguments are lexically
    unequal.  LNE differs  from  DIFFER  in  that  its  arguments  are
    converted to strings so that both the following fail
       LNE(10,'10')                 LNE(.ABC,'ABC')


 5.47  LOAD -- Load External Function
 5.47  LOAD -- Load External Function
 __________ __ ____ ________ ________

    LOAD(STRING,STRING)

    LOAD  is  used  to  make  external  functions available to SPITBOL
    programs.  The first STRING is a prototype of the form:

       "function-name(type,type,...)result-type"

    The  indicated  types  can  be  any  of  "INTEGER",   "REAL"   (if
    implemented)  or  "STRING" in which case the value is converted to
    the designated type before being passed  to  (returned  from)  the
    external  function.  Any other name for a type leaves the value in
    an unconverted form.

    The second argument to LOAD is a library name where  the  function
    is to be found.

    LOAD  is  highly  implementation  specific and is not available in
    all implementations.  See Section 12 for details.


 5.48  LOCAL * -- Get Name of Local
 5.48  LOCAL * -- Get Name of Local
 ___________ _ __ ___ ____ __ _____

    LOCAL(NAME,INTEGER)

    The value returned is the NAME  of  the  indicated  local  of  the
    function  whose  name is given by the first argument.  LOCAL fails
    if the second argument is out of range (less than  1,  or  greater
    than the number of locals).








         MACRO SPITBOL V3.5
                                                   PAGE 34 - [5.49]
         Functions



 5.49  LPAD * -- Left Pad
 5.49  LPAD * -- Left Pad
 __________ _ __ ____ ___

    LPAD(STRING,INTEGER,STRING)

    LPAD  returns  the  result  obtained  by  padding  out  the  first
    argument on the  left  to  the  length  specified  by  the  second
    argument,  using  the  pad character supplied by the one character
    string third argument.  If the third argument is null or  omitted,
    a  blank  is  used as the pad character.  If the first argument is
    already long enough or too long, it is  returned  unchanged,  this
    always  being the case if the second argument is negative or zero.
    LPAD is useful for constructing columnar output.


 5.50  LT -- Test for Less
 5.50  LT -- Test for Less
 ________ __ ____ ___ ____

    LT(NUMERIC,NUMERIC)

    LT is a predicate function which succeeds if  its  first  argument
    is less than the second.


 5.51  NE -- Test for Not Equal
 5.51  NE -- Test for Not Equal
 ________ __ ____ ___ ___ _____

    NE(NUMERIC,NUMERIC)

    NE  is  a  predicate  function which succeeds if its two arguments
    are unequal.


 5.52  NOTANY -- Build Character Select Pattern
 5.52  NOTANY -- Build Character Select Pattern
 ____________ __ _____ _________ ______ _______

    NOTANY(STRING) or NOTANY(EXPRESSION)

    NOTANY returns a pattern which will match any single character  in
    the  subject  string,  provided  it  does  not occur in the string
    argument.  A null argument is not permitted.  If the  argument  is
    an  expression,  it  is evaluated during pattern matching and must
    yield a non-null string.

















         MACRO SPITBOL V3.5
                                                   PAGE 35 - [5.53]
         Functions



 5.53  OPSYN * -- Equate Functions and Operators
 5.53  OPSYN * -- Equate Functions and Operators
 ___________ _ __ ______ _________ ___ _________

    OPSYN(NAME,NAME,INTEGER)

    In contrast with SNOBOL4, the second argument must  always  be  an
    already  defined  function name.  If the third argument is omitted
    or zero, the first argument must  be  a  function  name.   If  the
    third  argument  is 1 or 2 , the first argument must be resp.  one
    of the undefined unary or binary  operators  (sec  4.1).   In  all
    three  cases,  subsequent  use  of  the  first argument results in
    calling of the function corresponding to the second argument  with
    the  appropriate  arguments.   Note that names of system functions
    or operators cannot appear as the first argument.


 5.54  OUTPUT * -- Set Output Association
 5.54  OUTPUT * -- Set Output Association
 ____________ _ __ ___ ______ ___________

    OUTPUT(NAME,INTEGER,STRING) or OUTPUT(NAME,STRING,STRING)

    This function has  similar  arguments  and  behaves  similarly  to
    INPUT, which should be consulted for a detailed description (2).


 5.55  POS -- Define Positioning Pattern
 5.55  POS -- Define Positioning Pattern
 _________ __ ______ ___________ _______

    POS(INTEGER) or POS(EXPRESSION)

    POS  returns  a pattern which matches the null string provided the
    value  of  the  cursor  is  equal  to  the  non-negative   integer
    argument.   If  the  argument  is  an  expression, it is evaluated
    during pattern matching and must yield a non-negative integer.

























         MACRO SPITBOL V3.5
                                                   PAGE 36 - [5.56]
         Functions



 5.56  PROTOTYPE -- Retrieve Prototype
 5.56  PROTOTYPE -- Retrieve Prototype
 _______________ __ ________ _________

    PROTOTYPE(ARRAY) or PROTOTYPE(TABLE)

    PROTOTYPE returns the first argument used in the ARRAY,  TABLE  or
    BUFFER function call which created the argument.


 5.57  REMDR -- Remainder
 5.57  REMDR -- Remainder
 ___________ __ _________

    REMDR(INTEGER,INTEGER)

    REMDR  returns the remainder of dividing the first argument by the
    second.  This has the same sign as the first argument.


 5.58  REPLACE -- Translate Characters
 5.58  REPLACE -- Translate Characters
 _____________ __ _________ __________

    REPLACE(STRING,STRING,STRING)

    REPLACE  returns  the  result  of  applying  the   transformations
    represented  by  the  second  and  third  arguments  to  the first
    argument.  REPLACE fails if the second  and  third  arguments  are
    unequal in length or null.


 5.59  REVERSE * -- Reverse String
 5.59  REVERSE * -- Reverse String
 _____________ _ __ _______ ______

    REVERSE(STRING)

    REVERSE returns the result of reversing its argument.  Thus
       REVERSE('ABC')            produces          'CBA'


 5.60  REWIND -- Reposition File
 5.60  REWIND -- Reposition File
 ____________ __ __________ ____

    REWIND(INTEGER) or REWIND(STRING)

    The  argument must have previously appeared as the second argument
    of a call of   INPUT or OUTPUT.  The file attached to the  channel
    is  repositioned  so  that the next read or write operation starts
    at the first record of the file.   Existing  associations  to  the
    file   are   unaffected.   REWIND  may  not  be  provided  in  all
    implementations - see Section 12.












         MACRO SPITBOL V3.5
                                                   PAGE 37 - [5.61]
         Functions



 5.61  RPAD * -- Right Pad
 5.61  RPAD * -- Right Pad
 __________ _ __ _____ ___

    RPAD(STRING,INTEGER,STRING)

    RPAD  returns  the  result  obtained  by  padding  out  the  first
    argument  on  the  right  to  the  length  specified by the second
    argument, using the pad character supplied by  the  one  character
    string  third argument.  If the third argument is null or omitted,
    a blank is used as the pad character.  If the  first  argument  is
    already  long  enough  or too long, it is returned unchanged, this
    always being the case if the second argument is negative or  zero.
    RPAD is useful for constructing columnar output.


 5.62  RPOS -- Define Positioning Pattern
 5.62  RPOS -- Define Positioning Pattern
 __________ __ ______ ___________ _______

    RPOS(INTEGER) or RPOS(EXPRESSION)

    RPOS  returns a pattern which matches the null string provided the
    indicated number  of  characters  remain  to  be  matched  in  the
    subject   string.   If  the  argument  is  an  expression,  it  is
    evaluated during pattern matching and must  yield  a  non-negative
    integer.


 5.63  RSORT -- Reverse Sort
 5.63  RSORT -- Reverse Sort
 ___________ __ _______ ____

    RSORT(ARRAY or TABLE,INTEGER or NAME)

    Performs  a sort in descending (reverse) order of key on the first
    argument.  Consult SORT for details.


 5.64  RTAB -- Create Tabbing Pattern
 5.64  RTAB -- Create Tabbing Pattern
 __________ __ ______ _______ _______

    RTAB(INTEGER) or RTAB(EXPRESSION)

    RTAB returns a pattern which matches from the current location  up
    to  the  point  where the indicated number of characters remain to
    be matched.  The argument must be a non-negative integer.  If  the
    argument   is  an  expression,  it  is  evaluated  during  pattern
    matching and must yield a non-negative integer.














         MACRO SPITBOL V3.5
                                                   PAGE 38 - [5.65]
         Functions



 5.65  SETEXIT * -- Set Error Exit
 5.65  SETEXIT * -- Set Error Exit
 _____________ _ __ ___ _____ ____

    SETEXIT(NAME) or SETEXIT()

    SETEXIT allows interception of  execution  errors,  including  any
    detected  during calls of CODE and EVAL .  The argument is a label
    to  which  control  is  passed  if  a  subsequent  error   occurs,
    providing  that  the  value  of the keyword &ERRLIMIT is non-zero.
    The value of &ERRLIMIT is decremented when the error trap  occurs.
    A  SETEXIT  call with a null argument causes cancellation of error
    intercepts.  A subsequent error will terminate execution as  usual
    with  an  error  message.   The  result returned by SETEXIT is the
    previous intercept setting (i.e.  a  label  name  or  null  if  no
    intercept  was  set).  This  can  be  used to save and restore the
    SETEXIT conditions recursively.  The  error  routine  may  inspect
    the  error code and text   in &ERRTYPE and &ERRTEXT , and take one
    of the actions -


     1.  Terminate execution by transferring  to  the  special  system
         label,   ABORT  .   This causes error processing to resume as
         though no error intercept had been set.

     2.  Branch to the special system label CONTINUE  .   This  causes
         execution  to  resume by branching to the failure exit of the
         statement in error.

     3.  Continue execution elsewhere by branching to another  section
         of  the  program.   If  the error occurred inside a function,
         execution is still 'down a level'.

     4.  Branch  to  label  RETURN  ,  FRETURN  ,   NRETURN   provided
         &FNCLEVEL  is  non-zero.   This  avoids possible difficulties
         with 3.

    The occurrence of  an  error  cancels  the  intercept.   An  error
    routine  must  reissue  a SETEXIT call if error interception is to
    continue.


















         MACRO SPITBOL V3.5
                                                   PAGE 39 - [5.66]
         Functions



 5.66  SIZE -- Get String or Buffer Size
 5.66  SIZE -- Get String or Buffer Size
 __________ __ ___ ______ __ ______ ____

    SIZE(STRING or BUFFER)

    SIZE returns an  integer  count  of  the  defined  length  of  its
    argument.


 5.67  SORT * -- Sort
 5.67  SORT * -- Sort
 __________ _ __ ____

    SORT(ARRAY or TABLE,INTEGER or NAME)

    This  routine  sorts  the  contents  of  the ARRAY or  TABLE first
    argument in ascending order of key.  It differs from   RSORT  only
    in  that  the  latter  sorts  in  descending order of key.  If the
    first  argument  is  an  ARRAY  it  must  be  of   one   dimension
    (subsequently  referred  to  as  a  VECTOR ), or two dimensions (a
    MATRIX ).  Where the argument is a TABLE  ,  it  is  converted  by
    SORT  to an array of 2 dimensions, the first column containing the
    reference or key item and the second the  value,  in  exactly  the
    same  way as  results from a call to CONVERT . This is then sorted
    just as any other two dimensional array.  In all cases, the  items
    to  be  sorted  may  be  of mixed dataypes and the sorting is done
    primarily on datatype of key, using lexical ordering  of  datatype
    names,  and secondarily on value.  Thus items of similar datatypes
    become contiguously grouped in sorted order.  The  only  deviation
    from  this  rule  is that mixed  INTEGER and REAL (NUMERIC ) items
    are sorted as a single group and strings which  can  be  converted
    to  NUMERIC  are  compared  numerically  against NUMERIC keys.  In
    particular the NULL string is regarded as 0 or 0.0  in  comparison
    with  them.   Note  that  compared  numerically,  100  >  "20" but
    compared lexically "100" < "20".  A second argument, if  specified
    for  an  ARRAY  or  TABLE,  must  be an integer corresponding to a
    column index (1 or 2 for a TABLE). The keys are  then  taken  from
    this  column,  and  during the sort, complete rows are permuted to
    the order determined by key values.  If  the  second  argument  is
    omitted,  the  default  column  used  is that corresponding to the
    smallest  value  of  the   second   index   (e.g   -2   in   M   =
    ARRAY('10,-2:+2')).   The  sorting  method  used  is  stable  with
    respect to non-interchange of items having  equal  keys,  so  that
    repeated  sorting  on  successive  columns may be used to effect a
    total ordering.

    In the case of a VECTOR, the optional second argument may  be  the
    NAME   of a field of a programmer defined datatype created by DATA
    . In this case, if any of the values in the  VECTOR  are  of  this
    type,  the  contents  of the field corresponding to NAME  are used
    as the key.  If the second argument is  omitted,  the  sorting  is
    carried out by using the values the VECTOR contains as keys.







         MACRO SPITBOL V3.5
                                                   PAGE 40 - [5.67]
         Functions

    The  sort  method  used is Heapsort (see for instance Horowitz and
    Sahni, "Fundamentals of Data Structures",  Pitman  1977)  modified
    so  that  no  interchanging of equal keys occurs.  It is efficient
    in usage of both space and time, the time taken to  sort  N  items
    being  proportional  to  N * log(N).   The  aggregate  obtained is
    always a sorted copy of the original.  No extra store is used  for
    the  sort  except  in  the case of a TABLE, where space sufficient
    for conversion to an ARRAY is taken.  Examples of calls are
    *  Assume USERS is an ARRAY of programmer defined datatypes
    *  of the type created by       DATA('COMPUSER(NAME,TYME)')
          SUS = RSORT(SORT(USERS,.NAME),.TYME)
    which creates an array sorted  primarily  by  tyme  in  descending
    order  and secondarily by name in alphabetic order.
          MATX = SORT(SORT(SORT(MATX,3),2))
    which sorts MATX respectively by columns 3, 2, 1.
          V = SORT(V)
    which sorts V  by its elements.


 5.68  SPAN -- Create Spanning Pattern
 5.68  SPAN -- Create Spanning Pattern
 __________ __ ______ ________ _______

    SPAN(STRING) or SPAN(EXPRESSION)

    SPAN  creates  a  pattern  which, starting from the current cursor
    position, will match the longest non-null sequence  of  characters
    drawn  from  the  character  set  contained  in the argument.  The
    argument is not permitted to be  null.   If  the  argument  is  an
    expression,  it  is  evaluated  during  pattern  matching and must
    yield a non-null string.


 5.69  STOPTR * -- Stop Trace
 5.69  STOPTR * -- Stop Trace
 ____________ _ __ ____ _____

    STOPTR(NAME,STRING)

    STOPTR  terminates  tracing  for  the  name  given  by  the  first
    argument.   The  second  argument  designates the respect in which
    the trace is to be stopped and consists  of  one  of  the  strings
    listed under the description of TRACE.



















         MACRO SPITBOL V3.5
                                                   PAGE 41 - [5.70]
         Functions



 5.70  SUBSTR * -- Extract Substring
 5.70  SUBSTR * -- Extract Substring
 ____________ _ __ _______ _________

    SUBSTR(STRING or BUFFER,INTEGER,INTEGER)

    Extracts   a  substring  from  the  first  argument.   The  second
    argument specifies the first character (1 = start of  string)  and
    the  third  argument  gives  the number of characters.  An omitted
    third argument specifies all remaining characters of  the  string.
    Improper substrings cause statement failure.

    Note  that  no  conversion  to  string  is needed in the case of a
    BUFFER argument, the substring  is  extracted  directly  from  the
    buffer making SUBSTR quite efficient when working with buffers.


 5.71  TAB -- Create Tabbing Pattern
 5.71  TAB -- Create Tabbing Pattern
 _________ __ ______ _______ _______

    TAB(INTEGER) or TAB(EXPRESSION)

    TAB  returns  a pattern which matches from the current location up
    to the point where the indicated number of  characters  have  been
    matched.   The  argument  must  be a non-negative integer.  If the
    argument  is  an  expression,  it  is  evaluated  during   pattern
    matching and must yield a non-negative integer.


 5.72  TABLE * -- Create Table
 5.72  TABLE * -- Create Table
 ___________ _ __ ______ _____

    TABLE(INTEGER,,ARG)

    The  TABLE  function  creates  an associative table as in SNOBOL4.
    However in SPITBOL, the table is implemented internally  using  an
    efficient   hashing algorithm.  The integer argument is the number
    of hash headers used.  If it is omitted, 11 is  used  by  default.
    If  N  is  the number of entries in the table, and H is the number
    of hash headers, the average number of probes  to  find  an  entry
    rises  from  about 1.0 for small N, to N/2H if N is large compared
    with H.  Since the overhead for hash headers is small compared  to
    the  size of a table element, a useful guide is to use as argument
    an estimate of the number of entries to be stored  in  the  table.
    Any  second  argument  (permitted  for  SNOBOL4  compatibility) is
    always ignored.  The optional third argument is a value  which  it
    is  desired  to  have  returned  instead of the default NULL, when
    table look-up is performed using a key which has not been  entered
    into  the  TABLE.   This  is similar in effect to the usage of the
    second argument of ARRAY.  In contrast  with  SNOBOL4,  where  the
    first  reference  to an entry automatically creates a table entry,
    in  SPITBOL  an  entry  is  inserted  in  a  table  only  when  an
    assignment   is   explicitly  made.   Thus  table  look-up  for  a
    currently missing key does not create an entry for  that  key  and
    may be freely used.





         MACRO SPITBOL V3.5
                                                   PAGE 42 - [5.73]
         Functions



 5.73  TIME -- Get Timer Value
 5.73  TIME -- Get Timer Value
 __________ __ ___ _____ _____

    TIME()

    TIME  returns the integer number of milliseconds of processor time
    since the start of execution.


 5.74  TRACE * -- Initiate Trace
 5.74  TRACE * -- Initiate Trace
 ___________ _ __ ________ _____


    The TRACE function, which is quite invaluable as a debugging  aid,
    initiates  a  trace  of  the item whose name is given by the first
    argument.  The second argument specifies the sense  of  the  trace
    as follows -


            'A' or 'ACCESS'               access
            'V' or 'VALUE' or null        value
            'K' or 'KEYWORD'              keyword
            'L' or 'LABEL'                label
            'F' or 'FUNCTION'             function call and return
            'C' or 'CALL'                 function call
            'R' or 'RETURN'               function return

    The  access trace mode introduced in SPITBOL consists of producing
    trace output each  time  an  access  traced  item  is  referenced.
    Attempts  to trace a function before a DEFINE statement for it has
    been executed will fail.  If &STLIMIT  is  negative,  STCOUNT  may
    not  be  traced.  To give a visual impression of depth of nesting,
    a letter "I" is included in the trace output for  each  additional
    level of function call.


 5.75  TRIM -- Trim Trailing Blanks
 5.75  TRIM -- Trim Trailing Blanks
 __________ __ ____ ________ ______

    TRIM(STRING)

    TRIM  returns  the  result  of  trimming  trailing blanks from the
    argument string.


 5.76  UNLOAD * -- Unload Function
 5.76  UNLOAD * -- Unload Function
 ____________ _ __ ______ ________

    UNLOAD(NAME)

    NAME is the name of an external function which is to be  unloaded.
    The  names  of  user defined functions may also appear in calls to
    UNLOAD in which case the function becomes undefined.







         MACRO SPITBOL V3.5
                                                   PAGE 43 - [6]
         Keywords



                            *---------------*
                              [6]  Keywords
                            | [6]  Keywords |
                            *---------------*

    The following is a list of the keywords  implemented  in  SPITBOL.
    The  notation  (R)  after  the name indicates that the keyword may
    only be read so that attempts to assign to it will  result  in  an
    error.   With  the  exception  of  &STLIMIT,  values  assigned  to
    numeric keywords  must be in the range 0 to MXLEN .


     1.  &ABEND : Normally set to zero.  If it is set  to  a  non-zero
         value  at  the  end of execution,  an ABEND dump may be given
         if supported by the implementation.

     2.  &ABORT (R) :  Contains the pattern ABORT .

     3.  &ALPHABET (R) : Contains the full character set of  the  host
         computer in natural collating sequence.

     4.  &ANCHOR  :  Set to one for anchored pattern matching mode and
         to zero for  unanchored  mode.   Initial  value  is  zero  to
         correspond  with  SNOBOL4.   However  unanchored  matching is
         needed only rarely and is liable  to  be  very  expensive  in
         runtime  unless  carefully  used,  so  in  general it is good
         practice to start programs with the statement
             &ANCHOR = 1

     5.  &ARB (R) :  Contains the pattern ARB .

     6.  &BAL (R) :  Contains the pattern BAL .

     7.  &CODE  :  Initially  zero.   In  implementations  where   the
         concept   makes  sense,  values  found  to  be  in  &CODE  at
         termination are used as ending codes (Section 12).

     8.  &DUMP : The standard value is zero.  If the value is zero  at
         the  end  of  execution,  then  no symbolic dump is given.  A
         value of one gives a dump including values  of  keywords  and
         natural  variables.   If  the value is two, the dump includes
         non-null array, table and program defined  datatype  elements
         as  well.  The dump format is self explanatory and deals with
         the case of branched  structures  including  circular  lists.
         If  the  value exceeds two, an  ABEND dump may be produced as
         well if the implementation supports this.











         MACRO SPITBOL V3.5
                                                   PAGE 44 - [6]
         Keywords


     9.  &ERRLIMIT :  The  maximum  number  of  errors  which  can  be
         trapped  using  the  SETEXIT function. &ERRLIMIT is initially
         zero and when set non-zero by assignment, it  is  decremented
         each  time  a  SETEXIT trap occurs.  SETEXIT has no effect on
         normal error processing if &ERRLIMIT is zero.

    10.  &ERRTEXT : If an  execution  error  occurs,  then  the  error
         message  text  corresponding to the error code is stored as a
         string in &ERRTEXT.  It is possible to  assign  a  string  to
         &ERRTEXT  which  is then used in a subsequent error report if
         &ERRTYPE is assigned  a  value  out  of  the  range  used  by
         SPITBOL  itself.  Such an assignment does not signal an error
         as is the case with &ERRTYPE.

    11.  &ERRTYPE : If an execution error occurs, then the error  code
         is  stored  as  an  integer  in  &ERRTYPE.  &ERRTYPE  may  be
         assigned  a  value  in  which  case  an  immediate  error  is
         signalled.   This may be useful in reporting program detected
         errors.  Error codes used by  SPITBOL  all  fall  below  300.
         Values  in  &ERRTEXT and &ERRTYPE are useful in SETEXIT error
         intercept routines.

    12.  &FAIL (R) :  Contains the pattern FAIL .

    13.  &FENCE (R) :  Contains the pattern FENCE .

    14.  &FNCLEVEL (R) : Contains the current function nesting  level.

    15.  &FTRACE  :  The  standard  value  is  zero.   If  it  is  set
         positive, each function  call  and  return  is  traced.   The
         value  of &FTRACE is decremented  for each trace line printed
         until the value reaches zero again.

    16.  &INPUT : Set to one for normal  input  (standard  value).  If
         set to zero, all input associations are ignored.

    17.  &LASTNO  (R)  :  Contains  the  number  of the last statement
         executed.

    18.  &MAXLNGTH : Contains the  maximum  permitted  string  length.
         At  the  start  of execution its value is that given by MXLEN
         (Section 12). It may be set to  smaller values but not  to  a
         value exceeding MXLEN .

    19.  &OUTPUT  :  Set to one for normal output (standard value). If
         set to zero, all output associations are ignored.

    20.  &PROFILE :  When  set  to  zero  (the   default),   statement
         profiling  is disabled.  When set to one, statement profiling
         is enabled.  When statement  profiling  is  enabled,  SPITBOL
         keeps  track  of   the  count of each statement executed, and
         the  amount  of  central  processor  time   accumulated   for
         executing  each  statement.   If  profiling is enabled at any
         time during an execution, the accumulated profile is  printed
         on  the  standard output channel when the program terminates.


         MACRO SPITBOL V3.5
                                                   PAGE 45 - [6]
         Keywords

         The profile also indicates the  average  time  for  executing
         each statement.

         If  &PROFILE  is  set  to  two,  it  acts  as in the case for
         &PROFILE=1, except that function calls  are  charged  to  the
         statements which contain them.

         &PROFILE  is  not  available  in all implementations, and for
         some machines where processor  time  is  not  available,  the
         time  indicated may be wall time.  In all cases, the enabling
         of the profile adds additional time to the execution, so  the
         times indicated should be viewed as relative.

    21.  &REM (R) :  Contains the pattern REM .

    22.  &RTNTYPE  (R)  :  Contains  'RETURN',  'FRETURN' or 'NRETURN'
         depending on  the  type  of  function  return  most  recently
         executed.

    23.  &STCOUNT  :  Contains  a  count  of  the number of statements
         executed unless &STLIMIT is negative.

    24.  &STLIMIT : The maximum number of statements permitted  to  be
         executed.    Initially   50000  and  with  an  implementation
         dependent maximum (Section 12)  beyond  which  it  cannot  be
         set.    To  inhibit  this  check  on  numbers  of  statements
         executed, assign a negative value to the keyword.  Thus
                 &STLIMIT = -1
         is equivalent to &STLIMIT = "infinity". This will  result  in
         a  marginal  execution  speed  up  since  count  updating and
         checking is omitted.  The value of  &STCOUNT  remains  frozen
         at  the  value reached when &STLIMIT was set negative and the
         number of statements executed is omitted from  the  execution
         statistics.   Tracing  of  STCOUNT becomes no longer possible
         since its value is not incremented.

    25.  &STNO (R) : The number of the current statement.

    26.  &SUCCEED (R) :  Contains the pattern SUCCEED .

    27.  &TRACE : Initial value of zero suppresses trace  output.   If
         assigned  a positive value, trace output is generated and for
         each line printed &TRACE is  decremented  by  one  until  the
         value reaches zero again.

    28.  &TRIM  :  Set  to zero for normal input mode (default value).
         If  the  value  is  set  non-zero,  all  input  records   are
         automatically  trimmed  (trailing  blanks  are removed).  For
         operating systems  having  file  formats  in  which  variable
         length   records  may  have  trailing  blanks  suppressed,  a
         setting of zero does not imply that  padding  to  a  standard
         size  occurs,  merely  that  any  trailing  blanks  which are
         actually present will be preserved.  For  most  applications,
         initialising the value to 1 is to be recommended.




         MACRO SPITBOL V3.5
                                                   PAGE 46 - [7]
         Program Listing and Control Cards



                *----------------------------------------*
                  [7]  Program Listing and Control Cards
                | [7]  Program Listing and Control Cards |
                *----------------------------------------*

    Normally  a  listing  of  the  source program is produced in which
    statements are prefixed with a  statement  number.   This  listing
    usually  starts  with  a  heading identifying the SPITBOL version,
    and giving date  and  time  of  run.   Where  this  is  considered
    inappropriate  it  may  be  suppressed  (Section  12). Many of the
    control cards to be  described  permit  choice  of  other  listing
    options.   Control  cards are identified by a minus sign in column
    one.  They may occur anywhere in a source program and take  effect
    when  they  are encountered.  Most of them are special features of
    SPITBOL and are not available in  SNOBOL4.   The  full  names  are
    given  for  each  of  them, but they may be abbreviated since only
    the first four characters are significant to the compiler.


 7.1  Listing Control Cards
 7.1  Listing Control Cards
 ____________ _______ _____

    Listing control cards are used to  alter  the  appearance  of  the
    listing.   They  have no other effect on compilation or execution.
    Listing control cards always occur individually.




 7.1.1  -EJECT
 7.1.1  -EJECT

    The -EJECT control card  causes  the  compilation  listing  to  be
    skipped  to  the  top  of  the  next  page.  The current title and
    subtitle (if any) are printed at the top of the page.




 7.1.2  -SPACE
 7.1.2  -SPACE

    The -SPACE control  card  causes  spaces  to  be  skipped  on  the
    current  page.  If -SPACE occurs with no operand, then one line is
    skipped.  Alternatively, an  unsigned  integer  can  be  given  in
    columns  8-72  which represents the number of lines to be skipped.
    If there is insufficient space on the current  page,  -SPACE  acts
    like  -EJECT  and  the  listing  is  spaced to the top of the next
    page.











         MACRO SPITBOL V3.5
                                                   PAGE 47 - [7.1.3]
         Program Listing and Control Cards

 7.1.3  -TITLE
 7.1.3  -TITLE

    This card supplies a title for the source  program  listing.   The
    text  of  the title is taken from columns 8-72 of the -TITLE card.
    The subtitle is cleared to blanks, and an eject to the  next  page
    occurs next time a line is listed.


 7.1.4  -STITL
 7.1.4  -STITL

    The  -STITL  card  is  used  to  supply  a subtitle for the source
    program listing.  The text of the subtitle is taken  from  columns
    8-72  of  the -STITL card.  An eject occurs to the top of the next
    page next time a line is listed and the  current  title  (if  any)
    and  the  newly  supplied subtitle are printed.  If both title and
    subtitle are to be changed, then the -TITLE  card  should  precede
    the -STITL card.









































         MACRO SPITBOL V3.5
                                                   PAGE 48 - [7.2]
         Program Listing and Control Cards



 7.2  Option Control Cards
 7.2  Option Control Cards
 ___________ _______ _____

    The  option  control  cards  allow  selection  of various compiler
    options.  In each case, there are two modes and a pair of  control
    cards  which  permit  repeated flipping back and forth of the mode
    within a program.  Several control options  may  be  specified  on
    the  same  control  card  by  separating  the  names  with commas,
    leaving no intervening blanks.  For example
    -FAIL,LIST,PRINT
    In the list below, the default option is named first.




 7.2.1  -LIST -NOLIST
 7.2.1  -LIST -NOLIST

    The -NOLIST option causes  suppression  of  the  normal  statement
    listing.   This  may  be  useful  for  established program, or for
    terminal  output.   If  compilation  errors  are   detected,   the
    offending  statements are printed regardless of the setting of the
    list mode.  Some implementations provide  a  run  time  option  to
    select  NOLIST  mode  initially without the need to insert -NOLIST
    into the program being run (Section 12).




 7.2.2  -NOPRINT -PRINT
 7.2.2  -NOPRINT -PRINT

    Normally control cards are not printed.  The -PRINT option  causes
    them  to  be listed, provided the -LIST option is in effect.  This
    option may be useful if serialization is used for updating.




 7.2.3  -SINGLE -DOUBLE
 7.2.3  -SINGLE -DOUBLE

    The compilation listing is normally singly  spaced.   The  -DOUBLE
    option  causes  double  spacing  to  be  used,  with  a blank line
    folowing each listed line.















         MACRO SPITBOL V3.5
                                                   PAGE 49 - [7.2.4]
         Program Listing and Control Cards



 7.2.4  -INXXX
 7.2.4  -INXXX

    XXX in the above stands for an integer indicating  the  number  of
    characters  to  be  read  from  each  record of the SPITBOL source
    file.  The normal default is for  the  compiler  to  read  SPITBOL
    statements  from  columns  1-72  of  the  input  image.  Longer or
    shorter input  records  may  be  read  by  specifying  alternative
    values  for  XXX.  If any value other than 72 is in use at the end
    of translation, it is used as the maximum record length  for  data
    read  from  the  standard  input  file.  For historical reasons, a
    -IN72 card in effect at the end of compilation is taken  to  imply
    a  maximum  record length of 80 for execution time data.  There is
    however no need to restrict records to lengths of 72 or 80.




 7.2.5  -ERRORS -NOERRORS
 7.2.5  -ERRORS -NOERRORS

    Normally execution is allowed even when compilation errors  occur.
    If  it  is  wished  to inhibit execution if compilation errors are
    detected then the -NOERRORS option should be selected.




 7.2.6  -FAIL -NOFAIL
 7.2.6  -FAIL -NOFAIL

    In SNOBOL4 and in SPITBOL with the -FAIL mode set, a failure in  a
    statement  with  no  conditional  goto  is ignored and the program
    execution resumes with  the  next  statement  in  sequence.   This
    convention  often leads to errors going undetected, particuarly in
    the case of array references with  out  of  bound  subscripts  and
    pattern  matches  which  the user anticipates will always succeed.
    The -NOFAIL  option  changes  this  convention.   If  a  statement
    lacking  a  conditional goto is compiled under the -NOFAIL option,
    then if a failure occurs when  the  statement  is  executed,  this
    produces  an execution error with a suitable message.  This option
    is especially useful for student jobs and other  situations  where
    many small programs are being debugged.




 7.2.7  -EXECUTE -NOEXECUTE
 7.2.7  -EXECUTE -NOEXECUTE

    Normally   execution  is  initiated  following  compilation.   The
    -NOEXECUTE  option,  if  in  force  at  the  end  of  compilation,
    inhibits  execution.   A  run  time option may be provided for the
    same purpose (Section 12).






         MACRO SPITBOL V3.5
                                                   PAGE 50 - [8]
         Errors



                             *-------------*
                               [8]  Errors
                             | [8]  Errors |
                             *-------------*


 8.1  Compilation Error Messages
 8.1  Compilation Error Messages
 ________________ _____ ________

    When the compiler detects an error, the offending line is  printed
    with  a  marker  under  the  point at which the error was actually
    detected  and  an  error  code  and  self-explanatory  message  is
    printed.    Processing   of  the  statement  is  discontinued  and
    compilation continues with the next  statement.   Execution  of  a
    program  containing  errors is not suppressed unless the -NOERRORS
    option has  been  set.   If  an  attempt  is  made  to  execute  a
    statement  found  erroneous  by  the  compiler, an execution error
    occurs.


 8.2  Execution Error Messages
 8.2  Execution Error Messages
 ______________ _____ ________

    Extensive error checking is performed at run time.  When an  error
    is  detected,  execution is terminated with an error message which
    refers to the number of  the  erroneous  statement.   However,  as
    described  in  Section  5,  it  is  possible  to  avoid  automatic
    execution  termination  and  to   obtain   user   error   handling
    facilities by means of the SETEXIT function.

    In  addition  to  the  errors  listed here, the implementation may
    have additional system errors.  See Section 12.


 8.3  Error Codes and Messages
 8.3  Error Codes and Messages
 __________ _____ ___ ________

    The following list details all error messages with  the  exception
    of any which may be particular to certain implementations.

    Code                       Message
    ____                       _______

      1   Addition left operand is not numeric
      2   Addition right operand is not numeric
      3   Addition caused integer overflow
      4   Affirmation operand is not numeric
      5   Alternation right operand is not pattern
      6   Alternation left operand is not pattern
      7   Compilation error encountered during execution
      8   Concatenation left opnd is not string or pattern
      9   Concatenation right opd is not string or pattern
     10   Complementation operand is not numeric
     11   Complementation caused integer overflow
     12   Division left operand is not numeric
     13   Division right operand is not numeric
     14   Division caused integer overflow
     15   Exponentiation right operand is not numeric
     16   Exponentiation left operand is not numeric


         MACRO SPITBOL V3.5
                                                   PAGE 51 - [8.3]
         Errors

     17   Exponentiation caused integer overflow
     18   Exponentiation result is undefined
     19   Exponentiation right operand is negative
     20   Goto evaluation failure
     21   Function called by name returned a value
     22   Undefined function called
     23   Goto operand is not a natural variable
     24   Goto operand in direct goto is not code
     25   Immediate assignment left operand is not pattern
     26   Multiplication left operand is not numeric
     27   Multiplication right operand is not numeric
     28   Multiplication caused integer overflow
     29   Undefined operator referenced
     30   Pattern assignment left operand is not pattern
     31   Pattern replacement right operand is not string
     32   Subtraction left operand is not numeric
     33   Subtraction right operand is not numeric
     34   Subtraction caused integer overflow
     35   Unexpected failure in -NOFAIL mode
     36   Goto ABORT with no preceding error
     37   Goto CONTINUE with no preceding error
     38   Goto undefined label
     39   External function argument is not string
     40   External function argument is not integer
     41   FIELD function argument is wrong datatype
     42   Attempt to change value of protected variable
     43   ANY evaluated argument is not string
     44   BREAK evaluated argument is not string
     45   BREAKX evaluated argument is not string
     46   Expression does not evaluate to pattern
     47   LEN evaluated argument is not integer
     48   LEN evaluated argument is negative or too large
     49   NOTANY evaluated argument is not string
     50   POS evaluated argument is not integer
     51   POS evaluated argument is negative or too large
     52   RPOS evaluated argument is not integer
     53   RPOS evaluated argument is negative or too large
     54   RTAB evaluated argument is not integer
     55   RTAB evaluated argument is negative or too large
     56   SPAN evaluated argument is not string
     57   TAB evaluated argument is not integer
     58   TAB evaluated argument is negative or too large
     59   ANY argument is not string or expression
     60   APPLY first arg is not natural variable name
     61   ARBNO argument is not pattern
     62   ARG second argument is not integer
     63   ARG first argument is not program function name
     64   ARRAY first argument is not integer or string
     65   ARRAY first argument lower bound is not integer
     66   ARRAY first argument upper bound is not integer
     67   ARRAY dimension is zero,negative or out of range
     68   ARRAY size exceeds maximum permitted
     69   BREAK argument is not string or expression
     70   BREAKX argument is not string or expression
     71   CLEAR argument is not string
     72   CLEAR argument has null variable name


         MACRO SPITBOL V3.5
                                                   PAGE 52 - [8.3]
         Errors

     73   COLLECT argument is not integer
     74   CONVERT second argument is not string
     75   DATA argument is not string
     76   DATA argument is null
     77   DATA argument is missing a left paren
     78   DATA argument has null datatype name
     79   DATA argument is missing a right paren
     80   DATA argument has null field name
     81   DEFINE first argument is not string
     82   DEFINE first argument is null
     83   DEFINE first argument is missing a left paren
     84   DEFINE first argument has null function name
     85   Null arg name or missing ) in DEFINE first arg.
     86   DEFINE function entry point is not defined label
     87   DETACH argument is not appropriate name
     88   DUMP argument is not integer
     89   DUMP argument is negative or too large
     90   DUPL second argument is not integer
     91   DUPL first argument is not string or pattern
     92   EJECT argument is not a suitable name
     93   EJECT file does not exist
     94   EJECT file does not permit page eject
     95   EJECT caused non-recoverable output error
     96   ENDFILE argument is not a suitable name
     97   ENDFILE argument is null
     98   ENDFILE file does not exist
     99   ENDFILE file does not permit endfile
    100   ENDFILE caused non-recoverable output error
    101   EQ first argument is not numeric
    102   EQ second argument is not numeric
    103   EVAL argument is not expression
    104   EXIT argument is not suitable integer or string
    105   EXIT action not available in this implementation
    106   EXIT action caused irrecoverable error
    107   FIELD second argument is not integer
    108   FIELD first argument is not datatype name
    109   GE first argument is not numeric
    110   GE second argument is not numeric
    111   GT first argument is not numeric
    112   GT second argument is not numeric
    113   INPUT third argument is not a string
    114   Inappropriate second argument for INPUT
    115   Inappropriate first argument for INPUT
    116   Inappropriate file specification for INPUT
    117   INPUT file cannot be read
    118   LE first argument is not numeric
    119   LE second argument is not numeric
    120   LEN argument is not integer or expression
    121   LEN argument is negative or too large
    122   LEQ first argument is not string
    123   LEQ second argument is not string
    124   LGE first argument is not string
    125   LGE second argument is not string
    126   LGT first argument is not string
    127   LGT second argument is not string
    128   LLE first argument is not string


         MACRO SPITBOL V3.5
                                                   PAGE 53 - [8.3]
         Errors

    129   LLE second argument is not string
    130   LLT first argument is not string
    131   LLT second argument is not string
    132   LNE first argument is not string
    133   LNE second argument is not string
    134   LOCAL second argument is not integer
    135   LOCAL first arg is not a program function name
    136   LOAD second argument is not string
    137   LOAD first argument is not string
    138   LOAD first argument is null
    139   LOAD first argument is missing a left paren
    140   LOAD first argument has null function name
    141   LOAD first argument is missing a right paren
    142   LOAD function does not exist
    143   LOAD function caused input error during load
    144   LPAD third argument not a string
    145   LPAD second argument is not integer
    146   LPAD first argument is not string
    147   LT first argument is not numeric
    148   LT second argument is not numeric
    149   NE first argument is not numeric
    150   NE second argument is not numeric
    151   NOTANY argument is not string or expression
    152   OPSYN third argument is not integer
    153   OPSYN third argument is negative or too large
    154   OPSYN second arg is not natural variable name
    155   OPSYN first arg is not natural variable name
    156   OPSYN first arg is not correct operator name
    157   OUTPUT third argument is not a string
    158   Inappropriate second argument for OUTPUT
    159   Inappropriate first argument for OUTPUT
    160   Inappropriate file specification for OUTPUT
    161   OUTPUT file cannot be written to
    162   POS argument is not integer or expression
    163   POS argument is negative or too large
    164   PROTOTYPE argument is not table or array
    165   REMDR second argument is not integer
    166   REMDR first argument is not integer
    167   REMDR caused integer overflow
    168   REPLACE third argument is not string
    169   REPLACE second argument is not string
    170   REPLACE first argument is not string
    171   Null or unequally long 2nd, 3rd args to REPLACE
    172   REWIND argument is not a suitable name
    173   REWIND argument is null
    174   REWIND file does not exist
    175   REWIND file does not permit rewind
    176   REWIND caused non-recoverable error
    177   REVERSE argument is not string
    178   RPAD third argument is not string
    179   RPAD second argument is not integer
    180   RPAD first argument is not string
    181   RTAB argument is not integer or expression
    182   RTAB argument is negative or too large
    183   TAB argument is not integer or expression
    184   TAB argument is negative or too large


         MACRO SPITBOL V3.5
                                                   PAGE 54 - [8.3]
         Errors

    185   RPOS argument is not integer or expression
    186   RPOS argument is negative or too large
    187   SETEXIT argument is not label name or null
    188   SPAN argument is not string or expression
    189   SIZE argument is not string
    190   STOPTR first argument is not appropriate name
    191   STOPTR second argument is not trace type
    192   SUBSTR third argument is not integer
    193   SUBSTR second argument is not integer
    194   SUBSTR first argument is not string
    195   TABLE argument is not integer
    196   TABLE argument is out of range
    197   TRACE fourth arg is not function name or null
    198   TRACE first argument is not appropriate name
    199   TRACE second argument is not trace type
    200   TRIM argument is not string
    201   UNLOAD argument is not natural variable name
    202   Input from file caused non-recoverable error
    203   Input file record has incorrect format
    204   Memory overflow
    205   String length exceeds value of MAXLNGTH keyword
    206   Output caused file overflow
    207   Output caused non-recoverable error
    208   Keyword value assigned is not integer
    209   Keyword in assignment is protected
    210   Keyword value assigned is negative or too large
    211   Value assigned to keyword ERRTEXT not a string
    212   Syntax error.  Value used where name is required
    213   Syntax error.  Statement is too complicated.
    214   Syntax error.  Bad label or misplaced continuation line
    215   Syntax error.  Undefined or erroneous entry label
    216   Syntax error.  Missing END line
    217   Syntax error.  Duplicate label
    218   Syntax error.  Duplicated goto field
    219   Syntax error.  Empty goto field
    220   Syntax error.  Missing operator
    221   Syntax error.  Missing operand
    222   Syntax error.  Invalid use of left bracket
    223   Syntax error.  Invalid use of comma
    224   Syntax error.  Unbalanced right parenthesis
    225   Syntax error.  Unbalanced right bracket
    226   Syntax error.  Missing right paren
    227   Syntax error.  Right paren missing from goto
    228   Syntax error.  Right bracket missing from goto
    229   Syntax error.  Missing right array bracket
    230   Syntax error.  Illegal character
    231   Syntax error.  Invalid numeric item
    232   Syntax error.  Unmatched string quote
    233   Syntax error.  Invalid use of operator
    234   Syntax error.  Goto field incorrect
    235   Subscripted operand is not table or array
    236   Array referenced with wrong number of subscripts
    237   Table referenced with more than one subscript
    238   Array subscript is not integer
    239   Indirection operand is not name
    240   Pattern match right operand is not pattern


         MACRO SPITBOL V3.5
                                                   PAGE 55 - [8.3]
         Errors

    241   Pattern match left operand is not string
    242   Function return from level zero
    243   Function result in NRETURN is not name
    244   Statement count exceeds value of STLIMIT keyword
    245   Translation/execution time expired
    246   Stack overflow
    247   Invalid control card
    248   Attempted redefinition of system function
    249   Expression evaluated by name returned value
    250   Insufficient memory to complete dump
    251   Keyword operand is not name of defined keyword
    252   Error on printing to interactive channel
    253   Print limit exceeded on standard output channel
    254   Erroneous argument to HOST
    255   Error during execution of HOST
    256   SORT/RSORT 1st arg not suitable ARRAY or TABLE
    257   Erroneous 2nd arg in SORT/RSORT of vector
    258   SORT/RSORT 2nd arg out of range or non-integer
    259   FENCE function argument is not pattern
    261   Addition caused real overflow
    262   Division caused real overflow
    263   Multiplication caused real overflow
    264   Subtraction caused real overflow
    265   External function argument is not real
    266   Exponentiation caused real overflow
    267   Exponentiation right operand is real not integer
    268   Inconsistent value assigned to profile keyword
    269   BUFFER first argument is not integer
    270   BUFFER second argument is not string or buffer
    271   BUFFER initial value too big for allocation
    272   BUFFER first argument is not positive
    273   Buffer size is too big
    274   Requested buffer allocation exceeds MXLEN
    275   APPEND first argument is not buffer
    276   APPEND second argument is not string
    277   INSERT third argument not integer
    278   INSERT second argument not integer
    279   INSERT first argument not buffer
    280   INSERT fourth argument not a string
    281   CHAR argument not integer
    282   CHAR argument not in range

















         MACRO SPITBOL V3.5
                                                   PAGE 56 - [9]
         Programming Notes



                        *------------------------*
                          [9]  Programming Notes
                        | [9]  Programming Notes |
                        *------------------------*

    The  internal organization of SPITBOL is quite different from that
    of  SNOBOL4.   Consequently  the   relative   speed   of   various
    operations  differs.   This  section attempts to give some idea of
    how to obtain high efficiency in SPITBOL programs.


 9.1  Space Considerations
 9.1  Space Considerations
 __________ ______________

    The ANY, NOTANY, BREAK, BREAKX, SPAN functions use  translate  and
    test  tables  for  arguments  longer  than one character.  A table
    allocated for this purpose will be M words long by  N  bits  wide,
    where  M  is  64, 128 or 256 (machine dependent) and N is the word
    length in bits of the host computer.  For  each  function  call  a
    bit  column  is  used so that a single table suffices for N calls.
    With a constant  argument,  the  table  entry  is  precomputed  at
    compile  time  thus avoiding erosion of space by repeated calls in
    a run time loop.   Single  character  arguments  incur  no   space
    overhead .

    Integers  and reals have an overhead of one word above that needed
    by the usual hardware representation.

    Multidimensional arrays have a  space  overhead  of  8 + 2D  words
    where  D is the number of dimensions.  One dimensional arrays with
    a low bound of 1 (vectors ) are  treated  specially  and  have  an
    overhead of only three words.

    The  space  needed  for  non-null elements of tables is 4 words in
    addition to space  for  the  element  itself.   Each  table   hash
    header  is  one  word.   Thus  the  number  of headers can be made
    reasonably large without using  much  additional  space.   Program
    defined  datatypes  require  3 + F words, where F is the number of
    fields.  They are thus quite  compact  and  can  be  used  freely.
    Each  variable  block requires 8 words plus space for the variable
    name, the characters of  which  are  packed  several  to  a  word,
    usually  using  6,  7 or 8 bits for each character.  This space is
    constant irrespective of whether the name has a single  use     or
    is  used  multiply as a label, function, variable etc.  This space
    is never reclaimed once  it  has  been   allocated.   It  is  thus
    inefficient  to   use  variables  to build tables with the unary $
    operator.  Instead use the TABLE datatype.  The interpretive  code
    produced  by  the  compiler is held in code blocks  and is subject
    to garbage collection when no longer  accessible.   Advantage  can
    be  taken  of  this by writing label-free initialising code at the
    head of a program.  Even if labels are present it is  possible  to
    make  initialising  code   collectable  by the artifice of calling
    CODE with a string argument in which the labels are redeclared.





         MACRO SPITBOL V3.5
                                                   PAGE 57 - [9.1]
         Programming Notes


    Considerable amounts of store  are  used  in  repeatedly  building
    patterns.    They  should  either  be  pre-assigned  to  variables
    outside program loops  or  alternatively  if  written  in-line  in
    loops,  should  be  constant  so  that  they may be precomputed at
    compile time in order to avoid this overhead.

    Setting &TRIM non-zero  ensures  that  memory  is  not  wasted  in
    storing trailing blanks in strings.

    The   COLLECT  function  can  be  used  to  obtain  very  detailed
    information of memory utilization for various structures.

    Modifications to a string type require that the string  be  copied
    internally  first.   This  means  that space must be available for
    two copies of the string to  co-exist  in  memory  simultaneously.
    If  the  string  is  large  this  can lead to unanticipated memory
    usage.  For example, consider the input loop:
        LOOP CORPUS = CORPUS INPUT  :S(LOOP)
    As this reads more and more lines, CORPUS grows larger, and  large
    amounts  of  memory  (and  processor  time)  are spent copying the
    'old' value of CORPUS before INPUT is appended to it.  The  buffer
    type  is  helpful in avoiding this situation,  since modifications
    to buffers  (via  APPEND,  INSERT  and  pattern  replacement)  are
    performed directly on the existing buffer contents.


 9.2  Speed Considerations
 9.2  Speed Considerations
 __________ ______________

    To  a  greater  extent  than  is the case with SNOBOL4, there is a
    loss of efficiency in  encoding  complex  structures  as  strings.
    Use  arrays,  tables,  buffers and program defined datatypes where
    possible since all of these are highly efficient in SPITBOL.   The
    fast  associative  lookup  (hashing) feature of the TABLE makes it
    a particularly recommended feature  to  be  exploited  in  a  wide
    range of applications.

    Programmers  frequently  do  not  appreciate that execution speeds
    may be reduced  by  an  order  of  magnitude  if  poorly  designed
    patterns  fruitlessly  scan  data  in   unanchored mode.  With the
    pattern  matching  primitives  of  SPITBOL,  it   is   rare   that
    unanchored  matching  is  necessary and since anchored matching is
    much less expensive it is worth  acquiring the habit of  initially
    setting  &ANCHOR  non-zero.   If unanchored matching is needed for
    some purpose, take care that it is not unduly wasteful  with  data
    for which match failure is common.

    The  binary  $ pattern assignment is rather faster than the binary
    . pattern assignment and may be used freely.  SPITBOL  precomputes
    constant  expressions  before execution.  No efficiency is lost by
    writing pre-evaluable patterns  in-line  rather  than  predefining
    them.    Use of the unary * to defer computation is useful in some
    cases.  For example, consider the in-line matches -
        X ANY('PQR') BAL PAT 'X' RPOS(0)
        X ANY('PQR') BAL *PAT 'X' RPOS(0)
    The  second  form  is  more  efficient,  since  the  compiler  can


         MACRO SPITBOL V3.5
                                                   PAGE 58 - [9.2]
         Programming Notes

    precompute  the  entire  pattern  where  PAT  occurs as a deferred
    expression.

    The ANY, NOTANY, BREAK, BREAKX, SPAN,  RSORT, SORT  functions  are
    fast and highly recommended.

    ARB  and  ARBNO  are  slow  and can very often be avoided by using
    other  constructions.   Time  for  datatype  conversions  may   be
    significant.    Where  efficiency  is  important,  avoid  repeated
    unnecessary conversions.

    The SETEXIT error intercepts are fast and may be used for  program
    control as well as for debugging.

    Tracing  or  I/O  associating  a variable substantially slows down
    references to it but there is no residual access  penalty  if  the
    trace or I/O associations  are removed by STOPTR or DETACH.

    The  unary  $  (indirect) operator applied to a string argument in
    SPITBOL corresponds to a hash search of existing  variables.   The
    process  of  applying $ to a NAME (including the name of a natural
    variable),  is  much  faster,  which  is  why   unary  dot   (name
    operator)  returns  a NAME instead of a string.  It is thus better
    to use names rather than strings in applications such  as  passing
    variable names or labels indirectly as in
        F(.X)            rather than
        F("X") .

    Use  of the REPLACE function is optimised when, on repeated calls,
    the second and third arguments are found to  be  unchanged,  since
    in this case the previously constructed replace table is re-used.

    The  buffer  type  is  recommended for containing and manipulating
    large strings.   Pattern  replacement  can  be  specified  with  a
    buffer  name as the subject; the replacement is done on the buffer
    contents corresponding  to  the  substring  matched  as  with  the
    INSERT function.


 9.3  Other Notes
 9.3  Other Notes
 __________ _____

    The pattern match
       &ALPHABET LEN(N) LEN(1) $ CHAR
    is  useful  to  put  into  "CHAR"  the  Nth  character of the host
    machine character set.


    The interrogation operator, unary ? , is useful to  annihilate  an
    expression  which  is  evaluated  for its side effects rather than
    for its value.  For example
       S BREAK(*DELIM) $ K *?(TABLE<K> = TABLE<K> + 1)







         MACRO SPITBOL V3.5
                                                   PAGE 59 - [10]
         Specimen Programs



                        *------------------------*
                          [10] Specimen Programs
                        | [10] Specimen Programs |
                        *------------------------*

    Specimen programs of several  different  types  are  listed.   The
    first  one  is  especially  simple and uses no special facilities.
    The second and third are a little more ambitious and make  use  of
    program  defined  datatypes  and  tables  respectively.  Program 4
    serves no function apart from showing some of the  techniques  for
    producing  trace  output  and  providing  user handling of errors.
    The  job  control  commands  needed  to  run  these  programs  are
    implementation dependent and hence are listed in Section 12.







 10.1  Program 1
 10.1  Program 1
 _____________ _

    This  program reads data appended to its end and scans each record
    to count the number of vowels  it  contains.   A  listing  of  all
    records  constituting  the  program  and data is shown and this is
    followed by a copy of  the  output  produced  on  compilation  and
    execution.   The  -NOLIST  card  indicates  that no listing of the
    program is required.   Note  the  use  of  the  SPITBOL  selection
    feature  in  the  statement labelled NOMORE and the plus used as a
    statement continuation symbol in column 1 of the next  card.   The
    data  for  the  run   follows  the  END label of the program.  The
    output includes  the version number of the SPITBOL compiler  which
    will  be  updated  as  new  versions are introduced.  Compile time
    statistics, output  from  the  program  execution  and  statistics
    relating to the run are listed.






















         MACRO SPITBOL V3.5
                                                   PAGE 60 - [10.1]
         Specimen Programs

  -NOLIST
  -TITLE  P R O G R A M   1
  *
  *    PROGRAM TO COUNT THE VOWELS IN LINES OF TEXT
  *
            &ANCHOR  = &TRIM = 1
            VOWELS   = BREAK('AEIOU') LEN(1)
  *
  *    LOOP TO READ NEXT LINE OF INPUT
  *
  INP       INP      = COPY = INPUT                     :F(END)
            N        = 0
  *
  *    LOOP TO SEARCH FOR VOWELS
  *
  FINDVWLS  INP VOWELS =                                :F(NOMORE)
            N        = N + 1                            :(FINDVWLS)
  *
  *    ALL VOWELS HAVE BEEN FOUND
  *
  NOMORE    OUTPUT   = RPAD(N,2) (EQ(N,1) ' VOWEL ' , ' VOWELS')
  +           ' FOUND IN "' COPY '"'                    :(INP)
  END
  QWERTY
  1900 AND DECSYSTEM-10 SPITBOL
  THE SLITHY TOVES DID GYRE AND GIMBLE IN THE WABE
  12 * 2 = 24




  STORE USED     1360
  STORE LEFT     4477
  COMP ERRORS    0
  REGENERATIONS  0
  COMP TIME-MSEC 160


  1  VOWEL  FOUND IN "QWERTY"
  5  VOWELS FOUND IN "1900 AND DECSYSTEM-10 SPITBOL"
  13 VOWELS FOUND IN "THE SLITHY TOVES DID GYRE AND GIMBLE IN THE WABE"
  0  VOWELS FOUND IN "12 * 2 = 24"


  NORMAL END
  IN STATEMENT   8
  STMTS EXECUTED 58
  RUN TIME-MSEC  100
  MCSEC / STMT   1724
  REGENERATIONS  0








         MACRO SPITBOL V3.5
                                                   PAGE 61 - [10.2]
         Specimen Programs



 10.2  Program 2
 10.2  Program 2
 _____________ _

    This  is  a  somewhat  more  complex  program for sorting a set of
    records.  There is no -NOLIST card present and  so  a  listing  of
    the  program  is  produced  by the compiler with statement numbers
    placed on the left.  The output includes the sorted list and  then
    following  the  execution  statistics is a dump resulting from the
    assignment to keyword &DUMP in statement 2.  This illustrates  the
    excellent  diagnostic  assistance  available  should a program not
    behave as  expected.   The  structure  of  the  trees  is  readily
    discernible   in   the  dump  of  the  NODEs  of  which  they  are
    constituted.   (Note  that  this  program  could  also  have  been
    written using the SORT feature.)


  P R O G R A M   2                                               PAGE 1

          *    PROGRAM TO SORT A SET OF RECORDS ON A KEY USING A TREE SORTING
          *    TECHNIQUE.
          *
          *    DATATYPE WITH THE NECESSARY 4 FIELDS
          *
  1                 DATA('NODE(KEY,DAT,PRED,SUCC)')
  2                 &DUMP    = 2; &ANCHOR = &TRIM = 1
          *
          *    ROUTINE TO ADD "DATA" TO A TREE SORTED BY "KEY".
          *    "ROOT" IS PASSED BY REFERENCE (IT IS A SPITBOL NAME)
          *    AND POINTS TO THE TREE TO BE USED.
          *
  4                 DEFINE('ADNODE(KEY,DATA,ROOT)PTR')          :(ADNEND)
          *
          *    CREATE TREE INITIALLY IF NOT YET IN EXISTENCE
          *
  5       ADNODE    $ROOT    = IDENT($ROOT) NODE(KEY,DATA)      :S(RETURN)
  6                 PTR      = $ROOT
          *
          *    SEARCH TO FIND INSERTION POINT IN TREE
          *
  7       SEARCH    LLE(KEY,KEY(PTR))                           :S(BEFORE)
          *
          *    HERE IF NODE FOLLOWS THAT IN TREE
          *
  8       AFTER     PTR      = DIFFER(SUCC(PTR)) SUCC(PTR)      :S(SEARCH)
  9                 SUCC(PTR) = NODE(KEY,DATA)                  :S(RETURN)
          *
          *    HERE IF KEY PRECEDES THAT IN TREE
          *
  10      BEFORE    PTR      = DIFFER(PRED(PTR)) PRED(PTR)      :S(SEARCH)
  11                PRED(PTR) = NODE(KEY,DATA)                  :(RETURN)
  12      ADNEND






         MACRO SPITBOL V3.5
                                                   PAGE 62 - [10.2]
         Specimen Programs

          *
          *    ROUTINE TO PRINT A SORTED BINARY TREE
          *
  13                DEFINE('PRINTREE(TREE)')                    :(ENDPRT)
  14      PRINTREE  DIFFER(PRED(TREE)) PRINTREE(PRED(TREE))
  15                OUTPUT   = KEY(TREE) '  ' DAT(TREE)
  16                DIFFER(SUCC(TREE)) PRINTREE(SUCC(TREE))     :(RETURN)
  17      ENDPRT
          *
          *    RECORDS OF WHICH
          *    '1609   GALILEO :   TELESCOPE'
          *    IS TYPICAL ARE TO BE SORTED BY DATE AND BY INVENTOR.
          *    SPLIT OUT THE RECORDS AND ADD TO TWO SORTED TREES.
          *
  18      SORT      INP      = INPUT                            :F(PRINT)
  19                INP LEN(4) $ DATE SPAN(' ') (BREAK(':') ':') $ INVR
          .               SPAN(' ') REM $ INVN
  20                ADNODE(DATE,RPAD(INVR,16) INVN,.DATREE)
  21                ADNODE(RPAD(INVR,16),DATE '  ' INVN,.INVRTREE) :(SORT)
          *
          *    JOB DONE APART FROM PRINTING THE SORTED TREES
          *
  22      PRINT     OUTPUT   = 'INVENTIONS SORTED BY DATE'; OUTPUT =
  24                PRINTREE(DATREE) ; OUTPUT =
  26                OUTPUT   = 'INVENTIONS SORTED BY INVENTOR'; OUTPUT =
  28                PRINTREE(INVRTREE)
  29      END


  INVENTIONS SORTED BY DATE

  1609  GALILEO :         TELESCOPE
  1835  TALBOT W F :      PHOTOGRAPHY
  1876  BELL A G :        TELEPHONE
  1896  DIESEL R :        DIESEL ENGINE
  1896  MARCONI G :       RADIO
  1903  WRIGHT O & W :    POWERED FLIGHT

  INVENTIONS SORTED BY INVENTOR

  BELL A G :        1876  TELEPHONE
  DIESEL R :        1896  DIESEL ENGINE
  GALILEO :         1609  TELESCOPE
  MARCONI G :       1896  RADIO
  TALBOT W F :      1835  PHOTOGRAPHY
  WRIGHT O & W :    1903  POWERED FLIGHT


  NORMAL END
  IN STATEMENT   29
  STMTS EXECUTED 146
  RUN TIME-MSEC  160
  MCSEC / STMT   1095
  REGENERATIONS  0




         MACRO SPITBOL V3.5
                                                   PAGE 63 - [10.2]
         Specimen Programs

    DUMP OF NATURAL VARIABLES

  DATE = '1896'
  DATREE = NODE `1
  INP = '1896    DIESEL R :          DIESEL ENGINE'
  INPUT = '1896    DIESEL R :          DIESEL ENGINE'
  INVN = 'DIESEL ENGINE'
  INVR = 'DIESEL R :'
  INVRTREE = NODE `2
  OUTPUT = 'WRIGHT O & W :    1903  POWERED FLIGHT'
  REM = PATTERN


  DUMP OF KEYWORD VALUES

  &ANCHOR = 1
  &CODE = 0
  &DUMP = 2
  &ERRLIMIT = 0
  &ERRTEXT = ''
  &ERRTYPE = 0
  &FNCLEVEL = 0
  &FTRACE = 0
  &INPUT = 1
  &LASTNO = 28
  &MAXLNGTH = 3104
  &OUTPUT = 1
  &RTNTYPE = 'RETURN'
  &STCOUNT = 146
  &STLIMIT = 50000
  &STNO = 29
  &TRACE = 0
  &TRIM = 1


  NODE `1
  KEY(DATREE) = '1876'
  DAT(DATREE) = 'BELL A G :      TELEPHONE'
  PRED(DATREE) = NODE `5
  SUCC(DATREE) = NODE `3

  NODE `2
  KEY(INVRTREE) = 'BELL A G :      '
  DAT(INVRTREE) = '1876  TELEPHONE'
  SUCC(INVRTREE) = NODE `4

  NODE `3
  KEY(NODE `3) = '1896'
  DAT(NODE `3) = 'MARCONI G :     RADIO'
  PRED(NODE `3) = NODE `11
  SUCC(NODE `3) = NODE `7







         MACRO SPITBOL V3.5
                                                   PAGE 64 - [10.2]
         Specimen Programs

  NODE `4
  KEY(NODE `4) = 'MARCONI G :     '
  DAT(NODE `4) = '1896  RADIO'
  PRED(NODE `4) = NODE `6
  SUCC(NODE `4) = NODE `8

  NODE `5
  KEY(NODE `5) = '1609'
  DAT(NODE `5) = 'GALILEO :       TELESCOPE'
  SUCC(NODE `5) = NODE `9

  NODE `6
  KEY(NODE `6) = 'GALILEO :       '
  DAT(NODE `6) = '1609  TELESCOPE'
  PRED(NODE `6) = NODE `12

  NODE `7
  KEY(NODE `7) = '1903'
  DAT(NODE `7) = 'WRIGHT O & W :  POWERED FLIGHT'

  NODE `8
  KEY(NODE `8) = 'WRIGHT O & W :  '
  DAT(NODE `8) = '1903  POWERED FLIGHT'
  PRED(NODE `8) = NODE `10

  NODE `9
  KEY(NODE `9) = '1835'
  DAT(NODE `9) = 'TALBOT W F :    PHOTOGRAPHY'

  NODE `10
  KEY(NODE `10) = 'TALBOT W F :    '
  DAT(NODE `10) = '1835  PHOTOGRAPHY'

  NODE `11
  KEY(NODE `11) = '1896'
  DAT(NODE `11) = 'DIESEL R :      DIESEL ENGINE'

  NODE `12
  KEY(NODE `12) = 'DIESEL R :      '
  DAT(NODE `12) = '1896  DIESEL ENGINE'


















         MACRO SPITBOL V3.5
                                                   PAGE 65 - [10.3]
         Specimen Programs



 10.3  Program 3
 10.3  Program 3
 _____________ _

    This  program reads a set of keywords and then processes a file in
    order to count the number of occurrences of the  keywords  in  the
    text  held  in the file.  Notice the simple method of making input
    and output associations to the various input and output  files  in
    statements  2,  3  and  4.   A  table  created  in  statement 7 is
    initialised with the keywords at statement 8.   The  pattern  used
    to  break out words is written out of line since this ensures that
    matching in the inner loop at label WORDLOOP executes  at  maximum
    speed.   In a similar application where an in-line pattern must be
    used (e.g. if the string value  of  PUNCTUATION  were  subject  to
    change  during  execution),  then  the  statement  would  best  be
    written using deferred expressions as

      WORDLOOP INP BREAK(*PUNCTUATION) . WORD SPAN(*PUNCTUATION) =

    since,  being  constant,  the  pattern  can  be  pre-evaluated  at
    compile  time.   This saves repeatedly building the pattern in the
    loop, leaving only the necessary processing of the current  string
    in  PUNCTUATION  as  additional  work to be done compared with the
    version in  the  program.   The  searching  for  and  counting  of
    keywords  in statement 11  is done using the inherently efficient,
    system-provided hashing capability  of  the  TABLE  datatype.   To
    economise  in  table  lookups,  the  table  entry is assigned to a
    temporary variable in statement 10  whilst  a  check  is  made  to
    ensure  that  it  is non-null.  The call of CONVERT used to access
    non-null entries in the table does not sort the keys,  so  that  a
    separate  sorting process would be necessary if sorted output were
    required.  A listing of the filed output is given.


























         MACRO SPITBOL V3.5
                                                   PAGE 66 - [10.3]
         Specimen Programs

    Contents of file KEYWDS
    ________ __ ____ ______

    BREEZE
    DAY
    MOON
    OCEAN
    SEA
    SHIP
    SUN
    THE
    TWAS
    WATER

    Contents of file KEYTXT
    ________ __ ____ ______

    THE FAIR BREEZE BLEW, THE WHITE FOAM FLEW,
    THE FURROW FOLLOWED FREE:
    WE WERE THE FIRST THAT EVER BURST
    INTO THAT SILENT SEA.

    DOWN DROPT THE BREEZE, THE SAILS DROPT DOWN,
    'TWAS SAD AS SAD COULD BE;
    AND WE DID SPEAK ONLY TO BREAK
    THE SILENCE OF THE SEA!

    DAY AFTER DAY, DAY AFTER DAY,
    WE STUCK, NOR BREATH NOR MOTION;
    AS IDLE AS A PAINTED SHIP
    UPON A PAINTED OCEAN.

    WATER, WATER, EVERY WHERE,
    AND ALL THE BOARDS DID SHRINK;
    WATER, WATER, EVERY WHERE,
    NOR ANY DROP TO DRINK.

            SAMUEL TAYLOR COLERIDGE


    Contents of file KEYOUT at end of run
    ________ __ ____ ______ __ ___ __ ___

         KEYWORD    NUMBER OF OCCURRENCES
         -------    --------------------

             SUN .  .  .  .  . 0
            MOON .  .  .  .  . 0
            SHIP .  .  .  .  . 1
            TWAS .  .  .  .  . 1
             DAY .  .  .  .  . 4
             SEA .  .  .  .  . 2
             THE .  .  .  .  . 9
          BREEZE .  .  .  .  . 2
           OCEAN .  .  .  .  . 1
           WATER .  .  .  .  . 4





         MACRO SPITBOL V3.5
                                                   PAGE 67 - [10.3]
         Specimen Programs


  P R O G R A M   3                                               PAGE 1

          -PRINT
          -IN80
          *    PROGRAM TO COUNT THE OCCURRENCES OF KEYWORDS IN A PIECE
          *    OF TEXT.  THE SEARCH FOR KEYWORDS IS EFFICIENTLY PERFORMED
          *    BY HASHING INTO A TABLE.
          *
  1                 &ANCHOR = &TRIM = 1
  2                 INPUT(.KEYS,1,'KEYWDS')                     :F(NOFILE)
  3                 INPUT(.INPUT,2,'KEYTXT')                    :F(NOFILE)
  4                 OUTPUT(.OUT,3,)
  5                 PUNCTUATION = " .,;:'!"
  6                 WORDPAT  = BREAK(PUNCTUATION) $ WORD SPAN(PUNCTUATION)
  7                 KEYTABLE = TABLE(31)
          *
          *    LOOP IN WHICH KEYWORDS ARE READ IN AND HASHED INTO KEYTABLE
          *
  8       KEYLOOP   KEYTABLE<KEYS> = 0                          :S(KEYLOOP)
          *
          *    A SPACE IS ADDED TO LINES OF TEXT TO ENSURE MATCH SUCCESS
          *
  9       READLOOP  INP      = INPUT ' '                        :F(CONVERT)
          *
          *    INDIVIDUAL WORDS ARE EXTRACTED BY PATTERN MATCHING
          *
  10      WORDLOOP  INP WORDPAT =
  11                KEYTABLE<WORD> = DIFFER(ENTRY = KEYTABLE<WORD>) ENTRY + 1
  12                DIFFER(INP)                       :S(WORDLOOP)F(READLOOP)
          *
          *    FAILURE POINT
          *
  13      NOFILE    OUTPUT  = 'MISSING INPUT FILE'              :(END)
  14      CONVFL    OUTPUT  = 'NO KEYWORDS FOUND'               :(END)
          *
          *    EXTRACT THE ENTRIES FROM THE TABLE INTO AN ARRAY
          *
  15      CONVERT   A        = CONVERT(KEYTABLE,'ARRAY')        :F(CONVFL)
  16                OUT      = '     KEYWORD    NUMBER OF OCCURRENCES'
  17                OUT      = '     -------    ---------------------'
  18                OUT      =
          *
          *    PRINT THE ENTRIES
          *
  19                 I        = 1
  20      PRINT    OUT   = LPAD(A[I,1],13) DUPL(' . ',5) A[I,2] :F(END)
  21                I        = I + 1                            :(PRINT)
  22      END









         MACRO SPITBOL V3.5
                                                   PAGE 68 - [10.4]
         Specimen Programs



 10.4  Program 4
 10.4  Program 4
 _____________ _

    This program  is  included  merely  to  show  how  errors  may  be
    handled,  use  of  the  -NOFAIL  option  and  the  nature of trace
    output.


    Statement 1 sets the keyword &TRACE to permit printing  of  up  to
    40  lines of trace output and the next two statements indicate the
    items to be traced.  In statement 4 a limit of 10 is  set  on  the
    number  of  errors  to be intercepted and processed by the program
    itself, whilst the destination label in  the  event  of  an  error
    occurring  is  identified  in  the  next statement.  The next line
    contains a syntax error which results in the printing of an  error
    message.   Following  statement  14 is a -NOFAIL control card, the
    effect of which  is  to  cause  generation  of  special  code  for
    subsequent  statements  containing  no conditional goto so that if
    such a  statement  does,  contrary  to  the  implied  expectation,
    actually  fail,  an  error  message  is  produced.  This can be of
    great diagnostic value.   The  output  from  the  run  illustrates
    various  points.   Execution  of  the program was not inhibited by
    the compilation error.  The number of any statement where a  trace
    association  is active is embedded in asterisks and printed on the
    left so that starting with statement 4, we can trace the  flow  of
    control  through the program on account of the trace intercept set
    on the keyword &STCOUNT.  It will be  seen  that  the  compilation
    error  in  statement 6 results in an execution error and that this
    in turn causes a transfer of control to statement  18  where  user
    processing  of  the error message is provided.  At statement 7 the
    ACCESS trace of the INPUT variable produces lines of trace  output
    indicating  the  value  which  it  currently  holds.   The jump to
    statement 10 followed by the STOPTR statement results  in  turning
    off  the  &STCOUNT trace.   An attempt to jump to the non-existent
    label L100 produces a failure,  followed  immediately  by  another
    when  an  attempt is made to form the sum 3 + 'L200'.  The loop at
    statements 16 and 17 reads 10 elements into the array A  and  then
    as  the  array  is  accessed outside its bounds, a statement error
    occurs which is converted  to  a  run  time  failure  because  the
    statement  was  compiled  in  -NOFAIL mode.  Had this not been the
    case the loop could have run for many seconds before  the  integer
    value  in I finally overflowed.  A correct program of course would
    have had a conditional goto such as

                              :F(ARRAY.FULL.OR.DATA.USED.UP)

    in statement 16.  The  failure  terminates  execution  because  at
    statement  13  the  limit  on the number of errors to be tolerated
    was reset to zero.








         MACRO SPITBOL V3.5
                                                   PAGE 69 - [10.4]
         Specimen Programs

    P R O G R A M   4                                              PAGE 1

          -PRINT
          *
          *    PROGRAM TO DEMONSTRATE TRACING AND ERROR HANDLING
          *
  1                 &TRACE   = &ANCHOR = &TRIM = 40
  2                 TRACE(.INPUT,'ACCESS')
  3                 TRACE(.STCOUNT,'K')
  4                 &ERRLIMIT = 10
  5                 SETEXIT(.ERROR)
  6                 STATEMENT , WHICH SHOULD FAIL TO COMPILE
                              ^
  ERROR 223 -- SYNTAX ERROR.  INVALID USE OF COMMA

  7       LOOP                                             :S($INPUT)F(FAIL)
  8       L1        OUTPUT   = '"L1"'                           :(LOOP)
  9       L2        OUTPUT   = '"L2"'                           :(LOOP)
  10      STOPTR    OUTPUT   = 'STOPTR'
  11                STOPTR(.STCOUNT,'K')                        :(LOOP)
  12      FAIL      X        = 3 + INPUT
  13                &ERRLIMIT =
  14                A        = ARRAY(10);     I = 1
          -NOFAIL
  16      READ      A<I>     = INPUT
  17                I        = I + 1                            :(READ)
          *
          *    ERROR INTERCEPT ROUTINE
          *
  18      ERROR     OUTPUT   = 'ERROR NO.  '  &ERRTYPE '  IN STATEMENT'
          .            &LASTNO
  19                OUTPUT   = 'REASON FOR FAILURE :- '  &ERRTEXT
  20                OUTPUT   =
  21                SETEXIT(.ERROR)                             :(CONTINUE)
  22      END


  STORE USED     1279
  STORE LEFT     4558
  COMP ERRORS    1
  REGENERATIONS  0
  COMP TIME-MSEC 400
















         MACRO SPITBOL V3.5
                                                   PAGE 70 - [10.4]
         Specimen Programs

  ****4*******  &STCOUNT = 4
  ****5*******  &STCOUNT = 5
  ****6*******  &STCOUNT = 6
  ****18******  &STCOUNT = 7
  ERROR NO.  7  IN STATEMENT  6
  ****19******  &STCOUNT = 8
  REASON FOR FAILURE :- COMPILATION ERROR ENCOUNTERED DURING EXECUTION
  ****20******  &STCOUNT = 9

  ****21******  &STCOUNT = 10

  ****7*******  &STCOUNT = 11
  ****7*******  INPUT = 'L2'
  ****9*******  &STCOUNT = 12
  "L2"
  ****7*******  &STCOUNT = 13
  ****7*******  INPUT = 'STOPTR'
  ****10******  &STCOUNT = 14
  STOPTR
  ****11******  &STCOUNT = 15
  ****7*******  INPUT = 'L1'
  "L1"
  ****7*******  INPUT = 'L100'


  ERROR NO.  38  IN STATEMENT  7
  REASON FOR FAILURE :- GOTO UNDEFINED LABEL

  ****12******  INPUT = 'L200'
  ERROR NO.  2  IN STATEMENT  12
  REASON FOR FAILURE :- ADDITION RIGHT OPERAND IS NOT NUMERIC

  ****16******  INPUT = '1.111111'
  ****16******  INPUT = '2.2'
  ****16******  INPUT = '3.3'
  ****16******  INPUT = '4.4'
  ****16******  INPUT = '5.5'
  ****16******  INPUT = '6.6'
  ****16******  INPUT = '7.7'
  ****16******  INPUT = '8.8'
  ****16******  INPUT = '9.9'
  ****16******  INPUT = '10.10'


  ERROR 035 -- UNEXPECTED FAILURE IN -NOFAIL MODE

  IN STATEMENT   16
  STMTS EXECUTED 51
  RUN TIME-MSEC  280
  MCSEC / STMT   5490
  REGENERATIONS  0







         MACRO SPITBOL V3.5
                                                   PAGE 71 - [11]
         Implementation Information



                   *---------------------------------*
                     [11] Implementation Information
                   | [11] Implementation Information |
                   *---------------------------------*

    SPITBOL  is  implemented  on  a   wide   variety   of   computers.
    Condsiderable  efforts have been made to achieve compatibility and
    portability between versions but inevitably  there  are  features,
    values  or  limitations  particular  to each implementation.  This
    section gives details for the VAX/VMS implementation.

    Note that version BCAB-2132  of  SPITBOL  or  higher  requires  at
    least VMS version 2.


 11.1  &CODE
 11.1  &CODE
 ___________
    The  default  value  for  &CODE  in  VAX/VMS SPITBOL is one.  This
    avoids a "successful completion" message  from  VMS  which  occurs
    when &CODE is zero on exit.

    The  value  of  &CODE  is  used on exit as the return code to VMS.
      There are two exceptions:

    - &CODE = 998 will print a message on termination  to  the  effect
      that the standard output channel is not available.

    - &CODE  =  999  will print a message on termination to the effect
      that execution was suppressed  (either  via  startup  switch  or
      control card).

    The  VMS message number 196648 corresponds to "CLI-F-ABORT" and is
    useful to signal general program failure  to  the  command  stream
    via $STATUS/$SEVERITY.


 11.2  &ERRTEXT
 11.2  &ERRTEXT
 ______________
    The  initial  value  of &ERRTEXT contains the startup command line
    text, excluding the command name and any trailing  comment.   When
    reloading  from  a saved EXIT(n) file, if the value of n was -2 or
    -1, the new command line will replace the value of &ERRTEXT.


 11.3  &STLIMIT
 11.3  &STLIMIT
 ______________
    The default value for &STLIMIT is one billion.  Maximum  value  is
    2,147,403,647.   Note  that statement counting and checking can be
    disabled by setting the value of &STLIMIT to -1.











         MACRO SPITBOL V3.5
                                                   PAGE 72 - [11.4]
         Implementation Information

 11.4  &TRIM
 11.4  &TRIM
 ___________
    Records are never implicitly padded with blanks  on  output.   For
    input,  any  trailing  blanks  received depend on the file and the
    value of &TRIM.


 11.5  Buffers
 11.5  Buffers
 _____________
    VAX/VMS  SPITBOL  contains  an  additional  datatype  called   the
    BUFFER.   This  is  described  in  the  section  on datatypes.  In
    addition, new functions BUFFER, INSERT and APPEND have been  added
    to  support  buffers.   These functions are described in detail in
    Section 5.














































         MACRO SPITBOL V3.5
                                                   PAGE 73 - [11.6]
         Implementation Information



 11.6  Character Set for VAX/VMS SPITBOL
 11.6  Character Set for VAX/VMS SPITBOL
 _______________ ___ ___ _______ _______

    Character codes can  be  a  considerable  locus  of  confusion  in
    SPITBOL.   The  SNOBOL4  language  does  not  define  a "standard"
    graphic set, so in general an attempt has been made to conform  to
    the   original  IBM/360 EBCDIC symbology where possible (excluding
    the 'extended graphics').  This is the character style most  often
    used in references and manuals.

    The  point where this is most likely to cause problems is with the
    binary   bar   (alternation),   which   in   many   other    ASCII
    implementations  is  the exclamation point.  Such programs as make
    use of this convention must be editted -  OPSYN cannot be used  to
    redefine  a  system  operator's  semantics in MACRO SPITBOL.  Note
    also that the unary not-sign may be different.

    The correspondence between the  SNOBOL4 and VAX/VMS Macro  SPITBOL
    source program character set is as follows:

    Character Name
    _________ ____
                        IBM SNOBOL4
                        ___ _______
                                       VAX/VMS SPITBOL
                                       _______ _______

    Digits
                        0..9
                                       0..9
    Letters
                        A..Z
                                       A..Z a..z
    Left Parenthesis
                        (
                                       (
    Right Parenthesis
                        )
                                       )
    Left Angle Bracket
                        <
                                       < or [
    Right Angle Bracket
                        >
                                       > or ]
    Colon
                        :
                                       :
    Semicolon
                        ;
                                       ;
    Comma
                        ,
                                       ,
    Equal Sign
                        =
                                       =
    Double Quote


         MACRO SPITBOL V3.5
                                                   PAGE 74 - [11.6]
         Implementation Information

                        "
                                       "
    Single Quote
                        '
                                       '
    Negation
                        <Not-Sign>
                                       ~
    Query
                        ?
                                       ?
    Dollar Sign
                        $
                                       $
    Point
                        .
                                       .
    Exponentiation
                        **
                                       ** or !
    Percent
                        %
                                       %
    Asterisk
                        *
                                       *
    Divide
                        /
                                       /
    Plus
                        +
                                       +
    Minus
                        -
                                       -
    At
                        @
                                       @
    Blank
                        <Blank>
                                       <Blank> or <Tab>
    Alternation
                        |
                                       |
    Number Sign
                        #
                                       #
    Ampersand
                        &
                                       &
    Underscore
                        not avail.
                                       _





         MACRO SPITBOL V3.5
                                                   PAGE 75 - [11.7]
         Implementation Information



 11.7  Form of DATE String
 11.7  Form of DATE String
 __________ __ ____ ______
    DATE() returns an 22 character string of the form:

                          MM-DD-YYYY HH:MM:SS.CC

                                                           M      D
    These  wall-time  components  designate  respectively: _onth, _ay,
    Y     H     M       S                      C
    _ear, _our, _inute, _econd and Hundredths (_enti-) seconds.


 11.8  Errors
 11.8  Errors
 ____________
    In addition to the errors  issued  by  the  interpreter,  the  VMS
    interface  may  detect a number of conditions which it will report
    using the default VMS condition handler.

    There follows the list of SPITBOL's VMS-specific errors,  and  the
    severity  of  the  error.  Errors which have a severity of warning
    or less can be suppressed  with the /NOWARN startup  command  line
    switch.   (An  exception are the messages generated as a result of
    an exception caused by a LOADed function image.)   Errors  with  a
    listed  severity  of "Severe" will generally cause execution to be
    aborted  with  the  DCL   $STATUS  and   $SEVERITY   symbols   set
    appropriately.   Although  more  messages  may  be  added  in  the
    future, existing message symbols and values will not.


     Error Name    Severity          Description

     EXIT           Info     EXIT Module Saved - <Filename>

     EXSUP          Info     Execution Suppressed

     INSVIRMEM      Severe   Insufficient Virtual Memory
       This can occur if the value specified on the /MINT switch, or
    if
       the value of the system VIRTUALPAGECNT parameter is too low (it
       should generally be at least 4000.)

     LINETRUNC      Warning  Input Source Line Truncated

     LOADCRC        Severe   Load Incompatible, Please Retranslate
    Source
       SPITBOL has been modified since the EXIT(-n) module was saved.

     LOADMEM        Severe   <No longer used>

     LOADOPEN       Severe   Can't Open LOAD File - <Filename>

     LOADMAP        Severe   Error Mapping LOAD File - <Filename>

     LOADUNEXCOND   Warning  Loaded Function Failed To Handle
                               Condition At PC=<Hex PC>
       An external LOADed function was invoked and generated an
    exception
       condition which it did not handle.  Check to see that the image


         MACRO SPITBOL V3.5
                                                   PAGE 76 - [11.8]
         Implementation Information

       base address was properly specified.

     LOADUNEXTRY    Warning  Will Attempt to Recover By Forcing
    Failure
       A loaded function was unable to return an acceptable result, so
       SPITBOL attempts to continue execution by simulating failure.

     LOADVERS       Severe   Load Versions Incompatible,
                               Please Retranslate Source
       The version of SPITBOL used to save an EXIT(-n) module was not
       the same as the one being used to load it.

     NOSYSOUT       Severe   Output File Not Accessable
       The /LIST= or /OUT= device/file could not be opened for
    writing.

     NOTEXITMOD     Severe   File is Not a Saved EXIT File -
    <Filename>
       The file implied or specified by /LOAD was not a saved SPITBOL
       EXIT(-n) file.

     OPENOUT        Severe   Error Opening <Filename> as Output

     OPENIN         Severe   Error Opening <Filename> as Input

     PAUSE          Info     Paused at Statement <Stmt #>
       This is issued as a consequence of executing an EXIT(0).  Enter
       CONTINUE to resume execution.

     STACKOVFL      Severe   Virtual Stack Space Exhausted
       This is a severe stack overflow which will not be seen (SPITBOL
       will issue its own stack overflow through the standard error
       handling mechanism) unless SPITBOL is improperly linked.

     SYNTAX         Severe   Syntax Error In Command Line

     BADLINK        Severe   Incorrectly specified BASE(s) in SPITBOL
    link
       The symbol LOAD_BASE is higher than the start of the
    interpreter
       (BASE=) or STACK_LIMIT is too close to LOAD_BASE.

     LOADBADINT     Warning  Loaded function returned invalid
                               integer result pointer

     LOADBADREAL    Warning  Loaded function returned invalid real
                               number result ptr

     LOADBADSTRING  Warning  Loaded function returned invalid string
                               descriptor

     LOADBADUNCONV  Warning  Loaded function returned bad block for
                               unconverted result





         MACRO SPITBOL V3.5
                                                   PAGE 77 - [11.9]
         Implementation Information



 11.9  EXIT Function Usage
 11.9  EXIT Function Usage
 __________ ________ _____
    The EXIT  function  has  been  implemented  in  all  forms  except
    positive  integer  arguments  (that  is  to say, there is no total
    image save).  Each of the forms is described below.


 11.9.1  EXIT(0) Usage
 11.9.1  EXIT(0) Usage
    EXIT(0) will pause the program with a message;  a  DCL  "CONTINUE"
    command  will  continue  execution.  The message can be suppressed
    with the /NOWARN command line option.


 11.9.2  EXIT(String) Usage
 11.9.2  EXIT(String) Usage
    EXIT(string) will cause SPITBOL  to  exit  and  "string"  will  be
    given  to  the command interpreter as the next command.  Note that
    this subsumes the normal SPITBOL  semantics  of  EXIT(string)  for
    chain  execution  if the string is of the form "RUN image".  It is
    also possible to initiate a command file  (including  one  written
    by   the   program   itself)   if  the  string  is  of  the  form:
    "@command-file".


 11.9.3  EXIT(-n) Usage
 11.9.3  EXIT(-n) Usage
    EXIT(-n) is implemented, and will save the impure segments of  the
    interpreter  in  a  specially formatted block mode file.  The name
    for this file is the same as the  standard  input  file,  with  an
                      S       EX
    extension ".SEX" (SPITBOL EXit!) under the default directory.   If
    such  a  file already exists, it will be reused (with an extension
    of space if required), otherwise a new file  is  allocated.    The
    startup   switch   "/LOAD[=filename]"   can  be  used  to  load  a
    previously saved .SEX file.  If the "=filename" is  not  specified
    on  the  load, the default LOAD name is the same as that described
    above.  Specification of  /LOAD  does  not  obviate  the  need  to
    specify  a standard input file, although it need not have the same
    name as the save file,  and trivially could be "NL:" if no use  is
    to be made of the standard input channel.

    Certain  remarks are in order regarding this form of EXIT.  When a
    previously saved .SEX file is loaded, SPITBOL  performs  a  number
    of  fairly  extensive  checks to verify that the segment was saved
    under the same version of SPITBOL that is being used to  load  it.
    If  it is not, the load will not work and one of a number of fatal
    errors will be issued.  The conclusion should  be  that  the  file
    created  by  EXIT  is not really analogous to a "permanent" object
    or executable binary.   The  original  source  and  data  must  be
    retained in the event that a retranslation is indicated.

    One  other point should be noted as regards EXIT(-n).  Neither the
    status of open files, nor the contents of LOAD(...)  functions  is
    preserved  across  an  EXIT(-n);  this includes the standard input
    and output files, which are instead associated anew when the  exit
    module  is reloaded using the filenames given on the /LOAD startup
    line.   In general, INPUT(...), OUTPUT(...)  and  LOAD(...)  calls
    must  be  made  after  the  call  to  EXIT(-n).   In addition, the


         MACRO SPITBOL V3.5
                                                   PAGE 78 - [11.9.3]
         Implementation Information

    load-time  values  (default  or  explicit)  of  /MINC  and   /MINT
    override  whatever  values were in effect when the exit module was
    saved (SPITBOL will, however,  always  attempt  to  obtain  enough
    virtual  space  to  hold  the  impure  data  of  the  exit module,
    regardless of the setting of /MINT.)  If the EXIT(-1) or  EXIT(-2)
    forms  are  used,  then  the load-time values of the other startup
    command line switches override the  values  at  the  time  of  the
    EXIT.


 11.10  FENCE(PATTERN)
 11.10  FENCE(PATTERN)
 _____________________
    VAX/VMS  SPITBOL contains an additional intrinsic pattern matching
    function called FENCE.  This function is described  in  Section  5
    in detail.


 11.11  HOST
 11.11  HOST
 ___________
    The  only defined entry to HOST is when all arguments are null, in
    which case, HOST() returns the identifying string of the form:

                  VAX:VMS:sitename:username:accountname

    "Sitename" is derived from  a  translation  of  the  logical  name
    "SYS$SITENAME"  to  obtain  a  site name both for HOST and for the
    banner.  The translated string must be 28 or fewer characters.


 11.12  Range of Integers
 11.12  Range of Integers
 ____________ __ ________
    Integers are represented in a single  VAX  32-bit  longword.   The
    range for integers is: [ -2,147,483,648 , +2,147,483,647 ].




























         MACRO SPITBOL V3.5
                                                   PAGE 79 - [11.13]
         Implementation Information



 11.13  INPUT/OUTPUT
 11.13  INPUT/OUTPUT
 ___________________
    All  VAX/VMS  Macro  SPITBOL  I/O is processed through RMS (Record
    Management Services).  The general form of the  INPUT/OUTPUT  call
    in Macro SPITBOL is:

                      XXXPUT(Var,Filearg1,Filearg2)

    "Filearg1"  may  be any Macro SPITBOL object that can be converted
    to a name (e.g. number or string).  It has no significance to  the
    I/O  system  as  such,  however  it represents a unique binding to
    this I/O channel,  and it can thus be used in subsequent calls  to
    INPUT,  OUTPUT,  REWIND,  ENDFILE and EJECT.  If Filearg1 is null,
    an INPUT call refers to the standard  input  channel  association,
    and  an  OUTPUT  call  similarly  refers  to  the  standard output
    channel.   It  is  permitted  to  reassign  these   channels   via
    INPUT/OUTPUT,  but note that SPITBOL does not allow null arguments
    to REWIND or ENDFILE.

    "Filearg2" differs slightly from the form shown in Section  5  for
    the INPUT and OUTPUT functions, and has the form:

                       "Filespec/Switch/Switch/..."

    where  all  components,  including  "Filespec"  are  optional.  If
    Filespec is given, the current channel (if any) is closed out  and
    a  new  association  to the given Filespec is created.  "Filespec"
    is  given   in   standard   VMS/RMS   form   for   a   device/file
    specification.   If  the  Filespec  is  omitted  then any switches
    specified are processed  for  the  association,  but  the  present
    association  to  the  channel  remains  unchanged.   If the entire
    Filearg2 is null, then this  reduces  to  simply  I/O  associating
    "Var" to the channel designated by Filearg1.

    Any  given "Filearg1" channel can be associated for both INPUT and
    OUTPUT, however any such dual associations must  be  formed  prior
    to  opening  the  channel  in order to avoid an RMS error when the
    channel is used in a  manner  for  which  is  was  not  originally
    opened.   A  channel  is opened for I/O activity indirectly due to
    the first I/O reference to it.  The call to  INPUT  or  OUTPUT  by
    itself  causes no I/O activity, but only establishes the nature of
    the variable-to-channel and channel-to-file associations that  can
    be   used  later.   The  first  I/O  reference  to  a  channel  or
    channel-associated variable causes either an OPEN or CREATE to  be
    issued.   The  OPEN  (an existing file) is issued unless an OUTPUT
    association to the channel has been made, in which case  a  CREATE
    (new  file)  will  be issued.  The occurrence of some switches can
    modify this default action.

    Note that all I/O sequential in nature; the default mode  of  file
    creation  is  variable-length,  carriage  return  delimited record
    attributes.   It is possible to  process  existing  indexed  files
    transparently  through RMS, however, sequential access is the only
    processing   mode   available,   regardless    of    the    file's
    characteristics.


         MACRO SPITBOL V3.5
                                                   PAGE 80 - [11.13.1]
         Implementation Information



 11.13.1  FILEARG2 SWITCHES
 11.13.1  FILEARG2 SWITCHES
    The   following   switches  are  available  for  specification  on
    Filearg2.  They must be specified in upper-case.  In  many  cases,
    it  is  possible  to  precede  the  switch name by the prefix "NO"
    which indicates that the condition indicated by the switch  is  to
    be  inverted  for  this channel.  For switches which apply only to
    terminal I/O, their presence is ignored when  dealing  with  other
    devices or files.

        SWITCH           _ _ _ _ _ _ _ _ _ _ _
        ______           D_E_S_C_R_I_P_T_I_O_N

         /CCO   Cancel   terminal   control  O  on  subsequent  output
                operations.
         /CIF   If  the  named  file  already  exists,  it  is   used.
                Otherwise,  a  new  file  is created.  Note that if an
                existing  sequential  variable-length  file  is  being
                processed,  /EOF  must  also  be  specified  since RMS
                cannot  rewrite   records   in   such   files.    This
                restriction does not apply to indexed files.
         /CR    Set  CR/LF  file  attributes  for  CREATE  operations.
                Note that an  output  association  to  "TT:/-CR"  will
                thus  suppress the usual carriage return and line feed
                after each output assignment to the terminal.
         /DLT   Delete the file when it is closed.
         /EOF   Position  to  end-of-file  on  open.   If  an   OUTPUT
                association  has  been made, the presence of /EOF will
                cause an OPEN to be issued rather than a CREATE.
         /FTN   Set  FORTRAN-type  carriage  control  attributes   for
                CREATE.   This  switch  is mutually exclusive with the
                "CR" switch.
         /MXV   Maximize the version number of the file  on  a  CREATE
                between  any specified version and one higher than the
                highest existing verion.
         /PTA   Purge the terminal type-ahead  buffer  for  subsequent
                terminal input on this channel.
         /RNE   For  a  terminal  input-associated channel, subsequent
                input is not to be echoed.
         /RNF   For terminal-associated  input,  control-U,  control-R
                and  DELETE  characters are passed in the input string
                and are not taken as control characters.
         /SCF   Submit this file to the system standard  batch  stream
                when it is closed.
         /SPL   Submit  this  file  to the system standard spool queue
                when it is closed.
         /SUP   Supercede any existing file on CREATE.
         /TEF   Truncate the file to actual EOF when it is closed.










         MACRO SPITBOL V3.5
                                                   PAGE 81 - [11.13.2]
         Implementation Information



 11.13.2  I/O EXAMPLES
 11.13.2  I/O EXAMPLES
    Here are a few examples of INPUT/OUTPUT calls.  The  colons  (":")
    represent code sequences which are not shown.

    1. Attach  the user's terminal for input without echoing the first
       line read in.

            INPUT(.TTNE,1,'TT:/RNE')
                     :
            FIRST_LINE = TTNE
            INPUT(.TTNE,1,'/NORNE')
                     :


    2. Write  to  a  new  file  OUT.DAT  and  spool  it  when  SPITBOL
       terminates.

            OUTPUT(.OUTFILE,1,'OUT.DAT/SPL')


    3. Write  to  an  intermediate  file, then rewind it, read through
       it, and delete it.

            INPUT(.INTER,1,'SCRATCH.DAT/DLT')
            OUTPUT(.INTER,1)
                    :
       WRITELOOP
            INTER = X
                    :
            REWIND(1)
       READLOOP
            X = INTER   :F(EXIT)
                    :
       EXIT
            ENDFILE(1)
       END


    4. Append the record "***END***" to an existing file:

            OUTPUT(.OLDFILE,1,'OLDFILE.DAT/EOF/CIF')
            OLDFILE = '***END***'
       END













         MACRO SPITBOL V3.5
                                                   PAGE 82 - [11.14]
         Implementation Information



 11.14  Linking SPITBOL
 11.14  Linking SPITBOL
 ______________ _______


    SPITBOL is delivered pre-linked and ready for use.  Some sites  or
    users  may  wish  to  link their own copies.  Modifications to the
    source are not encouraged, as it renders much more  difficult  the
    process  of  diagnosing  trouble  reports.  If trouble reports are
    submitted, the implementor requests that the original,  unmodified
    interpreter be used to provide the necessary information.

    The normal link command is:

         $
         _ LINK/SYMB=SYS$SYSTEM:SPITBOL/EXE=SYS$SYSTEM:SPITBOL -
         $
         __     SYS$LIBRARY:SPITBOL/OPT

    The recommended SPITBOL.OPT linker options file is:

         SPITV35,SPITGO,SPITMSGS,SPITSYS,SPITIOSYS,-
         SYS$SYSTEM:SYS.STB/SELECT
         BASE=%X100000
         IOSEGMENT=128
         STACK=10
         SYMBOL=LOAD_BASE,%X7FE00
         SYMBOL=STACK_LIMIT,%X10000

    Note  that  VAX/VMS  SPITBOL  is  a  licensed product and sources,
    objects and executable images are for use only  on  the  system(s)
    where  the  license  applies.   This applies both to the delivered
    files as well as any modified versions of them.


 11.15  Terminal Listing Options
 11.15  Terminal Listing Options
 _______________ _______ _______
    If  the  standard  output  channel  is  a  terminal   device,   an
    abbreviated  listing  format  is  used  by default.  See below for
    details.





















         MACRO SPITBOL V3.5
                                                   PAGE 83 - [11.16]
         Implementation Information



 11.16  LOAD Function Usage
 11.16  LOAD Function Usage
 ___________ ________ _____
    The LOAD function is implemented with the  general  philosophy  of
    permitting  a  true  dynamic  load  of  externally  linked  images
    without  any  necessity  for  resorting  to  MACRO-32  or  similar
    machine-level  coding.  The first argument to LOAD is as described
    in Section 5.  The second argument  string  is  the  name  of  the
    image  to  be  loaded.   The usual defaults (those of the process)
    apply to this  name;   the  default  extension  is  ".EXE".   This
    string  should  never  be null, that form is reserved for a future
    implementation of a static LOAD.

    The  general  process  for  creating  a  LOADable  image  can   be
    summarized as follows:

      1. Prepare  and  debug  the  external  subroutine(s) you want to
         link into  a  loadable  function.   The  code  should  be  as
         thoroughly   checked   out  as  possible.    Debugging  under
         control of SPITBOL is difficult, and in extreme  cases,  bugs
         can  corrupt  the  interpreter's  store,  making them all but
         impossible to locate.

         Any language(s) can  be  used  to  program  the  subprograms,
         however  users of high-level languages usually need to follow
         some special guidelines (see below).

      2. Link an image consisting of the modules required.  The  image
         must  be  linked  at  a  suitable base address if it contains
         positionally dependent content (see below).  The link  should
         incorporate  a  search  of  SPITBOL's  symbol  table to avoid
         duplication of  the  run-time  library  in  the  image's  own
         virtual  space.   The  image  must  have  a  defined transfer
         address in user space.

      3. Run the  SPITBOL  program  and  issue  the  LOAD  call.   The
         function can now be used as an ordinary SPITBOL function.

    Details on each of these steps follow.



















         MACRO SPITBOL V3.5
                                                   PAGE 84 - [11.16.1]
         Implementation Information



 11.16.1  High-Level Languages and LOAD
 11.16.1  High-Level Languages and LOAD
    Images  invoked  by  LOAD are not entered via the image activator.
    Instead,  SPITBOL  gets  to  them  via   an   ordinary   CALL-type
    instruction  to  the  entry  point  of  the image.  Note that most
    "high-level  languages"  do  not  support  the  declaration  of  a
    parameterized subprogram as an image entry point.

    To  permit  the use of such languages for LOAD functions, a module
    to solve the problem just described is provided with  the  SPITBOL
    delivery  in  SYS$LIBRARY:SPITHLS.OBJ.   This  module  defines  an
    entry point, and  then  jumps  one  word  past  the  global  label
    SPIT$LOAD_ENTRY.   (The  one  word  is  to  bypass the procedure's
    register save mask.)  This means that the entry subprogram of  any
    LOADable   function    which   uses   SPITHLS.OBJ  must  be  named
    SPIT$LOAD_ENTRY.


 11.16.2  Calling Conventions for LOAD
 11.16.2  Calling Conventions for LOAD
    All  arguments  to  LOAD  are  transmitted  to  the  function   by
    reference  pointers  to  values  on the stack (in P1 space).  (The
    only exception  is  unconverted  arguments  which  are  passed  by
    reference  to  a  block  in SPITBOL's dynamic area.)  The function
    may  overwrite  these  stacked  values  freely,  since  they   are
    discarded  when  the  function  returns.   It goes without further
    comment that in no case should an attempt ever be  made  to  store
    outside the defined length of the value.

    If  a  LOADed function requires a dynamically sized memory area to
    work in, the LOAD prototype can specify a 'junk'  parameter  which
    can  be  a  string  of the appropriate length when the function is
    called.  LOADed functions should under  no  circumstances  attempt
    to  dynamically  map  their  own  virtual  memory since this would
    likely interfere with SPITBOL's own allocation process.

    It may, for  some  applications,  be  helpful  to  be  aware  that
    arbitrary binary data can be stored in strings and buffers.


 11.16.3  Return Conventions for LOAD
 11.16.3  Return Conventions for LOAD
    When  an  external  function  is  ready  to  return, it may signal
    success or  failure,  and  if  it  succeeds,  it  must  return  an
    appropriate  result  of  the  type described by the LOAD prototype
    for the function.

    Success or failure is indicated on return by the low order bit  of
    R0,  according  to the normal VAX/VMS convention (the remainder of
    the register is ignored).

    If the low bit of R0 is set on  return,  this  indicates  success,
    and  R1  points  to  an  integer  value,  real  value,  or  string
    descriptor as appropriate for the function.   This  is  the  value
    that will be returned to SPITBOL as the result of the call.




         MACRO SPITBOL V3.5
                                                   PAGE 85 - [11.16.3]
         Implementation Information

    Many   high-level   languages   do  not  have  the  capability  of
    returning  values  in  this  manner,  so   SYS$LIBRARY:SPITHLS.OBJ
    contains  two  additional  entry  points, SPIT$SUCCESS_RETURN(obj)
    and SPIT$FAIL_RETURN().  These are co-routine  entry  points  that
    can  be called using the VAX/VMS standard calling conventions, and
    will make adjustments to the  stack,  R0  and  R1  and  return  to
    SPITBOL.   "Obj" is the address of the returned value when success
                                                        must
    is  to  be  indicated.   Both of these entry points must be called
    from the same level as when the function was  originally  entered,
    that  is,  at the same point in execution where the function would
    normally return.

    Before the LOADed function is invoked, and also  when  the  result
    is  being  checked,  SPITBOL  establishes a condition handler that
    will receive control if any exceptions  occur.   These  exceptions
    typically  are  the result of an error in the function itself,  an
    improper specification of argument or result  types  in  the  LOAD
    call,    or  an  improper  link  of a non-PIC function (see below)
    causing invalid addresses to  be  returned  to  SPITBOL.   In  any
    event,  this handler will, after printing a message indicating the
    cause of the error, attempt recovery by  forcing  failure  of  the
    function  call.   This  will  generally allow SPITBOL execution to
    continue.  Note that this handler will  only  receive  control  in
    the  event  that  the  user's function does not properly field the
    condition itself.


 11.16.4  Linking External Functions
 11.16.4  Linking External Functions
    Like the old saw  about   how  to  shave  a  gorilla,  linking  an
                                         very
    function image for LOAD must be done ____ carefully.  As  a  rule,
    you  will  have  an  easier  time  of it if the image to be linked
    contains solely position independent content  (PIC),  though  this
    is not absolutely necessary.

    SPITBOL  reserves a set of pages between an address defined by the
    link-time symbol LOAD_BASE, and the bottom of the interpreter  for
    loading  images.    LOAD_BASE  is  defined in the SPITBOL.OPT link
    options file and is normally hex 7FE00

    When requested by a LOAD(...) call  to  load  an  external  image,
    SPITBOL  first  allocates the next available page in this area for
    image information, and maps the image itself directly  above  this
    page,  taking  as  many  pages  as required.  The base address (if
    any) specified to the linker when the image was generated  has  no
    effect  on the base address of the load.   So even if the image is
    not PIC, it is possible to predict  in  advance  where  the  image
    will  be  loaded.  Knowing this, the image can be linked with this
    location as the  base  address.   Note  that  if  several  non-PIC
    images  are to be loaded with different LOAD(...) calls, the order
    of the loading is significant.

    As an example, suppose you have an object module called  PROCSTATS
    produced  by VAX/VMS Fortran V2 (non-PIC) which you wish to use as
    a LOAD function.  You would link the image with a  linker  command
    such as:



         MACRO SPITBOL V3.5
                                                   PAGE 86 - [11.16.4]
         Implementation Information

           $ LINK/MAP PROCSTATS,SYS$LIBRARY:SPITHLS,-
             SYS$SYSTEM:SPITBOL/SELECTIVE_SEARCH,PROCSTATS/OPT

    The  reason for linking against SPITBOL's symbol table is to avoid
    including the VMS shareable run-time library  in  the  image.   In
    some  cases,  there will also be global symbols of interest in the
    interpreter  to  which  the  program  will   need   access.    The
    PROCSTATS.OPT  options  file  would contain at least one statement
    to  define  the  base  address  of  the   image   of   the   form:
    "BASE=%X80000".    This  is  one  page  above  the usual LOAD_BASE
    (%X7FE00) to leave room for the image data page  which  is  always
    allocated first by SPITBOL.

    If  additional  non-PIC images were to be linked, the total amount
    of virtual space used by images to be loaded first would  have  to
    be  calculated,  in  order  to  determine  the  actual load (base)
    address. For images which are entirely PIC, the  base  address  is
    irrelevant.   Note that for languages such as Fortran, the code is
    PIC but the pure data is not.


 11.16.5  Unconverted Values and Results for LOAD
 11.16.5  Unconverted Values and Results for LOAD
    If a type other than "INTEGER", "STRING", or "REAL"  is  indicated
    in  the  first  argument of the call to LOAD, the value is said to
    be "unconverted."

    In the case of passed arguments, a pointer to the  internal  block
    for  the  argument is given to the program.  The first longword of
    any such block is a SPITBOL block-type  word.   The  remainder  of
    the  block  is vertically encoded depending on the block-type.  No
    discussion of the internals of the interpreter are provided  here.
    The  source  listing  gives  a complete description of the storage
    blocks  for  SPITBOL   and   should   be   consulted   by   anyone
    contemplating using unconverted values.

    In  the  case  of  returned  values,  a pointer to the unconverted
    result must  be  in  R1  (returned  value  register).   The  block
    pointed  to must be in SPITBOL-correct format, including the value
    of the block-type  word.   It  will  be  copied  by  SPITBOL  into
    dynamic memory upon return.


















         MACRO SPITBOL V3.5
                                                   PAGE 87 - [11.17]
         Implementation Information



 11.17  MXLEN
 11.17  MXLEN
 ____________
    The   value   of   MXLEN  is  approximately  1,000,000.   This  is
    controlled by the "BASE=..." option  in  the  SPITBOL.OPT   linker
    options  file.   It is not recommended that this value be reduced,
    as it will limit the size  of  objects,  and  reduce  the  virtual
    space available for mapping in external (LOAD) images.


 11.18  Real Arithmetic
 11.18  Real Arithmetic
 ___________ __________
    Available  in  single  precision  with  a  printing  accuracy of 6
    digits.


 11.19  Extended Character Set
 11.19  Extended Character Set
 _______________ _________ ___
    All 256 8-bit ASCII codes are in  &ALPHABET.   The  tab  character
    may be used lexically in place of the space.


 11.20  REWIND
 11.20  REWIND
 _____________
    Available.


 11.21  Running SPITBOL
 11.21  Running SPITBOL
 ______________ _______


    SPITBOL  must  be  started with a command line in order to specify
    filenames for the standard channels, and  to  explicitly  override
    any  default  processing options.  This means that SPITBOL must be
    installed as a foreign command so that it can  recieve  a  command
    line.   If  SPITBOL  has  not been installed as a foreign command,
    this can be done individually by the  user  by  entering  the  VMS
    command:

                         $
                         _ SPIT*BOL :== $SPITBOL

    The  system  manager  normally  adds  this to the systemwide login
    command file as a part of the SPITBOL  delivery  process,  so  the
    above should not be necessary.

    The general form of the SPITBOL startup command line is:

            $ SPITBOL/switch... input-file/switch... "Any Text

    The  input-file  sets  the  identity of the standard input channel
    for SPITBOL.   The default extension  for  this  file  is  ".SPT".
    The  standard input channel represents the program source, and any
    data for  the  preassociated  INPUT  variable.   Such  data  input
    should  thus  immediately  follow the END statement of the source.
    All switches are optional.

    If no input-file is given, or  if  SPITBOL  is  unable  to  get  a
    command line, the default input-file will be SYS$INPUT.




         MACRO SPITBOL V3.5
                                                   PAGE 88 - [11.21]
         Implementation Information

    The  initial  value of the startup command line as provided by the
    VMS Command Line Interpreter (CLI) is  assigned  to  the  &ERRTEXT
    keyword.  This makes it possible to examine the command line as it
    is given to SPITBOL, in order  to  determine  filenames,  switches
    and  the like.   (The assignment to &ERRTEXT is made just prior to
    execution, and is  not  affected  by  any  preceeding  compilation
    errors.)   Note that the CLI will compress runs of tabs and blanks
    into single blanks, and place all unquoted  text  in  upper  case.
    Also  note that the command string begins with the first non-blank
               following
    character  _________  the VMS command name.   CLI "comments" (text
    following an unquoted "!" on the  command  line)  are  not  passed
    either.

    SPITBOL  recognizes  a  double-quote (") as an end-of-command line
    delimiter.  Any text following the double-quote  will  be  ignored
    by  SPITBOL,  but  will  appear  intact  in  the  initial value of
    &ERRTEXT.  This provides a mechanism for  passing  arbitrary  text
    into  the  program  from the command line.  The CLI will not alter
    the text following this double quote.

    It should be pointed out that the availability of startup  command
    line  text  in  &ERRTEXT is an addition in VAX/VMS SPITBOL, and is
    not  necessarily  portable  to  other   implementations   of   the
    language.

    In  some  cases,  there  may  be  a SPITBOL application or utility
    program for which a "custom" command  may  be  desired.   This  is
    easily achieved with a definition something like:

        $
        _ SPUTIL :== $SPITBOL/OUT=TT:/LOAD=SYS$LIBRARY:SPUTIL NL:

             $
    Typing  "_SPUTIL"  as  a VMS command will then load the saved EXIT
    file named SPUTIL in SYS$LIBRARY and execute it with the  standard
    output  file assigned to the terminal.  Other permutations will be
    useful depending on the particular application.























         MACRO SPITBOL V3.5
                                                   PAGE 89 - [11.21.1]
         Implementation Information



 11.21.1  Startup Switches
 11.21.1  Startup Switches
    Startup switches are optional in the sense that there are  defined
    defaults  for  all  of  them  that  should be adequate most of the
    time.  Switch names can be abbreviated to the minimum  unambiguous
    length.  A syntax error in the startup command line will cause the
    interpreter to exit with a message.

    Switches may appear at any point in the command  line;   they  are
    processed  left-to-right.   There  are no 'file-specific' switches
    as with some VMS languages, all switches are global.  The  use  of
    multiple  input  files separated either by commas or plus signs is
    not
    ___ supported.

    These are the switches provided on  the  SPITBOL  startup  command
    line:


     1.  /CRC /NOCRC
         This  switch  is  only  meaningful  on a /LOAD=... operation,
         where the specification of  /NOCRC  will  bypass  the  cyclic
         reducdancy  check of the SPITBOL code region.  The purpose of
         this check is to insure that the  version  of  SPITBOL  being
         used  is  the same as the version under which the exit module
         was saved.  As SPITBOL  also  checks  version  identification
         data  and  other  parameters, the overhead for this check may
         be considered unnecessary for frequently used  load  modules.
         In  such  cases,  /NOCRC  can  be  profitably specified.  The
         default is /CRC.

     2.  /CSTATS /NOCSTATS
         This  switch  will  suppress  the  printing  of   compilation
         statistics  on  the  output  file.  "/CSTATS" is the default.
         If /NOLIST has been specified, the default is /NOCSTATS.

     3.  /ESTATS /NOESTATS
         This  switch  will  suppress  the   printing   of   execution
         statistics  on  the  output  file.  "/ESTATS" is the default.
         If  /NOLIST  has  been  specified,  then   the   default   is
         /NOESTATS.

     4.  /EXECUTE /NOEXECUTE
         This  switch  has  the  same  logical effect as a  -NOEXECUTE
         control card in the source  program.   SPITBOL  will  process
         the  source  program,  and  then  exit  with  a  message that
         Execution Was Suppressed.  The default is "/EXECUTE".

     5.  /LIST[=filename] /NOLIST
         The /LIST switch allows specification  of  the  filename  for
         the  standard  output  channel.   If  a  terminal  device  is
         specified for the  /LIST  switch,  then  form  feeds  in  the
         program  listing  will be suppressed.  The default device and
         account for this  file  is  the  same  as  that  under  which
         SPITBOL  is  being run.  The default name for the output file
         is the input  file's  name,  and  the  default  extension  is


         MACRO SPITBOL V3.5
                                                   PAGE 90 - [11.21.1]
         Implementation Information

         ".LIS".   The  program listing and compilation statistics are
         sent to this file.  If neither of  /OUTPUT=...  or  /NOOUTPUT
         are  also  specified  on  the  command  line,  then execution
         output is also directed to this file.  This  includes  OUTPUT
         assigned text and TRACE and DUMP output.

         The  /NOLIST  switch  indicates that source listing is not to
         be generated. /NOLIST also causes an implicit  /NOESTATS  and
         /NOCSTATS.   Note  that  the  appearance  of /NOLIST does not
         mean that no output will  be  sent  to  the  standard  output
         channel.   However,  if the program makes no reference to the
         standard output channel, then if /NOLIST is  specified,  this
         channel will never be opened.

         /LIST  with  no  filename  inverts  the  effect of a previous
         /NOLIST  spec.   That  is,   enables   source   listing   and
         compilation statistics.

     6.  /MINC=nnn
         This  switch  controls the number of pages by which SPITBOL's
         working store is expanded when it becomes  exhausted.   Under
         normal  circumstances,  it should not be necessary to specify
         this switch, however, "/MINC=0" will prevent  any  additional
         allocation  to SPITBOL past the MINT allocation, and may thus
         be useful  in  preventing  the  unrestrained  growth  of  the
         interpreter.

         Even  if  MINC is non-zero, there are three cases which could
         concievably cause dynamic allocation of a SPITBOL  object  to
         fail.  These are:

            - The  size  of  the object exceeds &MAXLNGTH (MXLEN).  As
              this is initially greater than one million,  this  fault
              is  very  unlikely  to  occur  except as the result of a
              programming error.

            - If allocation would cause the virtual  memory  quota  to
              be  exceeded,  SPITBOL  will  print  a  MEMORY  OVERFLOW
              error, and terminate execution.  This is  also  unlikely
              on most systems.

            - If  SPITBOL  has  been  linked  allowing  RMS buffers to
              extend  in   P0  space  (linker  option  P0BUFS  -   the
              default),  then  with  a  large number of simultaneously
              open files  an  RMS  space  extension  would  block  the
              contiguous  growth  of  the  dynamic  area  and  cause a
              memory overflow.

         The default for this switch is "/MINC=20" which is 10K  bytes
         or about 2,000 SPITBOL 'words.'

     7.  /MINT=nnn
         This  switch  controls  the amount of  virtual memory (in 512
         Byte pages) that will be  initally  allocated  for  SPITBOL's
         working   storage   areas.   The  SPITBOL  VMS  interface  is
         designed to  permit  these  working  storage  areas  to  grow


         MACRO SPITBOL V3.5
                                                   PAGE 91 - [11.21.1]
         Implementation Information

         indefinitely,  as  long as the region remains contiguous, and
         there are pages available  in  the  process'  virtual  quota.
         However,  SPITBOL will not request additional memory from VMS
         unless it cannot get  enough  by  regenerating  its  existing
         store.   So,  this switch may be useful in some situations to
         avoid garbage collector  thrashing.   The  default  for  this
         switch  is  "/MINT=200"  which  is  equivalent to  about 100K
         bytes, or 25,000 SPITBOL 'words' (VAX Longwords).

         For most applications, the performance  will  increase  quite
         dramatically  as  real  memory  is made available.  Past that
         point, additional working set will improve  performance  only
         marginally.   As  the  dynamic  space  is  allowed  to become
         increasingly  virtual,  performance   will   very   gradually
         deteriorate  because  of  the  thrashing caused (principally)
         during garbage collection.  Thus as a general  guide,  it  is
         usually  best  to  minimize garbage collection at the expense
         of additional memory.

         Stack space is not included in the  MINT  allocation.   Stack
         is allocated automatically as needed.

     8.  /OUTPUT[=Filename]
         The  /OUTPUT=filename  switch  requests an alternate file for
         the standard output  channel  at  execution  time.   If  this
         switch  is  not  specified, then execution output is directed
         at the same file  as  the  source  listing  (/LIST=filename).
         This  file  is not opened until execution begins.  If at that
         time the channel cannot  be  opened,  SPITBOL  exits  with  a
         fatal status.

         /NOOUTPUT   directs  any  execution-time  references  to  the
         standard output channel to the null device (NL:)

         /OUTPUT with no  filename  restores  the  default  condition.
         That is, execution output is appended to the listing output.

         Note that /OUTPUT and /LIST are not synonymous.

     9.  /PAGE /NOPAGE
         If  this  switch  is specified, page separators in the source
         listing and statistics will be a few blank lines, instead  of
         form  feeds.   "/PAGE"  is  the  default, unless the standard
         output channel (see /OUTPUT switch) is a terminal,  in  which
         case "/NOPAGE" is the default.

         At  startup,  LIB$LP_LINES  is called to get the page length.
         From  the  value  returned  (66  unless  the   logical   name
         SYS$LP_LINES  is  assigned), six  is subtracted to leave room
         for page shoulders.

    10.  /WARN /NOWARN
         When /NOWARN is indicated on the command  line,  only  errors
         and  severe  errors  in  the  VMS  interface  logic  will  be
         reported on  SYS$ERROR.   This  can  be  useful  to  suppress
         messages  regarding source line truncation, exit module saves


         MACRO SPITBOL V3.5
                                                   PAGE 92 - [11.21.1]
         Implementation Information

         and similar messages. /WARN, the  default,  causes  reporting
         of such conditions.

         This  switch does not affect in any way SPITBOL's handling of
         errors with respect to the program.

    11.  /WIDTH=nnn
         SPITBOL attempts to compute a proper width for  the  standard
         output  file.   The switch "/WIDTH=n" can be used to override
         any  default.    Otherwise,   if   the   output   device   is
         record-oriented  (including  spooled  files),  the default is
         the buffer for the  device  as  indicated  by  VMS.   If  the
         buffer  size  cannot  be  obtained,  or  is outside the range
         [0..255], then a final default of 132 (decimal) is applied.












































         MACRO SPITBOL V3.5
                                                   PAGE 93 - [11.22]
         Implementation Information



 11.22  Stack Overflow
 11.22  Stack Overflow
 ____________ ________
    SPITBOL  stack  is  located  in  P0  (program)  space.   It  grows
    downwards  as  needed  from  LOAD_BASE  to STACK_LIMIT.  These two
    values are defined in the SPITBOL Link options file.  In  general,
    these  values  are  set  such  that stack overflow is not possible
    unless a program is truly out of control.


 11.23  TERMINAL
 11.23  TERMINAL
 _______________
    TERMINAL  is  available  and  is  associated  with  SYS$INPUT  and
    SYS$OUTPUT.   The  first  assignment  or  access to TERMINAL opens
    this channel.


 11.24  Time
 11.24  Time
 ___________
    All execution times in the VAX/VMS Macro  SPITBOL  system  are  in
    CPU  time  increments  of 10 (milliseconds).  This covers both the
    times shown in the statistics, and  the  time  retrieved  via  the
    system TIME function.  Wall time is available through DATE.





































         MACRO SPITBOL V3.5
                                                   PAGE 94 - [12]
         Implementation Information



                    *--------------------------------*
                      [12] Installation and Delivery
                    | [12] Installation and Delivery |
                    *--------------------------------*

    This  section  of  the  SPITBOL  manual  describes the process for
    unpackaging and installing the  VAX/VMS  MACRO  SPITBOL  software.
    This  section  is  also provided in hardcopy form with the 1600BPI
    tape to facilitate the  installation  process.   If  this  is  the
    first  time  you  have performed the delivery, please read through
    these directions before starting;  the  delivery  process  is  not
    highly  automated, and there will be a number of decisions for you
    to make.

    There are four steps to be  initially  performed  to  deliver  and
    install the software package.


     1.  Get  the files from the tape into the proper directories, and
         link  the  interpreter.    The   directories   involved   are
         SYS$LIBRARY:,  SYS$HELP:,  and  SYS$SYSTEM:.  Be certain that
         these VMS standard logical names are  defined  to  correspond
         to  valid  directories  on the system disk before undertaking
         the software installation.

     2.  Establish the  VMS  environment  and  commands  necessary  to
         execute MACRO SPITBOL.

     3.  Generate  the  reference  manual  and help file.  The program
         which does this is a SPITBOL program, so this  serves  as  an
         installation checkout.

     4.  Delete  and/or  copy  off  any optional files which you don't
         want to keep.

    Each of these steps is now detailed in turn.


    NOTE:
    NOTE:
    _____ This  version  of  MACRO  SPITBOL requires version 2 of VMS.
    If you are running any  version  1  of  VMS  you  cannot  use  the
    interpreter.   You  must first upgrade your system to version 2 of
    VMS before attempting to install MACRO SPITBOL.















         MACRO SPITBOL V3.5
                                                   PAGE 95 - [12.1]
         Implementation Information



 12.1  Transferring Delivery Files
 12.1  Transferring Delivery Files
 __________________ ________ _____


    Follow these steps:


     1.  Log on to the hardcopy system console  using  the  privileged
         SYSTEM  account.   Be certain that your default is set to the
         system  disk.   "BYPASS"  privilege  is  recommended  as   it
         insures  that  there  will be no snags in renaming or copying
         files.

     2.  If there  are  any  existing  files  or  directories  for  an
         earlier  version  of  SPITBOL,  they should be deleted.  (The
         new version  is  strictly  upward  compatible  with  previous
         versions.)   If  it  does  not already exist, create an empty
         scratch directory named SYS$DISK:[SPITBOL] with the command:

                         $
                         _ CRE/DIR SYS$DISK:[SPITBOL]


     3.  Set your default to the SPITBOL directory using the command:

                       $
                       _ SET DEFAULT SYS$DISK:[SPITBOL]


     4.  Mount the delivery tape on a drive with a command such as:

                              $
                              _ MOUNT MT:/OVER=ID


     5.  Copy all files from the  tape  into  the  directory  using  a
         command similar to:

                                $
                                _ COPY MT:*.* *


     6.  Dismount the tape with a command such as:

                                $
                                _ DISMOUNT MT:


     7.  Enter the command:

                                  $
                                  _ @SPITBOL

         This   command   file  will  rename  files  to  their  proper
         directories, and link the interpreter image.

    Sites with a previous release  of  the  interpreter  may  want  to
    print  a  copy of [SPITBOL]RELNOTES.LIS which documents changes in
    this release.




         MACRO SPITBOL V3.5
                                                   PAGE 96 - [12.2]
         Implementation Information



 12.2  Installing MACRO SPITBOL
 12.2  Installing MACRO SPITBOL
 ________________ _____ _______


     1.  Enter the commands:

                    $
                    _ SPIT*BOL :== $SYS$SYSTEM:SPITBOL
                    $
                    _ ASSIGN/SYS "<site-name>" SYS$SITENAME

         In the above, "<site-name>" is  any  text  string  of  28  or
         fewer   characters  which  SPITBOL  will  use  for  the  site
         identification.

         Using an editor, place the first of the above definitions  in
         the  systemwide  login  command  file  to define them for all
         users.   (The  name  of  this  file  varies  from  system  to
         system,  SYLOGIN.COM  and  SYSLOGIN.COM  in  SYS$MANAGER:  is
         typical.  If your site has not established such a file,  then
         users   will  have  to  define  this  command  in  their  own
         LOGIN.COM files.)   The ASSIGN  command  should  be  inserted
         into SYS$MANAGER:SYSTARTUP.COM .

     2.  In  general,  if  SPITBOL  is  to  be  used frequently, it is
         recommended that it be installed as a shareable image.   This
         can  be  done  (from  the  SYSTEM  account) using the command
         lines:

                   $ MCR INSTALL
                   SYS$SYSTEM:SPITBOL.EXE/SHARE/OPEN/HEADER

         SPITBOL  should  not   normally   be   installed   with   any
         privileges.



 12.3  Interpreter Checkout and Documentation Generation
 12.3  Interpreter Checkout and Documentation Generation
 _________________ ________ ___ _____________ __________


     1.  Set your default to SYS$LIBRARY:

     2.  Enter the command:

                    $
                    _ SPIT GPMDOC " {SET INPUT,SPITBOL.GPM}

         Note the blank  following  the  double  quote  in  the  above
         ____ ___ _____  _________  ___  ______  _____  __  ___  _____
         command.  This blank is significant and must be  included  as
         ________  ____ _____ __ ___________ ___ ____ __  ________  __
         shown.
         ______  If all is well, this will cause the system to ask  if
         you  want  to  produce the manual.  Answer "yes".  Generating
         the approximately 100 page manual takes about  5  minutes  on
         an  unloaded  VAX 11/780.  If it is working, a message should
         appear on your console for every page produced.






         MACRO SPITBOL V3.5
                                                   PAGE 97 - [12.3]
         Implementation Information

         After this, you will be asked if you  want  to  generate  the
         help  file.   Again  answer  "yes".   The generated file is a
         reformatted  version  of  the  manual  itself,  in  VMS  help
         library format.

         When this concludes, the GPMDOC program exits.

     3.  Print  SYS$LIBRARY:GPMDOC.LIS  on  a  132 column line printer
         and examine the listing to be sure that  the  interpreter  is
         functioning  properly.   Look  at  the  2  line header on the
         first listing page and be certain  that  the  site  name  you
         defined above appears there.

     4.  Print  SYS$LIBRARY:SPITBOL.MAN on (if possible) an 80 column,
         8.5x11 inch, white paper printer.  An  LA120  DECwriter  will
         do  if there is plenty of time available.  If any interactive
                                                   $
         device is  used,  be  certain  to  type  "_ SET TERM/NOBROAD"
         before  starting.   The table of contents is at the back - it
         should be moved to the indicated place at the beginning.

     5.  You should now decide if you  want  to  add  the  SPITBOL.HLP
         help  file to the system help file.  (The only reason for not
         so doing would be that it consumes about 300 blocks  of  disk
         space).   If  you  decide  to  do  this,  set your default to
         SYS$HELP: and enter the following commands:

                      $
                      _ LIB/COMPR=KEYSIZ:31/HELP HELPLIB
                      $
                      _ LIB/REPLACE/HELP HELPLIB SPITBOL
                      $
                      _ LIB/COMPRESS/HELP HELPLIB
                      $
                      _ PURGE HELPLIB.HLB




 12.4  Delivery File Cleanup
 12.4  Delivery File Cleanup
 ______________ ____ _______


    The delivery and  installation  process  is  concluded.   At  this
    point,  some  sites  may  choose  to  delete some of the delivered
    files in order to free up as much system disk space  as  possible.
    To  such  an  end,  a list of all delivered and generated files is
    given here, grouped by  their  function.   Examine  the  list  and
    delete the ones you don't want.


     1.  BASIC INTERPRETER:
         Basic  interpreter  files  consist  of  the executable image,
         objects, and sources.

         The executable image  is  built  as  SYS$SYSTEM:SPITBOL.EXE .
         This  file must not be deleted.  Also, SYS$SYSTEM:SPITBOL.STB
         is the corresponding symbol table  file  which  can  be  used
         when  linking images for use by LOAD(...).  It should also be
         retained.




         MACRO SPITBOL V3.5
                                                   PAGE 98 - [12.4]
         Implementation Information

         The  objects  are  in  SYS$LIBRARY:  and  named  SPITSYS.OBJ,
         SPITIOSYS,  SPITGO,  SPITMSGS and SPITV35.  It is recommended
         that    these    files     be     kept.      In     addition,
         SYS$LIBRARY:SPITBOL.OPT  is the standard SPITBOL link options
         file and should be retained if the objects are.

         The sources are in SYS$LIBRARY and have  the  same  names  as
         the  objects  except  that the file extensions are different.
         SPITGO.MAR is the entry  point,  and  provides  command  line
         processing,   initialization   and   basic  file  assignment.
         SPITSYS.MAR   contains   the    VMS    interface    routines.
         SPITIOSYS.MAR  contains  the VMS interface routines for input
         and output operations.  SPITV35.MAR is  the  source  for  the
         interpreter  itself.  SPITMSGS.MSG is the source text for the
         error messages  of  the  system.  It  is  input  to  the  VMS
         "MESSAGE" processor.

         SPITMACS.MAR  and  SPITMACS.MLB  comprise  the  macro library
         which is required for assembling any of these sources.

         These source files will  be  of  academic  interest  to  most
         sites,  and  can  be  profitably deleted since they consume a
         substantial quantity of disk space.

     2.  INTERPRETER SUPPORT FILES:
         On SYS$LIBRARY: will be found SPITHLS in .OBJ and .MAR  form.
         These  files  are  used  in  conjunction  with  the LOAD(...)
         feature and should not be deleted.  In  any  event  they  are
         quite small.

     3.  DOCUMENTATION FILES:
         The   delivery  process  outlined  above  uses  and  produces
         several files that relate to MACRO SPITBOL documentation.

         In SYS$LIBRARY: will be found SPITBOL.GPM and  SPITTEXT.GPM .
         These  two  files,  together, comprise the needed information
         to generate both the manual and help file text.  They can  be
         deleted once the manual and/or help file has been produced.

         The    delivery    process    generates    the    manual   in
         SYS$LIBRARY:SPITBOL.MAN. Once a good copy of  this  has  been
         printed, this file can be deleted.

         The  help  file  text  is  produced  in SYS$HELP:SPITBOL.HLP.
         This should be deleted only if no use is made of it.  If  you
         have  added it to the system help library, keep the .HLP file
         in case a future VMS delivery reinitializes the  system  help
         file.

         The   delivery   process   generates  a  SPITBOL  listing  in
         SYS$LIBRARY:GPMDOC.LIS.  This file is of  no  value  once  it
         has been checked out, and can be deleted.






         MACRO SPITBOL V3.5
                                                   PAGE 99 - [12.4]
         Implementation Information

     4.  GPMDOC:
         GPMDOC  is  the  text processing program (written in SPITBOL)
         that produces the manual and  help  text  files.   It  is  an
         interesting  program  in  its  own right, and for that reason
         you may wish to keep it.  Otherwise, all of the GPMDOC  files
         can be deleted, they are in SYS$LIBRARY:

         GPMDOC.SPT is the basic GPMDOC program source.

         GPMBIF.GPM  is  a  file  of  auxiliary  definitions needed by
         GPMDOC when it starts up.

         GPMDOC.GPM  is  part  of  the  reference  documentation   for
         GPMDOC.   To  generate this documentation, set the default to
         SYS$LIBRARY: and enter the commands:

              $
              _ SPIT GPMDOC -
              $
              __ " {SET OUTPUT,GPMDOC.MAN}{SET INPUT,GPMDOC.GPM}
              $
              _ PRINT/DELETE GPMDOC.MAN
              $
              _ DELETE GPMDOC.LIS;*


         JUSTIFY (.FOR, .OBJ, .EXE and .OPT) is a LOAD image  used  by
         GPMDOC  that   performs  right-justification of text strings.
         It is not essential to the operation  of  GPMDOC  (though  it
         runs  slightly  faster  with it.)  However, JUSTIFY is a good
         example of use of the LOAD(...) function feature, and  should
         be retained for that reason.

     5.  MISCELLANEOUS FILES:
         The  file  [SPITBOL]SPITBOL.COM  and  it's  scratch directory
         [SPITBOL]  are  of  no  use  once  the  delivery   has   been
         successfully   completed,   and  should  be  deleted.    This
         directory also contains RELNOTES.LIS.   These  release  notes
         are  primarily  directed  at sites with an earlier release of
         the system, and may be kept or deleted as desired.

         SYS$LIBRARY:DIF.SPT is a file comparator program  similar  to
         the   PDP-11  "CMP"  program.   It  runs significantly faster
         and, in  most  cases,  more  accurately  than  the  V2.4  VMS
         "DIFFERENCES"  command and for that reason may be of value to
         some sites.  The command format for DIF is described  in  its
         source.


















    ! ...................................... 16, 17
    $ ...................................... 16, 56, 57, 58
    $SEVERITY .............................. 75
    $STATUS ................................ 75
    % ...................................... 16
    & ...................................... 16

    &ABEND ................................. 43
    &ABORT ................................. 43
    &ALPHABET .............................. 43, 58
    &ANCHOR ................................ 4, 43, 57
    &ARB ................................... 43

    &BAL ................................... 43
    &CODE .................................. 43, 71
    &DUMP .................................. 43
    &ERRLIMIT .............................. 44
    &ERRTEXT ............................... 5, 21, 25, 38, 44, 71, 88

    &ERRTYPE ............................... 38, 44
    &FAIL .................................. 44
    &FENCE ................................. 44
    &FNCLEVEL .............................. 38, 44
    &FTRACE ................................ 44

    &FULLSCAN .............................. 3
    &INPUT ................................. 44
    &LASTNO ................................ 44
    &MAXLNGTH .............................. 5, 9, 44, 90
    &OUTPUT ................................ 44

    &PROFILE ............................... 5, 44
    &REM ................................... 45
    &RTNTYPE ............................... 45
    &STCOUNT ............................... 45
    &STFCOUNT .............................. 3

    &STLIMIT ............................... 6, 42, 45, 71
    &STNO .................................. 45
    &SUCCEED ............................... 45
    &TRACE ................................. 45
    &TRIM .................................. 5, 45, 57, 71

    * ...................................... 16, 57
    + ...................................... 16
    - ...................................... 16
    -DOUBLE ................................ 48
    -EJECT ................................. 46






                                     Index - i





    -EXECUTE ............................... 49
    -FAIL .................................. 49
    -IN .................................... 49
    -LIST .................................. 21, 48
    -NOERRORS .............................. 49, 50
    -NOEXECUTE ............................. 49, 89

    -NOFAIL ................................ 25, 49
    -NOLIST ................................ 48
    -NOPRINT ............................... 48
    -PRINT ................................. 48
    -SINGLE ................................ 48

    -SPACE ................................. 46
    -TITLE ................................. 46
    . ...................................... 16, 57
    .EXE ................................... 83
    .SEX ................................... 77

    .SPT ................................... 87
    / ...................................... 16
    /CCO ................................... 80
    /CIF ................................... 80
    /CR .................................... 80

    /CRC ................................... 89
    /CSTATS ................................ 89
    /DLT ................................... 80
    /EOF ................................... 80
    /ESTATS ................................ 89

    /EXECUTE ............................... 89
    /FTN ................................... 80
    /LIST .................................. 89
    /LOAD .................................. 71, 77
    /MINC .................................. 77, 90

    /MINT .................................. 77, 90
    /MXV ................................... 80
    /NOCRC ................................. 89
    /NOCSTATS .............................. 89
    /NOESTATS .............................. 89

    /NOEXECUTE ............................. 89
    /NOLIST ................................ 89
    /NOOUTPUT .............................. 91
    /NOPAGE ................................ 91
    /NOWARN ................................ 75, 91






                                     Index - ii





    /OUTPUT ................................ 91
    /PAGE .................................. 91
    /PTA ................................... 80
    /RNE ................................... 80
    /RNF ................................... 80
    /SCF ................................... 80

    /SPL ................................... 80
    /SUP ................................... 80
    /TEF ................................... 80
    /WARN .................................. 91
    /WIDTH ................................. 92

    <> ..................................... 7
    = ...................................... 6, 7, 16
    ? ...................................... 6, 7, 16, 58
    @ ...................................... 16
    ABEND .................................. 43, 43

    ABORT .................................. 4, 38, 43
    ALTERNATION ............................ 73
    ALTERNATIVE ............................ 5, 7
    ANCHOR ................................. 43
    ANCHORED MATCHING ...................... 57

    ANY .................................... 18, 56, 58
    APPEND ................................. 5, 10, 18, 57
    APPLY .................................. 18
    ARB .................................... 4, 20, 43, 58
    ARBNO .................................. 19, 58

    ARG .................................... 19
    ARRAY .................................. 9, 15, 18, 19, 39, 41
    ARRAYS ................................. 19, 56, 57
    ASSOCIATIVE LOOKUP ..................... 57
    BACKSPACE .............................. 3

    BAL .................................... 4, 43
    BLOCK .................................. 3
    BREAK .................................. 19, 56, 58
    BREAKX ................................. 5, 20, 56, 58
    BUFFER ................................. 5, 20

    BUFFERS ................................ 6, 10, 30, 57, 57, 58, 72
    CHAR ................................... 5, 21
    CHARACTER SET .......................... 6, 73, 87
    CLEAR .................................. 21
    CLI .................................... 88






                                    Index - iii





    CMP .................................... 99
    CODE ................................... 10, 21, 38, 56
    CODE BLOCKS ............................ 56
    COLLECT ................................ 22, 57
    COMMAND LINE ........................... 87
    CONDITION HANDLERS ..................... 85

    CONTINUE ............................... 38
    CONTROL CARDS .......................... 6, 46
    CONVERT ................................ 5, 22, 39
    COPY ................................... 22
    CPU TIME ............................... 93

    DATA ................................... 18, 23, 39
    DATATYPE ............................... 4, 23
    DATATYPE CONVERSIONS ................... 4, 11, 12, 58
    DATE ................................... 23, 75
    DCL .................................... 75

    DEBUGGING .............................. 42, 58, 83
    DEFERRED EXPRESSION .................... 58, 65
    DEFINE ................................. 18, 23
    DELIVERY ............................... 94
    DETACH ................................. 23, 58

    DIF.SPT ................................ 99
    DIFFER ................................. 4, 24
    DUMP ................................... 5, 24
    DUPL ................................... 24
    EBCDIC ................................. 73

    EJECT .................................. 5, 24, 79
    END .................................... 4
    ENDFILE ................................ 25, 79
    ERRORS ................................. 50, 75
    EVAL ................................... 25, 38

    EXIT ................................... 5, 25, 71, 77
    EXPRESSION ............................. 10
    FAIL ................................... 4, 44
    FENCE .................................. 4, 27, 44, 78
    FIELD .................................. 27

    FRETURN ................................ 38
    FULLSCAN ............................... 3
    FUNCTION ............................... 56
    FUNCTIONS .............................. 18
    GARBAGE COLLECTION ..................... 5, 22, 25, 56, 91






                                     Index - iv





    GE ..................................... 27
    GORILLA ................................ 85
    GOTOS .................................. 6
    GPMDOC ................................. 96, 99
    GT ..................................... 27
    HASH ................................... 56

    HASHING ................................ 4, 41, 57
    HELP LIBRARY ........................... 97
    HOST ................................... 5, 27, 78
    I/O .................................... 79
    I/O ASSOCIATION ........................ 58

    I/O SWITCHES ........................... 79
    IBM .................................... 1, 73
    IDENT .................................. 4, 28
    IF-THEN-ELSE ........................... 7
    INPUT .................................. 23, 25, 29, 36, 77, 79

    INSERT ................................. 5, 10, 30, 57
    INSTALL ................................ 96
    INSTALLATION ........................... 94, 96
    INTEGER ................................ 9, 14, 31, 39
    INTEGERS ............................... 56, 78

    INTERROGATION .......................... 58
    ITEM ................................... 7, 31
    JUSTIFY ................................ 99
    KEYWORDS ............................... 43
    LABEL .................................. 56

    LE ..................................... 31
    LEN .................................... 32
    LEQ .................................... 5, 32
    LGE .................................... 5, 32
    LGT .................................... 32

    LIB$LP_LINES ........................... 91
    LINKER ................................. 82, 82, 87
    LISTING ................................ 46
    LISTING OPTIONS ........................ 82
    LLE .................................... 5, 32

    LLT .................................... 5, 33
    LNE .................................... 5, 33
    LOAD ................................... 33, 77, 77, 83, 99
    LOAD MODULE ............................ 25
    LOAD_BASE .............................. 82, 85, 86, 93






                                     Index - v





    LOCAL .................................. 33
    LONGWORD ............................... 91
    LPAD ................................... 5, 34
    LT ..................................... 34
    MACRO-32 ............................... 83
    MATRIX ................................. 39

    MAXIMUM SIZE ........................... 5
    MXLEN .................................. 5, 9, 9, 9, 43, 44, 87, 90
    NAME ................................... 4, 9, 15, 39, 58
    NE ..................................... 34
    NL: .................................... 77

    NOTANY ................................. 34, 56, 58
    NRETURN ................................ 38
    NULL STRING ............................ 39
    NUMERIC ................................ 4, 39
    ON-LINE TERMINAL ....................... 6

    OPERATORS .............................. 16
    OPSYN .................................. 35, 73
    OPTIONS FILE ........................... 82
    OUTPUT ................................. 23, 24, 25, 29, 35, 36,
                                            77, 79

    P0BUFS ................................. 90
    PATTERN ................................ 9
    PATTERN MATCHING OPERATOR .............. 6
    PATTERN REPLACEMENT .................... 57
    PIC .................................... 85, 85, 86

    POS .................................... 35
    POSITION INDEPENDENCE .................. 85, 85
    PRE-EVALUATION ......................... 3, 5, 57, 65
    PROGRAM DEFINED DATATYPES .............. 23, 56, 57
    PROTOTYPE .............................. 36

    PUNCH .................................. 3
    QUICKSCAN .............................. 3
    REAL ................................... 9, 14, 39
    REAL ARITHMETIC ........................ 3, 87
    REALS .................................. 56

    RELEASE NOTES .......................... 99
    RELNOTES.LIS ........................... 99
    REM .................................... 4, 45
    REMDR .................................. 36
    REPLACE ................................ 36, 58






                                     Index - vi





    RETURN ................................. 38
    REVERSE ................................ 5, 36
    REWIND ................................. 36, 79, 87
    RMS .................................... 79, 90
    RPAD ................................... 5, 37
    RPOS ................................... 37

    RSORT .................................. 5, 6, 37, 39, 58
    RTAB ................................... 37
    SELECTION .............................. 5, 7
    SETEXIT ................................ 4, 5, 21, 25, 38, 44, 44
    SHAREABLE IMAGE ........................ 96

    SIZE ................................... 39
    SNOBOL4 ................................ 73
    SNOBOL4B ............................... 3
    SORT ................................... 5, 6, 39, 58
    SPACE OVERHEAD ......................... 56

    SPAN ................................... 40, 56, 58
    SPEED CONSIDERATIONS ................... 57
    SPIT$FAIL_RETURN ....................... 85
    SPIT$LOAD_ENTRY ........................ 84
    SPIT$SUCCESS_RETURN .................... 85

    SPITHLS ................................ 84, 85, 85
    STACK .................................. 91
    STACK OVERFLOW ......................... 93
    STACK_LIMIT ............................ 93
    STITL .................................. 47

    STOPTR ................................. 40, 58
    STRING ................................. 9, 12
    SUBSTR ................................. 5, 41
    SUCCEED ................................ 4, 45
    SWITCHES ............................... 87

    SYS$HELP ............................... 94
    SYS$INPUT .............................. 87
    SYS$LIBRARY ............................ 82, 84, 85, 85, 94
    SYS$LIBRARY: ........................... 98
    SYS$LP_LINES ........................... 91

    SYS$SITENAME ........................... 96
    SYS$SYSTEM ............................. 85, 94
    SYSLOGIN.COM ........................... 96
    SYSTARTUP.COM .......................... 96
    TAB .................................... 41






                                    Index - vii





    TAB CHARACTER .......................... 6
    TABLE .................................. 4, 4, 9, 15, 39, 39, 41,
                                            56, 57
    TABLES ................................. 56, 57
    TERMINAL ............................... 6, 93
    TERMINAL I/O ........................... 80

    TIME ................................... 42, 93
    TRACE .................................. 5, 42
    TRACING ................................ 58
    TRIM ................................... 42
    UNANCHORED MODE ........................ 57

    UNIVAC ................................. 1
    UNLOAD ................................. 42
    VALUE .................................. 3
    VARIABLE ............................... 56
    VECTOR ................................. 39

    VECTORS ................................ 19, 56
    VMS .................................... 94
    WORD ................................... 91
    [] ..................................... 7
    | ...................................... 17

    ~ ...................................... 16, 16




























                                    Index - viii


                                 TABLE OF CONTENTS
                                 _____ __ ________


         Section                        Title
         Page



              Introduction
    1         Introduction                                          1

              Summary of Differences
    2         Summary of Differences                                3
    2.1         Features not Implemented                            3
    2.2         Features Implemented Differently                    4
    2.3         Additional Features                                 5
    2.4         Syntax Differences                                  7

              Datatypes and Conversion
    3         Datatypes and Conversion                              9
    3.1         Available Datatypes                                 9
    3.2         Possible Datatype Conversions                       11
    3.3         Conversion Details                                  12

              Operators
    4         Operators                                             16
    4.1         Unary Operators                                     16
    4.2         Binary Operators                                    17

              Functions
    5         Functions                                             18
    5.1         ANY -- Pattern to Match Selected Character          18
    5.2         APPEND * -- Append string to buffer                 18
    5.3         APPLY * -- Apply function                           18
    5.4         ARBNO -- Pattern for Iterated Match                 19
    5.5         ARG * -- Obtain Argument Name                       19
    5.6         ARRAY -- Generate Array Structure                   19
    5.7         BREAK -- Construct Scanning Pattern                 19
    5.8         BUFFER * -- Create buffer object                    20
    5.9         BREAKX * -- Construct Scanning Pattern              20
    5.10        CHAR * -- Convert Character Code to String          21
    5.11        CLEAR * -- Clear Variable Storage                   21
    5.12        CODE * -- Compile Code                              21
    5.13        COLLECT -- Initiate Storage Regeneration            22
    5.14        CONVERT * -- Convert Datatypes                      22
    5.15        COPY * -- Copy Structure                            22
    5.16        DATA -- Create Datatype                             23
    5.17        DATATYPE * -- Obtain Datatype                       23
    5.18        DATE * -- Obtain Date                               23
    5.19        DEFINE -- Define a Function                         23
    5.20        DETACH -- Detach I/O Association                    23
    5.21        DIFFER * -- Test for Arguments Differing            24
    5.22        DUMP * -- Dump Storage                              24
    5.23        DUPL * -- Duplicate String or Pattern               24
    5.24        EJECT * -- Eject to new page                        24
    5.25        ENDFILE * -- Close a File                           25
    5.26        EQ -- Test for Equal                                25
    5.27        EVAL * -- Evaluate Expression                       25
    5.28        EXIT * -- Exit to Save Load Module or to JCL        25
    5.29        FENCE * -- Generate Fenced Pattern                  27


                                         i


                             TABLE OF CONTENTS (CON'T)
                             _____ __ ________ _______


         Section                        Title
         Page

    5.30        FIELD * -- Get Field Name                           27
    5.31        GE -- Test for Greater or Equal                     27
    5.32        GT -- Test for Greater                              27
    5.33        HOST * -- Obtain Information about Host Computer    28
    5.34        IDENT * -- Test for Identical                       28
    5.35        INPUT * -- Set Input Association                    29
    5.36        INSERT * -- Insert string in buffer                 30
    5.37        INTEGER * -- Test for Integer                       31
    5.38        ITEM -- Select Array or Table Element               31
    5.39        LE -- Test for Less or Equal                        31
    5.40        LEN -- Generate Specified Length Pattern            32
    5.41        LEQ * -- Test for Lexically Equal                   32
    5.42        LGE * -- Test for Lexically Greater or Equal        32
    5.43        LGT * -- Test for Lexically Greater                 32
    5.44        LLE * -- Test for Lexically Less or Equal           32
    5.45        LLT * -- Test for Lexically Less                    33
    5.46        LNE * -- Test for Lexically Not Equal               33
    5.47        LOAD -- Load External Function                      33
    5.48        LOCAL * -- Get Name of Local                        33
    5.49        LPAD * -- Left Pad                                  34
    5.50        LT -- Test for Less                                 34
    5.51        NE -- Test for Not Equal                            34
    5.52        NOTANY -- Build Character Select Pattern            34
    5.53        OPSYN * -- Equate Functions and Operators           35
    5.54        OUTPUT * -- Set Output Association                  35
    5.55        POS -- Define Positioning Pattern                   35
    5.56        PROTOTYPE -- Retrieve Prototype                     36
    5.57        REMDR -- Remainder                                  36
    5.58        REPLACE -- Translate Characters                     36
    5.59        REVERSE * -- Reverse String                         36
    5.60        REWIND -- Reposition File                           36
    5.61        RPAD * -- Right Pad                                 37
    5.62        RPOS -- Define Positioning Pattern                  37
    5.63        RSORT -- Reverse Sort                               37
    5.64        RTAB -- Create Tabbing Pattern                      37
    5.65        SETEXIT * -- Set Error Exit                         38
    5.66        SIZE -- Get String or Buffer Size                   39
    5.67        SORT * -- Sort                                      39
    5.68        SPAN -- Create Spanning Pattern                     40
    5.69        STOPTR * -- Stop Trace                              40
    5.70        SUBSTR * -- Extract Substring                       41
    5.71        TAB -- Create Tabbing Pattern                       41
    5.72        TABLE * -- Create Table                             41
    5.73        TIME -- Get Timer Value                             42
    5.74        TRACE * -- Initiate Trace                           42
    5.75        TRIM -- Trim Trailing Blanks                        42
    5.76        UNLOAD * -- Unload Function                         42

              Keywords
    6         Keywords                                              43


                                         ii


                             TABLE OF CONTENTS (CON'T)
                             _____ __ ________ _______


         Section                        Title
         Page


              Program Listing and Control Cards
    7         Program Listing and Control Cards                     46
    7.1         Listing Control Cards                               46
    7.1.1         -EJECT                                            46
    7.1.2         -SPACE                                            46
    7.1.3         -TITLE                                            47
    7.1.4         -STITL                                            47
    7.2         Option Control Cards                                48
    7.2.1         -LIST -NOLIST                                     48
    7.2.2         -NOPRINT -PRINT                                   48
    7.2.3         -SINGLE -DOUBLE                                   48
    7.2.4         -INXXX                                            49
    7.2.5         -ERRORS -NOERRORS                                 49
    7.2.6         -FAIL -NOFAIL                                     49
    7.2.7         -EXECUTE -NOEXECUTE                               49

              Errors
    8         Errors                                                50
    8.1         Compilation Error Messages                          50
    8.2         Execution Error Messages                            50
    8.3         Error Codes and Messages                            50

              Programming Notes
    9         Programming Notes                                     56
    9.1         Space Considerations                                56
    9.2         Speed Considerations                                57
    9.3         Other Notes                                         58

              Specimen Programs
    10        Specimen Programs                                     59
    10.1        Program 1                                           59
    10.2        Program 2                                           61
    10.3        Program 3                                           65
    10.4        Program 4                                           68

              Implementation Information
    11        Implementation Information                            71
    11.1        &CODE                                               71
    11.2        &ERRTEXT                                            71
    11.3        &STLIMIT                                            71
    11.4        &TRIM                                               72
    11.5        Buffers                                             72
    11.6        Character Set for VAX/VMS SPITBOL                   73
    11.7        Form of DATE String                                 75
    11.8        Errors                                              75
    11.9        EXIT Function Usage                                 77
    11.9.1        EXIT(0) Usage                                     77
    11.9.2        EXIT(String) Usage                                77
    11.9.3        EXIT(-n) Usage                                    77
    11.10       FENCE(PATTERN)                                      78
    11.11       HOST                                                78
    11.12       Range of Integers                                   78
    11.13       INPUT/OUTPUT                                        79


                                        iii


                             TABLE OF CONTENTS (CON'T)
                             _____ __ ________ _______


         Section                        Title
         Page

    11.13.1       FILEARG2 SWITCHES                                 80
    11.13.2       I/O EXAMPLES                                      81
    11.14       Linking SPITBOL                                     82
    11.15       Terminal Listing Options                            82
    11.16       LOAD Function Usage                                 83
    11.16.1       High-Level Languages and LOAD                     84
    11.16.2       Calling Conventions for LOAD                      84
    11.16.3       Return Conventions for LOAD                       84
    11.16.4       Linking External Functions                        85
    11.16.5       Unconverted Values and Results for LOAD           86
    11.17       MXLEN                                               87
    11.18       Real Arithmetic                                     87
    11.19       Extended Character Set                              87
    11.20       REWIND                                              87
    11.21       Running SPITBOL                                     87
    11.21.1       Startup Switches                                  89
    11.22       Stack Overflow                                      93
    11.23       TERMINAL                                            93
    11.24       Time                                                93

              Installation and Delivery
    12        Installation and Delivery                             94
    12.1        Transferring Delivery Files                         95
    12.2        Installing MACRO SPITBOL                            96
    12.3        Interpreter Checkout and Documentation Generation   96
    12.4        Delivery File Cleanup                               97


























                                         iv










