      SUBROUTINE D0DESR(T0,X0,T1,X1,NX,NT,F,FTX,XL,FTX0,IGMAX)
C
C  ACTUAL GRAGGS MODIFIED MID-POINT RULE.
C
      COMMON /DODESF/OKAY
C
      DOUBLE PRECISION T0,X0(NX),T1,X1(NX),FTX(NX),XL(NX),FTX0(NX)
      LOGICAL OKAY
      EXTERNAL F
C
      DOUBLE PRECISION DT,DT2,T,TEMP
C
      COMMON /CSTAK/DS
      DOUBLE PRECISION DS(500)
      REAL RS(1000)
      EQUIVALENCE (DS(1),RS(1))
C
      OKAY=.TRUE.
      DT=(T1-T0)/FLOAT(NT)
      DT2=0.5D0*DT
      NT2=2*NT
C
C ... IF THIS IS THE FIRST CALL, COMPUTE FTX0=F(T0,X(T0))
C
      IF (NT.EQ.1) CALL F(T0,X0,NX,FTX0)
      IF (.NOT.OKAY) GO TO 50
C
C ... COMPUTE FORWARD-EULER INITIAL TIME-STEP.
C
      DO 10 I=1,NX
         XL(I)=X0(I)
 10      X1(I)=X0(I)+DT2*FTX0(I)
C
C ... GET THE APPROXIMATE SOLUTION AT THE REST OF THE MESH-POINTS
C ... USING THE MID-POINT RULE.
C
      DO 30 IT=2,NT2
         T=T0+FLOAT(IT-1)*DT2
         CALL F(T,X1,NX,FTX)
         IF (.NOT.OKAY) GO TO 50
C
         DO 20 I=1,NX
            TEMP=X1(I)
            X1(I)=XL(I)+DT*FTX(I)
 20         XL(I)=TEMP
C
C ...... IF NEED TO, RAISE THE GLOBAL MAXIMUM.
C
 30      IF (IGMAX.GT.0) CALL D0DESU(X1,NX,RS(IGMAX))
C
C ... SMOOTH AT THE END POINT.
C
      CALL F(T1,X1,NX,FTX)
      IF (.NOT.OKAY) GO TO 50
C
      DO 40 I=1,NX
 40      X1(I)=0.5D0*(X1(I)+(XL(I)+DT2*FTX(I)))
C
C ... IF NEED TO, RAISE THE GLOBAL MAXIMUM.
C
      IF (IGMAX.GT.0) CALL D0DESU(X1,NX,RS(IGMAX))
C
 50   RETURN
C
      END
