#
/*
 *	Memory Parity enable and fail routines
 *	called from trap.c and main.c
 *	Peter C 26/May/78
 */
#include "../param.h"

#define PARREG	0172100		/* Address of parity registers */
#define ENABLE	01		/* Turn parity on */
#define ERROR	0100000		/* Error bit */

/*
 * Parity on routine 
 */

char	*reg_map;		/* contains bit map of parity register bottom bit is 1st parity register */

paron()
{	register char *pp;
	register char *bits;

	bits = 01;
	for(pp = PARREG; pp < PARREG + 32; pp =+ 02)
	{	if(fuiword(pp) != -1)
		{
			pp->integ = ENABLE;
			reg_map =| bits;
		}
		bits =<< 1;
	}
}


/*
 *	Parity fail routine
 */

parfail()
{	register char *pp;
	register char *bits;
	register v;
	bits = 01;

	for(pp = PARREG; pp < PARREG + 32; pp =+ 02)
	{	if(reg_map&bits)
		{
			if((v = pp->integ) < 0)		/* error bit on ? */
			{
				printf("parity fail; csr (%o) %o\n", pp, v);
			}
		}
		bits =<< 1;
	}
	panic("parity");
}
