/*
 *	sys3.c
 *	file and mount syscalls
 */
#include "h\types.h"
#include "h\param.h"
#include "h\file.h"
#include "h\user.h"
#include "h\buf.h"
#include "h\filsys.h"
#include "h\inode.h"
#include "h\conf.h"
#include "h\systm.h"

void stat1(struct inode*,word);
int getmdev(void);

struct mount mount[NMOUNT];

/*
 * common in stat + fstat
 */
void stat1(ip,ub)
struct inode *ip;
word ub;
	{
	int i;
	register struct buf *bp;
	int *cp;

	iupdat(ip,time);
	bp=bread(ip->i_dev,(ip->i_number+31)/16);	/* get inode's blk */
	cp=(int*)(bp->b_addr+(32*((ip->i_number+31)%16))+24);

	ip=(struct inode*)&(ip->i_dev);
	for (i=0;i<14;i++)    		/* copy out appropriate parts	*/
		{
		suword(ub,*(((int*)ip)++));
		ub+=2;
		}
	for(i=0;i<4;i++)
		{
		suword(ub,*cp++);
		ub+=2;
		}
	brelse(bp);
	}
/*
 * fstat systemcall
 */
void fstat(fl,s)
int fl,*s;
	{
	register struct file *fp;

	fp=getf(fl);
	if (fp==NULL)
		return;
	stat1(fp->f_inode,(word)s);
	}
/*
 *  stat
 */
#pragma warn -par	/* see comment int sys4.c	*/
void stat(n,s)
char *n;
int *s;
	{
	register struct inode *ip;

	ip=namei(uchar,0);
	if(ip==NULL)
		return;
	stat1(ip,(word)s);
	iput(ip);
	}

/*
 * duplicate file
 */
dup(fl)
	{
	register int i;
	register struct file *fp;

	fp=getf(fl);
	if(fp==NULL)
		return(-1);
	if((i=ufalloc())<0)
		return(-1);
	u->u_ofile[i]=fp;
	fp->f_count++;
	return(i);
	}

/*
 * mount filesystem on inode
 */
void smount(de,n,fl)
char *de,*n;
int fl;
	{
	dev_t d;
	register struct inode *ip;
	register struct mount *mp;
	struct mount *smp;

	d=getmdev();
	if(u->u_error)
		return;
	u->u_dirp=n;
	ip=namei(uchar ,0);
	if (ip==NULL)
		return;
	if (ip->i_count!=1||(ip->i_mode&(IFBLK&IFCHR))!=0)
		goto OUT;
	smp=NULL;			/* get an empty mount slot	*/
	for (mp=&mount[0];mp<&mount[NMOUNT];mp++)
		{
		if(mp->m_bufp!=NULL)
			{		/* already mounted		*/
			if(d==mp->m_dev)
				goto OUT;
			}
		else
			if (smp==NULL)	/* got empty slot		*/
				smp=mp;
		}
	if (smp==NULL)
		goto OUT;

	(*bdevsw[major(d)].d_open)(d,!fl);
	if (u->u_error)
		goto OUT;
	mp=(struct mount*)bread(d,1);	/* read in superblock		*/
	if (u->u_error)
		{
		brelse((struct buf*)mp);
		goto OUT1;
		}
	smp->m_inodp=ip;
	smp->m_dev=d;
	smp->m_bufp=getblk(NODEV,0);	/* alloc buffer for superblock	*/
	bcopy(((struct buf*)mp)->b_addr,smp->m_bufp->b_addr,256);
	smp=(struct mount*)smp->m_bufp->b_addr;
	((struct filsys*)smp)->s_ilock=0;
	((struct filsys*)smp)->s_flock=0;
	((struct filsys*)smp)->s_ronly=fl&1;
	brelse((struct buf*)mp);
	ip->i_flag|= IMOUNT;		/* inode is now mounted on	*/
	prele(ip);
	return;
OUT:
	u->u_error=EBUSY;
OUT1:
	iput(ip);
	}

/*
 * umount
 */
void sumount(de)
char *de;
	{
	dev_t d;
	register struct inode *ip;
	register struct mount *mp;

	update();
	d=getmdev();
	if (u->u_error)
		return;
	for (mp=&mount[0];mp<&mount[NMOUNT];mp++)	/* get mounted	*/
		if(mp->m_bufp!=NULL && d==mp->m_dev)	/* slot		*/
			goto FOUND;
	u->u_error=EINVAL;			/* wasn't mounted	*/
	return;

FOUND:
	for(ip=&inode[0];ip<&inode[NINODE];ip++)
		if(ip->i_number!=0 && d==ip->i_dev)
			{
			u->u_error=EBUSY;	/* dev still in use	*/
			return;
			}
	(*bdevsw[major(d)].d_close)(d,D_UMOUNT);
	ip=mp->m_inodp;
	ip->i_flag&=~IMOUNT;			/* unmount inode	*/
	iput(ip);
	ip=(struct inode*)mp->m_bufp;
	mp->m_bufp=NULL;
	brelse((struct buf*)ip);		/* release sb buffer	*/
	}
/*
 * get device to be mounted
 */

int getmdev(void)
	{
	register dev_t d;
	register struct inode *ip;

	ip=namei(uchar,0);

	if(ip==NULL)
		return(NODEV);
	if((ip->i_mode&IFMT)!=IFBLK)	/* only blk dev can be mounted	*/
		u->u_error=ENOTBLK;
	d=ip->i_addr[0];
	if(major(ip->i_addr[0])>=nblkdev)	/* illegal major number	*/
		u->u_error=ENXIO;
	iput(ip);
	return(d);
	}
