/*
 *	rdwri.c
 */

#include "h\types.h"
#include "h\param.h"
#include "h\proc.h"
#include "h\user.h"
#include "h\inode.h"
#include "h\conf.h"
#include "h\buf.h"
#include "h\systm.h"

extern byte endofd;

/*
 * read the file belonging to the inode
 *
 *	u_base  -	ptr to read data to
 *	u_offset-	offset in file
 *	u_count -	bytes to read
 *	u-segflg-	read to kernel or user memory
 */
void readi(ip)
register struct inode *ip;
	{
	struct buf *bp;
	word lbn,bn,on,n;
	register word dn;

	if(u->u_count==0)
		return;

	ip->i_flag|=IACC;
	if ((ip->i_mode&IFMT)==IFCHR)	/* char special file	*/
		{
		(*cdevsw[major(ip->i_addr[0])].d_read)(ip->i_addr[0]);
		return;
		}
	do
		{
		lbn=bn=(word)(u->u_offset>>9);
		on =(word)(u->u_offset&0777);
		n=min(512-on,u->u_count);
		if ((ip->i_mode&IFMT)!=IFBLK)
			{		/* regular file		*/
			dn=(word)(I_SIZE(ip)-u->u_offset);
			/*(((dword)ip->i_size0)<<16)+ip->i_size1*/

			if (dn<=0)
				return;

			n=min(n,dn);

			if((bn=bmap(ip,lbn))==0)
				return;
			dn=ip->i_dev;
			}
		else
			{		/* block special file	*/
			dn=ip->i_addr[0];
			rablock=bn+1;
			}
		if (ip->i_lastr+1==lbn)
			bp=breada(dn,bn,rablock);
		else
			bp=bread(dn,bn);

		ip->i_lastr=lbn;

		iomove(bp,on,n,B_READ);
		brelse(bp);
		}
		while(u->u_error==0 && u->u_count>0);
	}

/*
 * write to file belonging to inode
 */

void writei(ip)
register struct inode *ip;

	{
	struct buf *bp;
	int n,on,dn;
	register int bn;
	ip->i_flag|=IACC|IUPD;
	if((ip->i_mode&IFMT)==IFCHR)
		{
		(*cdevsw[major(ip->i_addr[0])].d_write)(ip->i_addr[0]);
		return;
		}
	if (u->u_count==0)
		return;
	do
		{
		bn=(word)(u->u_offset>>9);
		on=(word)(u->u_offset&0777);
		n=min(512-on,u->u_count);
		if((ip->i_mode&IFMT)!=IFBLK)
			{
			if ((bn=bmap(ip,bn))==0)
				return;
			dn=ip->i_dev;
			}
		else
			dn=ip->i_addr[0];
		if(n==512)
			bp=getblk(dn,bn);
		else
			bp=bread(dn,bn);
		iomove(bp,on,n,B_WRITE);

		if(u->u_error!=0)
			brelse(bp);
		else
			if ((u->u_offset&0777)==0)
				bawrite(bp);
			else
				bdwrite(bp);
		if(((ip->i_size0<=(u->u_offset>>16))&&
		   (ip->i_size1< (u->u_offset&0xffff)))&&
			(ip->i_mode&(IFBLK&IFCHR))==0)
			{
			ip->i_size0=(byte)(u->u_offset>>16);
			ip->i_size1=(word)(u->u_offset&0xffff);
			}
		ip->i_flag |= IUPD;
		}
		while(u->u_error==0 && u->u_count!=0);
	}

/*
 * move data to/from buffer and user memory
 */

void iomove(bp,o,n,flag)
struct buf *bp;
register int n;
int o,flag;
	{
	register char *cp;
	int t;
	cp=bp->b_addr+o;
	if (flag==B_WRITE)
		{
#ifndef ONLY_C
		t=copyin(u->u_base,cp,n);
#else
		while(n--)
			{
			if ((t=cpass())<0)
				return;
			*cp++=t;
			}
#endif /* ONLY_C */
		}
	else
		{
#ifndef ONLY_C
		t=copyout(cp,u->u_base,n);
#else
		while(n--)

			if(passc(*cp++)<0)
				return;
#endif /* ONLY_C */
		}
	if (t)
		{
		u->u_error=EFAULT;
		return;
		}
	u->u_base+=n;
	u->u_offset+=n;
	u->u_count-=n;
	return;
	}

#ifndef ONLY_C

/*
 * move from user/kernel memory to kernel memory
 */
copyin(fr,to,n)
void *fr,*to;
word n;
	{
	if(u->u_segflg)
		{
		while(n--)
			*(((char*)to)++)=*(((char*)fr)++);
		return(0);
		}
	if ((dword)fr+(dword)n>cup->p_ldt[DATAS/8].limit)
		return(-1);
asm	{	push di;
		push si;
		push ds;
		cld
		mov cx,n;
		mov si,fr;
		mov di,to;
		mov ax,0fh;
		mov ds,ax;
		mov ax,28h;	/* Kernel data */
		mov es,ax;
	rep	movsb;
		pop ds;
		pop si;
		pop di;
	}
	return (0);
	}
/*
 * move from kernel memory to user/kernel memory
 */
copyout(fr,to,n)
void *fr,*to;
word n;
	{
	if(u->u_segflg)
		{
		while(n--)
			*(((char*)to)++)=*(((char*)fr)++);
		return(0);
		}
	if ((dword)to+(dword)n>cup->p_ldt[DATAS/8].limit)
		return(-1);
asm	{	push di;
		push si;
		push ds;
		cld;
		mov cx,n;
		mov si,fr;
		mov di,to;
		mov ax,0fh;
		mov es,ax;
		mov ax,28h;	/* Kernel data */
		mov ds,ax;
	rep	movsb;
		pop ds;
		pop si;
		pop di;
	}
	return (0);
	}
#endif /* ONLY_C */