/*
 *	tty.h
 */

/*
 * CBLOCK must be power of 2, also change i286.asm
 */

#define	CBLOCK	8
#define	CBSIZE	(CBLOCK - sizeof(struct cblock *))
#define	CROUND	(CBLOCK - 1)

/*
 * cblocks are used as temporary storage for characters
 * coming and going from and to tty devices
 */
struct cblock
	{
	struct cblock *c_next;  /* next block		*/
	char c_info[CBSIZE];	/* the characters	*/
	};

/*
 * a clist is a chained list of cblocks
 */
struct clist
	{
	int c_cc;     		/* chars in this list	*/
	char *c_cf;		/* ptr to firs char	*/
	char *c_cl;		/* ptr to last char	*/
	};

/*
 * the tty struct
 * every tty like device has one
 */
struct tty
	{
	struct	clist	t_rawq;		/* raw chars coming in	       	*/
	struct	clist	t_canq;		/* incoming after e&k processing*/
	struct	clist	t_outq;		/* chars going out		*/
	int	t_flags;		/* flags changeable by stty 	*/
	int	(*t_addr)(struct tty*);	/* startup fn if exeists	*/
	char	t_delct;		/* delimiters in raw queue	*/
	char	t_char;			/*				*/
	char	t_rowp;			/* cursor row			*/
	char	t_colp;			/* cursor column		*/
	int	t_state;		/* internal state		*/
	int	t_speeds;		/* line speeds			*/
	dev_t	t_dev;			/* tty device number		*/
	char	t_erase;		/* erase char			*/
	char	t_kill;			/* kill char			*/
	char	t_lnb;			/* line beginning		*/
	char	t_lnp;			/* current position		*/
	char	t_lne;			/* line end			*/
	};

/* tty i/o priorities */

#define TTIPRI  10
#define TTOPRI  20

#define CEOT    4             		/* CTRL/D */
#define CQUIT   024             	/* CTRL/T */
#define CINTR   0             		/* CTRL/@ */
#define CESC    0             		/* ESCAPE */
#define RAWN	24
#define COLN    80
#define LNM     COLN-1

/* limits */
#define TTHIWAT 80
#define TTLOWAT 20
#define TTYHOG  256

/* modes */
#define HUPCL   01
#define XTABS   02
#define LCASE   04
#define ECHO    010
#define CRMOD   020
#define RAW     040
#define ODDP    0100
#define EVENP   0200
#define ANYP	0300
#define NLDELAY 001400
#define TBDELAY 006
#define CRDELAY 03
#define VTDELAY 04

/* Internal states */
#define TIMEOUT 010             /* Waiting for delay       		*/
#define WOPEN   020             /* Waiting for open             	*/
#define ISOPEN  040             /* Device is open	                */
#define SSTART  0100            /* Device has provate startup fn       	*/
#define CARR_ON 0200            /* Software copy of carrier-present 	*/
#define BUSY    0400       	/* Device is busy   			*/
#define SELFPOS 01000           /* Device knows it's cursor pos		*/
#define ASLEEP  01   		/* Issue wakeup if ready       		*/
#define STOP    02           	/* Hold output (CTRL/s,CTRL/q) 		*/

extern char canonb[CANBSIZ];


int getc(struct clist*);
int putc(char,struct clist*);

void flushtty(struct tty*);
int canon (struct tty*);
void ttyinput (int,struct tty*);
void ttyoutput(int,struct tty*);
void ttrstrt(struct tty*);
void ttstart(struct tty*);
void ttread (struct tty*);
void ttwrite(struct tty*);
int ttsgtty(struct tty*,int*);
void signal (struct tty*,int);
