/*	lp.c
 *	Centronics paralell interface printer driver
 *
 *	(c) Szigeti Szabolcs 1992 
 *
 *		minor device: 	0 -> LPT1 ( char dev )
 *				1 -> LPT2 ( char dev )
 *				2 -> LPT3 (not yet)
 */

/* TO DO:  (1) make init for autoconfigure
 *	   (2) install dynamic int sense
 */
	   
#include "h\types.h"
#include "h\param.h"
#include "h\user.h"
#include "h\proc.h"
#include "h\machine.h"
#include "h\systm.h"

#define LPPRI 10

#define MAJOR 4		/* major device number ( see conf/c.c )	*/
#define NUNIT 3		/* number of minor devices		*/

#define P_DATA	0       /* data port	*/
#define P_STAT	1	/* status port	*/
#define P_CONT	2	/* ctrl port 	*/

#define BASE0	0x378	/* lpt1	*/
#define BASE1	0x278   /* lpt2 */
#define BASE2	0x3b0	/* lpt3 */

#define S_BUSY	128	/* device busy	*/
#define S_ACK	64	/* ack data	*/
#define S_POUT	32	/* paper out	*/
#define S_SEL	16	/* on line	*/
#define S_ERR	8	/* gen. fault	*/

#define C_ITEN	16	/* enable it	*/
#define C_SINP	8	/* select input	*/
#define C_INPR	4	/* init printer	*/
#define C_AFEED 2	/* auto feed	*/
#define C_STROB 1	/* data strobe	*/


#define RESET_TIME	HZ/3*2	/* time for printer to reset	*/
/*
 * struct lp stores the state for every monor device
 */
struct lp
	{
	byte oflag;	/* open flag		*/
	word pbase;	/* base addr		*/
	byte opt;	/* hardware options	*/
	byte lpflag;	/* flags, see below	*/
	}
	lp [NUNIT]=
	{
	{0,BASE0,0},{0,BASE1,0},{0,BASE2,0}
	};

/* oflag  */
#define OPEN 1		/* device open		*/
#define INOP 128	/* device inoperable	*/

/* lpflag */
#define LCASE 1		/* convert to upper case*/
#define CRLF  2		/* LF=CR+LF		*/
#define XTAB  4		/* expand tabs to spaces*/	/* not implemented*/
#define TRANS 8		/* translate spec chars */	/* not implemented*/
#define EJECT 16	/* Form feed at close	*/



/*
 * open device, printer open for exclusive use
 */

lpopen(dev,flag)
int dev,flag;
	{
	static inited = 0;
	register int dv=minor(dev);

	if (!inited)		/* init driver ,if first call	*/
		{
		lpinit();
		inited++;
		}
	if ((dv>=NUNIT)||(lp[dv].oflag&INOP))
		{		/* illegal dev no		*/
		u->u_error=ENXIO;
		return;
		}
	if (lp[dv].oflag==OPEN)
		{		/* printer cannot be shared!	*/
		u->u_error=EIO;
		return;
		}
	outbyte (lp[dv].pbase+P_CONT,0);

	lp[dv].oflag=OPEN;	/* set and reset flags		*/
	lp[dv].opt=0;
	lp[dv].lpflag=0;

	outbyte(lp[dv].pbase+P_CONT,C_ITEN|C_INPR|C_STROB);
        timeout(wakeup,&lp[dv].pbase,RESET_TIME);
	sleep ((int)&lp[dv].pbase,LPPRI);	/* wait for reset	*/
	if (lperror(dv))
		lp[dv].oflag=0;

	}
/*
 * close device
 */
lpclose(dev,flag)
register int dev,flag;
	{
	dev = minor(dev);
	if (!lperror())
		if (lp[dev].lpflag & EJECT)
			lpoutchar(dev,12);	/* FormFeed 	*/
	lp[dev].oflag=0;			/* Closed	*/
	}
/*
 * write onto device
 */
lpwrite(dev)
	{
	register int c;
	byte st;
	register word save;

	dev=minor(dev);
	while ((c=cpass())>=0)
		{
		if (c<='a' && c<='z' && lp[dev].lpflag & LCASE)
			c+='A'-'a';
		if (c=='\n' && lp[dev].lpflag & CRLF)
			if (lpoutchar(dev,'\r'))
				break;
		if (lpoutchar(dev,c))
			break;
		}
	return;
	}
/*
 * output one char to device
 */
lpoutchar(dev,c)
register int dev,c;
	{
	if (lperror(dev))
			return(-1);
	lock();

	outbyte (lp[dev].pbase+P_DATA,c&0xff);	/* output char	*/

	outbyte (lp[dev].pbase+P_CONT,lp[dev].opt|C_INPR|C_ITEN);
	asm {nop;nop;nop;nop;}
	outbyte (lp[dev].pbase+P_CONT,lp[dev].opt|C_INPR|C_ITEN|C_STROB);

	sleep((int)&lp[dev].pbase,LPPRI);	/* wait for interrupt	*/

	enable();
	return(0);
        }

/*
 * get device error status
 */
lperror(dev)
	{
	register int st;
	st=inbyte (lp[dev].pbase+P_STAT);
	if ((st&S_SEL)==0)
		{
		prdev("Device off line",MAJOR<<8|dev);
		goto ERROR;
		}
	if ((st&S_ERR)==0)
		{
		prdev("General failure",MAJOR<<8|dev);
		goto ERROR;
		}
	if (st&S_POUT)
		{
		prdev("Paper out",MAJOR<<8|dev);
		goto ERROR;
		}

	return(0);
ERROR:  u->u_error=EIO;
	return(1);
	}
/*
 * interrupt from dev #1
 */
/*
 * These fns should be one fn, that polls the ports and dispatches
 * int routines.
 */
lp1int()
	{
	intack1();
	wakeup ((int)&lp[0].pbase);
	}
/*
 * interrupt from dev #2
 */
lp2int()
	{
	intack1();
	wakeup ((int)&lp[1].pbase);
	}
/*
 * sgtty: set & get opt and lpflag bytes
 */
lpsgtty(dev,v)
register int dev,*v;

	{
	dev=minor(dev);
	if (lp[dev].oflag==INOP||dev>=NUNIT)
		{
		u->u_error=ENXIO;
		return(-1);
		}
	if (v)
		{
		*v++=lp[dev].opt;
		*v=lp[dev].lpflag;
		return(1);
		}
	v=&u->u_aux[0];
	lp[dev].opt    = (*v++)&C_AFEED;
	lp[dev].lpflag = *v;
	return(0);
	} 
/*
 * initialize devices
 */
/*
 * Should determine number of ports
 */
lpinit()
	{
	lp[2].oflag=INOP;	/* only 2 devices are supported yet */
	lp[1].oflag=INOP;	/* This is a kludge!!!		    */
	}