.
. Reconstructed source code of NOS/MT
.
.   Original code by John Walker / Dan Drake, ca. 1980
.   Disassembly tool by Peter Buro, 1986
.
          idt       "USER"
.
          copy      "../systemdef/sysdef"
          copy      "../systemdef/specialdef"
          copy      "../source/jsys$"
.
.         Initialise user data structure and enter command loop
.
.         Called from boot sequence for each user block with a
.         a ptr to the user block in r7.
.
.
USERH*    .                                   INITIALISE DEFAULT USER DATA
          seto      usogid(r7)                original group id  = -1
          clr       usouid(r7)                original user id   =  0
          seto      usegid(r7)                effective group id = -1
          clr       useuid(r7)                effective user id  =  0
          li        r0,02f                    default privacy = rx-rwx-rwx
          mov       r0,usdefpr(r7)            
          clr       usnactp(r7)               zero active processes
          clr       usdefdn(r7)               no default directory node
          clr       uspars(r7)                no current parameter buffer
          clr       uscurms(r7)               no current message
          clr       uscrac(r7)                script$ nesting level   = 0
          clr       uscrap(r7)                script$ file chain head = empty
          clr       usmodeb(r7)               cler user mode bits
          mov       suit,usdefsu(r7)          default directory is on 1:
          clr       usdefdi(r7)               no default directory

          mov       r7,r9                     INITIALISE HANDLER MSG QUEUE
          ai        r9,ushmq                  message queue for handler process
          blwp      initq$
          ai        r9,ushwork-ushmq          work available for handler process
          blwp      initq$
          clr       qn(r9)                    clear queue count

          mov       r7,r9                     INITIALISE OPEN FILE TABLE
          ai        r9,usoft                  start of open file table for user
          li        r0,mxof                   maximum open files per user
usopspin  clr       officode(r9)              file not open
          ai        r9,ofl                    open file table entry length
          dec       r0                        any more?
          jne       usopspin                    -> yes, do another

          mov       r7,r9                     INITIALISE REPLY QUEUE
          ai        r9,usrplm                 reply message queue
          blwp      initq$
          ai        r9,usrpld-usrplm          reply available P/V queue
          blwp      initq$
          clr       qn(r9)                    queue count

          li        r0,256                    INITIALISE SYSTEM LOW MEM SECTION
          clr       r1                        from 
          clr       r2                        to
          mov       usmb(r7),r3               user memory bank
          bl        mtu

          li        r1,bosmtl                 PRINT SIGNON LINE TO TERMINAL
          ai        r1,mbtext                 allocate msg buffer
          blwp      bgeta$
          data      memful  
          mov       r1,r8                     and build terminal message
          li        r0,mttext           
          mov       r0,mbtype(r8)             . set message type
          li        r0,bosmtl           
          mov       r0,mblen(r8)              . set signon text length
          ai        r1,mbtext           
          li        r2,bosmt                  . setup text copy
          li        r0,bosmtl
sonspin   movb      *r2+,*r1+                 copy text to message
          dec       r0
          jne       sonspin             

          mov       usterm(r7),r0             send to associated terminal
          bl        trmqms

.         Fall through to the command loop.
.
.         Note that each terminal driver is pre-loaded with a
.         'login' input text, so that will be the first command
.         read and executed.

.
. Command loop
.
UCMD*     mov       usogid(r7),usegid(r7)     reset effective user/group
          mov       usouid(r7),useuid(r7)       back to original user/group 
.
          bl        scrinp                    READING LINE FROM SCRIPT?
          data      noscrp                      -> no, regular command line
          mov       r8,uscurms(r7)            save input line msg ptr
          jmp       uexec

noscrp
          mov       usterm(r7),r0             QUERY ASSOCIATED TERMINAL
          ai        r0,chiavail            
          mov       r0,r1
          mov       ql(r1),r1                 input line waiting?
          jgt       jlb002                      -> yes

          li        r1,12                     SEND CMD PROMPT
          blwp      bgeta$                    allocate message block
          data      memful  
          mov       r1,r8                     build message
          li        r0,mttext
          mov       r0,mbtype(r8)             . set type text
          li        r0,1
          mov       r0,mblen(r8)              . set length 1
          li        r0,03a00
          mov       r0,mbtext(r8)             . set text to ':'
          mov       usterm(r7),r0
          bl        trmqms                    send to associated terminal

jlb002    mov       usterm(r7),r0             GET NEXT INPUT LINE
          bl        triget
          mov       r8,uscurms(r7)            save current input msg ptr

          c         mbtype(r8),msgint         is it an interrupt msg (^C)?
          jne       uexec                       -> no, go execute line
          
          mov       r8,r1                     IGNORE INTERRUPT FOR CMD LOOP
          blwp      brel$                     release message
          mov       r7,r0
          ai        r0,ushwork                work msg P/V queue
          blwp      p$                        yield-wait for work message
          mov       r7,r9
          ai        r9,ushmq                  unlink & release work message
          blwp      remove
          mov       r8,r1
          blwp      brel$
          jmp       ucmd                      and loop for next command line

.
. Process a command line
.   input: r7 = user ptr, r8 = input line ptr
.
UEXEC*    
          mov       r7,r5                     SCAN FOR COMMAND WORD
          mov       r8,r7                     r7 = text ptr
          ai        r7,mbtext                 r6 = text length
          mov       mblen(r8),r6
          dec       r6                        drop <cr> at end?
jlb004    
          bl        scan                      skip leading spaces
          jlt       jlb003                      -> ignore empty line
          ci        r0,' '
          jeq       jlb004
          mov       r7,r9                     place r9 at start of command
          dec       r9
          li        r1,1                      init length to 1
jlb006    
          bl        scan                      break command word at:
          jlt       jlb005  
          ci        r0,' '                    - space
          jeq       jlb005  
          ci        r0,','                    - comma
          jeq       jlb005  
          ci        r0,'('                    - open parenthesis
          jeq       jlb005  
          inc       r1
          jmp       jlb006

jlb003    .                                   RELEASE INPUT LINE & LOOP
          mov       r5,r7                     reset r7 to user ptr
UCDONE*   mov       uscurms(r7),r1            input line already released?
          jeq       ucmd                        -> yes, loop
          blwp      brel$                     release input line buffer
          jmp       ucmd                        -> loop

jlb005    .                                   CHECK BUILT-IN COMMANDS
          li        r2,sysct                  setup scan table in commands.asm
          li        r3,sysctl
jlb00A    
          c         r1,*r2                    length matches?
          jne       jlb007                      -> no, check next one
          mov       2(r2),r4                  get command name ptr
          mov       r9,r7                     rescan input line command word
          mov       r1,r6
jlb009    
          bl        scan                      check next character
          jlt       jlb008                      -> reached end = match
          swpb      r0
          cb        r0,*r4+                   character matches?
          jne       jlb007                      -> no 
          jmp       jlb009                      -> yes, check next

jlb008    
          mov       04(r2),r11                DO INTERNAL COMMAND
          mov       r9,r6                     place ptr to first character of
          a         *r2,r6                      param string in ujpkt temp
          mov       r6,ujpkt(r5)                location
          mov       r8,r0                     place length of param string in
          ai        r0,mbtext                   ujpkt+2 temp location
          s         r0,r6
          neg       r6                        r6 is minus length of cmd word
          a         mblen(r8),r6
          dec       r6                        drop <cr> at end
          mov       r6,ujpkt+2(r5)
          mov       r5,r7                     set r7 back to user ptr
          rt                                  and jump to external command

jlb007    .                                   MORE INTERNAL CMDS TO CHECK?
          ai        r2,6                      move to next cmd entry in table
          dec       r3                        last entry done?
          jne       jlb00a                      -> no, go check next

          mov       r9,ujpkt+4(r5)            GO LOAD & RUN EXTERNAL COMMAND
          mov       r1,ujpkt+6(r5)            save command string in tmp loc.
          mov       r5,r7                     set r7 back to user ptr
          b         uload                       -> after loading goto UHPRO

. Once a user program is running as its own process, the main user process
. enters a loop to handle messages:
.   (1) jsys messages sent from the child user process
.   (2) interrupt messages sent from the associated terminal (Ctrl-C)
.
. This handler loop ends when the user program calls jsys 'exit', which
. resumes the above terminal input command loop.

.
. UHPRO: wait for JSYS calls from the user program, or for Ctrl-C messages
.
UHPRO*    mov       r7,r0                     wait for message to arrive
          ai        r0,ushwork                
          blwp      p$
          mov       r7,r9                     fetch message
          ai        r9,ushmq
          blwp      remove
          mov       r8,uscurms(r7)            save in user block

          mov       mbtype(r8),r0             check message type
          li        r1,msgsys                 and look up handler routine
          li        r2,2
jlb00C    c         r0,*r1+                   found message type?
          jne       jlb00b                      -> no
          mov       *r1,r2                    fetch handler ptr
          b         *r2                         and go call
jlb00B    inct      r1
          dec       r2                        more types?                        
          jne       jlb00c                      -> yes

UHDONE*   mov       uscurms(r7),r1            release handler work message
          blwp      brel$
          jmp       uhpro                     and go wait for next

.
. User process end. called from jsys.asm, either on EXIT or EXEC jsys calls
.
.
UPEND*    mov       r7,r5                     CLOSE OPEN FILES
          ai        r5,usoft                  scan all file handles
          li        r4,mxof

jlb00E    mov       officode(r5),r3           linked to inode ptr?
          jeq       jlb00d                      ->  no, already closed
          li        r1,18                     build 'close' message
          blwp      bgeta$
          data      memful  
          mov       r3,fmrqst(r1)             param 0 is inode ptr
          clr       officode(r5)              set file handle as unlinked
          mov       r1,r8
          bl        fsbhea                    fill out std FS hdr
          li        r0,close$
          mov       r0,mbtype(r8)             set jsys 'close'
          bl        fsend                     send to FS and wait for reply
          mov       r8,r1                     free close message
          blwp      brel$

jlb00D    ai        r5,ofl                    move to next handle
          dec       r4                        more handles to do?
          jne       jlb00e                      -> yes

          mov       usmodeb(r7),r0            CLOSE SPECIAL FILES
          andi      r0,umbspfx                special files open?
          jeq       jlb00f                      -> no, skip
          li        r0,umbspfx                reset special open flag
          szc       r0,usmodeb(r7)

          li        r1,spnt                   scan special device table          
jlb011    mov       spnvec(r1),r2             get operations vector
          mov       spvexit(r2),r2            fetch 'exit' vector, set?
          jeq       jlb010                      -> no, skip
          mov       r1,ujpkt(r7)              save r1 in tmp loc
          mov       spnfct(r1),r6             set up file ctrl table ptr in r6
          bl        *r2                       call special device exit sub
          mov       ujpkt(r7),r1              restore r1
jlb010    ai        r1,spnl                   move to next device
          ci        r1,spnte                  past last one?
          jl        jlb011                      -> no, do next
          
jlb00F    li        r1,16                     SYNC DISK AND RESUME CMD LOOP
          blwp      bgeta$                    allocate FS msg
          data      memful  
          mov       r1,r8
          bl        fsbhea                    fill out std FS msg headers
          li        r0,sync$
          mov       r0,mbtype(r8)             set jsys 'sync'
          bl        fsend                     send to FS and wait for reply
          mov       r8,r1
          blwp      brel$                     release FS reply msg
          mov       usterm(r7),r1
          clr       chiraw(r1)                clear raw mode
          b         ucmd                      RESUME COMMAND LOOP
.
.
msgsys    data      mtjsys
          data      uhjsys  
msgint    data      mtint 
          data      lbl003  
.
.
lbl003    .                                   HANDLE CTRL-C INTERRUPT
          mov       uscurms(r7),r1            release ^C work message
          blwp      brel$

jlb014    mov       usterm(r7),r2             PURGE ^C INPUT MESSAGES
          ai        r2,chimsgq
          mov       r2,r3
          limi      0
jlb013    mov       qfl(r2),r2                move to next message
          c         r2,r3                     at queue end?
          jeq       jlb012                      -> yes, done
          mov       mbtype(r2),r0
          ci        r0,mtint                  ^C message?
          jne       jlb013                      -> no, check next one
          mov       qhl(r2),r9                backup & unlink ^C message
          blwp      remove
          limi      15
          mov       r8,r1                     release message
          blwp      brel$
          mov       r9,r2                     
          mov       usterm(r7),r0             repeat until purged
          ai        r0,chiavail
          blwp      p$
          jmp       jlb014

jlb012    limi      15
          clr       r0                        r0 = no error code
          mov       usactpq+qfl(r7),r1        r1 = process ptr
          ai        r1,-phulink
          bl        tdvrt                     TEST & UPDATE TRAP JSYS BLOCK
          data      lbl004                      -> not handled by user process
          b         uhpro                     handled, resume handler loop

lbl004    li        r2,readyq                 REMOVE USER PROCESS FROM READY Q
          ai        r2,2*pruser               start at queue head
          mov       r2,r3
          limi      0
jlb016    mov       qfl(r2),r2                move to next process
          c         r2,r3                     at queue end?
          jeq       jlb015                      -> yes, done
          c         phuuct(r2),r7             right user?        
          jne       jlb016                      -> no, check next
          mov       qhl(r2),r9                backup and remove from ready q
          blwp      remove
          limi      15                        repeat until done
          jmp       lbl004

jlb015    limi      15                        PURGE WORK MESSAGES
jlb018    mov       r7,r0
          ai        r0,ushwork                check work size
          blwp      pmay$                     any more work pending?
          jeq       jlb017                      -> no, done
          mov       r7,r9                     remove msg from work msg list
          ai        r9,ushmq
          blwp      remove
          mov       r8,r1                     release msg
          blwp      brel$
          jmp       jlb018                    test next

jlb017    mov       usnactp(r7),r0            FREE PROCESS(ES)
          jeq       jlb019                      -> no more processes, done
          dec       usnactp(r7)               reduce process count
          mov       r7,r9
          ai        r9,usactpq
          blwp      remove                    remove from user process queue
          ai        r8,-phulink
          li        r9,uprocl
          blwp      insert                    add back to free process queue
          jmp       jlb017

jlb019    bl        scrtrm                    END SCRIPT EXECUTION
          b         upend                     CLOSE FILES & RESUME COMMAND LOOP
.
          end        
.
