.
. Reconstructed source code of NOS/MT
.
.   Original code by John Walker / Dan Drake, ca. 1980
.   Disassembly tool by Peter Buro, 1986
.
          idt       "SPECIAL"
.
          copy      "../systemdef/sysdef"
          copy      "../systemdef/specialdef"
.
. Copy (text) message to user buffer
.
XFMSGB*   mov       mblen(r8),r0              r0 = available data length
          mov       r8,r1
          ai        r1,mbtext                 r1 = msg text ptr
          mov       ujpkt+4(r7),r2            r2 = user buffer ptr
          mov       usmb(r7),r3               r3 = user memory bank
          c         r0,ujpkt+6(r7)            available len > buffer len?
          jle       jlb000                      -> no
          mov       ujpkt+6(r7),r0            set len to requested len
jlb000    mov       r0,ujpkt+8(r7)            set bytes written word
          b         MTU                       copy msg text & return
.
. Initialise for call(s) to SFMSG
.
SFMSGI*   clr       ujpkt+8(r7)               init bytes written to zero
          mov       ujpkt+4(r7),ujpkt+10(r7)  save buffer address to temp var
          rt        
.
. Build text message(s) from user text buffer
.   input: r2 = max msg len, r7 = user block ptr
.
SFMSG*    c         ujpkt+6(r7),ujpkt+8(r7)   bytes written = buffer length?
          jeq       jlb001                    yes -> done

          mov       ujpkt+6(r7),r1            CALC MESSAGE SIZE
          s         ujpkt+8(r7),r1            calc remaining length
          c         r1,r2                     larger than max line length?
          jle       jlb002                      -> no
          mov       r2,r1                     limit to max msg length
jlb002    a         r1,ujpkt+8(r7)            adjust bytes written

          mov       r1,r0                     BUILD TEXT MESSAGE
          ai        r1,mbtext                 add header length to text len
          blwp      BGETA$                    allocate masg
          data      MEMFUL  
          mov       r1,r8
          mov       r0,mblen(r8)              r0 = text length
          mov       r1,r2
          ai        r2,mbtext                 r2 = dst pointer
          li        r1,mttext
          mov       r1,mbtype(r8)             set type to text message
          mov       ujpkt+10(r7),r1           r1 = src pointer
          a         r0,ujpkt+10(r7)           update src ptr to next chunk
          mov       usmb(r7),r3               r3 = memory banl
          inct      r11                       select normal return
          b         MFU                       COPY FROM USER SPACE & RETURN

jlb001    mov       *r11,r11                  alternate return = no more data
          rt        
.
. Is the path a special file?
.   input: r0 = path offset, r7 = user block ptr, r8 = FS msg ptr
.   output: normal return = not special
.           alternate return = special, index in r0
.
SPECFT*   mov       r7,r9                     SETUP SCAN POINTER AND LENGTH
          mov       r8,r7                     r7 points to FS block with path
          a         r0,r7                     add offset to path
          ai        r7,fmrqst                 skip std header fields
          mov       *r7+,r6                   fetch length, r7 points to text
          mov       r11,r5                    save return address

jlb004    bl        SCAN                      SKIP SPACES
          jlt       jlb003                    eol reached? -> yes                    
          ci        r0,' '                    white space?
          jeq       jlb004                      -> yes, skip
          inc       r6                        push back character
          dec       r7

          mov       r6,r3                     TEST SPECIAL FILE NAME TABLE
          mov       r7,r4                     copy path pointer
          li        r2,SPNT                   start of special name table
          
jlb009    mov       r3,r6                     TEST NAME LENGTH
          mov       r4,r7
          c         r3,spnlen(r2)             lengths match?
          jeq       jlb005                      -> equal, go test
          jl        jlb006                      -> shorter, move to next
          mov       spnlen(r2),r6             truncate path to name length
jlb005    mov       spnadr(r2),r1             get name ptr

jlb008    bl        SCAN                      COMPARE NAME VS. PATH
          jlt       jlb007                    eol? -> match found
          swpb      r0
          cb        r0,*r1+                   character matches?
          jeq       jlb008                      -> yes, test next

jlb006    ai        r2,spnl                   NEXT SPECIAL NAME TABLE ENTRY
          ci        r2,SPNTE                  reached end?
          jl        jlb009                      -> no, test next

jlb003    mov       r9,r7                     NO MATCH, restore r7
          b         2(r5)                     and take normal return
          
jlb007    c         r3,spnlen(r2)             TEST TRAILING CHARS
          jeq       jlb00A                    no trialing path chars -> found
          inct      r6                        extend scan string
          bl        SCAN                      scan past special name
          ci        r0,' '                    found a space?
          jne       jlb006                      -> no, no match, move to next
          
jlb00A    mov       r9,r7                     FOUND A SPECIAL FILE PATH
          mov       spnidx(r2),r0             get special file index
          mov       *r5,r11                   take alternate return
          rt        

. Check if the file index is a special file.
.   These indexes are fixed for all users:
.   - the index 0, 1 and 2 are hard coded to the user's console
.   - other devices have hard coded indices of 255 and below
.
SPECIX*   movb      ujpkt+3(r7),r0            IS FILE INDEX FOR SPECIAL FILE?
          srl       r0,8                      get index into r0
          li        r2,SPNT                   scan special file name table
jlb00C    c         r0,spnidx(r2)             index associated with special?
          jeq       jlb00B                      -> yes, take alternate return
          ai        r2,spnl                   move to next special file entry
          ci        r2,SPNTE                  past end of table?
          jl        jlb00C                      -> no, try next special file
          b         2(r11)                    NORMAL RETURN

jlb00B    mov       *r11,r11                  IS SPECIAL, TAKE ALTERNATE RETURN
          rt        
.
. CONS.DEV device routines
.
SPFCON*   data      00000                     spvboot
          data      00000                     spvint
          data      00000                     spvopen
          data      00000                     spvclose
          data      cns$rd                    spvread
          data      cns$wr                    spvwrite
          data      00000                     spvseek
          data      cns$io                    spvioctl
          data      00000                     spvfstat
          data      00000                     spvexit

cns$rd    mov       ujpkt+6(r7),r0            reading zero bytes?
          jeq       jlb00D                      -> yes, test pending input

          bl        SCRINP                    currently reading a script?
          data      noscrip                     -> no
          jmp       jlb00E                    -> yes, just send line

noscrip   mov       usterm(r7),r0             get line from user's terminal
          bl        TRIGET
          mov       mbtype(r8),r0             get message type
          ci        r0,mtint                  is it an interrupt (^C)?
          jeq       jlb00F                      -> yes

jlb00E    bl        XFMSGB                    SEND MSG TEXT TO USER
          mov       r8,r1                     release message
          blwp      BREL$
          b         JSYSEN                    NORMAL RETURN

jlb00F    mov       r8,r1                     release interrupt message
          blwp      BREL$
          movb      KSXINT,ujpkt+1(r7)        set interupted status code          
jlb011    clr       ujpkt+8(r7)               set zero bytes transferred
          b         JSYSE                     RETURN

jlb00D    mov       uscrap(r7),r0             in a script?
          jne       jlb010                      -> yes, return OK
          mov       usterm(r7),r1
          mov       chiavail+qn(r1),r0        messages pending?
          jgt       jlb010                      -> yes, return OK
          movb      KSEOF,ujpkt+1(r7)         set status EOF
          jmp       jlb011                    -> return with status
jlb010    movb      KSNORM,ujpkt+1(r7)        set status OK
          jmp       jlb011                    -> return with status

cns$wr    bl        SFMSGI                    init write routine
jlb012    li        r2,134                    set max msg length
          bl        SFMSG                     build message(s) from data
          data      JSYSEN                      -> no more chunks, done
          mov       usterm(r7),r0             get user's terminal
          bl        TRMQMS                    send text message
          jmp       jlb012                    -> try next chunk

cns$io    movb      ujpkt+2(r7),r0            get control string length
          srl       r0,8
          ci        r0,2                      length <2?
          jl        jlb013                      -> do nothing
          mov       ujpkt+4(r7),r1            get ctrl string address
          inc       r1                        r1 = data byte addr
          li        r0,1                      r0 = 1 byte len
          mov       r7,r2
          ai        r2,ujpkt+6                r2 = dst is tmp loc in ujpkt
          mov       usmb(r7),r3               r3 = memory bank
          bl        MFU                       FETCH IOCTL DATA BYTE

          clr       r0                        clear raw flag
          movb      ujpkt+6(r7),r1            data byte is zero?
          jeq       jlb014                      -> yes, normal mode
          inc       r0                        set 'raw' mode flag
jlb014    mov       usterm(r7),r1
          mov       r0,chiraw(r1)             set term to raw mode
          jeq       jlb013                    setting to normal? -> done
          clr       chechol(r1)               reset echo lock
          mov       r1,r0                     signal work available
          ai        r0,chowork                  to make terminal pick up
          blwp      V$                          these status changes

jlb013    b         JSYSEN                    RETURN

.
. Write to terminal of (another) user
.
SPFITM*   data      00000                     spvboot
          data      00000                     spvint
          data      00000                     spvopen
          data      00000                     spvclose
          data      00000                     spvread
          data      itm$wr                    spvwrite
          data      00000                     spvseek
          data      00000                     spvioctl
          data      00000                     spvfstat
          data      00000                     spvexit

itm$wr    mov       r6,ujpkt+12(r7)           save terminal pointer
          bl        SFMSGI                    init transfer
jlb015    li        r2,134                    max msg length 134 bytes
          bl        SFMSG                     build a message
          data      JSYSEN                      -> no more chunks, done
          mov       ujpkt+12(r7),r0           send msg to the terminal
          bl        TRMQMS
          jmp       jlb015                    check for more chunks

.
. PARAM.DEV device routines
.
SPFPRM*   data      00000                     spvboot
          data      00000                     spvint
          data      00000                     spvopen
          data      00000                     spvclose
          data      prm$rd                    spvread
          data      00000                     spvwrite
          data      00000                     spvseek
          data      00000                     spvioctl
          data      00000                     spvfstat
          data      00000                     spvexit

prm$rd    mov       uspars(r7),r8             fetch current param string msg
          bl        XFMSGB                    copy text to user space
          b         JSYSEN                    return status OK
.
          end        
.
