.
. Reconstructed source code of NOS/MT
.
.   Original code by John Walker / Dan Drake, ca. 1980
.   Disassembly tool by Peter Buro, 1986
.
          idt       "JSYS"
.
          copy      "../systemdef/sysdef"

. =============================================================================
. JSYS MESSAGE CREATION & HANDLING
. =============================================================================

. JSYSI turns a xop 1 syscall into a msg to the user handler.
.   Called from JSYS (in common.asm) at limi 0, r8 = process ptr
.
JSYSI*    li        r1,14                     BUILD JSYS MESSAGE
          blwp      BGETA$
          data      MEMFUL  
          mov       r8,mbtext(r1)             set proces block ptr
          mov       r10,mbtext+2(r1)          set user's jsys block ptr
          mov       lbl000,mbtype(r1)         set type jsys
          mov       phuuct(r8),r9             get user block ptr
          mov       r9,r0
          ai        r9,ushmq
          ai        r0,ushwork
          mov       r1,r8                     place msg on user handler queue
          blwp      INSERT
          blwp      VINT$                     signal work available
          b         ENDIN$                    return when handler thread done

lbl000    data      mtjsys

. UHJSYS: perform work for system call
.   called from process handler after receiving a msg from the user process
.   r8 = jsys message as created by JSYSI above.
.
UHJSYS*   li        r0,2                      COPY 1ST WORD OF JSYS REQUEST
          mov       mbtext+2(r8),r1           r1 = user's jsys request ptr
          mov       r7,r2
          ai        r2,ujpkt                  r2 = jpkt area in user block            
          mov       usmb(r7),r3               r3 = memory bank
          bl        MFU                       copy from user space

          movb      ujpkt(r7),r1              ANALYSE REQUEST
          srl       r1,8
          ci        r1,37                     within range?
          jl        jlb000                      -> yes
          clr       r1                        turn into 'unknow' jsys
jlb000    a         r1,r1                     turn into index (i.e. x 4)
          a         r1,r1
          movb      lbl001(r1),r0             get jsys block size in bytes
          srl       r0,8
          mov       r0,mbtype(r8)             change message type (should be mblen?)
          mov       lbl002(r1),r9             fetch service routine
          dect      r0                        jsys request >2 bytes long?
          jeq       jlb001                      -> no

          mov       mbtext+2(r8),r1           COPY REST OF JSYS REQUEST
          inct      r1                        r1 = rest of request        
          mov       r7,r2
          ai        r2,ujpkt+2                r2 = rest of jpkt area
          mov       usmb(r7),r3               r3 = memory bank
          bl        MFU                       copy from user space

jlb001    b         *r9                       jump to service routine

. JSYSEN: end JSYS call with OK status
.
JSYSEN*   movb      KSNORM,ujpkt+1(r7)        set OK reply status

. JSYSE: tail end of a JSYS call
.
. This routine copies the jsys reply back to the user process and checks for
. any pending ^C interrupt.
.
JSYSE*    mov       uscurms(r7),r8            fetch jsys msg ptr
          mov       mbtext+2(r8),r2           r2 = user's jsys request ptr
          mov       mbtype(r8),r0             r0 = reply type (should be mblen?)
          mov       r7,r1                     r1 = jpkt area in user block
          ai        r1,ujpkt
          mov       usmb(r7),r3               r3 = memory bank
          bl        MTU                       COPY REPLY BACK TO USER SPACE
          mov       ushwork+qn(r7),r0         more pending handler work?
          jgt       jlb002                      -> yes
          jmp       jlb003                      -> no

jlb002    mov       ushmq+qfl(r7),r8          get next work
          mov       mbtype(r8),r0             get type
          ci        r0,mtint                  is it a Ctrl-C message?
          jeq       jlb004                      -> yes

jlb003    mov       uscurms(r7),r1            fetch jsys msg ptr
          mov       mbtext(r1),r8             fetch process block ptr
          li        r9,2*pruser               select user prio ready queue
          ai        r9,READYQ
          blwp      INSERT                    SET USER PROCESS RUNNABLE
          blwp      BREL$                     release jsys reply
          b         UHPRO                     RESUME WORK HANDLER

jlb004    clr       r0                        CHECK TRAP BITS
          mov       uscurms(r7),r1            fetch jsys msg ptr
          mov       mbtext(r1),r1             fetch process block ptr
          bl        TDVRT                     has a trap routine been set?
          data      lbl003                      -> no

          mov       r7,r0                     PURGE ^C WORK MESSAGE             
          ai        r0,ushwork                wait for ^C msg to arrive
          blwp      P$
          mov       r7,r9                     remove from queue
          ai        r9,ushmq
          blwp      REMOVE
          mov       r8,r1                     and release it
          blwp      BREL$

          mov       usterm(r7),r1             PURGE ^C INPUT LINE
          mov       chiavail+qn(r1),r0        pending input line(s)?
          jgt       jlb005                      -> yes
          jmp       jlb006                      -> no, resume user process

jlb005    mov       chimsgq+qfl(r1),r2        get first pending input msg
          mov       mbtype(r2),r0
          ci        r0,mtint                  is it ^C?
          jne       jlb006                      -> no, resume user process
          mov       r1,r0                     wait for input to become available
          ai        r0,chiavail
          blwp      P$
          mov       r1,r9                     remove from queue
          ai        r9,chimsgq
          blwp      REMOVE
          mov       r8,r1                     and release it
          blwp      BREL$
jlb006    jmp       jlb003                    
          
lbl003    mov       uscurms(r7),r1            LEAVE IN QUEUE FOR HANDLER PROCESS
          blwp      BREL$                     release jsys msg
          b         UHPRO                     -> resume handler loop

. For reference: the layout of the TRAP jsys block:
.
.    +----------+----------+
.  0 | JTRAP    | (status) |
.  2 |     mask bits       |
.  4 |   trap routine      |
.  6 | prev addr (reentry) |
.  8 | prev mask (error)   |
.    +----------+----------+

TDVRT*    .                                   TEST & UPDATE TRAP JSYS BLOCK
          mov       r0,r8                     save error code
          mov       r1,ujpkt+10(r7)           save proc ptr (not copied to usr)

          li        r1,1                      default error mask = 1
          srl       r0,8                      
          jeq       jlb007  
          sla       r1,r0                     shift mask bit with error val

jlb007    mov       ustrapm(r7),r0            fetch trap bits
          inv       r0                        
          szc       r0,r1                     interrupt trapped?
          jne       jlb008                      -> yes
          mov       *r11,r11                    -> no, use notrap vector
          rt

jlb008    mov       r11,r9                    UPDATE TRAP JSYS BLOCK
          mov       ustrapp(r7),r2            r2 = dst = trap reentry word
          ai        r2,6                           
          li        r0,2                      r0 = len = 2 bytes
          mov       ujpkt+10(r7),r1           get saved process block ptr
          ai        r1,phpc                   r1 = src = phpc ptr
          mov       usmb(r7),r3               r3 = memory bank
          bl        MTU                       copy return PC to 'reentry'

          stwp      r1                        r1 = src = ptr to r8 = error code
          ai        r1,2*r8
          li        r0,2                      r0 = len = 2 bytes
          mov       ustrapp(r7),r2            r2 = dst = trap error word
          ai        r2,8
          mov       usmb(r7),r3               r3 = memory bank
          bl        MTU                       copy error code to 'error'

          li        r0,2                      r0 = len = 2 bytes
          mov       ustrapp(r7),r1            r1 = src = trap 'routine' word
          ai        r1,4
          mov       ujpkt+10(r7),r2           get saved process block ptr
          ai        r2,phpc                   r2 = dst = phpc ptr
          mov       usmb(r7),r3               r3 = memory bank
          bl        MFU                       ! update user PC to int routine !

          b         2(r9)                     NORMAL RETURN

. JSYS TABLE
.
. This table has en entry for every JSYS call. The first word has the length
. in bytes of the request block, the second has a ptr to the service routine
. for each JSYS call.
.
. Note that these routines are not called from the user program threads, but
. from the handler thread of each user.

lbl001    data      0200                      jsys 0   undef
lbl002    data      jundef
.
          data      0200, jundef              jsys 1   undef
          data      0400, jexit               jsys 2   exit$
          data      0200, jundef              jsys 3   undef
          data      0400, jdelay              jsys 4   delay$
          data      0800, jopen               jsys 5   open$
          data      0400, jclose              jsys 6   close$
          data      0a00, jcreat              jsys 7   create$
          data      0a00, jlink               jsys 8   link$
          data      0600, jdelet              jsys 9   delete$
          data      0600, jmkdir              jsys 10  mkdir$
          data      0a00, jread               jsys 11  read$
          data      0a00, jwrite              jsys 12  write$
          data      0C00, jseek               jsys 13  seek$
          data      0E00, jtrap               jsys 14  trap$
          data      0800, jmem                jsys 15  mem$
          data      0600, jioctl              jsys 16  ioctl$
          data      0600, jexec               jsys 17  exec$
          data      0C00, jfstat              jsys 18  fstat$
          data      0800, jalloc              jsys 19  alloc$
          data      0600, jsboot              jsys 20  sboot$
          data      0200, jsync               jsys 21  sync$
          data      0800, jmount              jsys 22  mount$
          data      0600, jdmoun              jsys 23  dmount$
          data      0800, jchacc              jsys 24  chacc$
          data      0a00, jchown              jsys 25  chown$
          data      0600, jasdir              jsys 26  asdir$
          data      0a00, jgetid              jsys 27  getid$
          data      0800, jsetid              jsys 28  setid$
          data      0600, jtime               jsys 29  time$
          data      0600, jstime              jsys 30  stime$
          data      0C00, jvstat              jsys 31  vstat$
          data      0600, jscript             jsys 32  script$
          data      0a00, jprep               jsys 33  prep$
          data      0600, jfdup               jsys 34  fdup$ 
          data      0C00, jfosta              jsys 35  ostat$
          data      0400, jflock              jsys 36  flock$

. =============================================================================
. JSYS WORKER ROUTINES (FILE RELATED ONES ARE IN JSYSF.ASM)
. =============================================================================

. jundef: report undefined JSYS call
.
jundef    li        r1,26                     REPORT ERROR
          blwp      BGETA$                    allocate text message
          data      MEMFUL  
          mov       r1,r8
          li        r0,mttext                 set type to text
          mov       r0,mbtype(r8)
          li        r0,16                     set str size to 16
          mov       r0,mblen(r8)

          li        r2,lbl00E                 copy str to msg
          ai        r1,mbtext
jlb009    movb      *r2+,*r1+
          dec       r0
          jne       jlb009

          mov       usterm(r7),r0             send text to associated terminal
          bl        TRMQMS
          b         lbl00F                    AND EXIT USER PROCESS
.
lbl00E    text      "Undefined JSYS."
lbl011    byte      0d                        <cr>
          even

.    +----------+----------+
.  0 | JEXIT    |          |
.  2 |     exit status     |
.    +----------+----------+

jexit     
          mov       ujpkt+2(r7),r0            Fetch exit status
          jeq       lbl00F                      -> status OK, just terminate
          
          li        r1,34                     SEND EXIT MESSAGE TO TERMINAL
          blwp      BGETA$
          data      MEMFUL  
          mov       r1,r8
          li        r0,mttext                 type is text message
          mov       r0,mbtype(r8)
          li        r0,24                     text length is 24 chars
          mov       r0,mblen(r8)
          ai        r1,mbtext                 copy termination txt to msg
          li        r2,lbl010
          li        r0,19
jlb00A    movb      *r2+,*r1+
          dec       r0
          jne       jlb00A  
          mov       00024(r7),r0              add exit code in hex
          bl        HEXWOR
          movb      lbl011,*r1+               add <cr>
          mov       usterm(r7),r0             send to terminal
          bl        TRMQMS

lbl00F    mov       uscurms(r7),r8            REMOVE PROCESS FROM ACTIVE QUEUE
          mov       mbtext(r8),r8             find process head
          ai        r8,phulink
          mov       qhl(r8),r9                back-up
          blwp      REMOVE                      and remove next 
          ai        r8,-phulink

          li        r9,UPROCL                 PUT PROCESS BACK ON FREE LIST
          blwp      INSERT
          mov       uscurms(r7),r1            release cmd line buffer
          blwp      BREL$
          dec       usnactp(r7)               more processes active for user?          
          jne       jlb00B                      -> yes
          b         UPEND                     resume command loop

jlb00B    b         UHPRO                     resume wait

HEXWOR*   li        r2,4                      PRINT HEX WORD TO STRING
jlb00C    src       r0,12
          mov       r0,r3
          andi      r3,0000F
          movb      HEXTAB(r3),*r1+           hextab is in edit.asm
          dec       r2
          jne       jlb00C  
          rt        

lbl010    text      "Termination status "
          even

.    +----------+----------+
.  0 | JDELAY   | (status) |
.  2 |     wait time       |  note: wait time is in msec
.    +----------+----------+

jdelay    li        r2,1000                   calculate ms per tick
          clr       r1
          li        r3,TICKSE
          div       r3,r1                     result in r1

          clr       r2                        
          li        r0,1                      minimum one tick delay
          mov       ujpkt+2(r7),r3            requested delay is zero?
          jeq       jlb00D                      -> yes, wait one tick
          div       r1,r2                     calc delay in ticks
          mov       r2,r0                     result is zero?
          jne       jlb00D                      -> no
          inc       r0                        still one tick minimum
jlb00D    blwp      D$ELAY                    go wait (and yield)
          b         JSYSEN                    return status OK

.    +----------+----------+
.  0 | JTRAP    | (status) |
.  2 |     mask bits       |
.  4 |   trap routine      |
.  6 | prev trap (reentry) |
.  8 | prev mask (error)   |
. 10 |    additional 1     |
. 12 |    additional 2     |
.    +----------+----------+

jtrap     mov       ustrapm(r7),ujpkt+8(r7)   return old trap mask
          mov       ustrapp(r7),ujpkt+6(r7)   return old trap jsys ptr
          mov       ujpkt+2(r7),ustrapm(r7)   set new trap mask
          mov       uscurms(r7),r8            set new jsys ptr
          mov       mbtext+2(r8),ustrapp(r7)
          b         JSYSEN                    -> return with status OK

.    +----------+----------+
.  0 | JMEM     | (status) |
.  2 |     sub function    |
.  4 |    (first free)     |
.  6 |     (free len)      |
.    +----------+----------+

jmem      mov       usfreea(r7),ujpkt+4(r7)   place values in reply
          mov       usfreel(r7),ujpkt+6(r7)
          b         JSYSEN                    return with status OK

.    +----------+----------+
.  0 | JEXEC    | (stat)   |
.  2 | path len |          |
.  4 |      path addr      |
.    +----------+----------+

jexec     mov       usnactp(r7),r0            CHECK IMAGE IS SINGLE THREADED
          dec       r0                        single process (=thread) image?
          jne       jlb00E                      -> no
          clr       usnactp(r7)               zero process count
          
          mov       mbtext(r8),r8             REMOVE PROCESS FROM USER LIST
          ai        r8,phulink                fetch process block ptr
          mov       qhl(r8),r9
          blwp      REMOVE                    unlink from user
          ai        r8,-phulink

          li        r9,UPROCL                 RETURN PROCESS BLOCK TO FREE LIST
          blwp      INSERT

          mov       uscurms(r7),r1            BUILD FAKE COMMAND LINE MSG
          blwp      BREL$                     release old request
          movb      ujpkt+2(r7),r1            calculate msg size
          srl       r1,8                        as name len + 12
          mov       r1,r0                     zero name length?
          jeq       jlb00F                      -> yes, same as exit
          ai        r1,12
          blwp      BGETA$                    allocate new message
          data      MEMFUL  
          mov       r1,uscurms(r7)
          li        r2,mttext
          mov       r2,mbtype(r1)
          mov       r0,mblen(r1)

          mov       r1,r8                     COPY EXEC PATH AS FAKE CMD LINE
          mov       r1,r2                     r2 = ptr to text in msg
          ai        r2,mbtext
          mov       ujpkt+4(r7),r1            r1 = ptr to text in user space
          mov       usmb(r7),r3               r3 = user memory bank
          bl        MFU                       copy path to message
          mov       r8,r1          

          a         mblen(r8),r1              point 1 past last char
          cb        mbtext-1(r1),lbl011       last char is <cr>?
          jeq       jlb010                      -> yes
          movb      lbl011,mbtext(r1)         add <cr> to path
          inc       mblen(r8)
jlb010    b         UEXEC                     EXECUTE CMD AS IF TYPED IN

jlb00E    movb      KSMPRC,ujpkt+1(r7)        report too many processes
          b         JSYSE
          
jlb00F    b         UPEND                     END USER PROGRAM

.    +----------+----------+
.  0 | JGETID   | (status) |
.  2 |   (original gid)    |
.  4 |   (original uid)    |
.  6 |   (effective gid)   |
.  8 |   (effective uid)   |
.    +----------+----------+

jgetid    mov       usogid(r7),ujpkt+2(r7)    get original group
          mov       usouid(r7),ujpkt+4(r7)    get original user
          mov       usegid(r7),ujpkt+6(r7)    get effective group
          mov       useuid(r7),ujpkt+8(r7)    get effective user
          b         JSYSEN

.    +----------+----------+
.  0 | JSETID   | (status) |
.  2 |  orig. + eff. gid   |
.  4 |  orig. + eff. uid   |
.  6 |    access bits      |
.    +----------+----------+

jsetid    mov       usegid(r7),r0             called by group 0 user?
          jeq       jlb011                      -> yes
          c         ujpkt+2(r7),usogid(r7)    keep original group?
          jne       jlb012                      -> no, error
          c         ujpkt+4(r7),usouid(r7)    keep original user?
          jne       jlb012                      -> no, error

jlb011    mov       ujpkt+2(r7),usogid(r7)    set original and effective group
          mov       usogid(r7),usegid(r7)
          mov       ujpkt+4(r7),usouid(r7)    set original and effective user
          mov       usouid(r7),useuid(r7)
          mov       ujpkt+6(r7),r0            default prot. bits specified?
          jeq       jlb013                      -> no
          mov       r0,usdefpr(r7)            set default protection bits
jlb013    b         JSYSEN

jlb012    movb      ksprot,ujpkt+1(r7)        report protection violation
          b         JSYSE

.    +----------+----------+
.  0 | JTIME    | (status) |
.  2 |    (time val H)     |
.  4 |    (time val L)     |
.    +----------+----------+

clentry   equ       2                         defined in RTC24 driver

jtime     mov       YRCLK,r1                  is a RTC24 card present?
          jne       jlb014                      -> yes
          li        r1,UCLOCK                 use system clock
          limi      0
          mov       *r1+,ujpkt+2(r7)          get high word
          mov       *r1,ujpkt+4(r7)           get low word
          limi      15
          b         JSYSEN                    return status OK

jlb014    mov       clentry(r1),r2            fetch RTC24 entry vector
          mov       *r2,r2                    fetch read routine ptr
          mov       r7,r8
          mov       r1,r7                     set r7 to RTC24 control block
          bl        *r2                       call read routine
          mov       r8,r7
          mov       r0,ujpkt+2(r7)            get time from r0,r1
          mov       r1,ujpkt+4(r7)
          b         JSYSEN                    return status OK

.    +----------+----------+
.  0 | JSTIME   | (status) |
.  2 |     time val H      |
.  4 |     time val L      |
.    +----------+----------+

jstime    mov       usegid(r7),r0             called by group 0 user?
          jne       jlb015                      -> no, reject
          li        r1,UCLOCK                 set system clock
          limi      0
          mov       ujpkt+2(r7),*r1+          high word
          mov       ujpkt+4(r7),*r1           low word
          limi      15
          mov       YRCLK,r3                  is a RTC24 card present?
          jne       jlb016                      -> yes
          b         JSYSEN                    return status OK

jlb016    mov       clentry(r3),r2            fetch RTC24 entry vector
          mov       2(r2),r2                  fetch write routine ptr
          mov       ujpkt+2(r7),r0            new time to r0,r1
          mov       ujpkt+4(r7),r1
          mov       r7,r8
          mov       r3,r7                     set r7 to RTC24 control block
          bl        *r2                       call RTC set time routine
          mov       r8,r7
          b         JSYSEN

jlb015    movb      ksprot,ujpkt+1(r7)        report protection violation
          b         JSYSE


. Error code table
.
ksnorm*   byte      0                         request completed normally
kseof*    byte      1                         end of file on I/O request
ksioer*   byte      2                         unrecoverable I/O error
ksnotf*   byte      3                         file not found in directory
ksbadf*   byte      4                         bad file index
kssynt*   byte      5                         bad file name syntax
ksfunc*   byte      6                         bad subfunction on request
ksnotx*   byte      7                         file not executable
ksmxof*   byte      8                         too many open files for process
ksmxin*   byte      9                         too many open files for system
ksnotd*   byte      10                        non-directory in file path
ksprot*   byte      11                        protection violation
ksstex*   byte      12                        storage exhausted on unit
ksmxfl*   byte      13                        max file count on volume reached
ksbdft*   byte      14                        bad file type for operation
ksdupn*   byte      15                        dual name for directory illegal
ksnotv*   byte      16                        file not empty
ksvlnk*   byte      17                        cannot link across volumes
ksalrd*   byte      18                        file already exists
ksbusy*   byte      19                        file / device busy
kswrng*   byte      20                        wrong volume mounted on device
ksinvv*   byte      21                        invalid volule / bad file system
ksmsns*   byte      22                        SCRIPT$ files too deeply nested
ksxint*   byte      23                        control C aborted JSYS
ksmprc*   byte      24                        too many processes active
          even
.
          end        
.
