.
. Reconstructed source code of NOS/MT
.
.   Original code by John Walker / Dan Drake, ca. 1980
.   Disassembly tool by Peter Buro, 1986
.
          idt       "COMMON"
.
          copy      "../systemdef/sysdef"
.
INTRPT*   limi      0                         HANDLE H/W INT
          clr       INTUSR                    assume system process
          mov       USRACT,r1                 currently in user process?
          jeq       l1                          -> yes, go to vector directly
          bl        sysmem                    switch to system memory bank
          mov       r8,INTUSR                 save user process block ptr
          li        r9,2*pruser
          ai        r9,READYQ                 select user prio ready queue
          blwp      PUSH$                     place process at front of queue
l1        b         *r12                      jump to vector set up by INIT*

. JSYS is the XOP 1 = JSYS handler, called directly from the xop 1 vector
.
JSYS*     limi      0                         prevent being switched ot                    
          mov       r11,r10                   save jsys block ptr
          bl        sysmem                    switch to system memory bank
          b         JSYSI

. ulaunch:  enter user mode code
.
ULAUNC*   mov       phuuct(r1),r2             get user table for this process
          mov       usmb(r2),r3               get memory bank ctrl table         
          mov       mbenbr(r3),r1             get enable bank ptr
          mov       mbdisr(r3),USRACT         store disbale bank ptr
          bl        SYSDMA                    disable system memory bank
          bl        *r1                       enable user memory bank
          rtwp                                jump to user process
.
. sysmem: enter system mode (from user mode)
.
sysmem    mov       r11,r9                    SWAP TO SYSTEM MODE
          mov       USRACT,r1                 get memory bank disable ptr  
          clr       USRACT                    clear user mode flag
          bl        *r1                       disable user memory bank
          bl        SYSMAP                    enable system bank
          mov       ACTIVE,r8                 get active process
          clr       ACTIVE                    no active process
          seto      ACTPRI                    max priority
          mov       r13,phws(r8)              save CPU state in process block
          mov       r14,phpc(r8)
          mov       r15,phstat(r8)
          b         *r9

. MFU: Move data from user memory (to system memory)
.   input: r0 = len, r1 = src, r2 = dst, r3 = src bank
.
MFU*      mov       r11,r6                    MOVE FROM USER TO SYSTEM
          mov       r0,r0                     length to move is zero?
          jne       jlb001                      -> no
          rt                                  done

jlb001    mov       r0,r4                     save length
          li        r5,DTBUFR                 r5 = staging buffer
          li        r0,bufsem
          blwp      P$                        wait for buffer access
          mov       r4,r0
          mov       r3,umbank
          mov       mbenbr(r3),r4             cache the usrmem enable call
          mov       mbdisr(r3),r3             cache the usrmem diasable call
          mov       r0,remlen                 save remaining length to copy

          ci        r0,DTBFL                  length larger than buffer?
          jle       jlb002                      -> no
          li        r0,DTBFL                  set length to buffer length
jlb002    s         r0,remlen                 adjust remaining length
          mov       r0,curlen
          mov       r1,r11                    TEST SRC BYTE MOVE
          srl       r11,1                     src is at odd address?
          joc       jlb003                      -> yes, do byte move
          inc       r0                        no, do word move
          srl       r0,1                      calc length in words (round up)
          
          limi      0                         WORD MOVE USER SRC TO BUFFER
          bl        SYSDMA                    disable system bank
          bl        *r4                       enable user bank
jlb004    mov       *r1+,*r5+                 copy word-by-word
          dec       r0
          jne       jlb004
jlb009    bl        *r3                       disable user bank
          bl        SYSMAP                    enable system bank
          limi      15

          ci        r2,DTBUFR                 target was the buffer?
          jeq       jlb005                      -> yes, done (keeping buf lock)

          li        r5,DTBUFR                 move buffer to system dst                 
          mov       curlen,r0
          mov       r0,r4                     TEST DST BYTE MOVE
          soc       r2,r4                     dst at odd byte, or length odd?
          srl       r4,1
          joc       jlb006                      -> yes, do byte move
          srl       r0,1                      calc length in words

jlb007    mov       *r5+,*r2+                 WORD MOVE BUFFER TO SYSTEM DST
          dec       r0                        copy word-by-word
          jne       jlb007

jlb00A    mov       remlen,r4                 PREPARE NEXT BLOCK TO MOVE
          mov       umbank,r3                 restore registers
          li        r0,bufsem                 release buffer
          blwp      V$
          mov       r4,r0                     any remaining length left?
          jne       jlb001                      -> yes, repeat steps

jlb005    b         *r6                       RETURN TO CALLER

jlb003    limi      0                         BYTE MOVE USER TO BUFFER
          bl        SYSDMA                    disable system bank
          bl        *r4                       enable user bank
jlb008    movb      *r1+,*r5+                 copy byte-by-byte
          dec       r0
          jne       jlb008
          jmp       jlb009                    -> continue with dst move

jlb006    movb      *r5+,*r2+                 BYTE MOVE BUFFER TO SYSTEM DST
          dec       r0                        copy byte-by-byte
          jne       jlb006  
          jmp       jlb00A                    -> prepare next block to move



. MTU: Move data to user memory (from system memory)
.   input: r0 = len, r1 = src, r2 = dst, r3 = dst bank
.
MTU*      clr       r6                        MOVE FROM SYSTEM TO USER

lbl008    mov       r0,r0                     length to move is zero?
          jne       jlb00B                      -> no
          rt                                  done

jlb00B    mov       r0,r4                     save length
          ci        r1,DTBUFR                 source is buffer?
          jeq       jlb00C                      -> yes, assume buffer locked
          li        r5,DTBUFR
          li        r0,bufsem                 wait for buffer access
          blwp      P$
jlb00C    mov       r11,retsav
          mov       r6,srcflg
          mov       r4,r0
          mov       r3,umbank
          mov       r0,remlen

          ci        r0,DTBFL                  length larger than buffer?
          jle       jlb00D                      -> no
          li        r0,DTBFL                  set length to buffer length
jlb00D    s         r0,remlen                 adjust remaining length
          ci        r1,DTBUFR                 source is system buffer?
          jeq       jlb00E                      -> yes, skip fetch
          mov       r0,curlen                 save length of current copy

          mov       srcflg,r6                 DETERMINE SRC TYPE
          jeq       jlb00F                      flag is MTU? -> normal copy
          ci        r6,0FFFF                  flag is MTUP?
          jeq       jlb010                      -> copy high bytes only
          ci        r6,1                      flag is MTUIOP?
          jeq       jlb011                      -> funky copy
          bl        *r6                       call custom copy routine
          jmp       jlb00E                    -> do dst copy

jlb00F    mov       r1,r11                    TEST SRC BYTE COPY
          srl       r11,1                     odd src address?
          joc       jlb012                      -> yes, byte copy
          inc       r0                        do word move
          srl       r0,1                      calc length in words

jlb013    mov       *r1+,*r5+                 SYSTEM SRC TO BUFFER WORD MOVE
          dec       r0
          jne       jlb013

jlb00E    li        r5,DTBUFR                 PREPARE DST MOVE
          mov       curlen,r0                 get copy length
          mov       mbenbr(r3),r4             cache usrmem enable routine
          mov       mbdisr(r3),r3             cache usrmem disable routine
          mov       r0,r11                    length or dst odd?
          soc       r2,r11
          srl       r11,1
          joc       jlb014                      -> yes, do byte move

          czc       msk$0F,r0                 length multiple of 16?
          jeq       jlb015                      -> yes, use unrolled loop
          srl       r0,1                      calc length in words

          limi      0                         WORD MOVE BUFFER TO USER DST
          bl        SYSDMA                    disable system memory bank
          bl        *r4                       enable user memory bank
jlb016    mov       *r5+,*r2+                 copy word-by-word
          dec       r0
          jne       jlb016
jlb01A    bl        *r3                       disable user memory bank
          bl        SYSMAP                    enable sysem memorey bank
          limi      15

          mov       retsav,r11                PREPARE NEXT BLOCK MOVE
          mov       srcflg,r6                 restore registers
          mov       remlen,r4
          mov       umbank,r3
          li        r0,bufsem                 release buffer
          blwp      V$
          mov       r4,r0                     remaining length to copy?
          jne       jlb00B                      -> yes, do next block
          rt                                  RETURN TO CALLER

jlb012    movb      *r1+,*r5+                 BYTE MOVE SRC TO BUFFER
          dec       r0                        move byte-by-byte
          jne       jlb012  
          jmp       jlb00E                    -> continue with dst move

jlb010    ai        r0,7                      MTUP SOURCE
          srl       r0,3                      read from device buffer that
jlb017    movb      *r1,*r5+                    has data in high bytes only
          movb       2(r1),*r5+               (unrolled, 8 bytes per loop)
          movb       4(r1),*r5+
          movb       6(r1),*r5+
          movb       8(r1),*r5+
          movb      10(r1),*r5+
          movb      12(r1),*r5+
          movb      14(r1),*r5+
          ai        r1,16
          dec       r0
          jne       jlb017  
          jmp       jlb00E                    -> continue with dst move

jlb011    ai        r0,7                      MTUIOP SOURCE
          srl       r0,3                      read from device that presents
jlb018    mov       *r1,r6                      all bytes on same address, in
          sla       r6,8                        low byte, high order byte first
          soc       *r1,r6                    (unrolled, 8 bytes per loop)
          mov       r6,*r5+
          mov       *r1,r6
          sla       r6,8
          soc       *r1,r6
          mov       r6,*r5+
          mov       *r1,r6
          sla       r6,8
          soc       *r1,r6
          mov       r6,*r5+
          mov       *r1,r6
          sla       r6,8
          soc       *r1,r6
          mov       r6,*r5+
          dec       r0
          jne       jlb018  
          jmp       jlb00E                    -> continue with dst move

jlb014    limi      0                         BYTE MOVE BUFFER TO DST
          bl        SYSDMA                    disable system memory bank
          bl        *r4                       enable user memory bank
jlb019    movb      *r5+,*r2+                 move byte-by-byte
          dec       r0
          jne       jlb019
          jmp       jlb01A                    -> resume main routine

jlb015    srl       r0,4                      MOVE BUF TO DST, UNROLLED
          limi      0                         divide length by 16
          bl        SYSDMA                    disable system memory bank
          bl        *r4                       enable user memory bank
jlb01B    mov       *r5+,*r2+                 unrolled loop, 16 bytes per loop
          mov       *r5+,*r2+
          mov       *r5+,*r2+
          mov       *r5+,*r2+
          mov       *r5+,*r2+
          mov       *r5+,*r2+
          mov       *r5+,*r2+
          mov       *r5+,*r2+
          dec       r0
          jne       jlb01B  
          jmp       jlb01A                    ->resume main routine

msk$0F    data      0F                        mask for unrollable length test

bufsem    data      bufsem                    semaphore for copy buffer access
          data      bufsem  
          data      1

remlen    bss       2                         remaining length
curlen    bss       2                         current length
umbank    bss       2                         user memory bank
srcflg    bss       2                         type of data source
retsav    bss       2                         saved return address
.
.
MTUP*     seto      r6                        set MTUP flag
          b         lbl008                    -> do the copy
.
.
MTUIOP*   li        r6,1                      set MTUIOP flag
          b         lbl008                    -> do the copy
.
. MTUA: use a routine to fetch the source
.   input: r0-r3 as for MTU, r6 = ptr to source routine
.
MTUA*     b         lbl008                    -> do the copy
.
          end        
.
