/* smg:main.c */

#include <sys/types.h>
#include <sys/fcntl.h>
#include <sys/timeb.h>
#include <signal.h>
#include <string.h>
#include <sys/wait.h>
#include <stdio.h>
#include <sys/ipm.h>
#include <sys/inet/tcp_user.h>
#include <sys/inet/in.h>

#define SMGPORT 1123
int debon(), deboff(), clean(), quit();
int debug = 0;

main(argc, argv)
int argc;
char *argv[];
{
	int tcpfd, lfd;
	struct tcpuser luser, nuser;
	int status;
	int ding();

	signal(SIGIOT, debon);
	signal(SIGALRM, ding);
	signal(SIGEMT, deboff);
	setpgrp(getpid(), getpid());
	signal(SIGHUP, clean);
	signal(SIGINT, clean);
	signal(SIGQUIT, clean);
	signal(SIGTERM, SIG_IGN);

	if (argc == 2)
		if (strncmp(argv[1], "-d", 2) == 0)
			debug = 1;

	if ((lfd = tcp_sock()) < 0)
		fatal("tcp_sock failed");
	
	bzero(&luser, sizeof luser);
	luser.lport = SMGPORT;
	if (tcp_listen(lfd, &luser) < 0)
		fatal("tcp_listen failed");

	for (;;) {
		if ((tcpfd = tcp_accept(lfd, &nuser)) < 0)
				perror("accepting stream conx");
		else 
			if (fork() == 0)
				if (fork() == 0)
					xfer_data(tcpfd);
				else
					exit(0);
			else
				wait(&status);
		close(tcpfd);
	}
}

xfer_data(tcpfd)  /* never exits, except on error */
int tcpfd;
{
	struct mesghdr mh, mymh;
	fd_set rv;
	char *dp, message[MAXMESG];
	int msid, sidfd;
	int to = 0xefffffff;
	char *p;
	int n, tot;

	signal(SIGTERM, quit);
	signal(SIGINT, quit);
	sidfd = msgbind(0);
	msid = fdsid(sidfd);
	if (debug)
		printf("started new smg pid = %d\n", getpid());
	mymh.orig.net = getnetwork();
	mymh.orig.node = getnode();
	mymh.orig.scope = getscope();
	mymh.orig.sid = msid;
	for (;;) {
		FD_ZERO(rv);
		FD_SET(tcpfd, rv);
		FD_SET(sidfd, rv);
		switch(select(getdtablesize(), &rv,(fd_set *)0, to)) {
		case 1:
		case 2:
			if (FD_ISSET(tcpfd, rv)) {
				if (read(tcpfd, &mh, sizeof mh)<=0){
					if (debug)
						printf("broken pipe\n");
					quit();
				}
				if (mh.length > MAXMESG) {
					while(mh.length > 0) {
						n = min(mh.length, MAXMESG);
						mh.length -= read(tcpfd, message, n);
					}
					if (debug)
						printf("big message received\n");
					break;
				}
				tot = 0;
				while(tot < mh.length) {
					n = read(tcpfd, message + tot, mh.length - tot);
					if (n == 0) {
						if (debug)
							printf("broken pipe2\n");
						quit();
					}
					tot += n;
				}
				memcpy(&mh.orig, &mymh.orig, sizeof mh.orig);
				if (debug) {
					printf("tcp->msgsend\n");
					printf("pid = %d\n", getpid());
					hexdump(&mh, sizeof mh);
				}
				alarm(2);
				p = msgalloc(mh.length);
				alarm(0);
				if ((int)p == -1)
					goto around;
				bcopy(message, p, mh.length);
				if(msgsend(&mh, p) < 0) {
					perror("smg:msgsend");
					msgfree(p);
				}
			}
around:
			if (FD_ISSET(sidfd, rv)) {
				dp = msgrecv(sidfd, &mh);
				if (debug) {
					printf("msgsend->tcp\n");
					printf("pid = %d\n", getpid());
					hexdump(&mh, sizeof mh);
				}
				if (write(tcpfd, &mh, sizeof mh) < 0)
					perror("smg write");
				if (write(tcpfd, dp, mh.length) < 0)
					perror("smg write");
				msgfree(dp);
			}
			break;
		case 0:
			perror("smg:select returned 0");
			break;
		case -1:
			perror("smg:select returned -1");
			break;
		}
	}
}
int
clean()
{
	if (debug)
		printf("parent exiting\n");
	kill(0, SIGTERM);
	exit(0);
}

quit()
{
	if (debug)
		fprintf(stderr, "pid %d quitting\n", getpid());
	exit(0);
}

fatal(msg)
	char *msg;
{
	perror(msg);
	exit(-1);
}

deboff()
{
	signal(SIGEMT, deboff);
	fprintf(stderr, "smg:debugging turned off pid = %d\n", getpid());
	fflush(2);
	debug = 0;
}

debon()
{
	signal(SIGIOT, debon);
	fprintf(stderr, "smg:debugging turned on pid = %d\n", getpid());
	fflush(2);
	debug = 1;
}


hexdump(p, len)
char *p;
int len;
{

	static char hexs[68];
	u_char *t, *q, *r, *s;
	int x,i,j;

	printf("hexdump len = %d (0x%x)\n", len, len);
	x = len/16;
	t=(u_char *)p;
	for (i=0;i<x;i++) {
		q=t;
		for (j=0;j<16;j++)
			printf("%02x ", *q++);
		printf("   ");
		q=t;
		for (j=0;j<16;j++) {
			if(*q >= 0x20 && *q < 0x7f)
				printf("%c", *q);
			else
				printf(".");
			q++;
		}
		printf("\n");
		t+=16;
	}
	x = len%16;
	q=t;
	for(j=0;j<16;j++) {
		if (x-- > 0)
			printf("%02x ", *q++);
		else
			printf("   ");
	}
	printf("   ");
	q=t;
	x = len%16;
	for(j=0;j<x;j++) {
		if(*q >= 0x20 && *q < 0x7f)
			printf("%c", *q);
		else
			printf(".");
		q++;
	}
	printf("\n");
}

ding()
{
	signal(SIGALRM, ding);
}

min(a,b)	{return a< b ? a : b; }
