/* uname.c: Print system info */
#include <stdio.h>
#include <sys/utsname.h>

int	nflag = 1;
int	sflag;
int	rflag;
int	vflag;
int	mflag;

main(argc, argv)
	int argc;
	char *argv[];
{
	struct utsname u;

	uname(&u);
	if (argc > 1) {
		argv++;
		sflag = 0;
		if (**argv != '-')
			usage();
		++*argv;
		while (**argv) {
			switch (**argv) {
			case 's':
				sflag++;
				break;
			case 'n':
				nflag++;
				break;
			case 'r':
				rflag++;
				break;
			case 'v':
				vflag++;
				break;
			case 'm':
				mflag++;
				break;
			case 'a':
				sflag++; nflag++; rflag++; vflag++;
				mflag++;
				break;
			default:
				printf("%x %c  ", **argv, **argv);
				usage();
			}
			++*argv;
		}
	}
	if (sflag)
		printf("%s ", u.sysname);
	if (nflag)
		printf("%s ", u.nodename);
	if (rflag)
		printf("%s ", u.release);
	if (vflag)
		printf("%s ", u.version);
	if (mflag)
		printf("%s ", u.machine);
	printf("\n");
}

usage()
{
	fprintf(stderr, "usage: uname [-snrvma]\n");
	exit(1);
}
