/* timeconst: Calculate table of time constants for 8530 */
#include <stdio.h>

#define	NSPEED	(sizeof speed_table / sizeof (int))
#define	NDIV	(sizeof div_table / sizeof (int))

main(argc, argv)
	int argc;
	char *argv[];
{
	static int speed_table[] = { 38400, 19200, 9600,
				4800, 2400, 1200, 600, 300, 150 };
	static int div_table[] = { 1, 16, 32, 64 };
	int *q, *p;
	double tc, pclk, atof();

	if (argc != 2) {
		fprintf(stderr, "Usage: %s pclk\n", argv[0]);
		exit(1);
	}
	pclk = atof(argv[1]);
	if (pclk <= 0) {
		fprintf(stderr, "pclk must be positive non-zero\n");
		exit(1);
	}
	for (p = div_table; p < &div_table[NDIV]; p++) {
		printf("\tDivide by %d\n", *p);
		for (q = speed_table; q < &speed_table[NSPEED]; q++) {
			tc = (pclk/(2.0 * *q * *p)) - 2;
			printf("%14.5f %5d\n", tc, *q);
		}
		printf("\n");
	}
}
