/*
 * Print system stuff
 */

#define mask(x) (x&0377)
#include <sys/param.h>
#include <sys/conf.h>
#include <nlist.h>
#include <sys/ipm.h>
#include <sys/sid.h>
#include <sys/ttyio.h>
#define  NZITTY 4

char	*fcore	= "/dev/kmem";
char	*fnlist	= "/unix";
int	fc;

struct	nlist setup[] = {
#define	SINODE	0
	{ "_inode"},
#define	STEXT	1
	{"_text" },
#define	SPROC	2
	{ "_proc" },
#define	STTY	3
	{ "_tty" },
#define	SNDH	4
	{ "_ndh11" },
#define	SKL	5
	{ "_constty" },
#define	SFIL	6
	{ "_file" },
#define	SMOUNT	7
	{ "_mount" },
#define	SSWAPMAP	8
	{ "_swapmap" },
#define	SCOREMAP	9
	{ "_cormap" },
#define	SSID		10
	{ "_sid" },
#define	SMESG		11
	{ "_mesg" },
	0
};

int	inof;
int	txtf;
int	prcf;
int	ttyf;
int	usrf;
long	ubase;
int	filf;
int	mountf;
int	swapmapf;
int	sidf;
int	mesgf;
int	allflg;

main(argc, argv)
char **argv;
{

	while (--argc && **++argv == '-') {
		while (*++*argv)
		switch (**argv) {

		case 'a':
			allflg++;
			break;

		case 'i':
			inof++;
			break;

		case 'x':
			txtf++;
			break;
		case 'p':
			prcf++;
			break;

		case 't':
			ttyf++;
			break;

		case 'u':
			if (--argc == 0)
				break;
			usrf++;
			ubase = hatoi(*++argv);
			break;

		case 'f':
			filf++;
			break;
		case 'm':
			mountf++;
			break;
		case 's':		/* swap map */
			swapmapf++;
			break;
		case 'S':		/* sid */
			sidf++;
			break;
		case 'M':		/* mesg */
			mesgf++;
			break;
		}
	}
	if (argc>0)
		fcore = argv[0];
	if ((fc = open(fcore, 0)) < 0) {
		printf("Can't find %s\n", fcore);
		exit(1);
	}
	if (argc>1)
		fnlist = argv[1];
	nlist(fnlist, setup);
	if (setup[SINODE].n_type == -1) {
		printf("no namelist\n");
		exit(1);
	}
	if (inof)
		doinode();
	if (txtf)
		dotext();
	if (ttyf)
		dotty();
	if (prcf)
		doproc();
	if (usrf)
		dousr();
	if (filf)
		dofil();
	if (mountf)
		domount();
	if (swapmapf)
		doswapmap();
	if (sidf)
		dosid();
	if (mesgf)
		domesg();
}

doinode()
{
#include <sys/inode.h>
	register struct inode *ip;
	struct inode xinode[NINODE];
	register int nin, loc;

	nin = 0;
	kseek(fc, (long)setup[SINODE].n_value, 0);
	read(fc, (char *)xinode, sizeof(xinode));
	for (ip = xinode; ip < &xinode[NINODE]; ip++)
		if (ip->i_count)
			nin++;
	printf("%d active inodes\n", nin);
	printf("   LOC  FLAGS  CNT DEVICE   INO   MODE NLK UID  SIZE/DEV\n");
	loc = setup[SINODE].n_value;
	for (ip = xinode; ip < &xinode[NINODE]; ip++, loc += sizeof(xinode[0])) {
		if (ip->i_count == 0)
			continue;
		printf("%7.1x ", loc);
		putf(ip->i_flag&ILOCK, 'L');
		putf(ip->i_flag&IUPD, 'U');
		putf(ip->i_flag&IACC, 'A');
		putf(ip->i_flag&IMOUNT, 'M');
		putf(ip->i_flag&IWANT, 'W');
		putf(ip->i_flag&ITEXT, 'T');
		printf("%4d", ip->i_count&0377);
		printf("%3d,%3d", major(ip->i_dev), minor(ip->i_dev));
		printf("%6ld", ip->i_number);
		printf("%7o", ip->i_mode);
		printf("%4d", ip->i_nlink);
		printf("%4d", ip->i_uid);
		if ((ip->i_mode&IFMT)==IFBLK || (ip->i_mode&IFMT)==IFCHR)
			printf("%6d,%3d", major(ip->i_rdev), minor(ip->i_rdev));
		else
			printf("%10ld", ip->i_size);
		printf("\n");
		if (allflg) {
			int i;

			for (i = 0; i < NADDR; i++)
				printf("\t%2d - %x\n", i, ip->i_addr[i]);
		}
	}
}

putf(v, n)
{
	if (v)
		printf("%c", n);
	else
		printf(" ");
}

dotext()
{
#include <sys/text.h>
	register struct text *xp;
	struct text xtext[NTEXT];
	register loc;
	int ntx;

	ntx = 0;
	kseek(fc, (long)setup[STEXT].n_value, 0);
	read(fc, (char *)xtext, sizeof(xtext));
	for (xp = xtext; xp < &xtext[NTEXT]; xp++)
		if (xp->x_iptr!=NULL)
			ntx++;
	printf("%d text segments\n", ntx);
	printf("     LOC FLAGS DADDR    CADDR  SIZE     IPTR  CNT CCNT\n");
	loc = setup[STEXT].n_value;
	for (xp = xtext; xp < &xtext[NTEXT]; xp++, loc+=sizeof(xtext[0])) {
		if (xp->x_iptr == NULL)
			continue;
		printf("%8x", loc);
		printf(" ");
		putf(xp->x_flag&XTRC, 'T');
		putf(xp->x_flag&XWRIT, 'W');
		putf(xp->x_flag&XLOAD, 'L');
		putf(xp->x_flag&XLOCK, 'K');
		putf(xp->x_flag&XWANT, 'w');
		printf(" %5u", xp->x_daddr);
		printf(" %8x", xp->x_caddr);
		printf(" %5d", xp->x_size);
		printf(" %8x", xp->x_iptr);
		printf(" %4d", xp->x_count&0377);
		printf(" %4d", xp->x_ccount);
		printf("\n");
	}
}

doproc()
{
#include <sys/proc.h>
	struct proc xproc[NPROC];
	register struct proc *pp;
	register loc, np;

	kseek(fc, (long)setup[SPROC].n_value, 0);
	read(fc, (char *)xproc, sizeof(xproc));
	np = 0;
	for (pp=xproc; pp < &xproc[NPROC]; pp++)
		if (pp->p_stat)
			np++;
	printf("%d processes\n", np);
	printf("     LOC S   F  PRI SIGNAL UID TIM CPU NI  PGRP   PID  PPID     ADDR SIZE WCHAN     LINK    TEXTP    CLKT\n");
	for (loc=setup[SPROC].n_value,pp=xproc; pp<&xproc[NPROC]; pp++,loc+=sizeof(xproc[0])) {
		if (pp->p_stat==0 && allflg==0)
			continue;
		printf("%08x", loc);
		printf("%2d", pp->p_stat);
		printf("%4o", (unsigned char)pp->p_flag);
		printf("%5d", (unsigned char)pp->p_pri);
		printf("%7o", pp->p_sig);
		printf("%4d", pp->p_uid&0377);
		printf("%4d", pp->p_time&0377);
		printf("%4d", pp->p_cpu&0377);
		printf("%3d", pp->p_nice);
		printf("%6d", pp->p_pgrp);
		printf("%6d", pp->p_pid);
		printf("%6d", pp->p_ppid);
		printf("%9x", ctob((unsigned)pp->p_addr));
		printf("%5x", pp->p_size);
		printf("%9x", pp->p_wchan);
		printf("%9x", pp->p_link);
		printf("%9x", pp->p_textp);
		printf(" %u", pp->p_clktim);
		printf("\n");
	}
}

#ifndef NTTY_LDS
#define NTTY_LDS	32
#endif

dotty()
{
	Tty tty[NTTY_LDS];
	int n;
	register char *mesg;

	mesg = " # RAW      OUT          MODE DEL COL STATE\n";
	kseek(fc, (long)setup[STTY].n_value, 0);
	read(fc, (char *)tty, sizeof tty);
	printf(mesg);
	for (n = 0; n < 10; n++)
		ttyprt(n, &tty[n]);
}

ttyprt(n, atp)
struct tty *atp;
{
	register struct tty *tp;

	tp = atp;
	printf("%2d ", n);
	printf("%08x ", tp->t_rawq);
	printf("%08x ", tp->t_outq);
	printf("%8.1o", tp->t_flags);
	printf("%3d", tp->t_delct);
	printf("%4d ", tp->t_col);
	putf(tp->t_state&TBLOCK, 'B');
	putf(tp->t_state&TTSTOP, 'S');
	printf("\n");
}

dousr()
{
#include <sys/dir.h>
#include <sys/signal.h>
#include <sys/seg.h>
#include <sys/user.h>
	union {
		struct	user rxu;
		char	fxu[USIZE << BPCSHIFT];
	} xu;
	register struct user *up;
	register i;

	printf("ubase 0x%x\n", ubase);
	kseek(fc, ubase, 0);
	read(fc, (char *)&xu, sizeof(xu));
	up = &xu.rxu;
	printf("rsav %.1x %.1x\n", up->u_rsav[0], up->u_rsav[1]);
	printf("segflg, error %d, %d\n", up->u_segflg, up->u_error);
	printf("uids %d,%d,%d,%d\n", up->u_uid,up->u_gid,up->u_ruid,up->u_rgid);
	printf("procp %.1x\n", up->u_procp);
	printf("base, count, offset %.1x %.1x %ld\n", up->u_base,
		up->u_count, up->u_offset);
	printf("cdir %.1x\n", up->u_cdir);
	printf("dbuf %.14s\n", up->u_dbuf);
	printf("dirp %.1x\n", up->u_dirp);
	printf("dent %d %.14s\n", up->u_dent.d_ino, up->u_dent.d_name);
	printf("pdir %.1x\n", up->u_pdir);
	printf("\nfile\t");
	for (i = 0; i < NOFILE; i++) {
		printf("%9x", up->u_ofile[i]);
		if ((i+1 & 03) == 0)
			printf("\n\t");
	}
	printf("\npofile\t");
	for (i = 0; i < NOFILE; i++) {
		printf("%9x", up->u_pofile[i]);
		if ((i+1 & 03) == 0)
			printf("\n\t");
	}
	printf("\nargs");
	for (i=0; i<5; i++)
		printf(" %.1x", up->u_arg[i]);
	printf("\nsizes %.1x %.1x %.1x\n", up->u_tsize, up->u_dsize, up->u_ssize);
	printf("qsav %.1x %.1x\n", up->u_qsav[0], up->u_qsav[1]);
	printf("ssav %.1x %.1x\n", up->u_ssav[0], up->u_ssav[1]);
	printf("sigs");
	for (i=0; i<NSIG; i++)
		printf(" %.1x", up->u_signal[i]);
	printf("\ntimes %ld %ld\n", up->u_utime/60, up->u_stime/60);
	printf("ctimes %ld %ld\n", up->u_cutime/60, up->u_cstime/60);
	printf("ar0 %.1x\n", up->u_ar0);
/*
	printf("prof");
	for (i=0; i<4; i++)
		printf(" %.1x", up->u_prof[i]);
*/
	printf("ttyp %.1x\n", up->u_ttyp);
	printf("ttydev %d,%d\n", major(up->u_ttyd), minor(up->u_ttyd));
	printf("comm '%.14s'\n", up->u_comm);
	printf("magic 0%o\n", up->u_exdata.ux_mag);
	printf("u_ticks %d, u_mem %d, u_ior %d, u_iow %d\n", 
		up->u_ticks, up->u_mem, up->u_ior, up->u_iow);
	for (i = 0; i < 3; i++)
		printf("%d: limit 0x%x, status 0x%x, addr 0x%x\n", 
			i,
			up->u_proto[i].limit, up->u_proto[i].status,
			up->u_proto[i].addr);
	printf("u_msglist 0x%x\n", up->u_msglist);
}

hatoi(s)
	char *s;
{
	register char *cp;
	register v;
	static char table[] = "0123456789abcdef";

	for (v = 0; *s; ++s)
		for (cp = table; *cp; cp++)
			if (*cp == *s) {
				v = (v << 4) + cp - table;
				break;
			}
	return v;
}

dofil()
{
#include <sys/file.h>
	struct file xfile[NFILE];
	register struct file *fp;
	register nf;
	int loc;

	nf = 0;
	kseek(fc, (long)setup[SFIL].n_value, 0);
	read(fc, (char *)xfile, sizeof(xfile));
	for (fp=xfile; fp < &xfile[NFILE]; fp++)
		if (fp->f_count)
			nf++;
	printf("%d open files\n", nf);
	printf("  LOC   FLG   CNT    INO    OFFS\n");
	for (fp=xfile,loc=setup[SFIL].n_value; fp < &xfile[NFILE]; fp++,loc+=sizeof(xfile[0])) {
		if (fp->f_count==0)
			continue;
		printf("%8.1x ", loc);
		putf(fp->f_flag&FREAD, 'R');
		putf(fp->f_flag&FWRITE, 'W');
		putf(fp->f_flag&FPIPE, 'P');
		putf(fp->f_flag&FSID, 'S');
		printf(" ");
		printf("%4d ", mask(fp->f_count));
		printf("%8.1x", fp->f_inode);
		printf(" %ld\n", fp->f_offset);
	}
}

domount()
{
#include <sys/mount.h>
	register struct mount *mp;
	struct mount xmount[NMOUNT];
	register nin;
	
	nin = 0;
	kseek(fc, (long)setup[SMOUNT].n_value, 0);
	read(fc, (char *)xmount, sizeof(xmount));
	for (mp = xmount; mp < &xmount[NMOUNT]; mp++)
		if (mp->m_bufp)
			nin++;
	printf("%d mounts in table\n", nin);
	printf("LOC      DEV      INODE    BUF      ROOT\n");
	for (mp = xmount; mp < &xmount[NMOUNT]; mp++) {
		if (mp->m_bufp == NULL)
			continue;
		printf("%08x ", mp - xmount);
		printf("%08x ", mp->m_dev);
		printf("%08x ", mp->m_inodp);
		printf("%08x ", mp->m_bufp);
		printf("%08x ", mp->m_mount);
		printf("\n");
	}
}
#include <sys/map.h>
doswapmap()
{
	register struct map *xp;
	struct map swapmap[SMAPSIZ];
	struct map coremap[CMAPSIZ];
	register free, largest;

	printf("Swap map\n");
	largest = free = 0;
	kseek(fc, (long)setup[SSWAPMAP].n_value, 0);
	read(fc, (char *)swapmap, sizeof swapmap);
	printf("%5s %5s\n", "ADDR", "SIZE");
	for (xp = swapmap; xp < &swapmap[SMAPSIZ]; xp++)
		if (xp->m_size > 0) {
			if (xp->m_size > largest)
				largest = xp->m_size;
			free += xp->m_size;
			printf("%5d %5d\n", xp->m_addr, xp->m_size);
		}
	printf ("Total blocks %d, largest contiguous %d\n", free, largest);

	printf ("Core map\n");
	largest = free = 0;
	kseek(fc, (long)setup[SCOREMAP].n_value, 0);
	read(fc, (char *)coremap, sizeof coremap);
	printf ("%5s %5s\n", "ADDR", "SIZE");
	for (xp = coremap; xp < &coremap[SMAPSIZ]; xp++)
		if (xp->m_size > 0) {
			if (xp->m_size > largest)
				largest = xp->m_size;
			free += xp->m_size;
			printf("%5d %5d\n", xp->m_addr, xp->m_size);
		}
	printf ("Total blocks %d, largest contiguous %d\n", free, largest);
}

#define	LOC(x)	((int)setup[SSID].n_value + ((int)(x) - (int)xsid))

dosid()
{
	register struct sid *sp;
	struct sid xsid[NSIDS];
	register nsids;

	nsids = 0;
	kseek(fc, (long)setup[SSID].n_value, 0);
	read(fc, (char *)xsid, sizeof(xsid));
	for (sp = xsid; sp < &xsid[NSIDS]; sp++)
		if (sp->serv_id)
			nsids++;
	printf("%d active sids\n", nsids);
        printf("                  IMPORT            NORM\n");
        printf("LOC      SID      FIRST    LAST     FIRST    LAST\n");
        for (sp = xsid; sp < &xsid[NSIDS]; sp++) {
                if (sp->serv_id == 0)
                        continue;
                printf("%08x ", LOC(sp));
                printf("%8d ", sp->serv_id);
                printf("%08x ", sp->import.first);
                printf("%08x ", sp->import.last);
                printf("%08x ", sp->norm.first);
                printf("%08x ", sp->norm.last);
		printf("\n");
	}
}

domesg()		/* display message structure */
{
	register struct mesg *mp;
	struct mesg xmesg[NMESG];
	register nmesgs;
	register loc;
	register struct mesghdr *hp;

	nmesgs = 0;
	kseek(fc, (long)setup[SMESG].n_value, 0);
	read(fc, (char *)xmesg, sizeof xmesg);
	for (mp = xmesg; mp < &xmesg[NMESG]; mp++)
		if (mp->addr != 0)
			nmesgs++;
	printf("%d active mesgs\n", nmesgs);
	printf("LOC      NEXT     ADDR     SIZE    FLAG LENGTH ORIG     DEST\n");
	loc = setup[SMESG].n_value;
	for (mp = xmesg; mp < &xmesg[NMESG]; mp++, loc += sizeof(struct mesg)) {
		if (mp->addr == 0)
			continue;
		printf("%08x ", loc);
		printf("%08x ", mp->next);
		printf("%08x ", mp->addr);
		printf("%08x ", mp->size);
		hp = &mp->header;
		putf(hp->flags & 1, 'I');
		putf(hp->flags & 2, 'F');
		putf(hp->flags & 4, 'R');
		printf(" %6d ", hp->length);
		printf("%d.%d.%d.%d ", hp->orig.net, hp->orig.node,
			hp->orig.scope, hp->orig.sid);
		printf("%d.%d.%d.%d\n", hp->dest.net, hp->dest.node,
			hp->dest.scope, hp->dest.sid);
	}
}
kseek(fd, offset, how)
{
	return lseek(fd, offset & ~0xC0000000, how);
}
