/*
 * adb - routines to read a.out+core at startup
 */

#include "defs.h"
#include <sys/stat.h>

off_t	datbas;			/* offset of the base of the data segment */
off_t	stksiz;			/* stack size in the core image */
INT	sigcode;	/* belongs in head.h */
L_INT	entrypt;

char	*symfil	= "a.out";
char	*corfil	= "core";
#define  KERNEL_ENTRY  0x80000000
#define	UPAGE_BASE	0x04000000
# define OMAG_TEXTOFF 0x20
# define BASE_DATA_SEGMENT (1L << 12)  /* data base in core */   
#define	NBPG	512

struct	segment	segtab[256];

setsym()
{
	off_t loc;
	struct exec hdr;
	register struct nlist *sp;
	int ssiz;
	char *strtab;


	fsym = getfile(symfil, 1);
	txtmap.ufd = fsym;

	if (read(fsym, (char *)&hdr, sizeof hdr) != sizeof hdr ||
	    N_BADMAG(hdr)) {
		txtmap.e1 = MAXFILE;
		return;
	}

	filhdr = hdr;
	loc = filhdr.a_text+filhdr.a_data;
	txtmap.f1 = txtmap.f2 = N_TXTOFF(filhdr);
	txtmap.b1 = entrypt = filhdr.a_entry;
	switch (filhdr.a_magic) {
	case OMAGIC:
		txtmap.b2 = 0;
		txtmap.e1 = txtmap.e2 = entrypt + loc;
		break;
	case ZMAGIC:
	case NMAGIC:	/* on Gun data starts at 16MB mark */
		txtmap.e1 = filhdr.a_text;
		txtmap.b2 = datbas = 1 << 24;
		txtmap.e2 = datbas + filhdr.a_data;
		txtmap.f2 += (txtmap.e1 + 511) & ~0x1ff;
	}
	loc = N_SYMOFF(filhdr);
	symtab = (struct nlist *) malloc(filhdr.a_syms);
	esymtab = &symtab[filhdr.a_syms / sizeof (struct nlist)];
	if (symtab == NULL)
		goto nospac;
	lseek(fsym, loc, 0);
	if (filhdr.a_syms == 0)
		goto nosymt;
	/* SHOULD SQUISH OUT STABS HERE!!! */
	if (read(fsym, symtab, filhdr.a_syms) != filhdr.a_syms)
		goto readerr;
	if (read(fsym, &ssiz, sizeof (ssiz)) != sizeof (ssiz))
		goto oldfmt;
	strtab = (char *) malloc(ssiz);
	if (strtab == 0)
		goto nospac;
	*(int *)strtab = ssiz;
	ssiz -= sizeof (ssiz);
	if (read(fsym, strtab + sizeof (ssiz), ssiz) != ssiz)
		goto readerr;
	for (sp = symtab; sp < esymtab; sp++)
		if (sp->n_un.n_strx)
			sp->n_un.n_name = strtab + sp->n_un.n_strx;

nosymt:
	if (INKERNEL(filhdr.a_entry)) {
		txtmap.b1 += KERNOFF;
		txtmap.e1 += KERNOFF;
		txtmap.b2 += KERNOFF;
		txtmap.e2 += KERNOFF;
	}

	return;
readerr:
	printf("Error reading symbol|string table\n");
	exit(1);
nospac:
	printf("Not enough space for symbol|string table\n");
	exit(1);
oldfmt:
	printf("Old format a.out - no string table\n");
	exit(1);
}



setcor()
{
	ADDR usersp;

	fcor = datmap.ufd = getfile(corfil,2);
	u.u_ar0 = 0;		/* offset in case this isn't a good core file */
	IF read(fcor, (char *)&u, ctob(USIZE)) != ctob(USIZE)
	ORF N_BADMAG(u.u_exdata.ux_mag)
	THEN	datmap.e1 = MAXFILE;
		return;
	FI
	u.u_ar0 = (int)u.u_ar0 - 0x04000000;
	usersp = *(ADDR *)(((ADDR)&u)+(ADDR)&u.u_ar0[SP]);
	IF kernel && fcor != -1
	THEN
		/* kcore = 1;	*/
		datmap.b1 = 0x80000000;
		lookup("_end");
		datmap.e1 = cursym->n_value;
		datmap.f1 = ctob(USIZE);
		datmap.b2 = 0x04000000;
		datmap.e2 = 0x04000000 + ctob(USIZE);
		datmap.f2 = 0;
		return;
	FI
	signo = u.u_arg[0];
	sigcode = 1; /*u.u_code;*/
	filhdr.a_text = ctob(u.u_tsize);
	filhdr.a_data = ctob(u.u_dsize);
	stksiz = ctob(u.u_ssize);
	switch (filhdr.a_magic) {
	case OMAGIC:
		datmap.b1 = 0;
		datmap.e1 = filhdr.a_text+filhdr.a_data;
		datmap.f2 = ctob(USIZE) + datmap.e1;
		datmap.e1 += datmap.b1;
		break;
	case NMAGIC:
	case ZMAGIC:
		datmap.b1 = 1 << 24;
		datmap.e1 = datmap.b1 + filhdr.a_data;
		datmap.f2 = ctob(USIZE) + filhdr.a_data;
		break;
	}
	datbas = datmap.b1;
	datmap.f1 = ctob(USIZE);
	datmap.b2 = 0x03000000 - (stksiz); 
	datmap.e2 = 0x03000000;
	if (!(filhdr.a_entry == KERNEL_ENTRY)) 
		core_exec_match();
	
}

#ifdef notdef
getpcb()
{

	lseek(fcor, masterpcbb&~0x80000000, 0);
	read(fcor, &pcb, sizeof (struct pcb));
	pcb.pcb_p0lr &= ~AST_CLR;
	printf("p0br %X p0lr %X p1br %X p1lr %X\n",
	    pcb.pcb_p0br, pcb.pcb_p0lr, pcb.pcb_p1br, pcb.pcb_p1lr);
}
#endif notdef

create(f)
	char *f;
{
	register int fd;

	fd = creat(f, 0644);
	if (fd < 0)
		return (-1);
	close(fd);
	return (open(f, wtflag));
}

getfile(filnam, cnt)
	char *filnam;
{
	register int fsym;

	if (eqstr(filnam, "-"))
		return (-1);
	fsym = open(filnam, wtflag);
	if (fsym < 0 && xargc > cnt) {
		if (wtflag)
			fsym = create(filnam);
		if (fsym < 0)
			printf("cannot open `%s'\n", filnam);
	}
	return (fsym);
}

setvar()
{

	var[varchk('b')] = datbas;
	var[varchk('d')] = filhdr.a_data;
	var[varchk('e')] = filhdr.a_entry;
	var[varchk('m')] = filhdr.a_magic;
	var[varchk('s')] = stksiz;
	var[varchk('t')] = filhdr.a_text;
}
/* Attempt to determine if the core file belongs to the binary file
   being debugged
*/
core_exec_match()
{
	if (filhdr.a_magic == u.u_exdata.ux_mag)
		return;
	printf("Corefile may not be from this program\n");
}

