static char *RCSid = "$Header: opset.c,v 1.2 86/04/22 13:58:24 mark Exp $";

/*
 * $Log:	opset.c,v $
 * Revision 1.2  86/04/22  13:58:24  mark
 * see brad
 * 
 * Revision 1.1  86/02/28  13:34:30  root
 * Initial revision
 * 
 */

#ifndef lint
static	char sccsid[] = "@(#)opset.c 4.4 5/12/83";
#endif lint

# include "defs.h"
# include "inst.h"	

/*
 *	UNIX debugger
 *	Instruction printing routines.
 *	MACHINE DEPENDENT
 */

extern ushort *disasm();

L_INT		dot;
INT		dotinc;

int curr_pc = 0;
char tmpbuf[100];
/*
 * inst_ptr: Buffer pointer containing instruction to dissamble.
 * This buffer if filled in printins() otherwise assume to be empty
 * This was a KLUGE way of passing the ENTIRE opcode to das.
 */ 
unsigned short *inst_ptr;


char *
printit(val)
int val;
{
	register int offset;

# ifdef DEBUG
	printf("val:%X\n",val);
# endif DEBUG
	offset = findsym(val,ISP);
	if (cursym)
	{
		sprintf(tmpbuf,"%s",cursym->n_un.n_name);
		if (offset != 0)
			sprintf(tmpbuf+strlen(cursym->n_un.n_name),"+#%x",
						offset);
	}
	else
		sprintf(tmpbuf,"#%x",val);
	return tmpbuf;
}

# define MAXLEN 3

printins(pc, Idsp)
register u_int	*pc;
int	Idsp;
{
	u_int codebuf[MAXLEN];
	char buf[100];
	register ushort *opcode,*newop;
	int i;

# ifdef DEBUG
	printf("pc:%X, *pc:%X\n",pc,*pc);
	flushbuf();
# endif DEBUG

	curr_pc = (u_int)pc;
	inst_ptr = (unsigned short *)(codebuf);
	inst_ptr++;
	*codebuf = chkget(pc++,ISP);
	*(codebuf+1) = chkget(pc++,ISP);
	*(codebuf+2) = chkget(pc,ISP);

	opcode = (ushort *) codebuf;
# ifdef DEBUG
	printf("opcode:%X, pc:%X\n",*opcode,curr_pc+sizeof(ushort));
	flushbuf();
# endif DEBUG


	/* sent curr_pc to check of symbol (label:) to print */

	das_print_ins(*opcode,dot);


#ifdef NODAS
	if ((newop = print_ins(opcode)) != NULL)
	{
		printf("%s",buf);
		dotinc = (newop - opcode) * sizeof (ushort);
	}
	else
		dotinc = sizeof(ushort);
#endif NODAS
}
