static char *RCSid = "$Header: dis.c,v 1.2 86/04/22 13:57:22 mark Exp $";

/*
 * $Log:	dis.c,v $
 * Revision 1.2  86/04/22  13:57:22  mark
 * see brad
 * 
 * Revision 1.1  86/02/28  13:34:23  root
 * Initial revision
 * 
 */

# include <stdio.h>
# include "inst.h"

# define local static
#define STANDALONE

extern int curr_pc;

local char *dreg[8] =
{
  "d0", "d1", "d2", "d3", "d4", "d5", "d6", "d7"
};

local char *areg[8] =
{
  "a0", "a1", "a2", "a3", "a4", "a5", "fp", "sp"
};

local char *sztab[4] =
{
  "b", "w", "l", "INVALID"
};

local char *cctab[16] =
{
  "ra", "sr", "hi", "ls", "cc", "cs", "ne", "eq",
  "vc", "vs", "pl", "mi", "ge", "lt", "gt", "le"
};

# define DREGOFF(a) (dreg[((a) >> 9) & 0x7]);
# define AREGOFF(a) (areg[((a) >> 9) & 0x7]);
# define SZCHAR(a) (sztab[((a) >> 6) & 0x3]);


local char eabuf[255];
static sizekludge = 0;

local char *
getea(opcode,opprint,offset)
ushort **opcode;
char * (*opprint)();
int offset;
{
	register int opval, index;
	register int opmode;
	register char *regptr, *szptr, *ptr;
	short displ;

	opval = (**opcode) & 0x07;
	opmode = ((**opcode) >> 3) & 0x07;

	switch (opmode)
	{
	  case 0:
		sprintf(eabuf,"%s", dreg[opval]);
		break;

	  case 1:
		sprintf(eabuf,"%s", areg[opval]);
		break;

	  case 2:
		sprintf(eabuf,"%s@", areg[opval]);
		break;

	  case 3:
		sprintf(eabuf,"%s@+", areg[opval]);
		break;

	  case 4:
		sprintf(eabuf,"-%s@", areg[opval]);
		break;

	  case 5:
		ptr = areg[opval];
disp:
	        displ = (short) *(*opcode+offset);
		sprintf(eabuf,"%s@(#0x%x) dec=%d",ptr,*(*opcode+offset),displ);
		offset++;
		break;

	  case 6:
		ptr = areg[opval];
indx:
		index = *(*opcode+offset);
		if (index & 0x8000)
			regptr = areg[(index >> 12) & 0x3];
		else
			regptr = dreg[index >> 12];
		szptr = (index & 0x0800 ? offset++,".L" : ".W");
		index &= 0xff;
		sprintf(eabuf,"%s@(#0x%x,%s%s)",ptr,
						index,regptr,szptr);
		offset++;
		break;

	  case 7:
		switch (opval)
		{
		  case 0:
			ptr = (*opprint) (*(*opcode+offset));
			sprintf(eabuf,"%s",ptr);
			break;

		  case 1:
			ptr = (*opprint) (*(long *)(*opcode+offset));
			sprintf(eabuf,"%s",ptr);
			offset ++;
			break;

		  case 2:
			ptr = "PC";
			goto disp;

		  case 3:
			ptr = "PC";
			goto indx;

		  case 4:
			opval = (**opcode) & 0x00c0;
			if (opval == 0)
				opval = (*(*opcode+offset)) & 0xff;
			else if (opval == 0x0040 || sizekludge)
				opval = *(*opcode+offset);
			else
			{
				opval = *(long *)(*opcode+offset);
				offset ++;
			}
			sprintf(eabuf,"#0x%x",opval);
			break;
		}
		offset ++;
	}
	*opcode += offset-1;
	return eabuf;
}

/*
**	get an effective address which is next to the opcode
*/

local char *
getea1(opcode,opprint)
ushort **opcode;
char * (*opprint)();
{
	return getea(opcode,opprint,1);
}

/*
**	get an effective address which is offset by one ushort from the opcode
*/

local char *
getea2(opcode,opprint)
ushort **opcode;
char * (*opprint)();
{
	return getea(opcode,opprint,2);
}

local char *
getea3(opcode,opprint)
ushort **opcode;
char * (*opprint)();
{
	return getea(opcode,opprint,3);
}

ushort *
_adr_op_ea(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *regptr;
	register char *eaptr;
	register char *szptr;

	if (*opcode & 0x0100)
		szptr = "l";
	else
		szptr = "w";
	regptr = AREGOFF(*opcode);
	eaptr = getea1(&opcode,opprint);
	sprintf(buf,"%s%s\t%s,%s",opstring,szptr,eaptr,regptr);
	return (opcode+1);
}


/*
**	this routine gets those insts which only operate on A regs
*/

ushort *
_ar(opcode,opstring,buf,opprint)
register ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *regptr;

	regptr = areg[(*opcode) & 0x7];
	sprintf(buf,"%s\t%s",opstring,regptr);
	return (opcode+1);
}
	

ushort *
_ar_imm(opcode,opstring,buf,opprint)
register ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *regptr;

	regptr = areg[(*opcode) & 0x7];
	sprintf(buf,"%s\t%s,#0x%x",opstring,regptr,*(opcode+1));
	return (opcode+2);
}

ushort *
_bcc(opcode,opstring,buf,opprint)
register ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *ccptr;
	register char disp = (*opcode) & 0xff;
	register short ldisp = *(opcode+1);

	ccptr = cctab[((*opcode) >> 8) & 0xf];
	if (disp)
	{
		sprintf(buf,"%s%s\t%s",opstring,ccptr,
					(*opprint)(disp+curr_pc+2));
		return (opcode+1);
	}
	else
	{
		sprintf(buf,"%s%s\t%s",opstring,ccptr,
				(*opprint)(ldisp+curr_pc+2));
		return (opcode+2);
	}
}

ushort *
_dbcc(opcode,opstring,buf,opprint)
register ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *ccptr, *reg;

	ccptr = cctab[((*opcode) >> 8) & 0xf];
	reg = dreg[(*opcode) & 0x7];
	sprintf(buf,"%s%s\t%s,%s",opstring,ccptr,reg,
				(*opprint)((int)*(opcode+1)+curr_pc+4));
	return (opcode+2);
}

ushort *
_dr(opcode,opstring,buf,opprint)
register ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *regptr;

	regptr = dreg[(*opcode) & 0x7];
	sprintf(buf,"%s\t%s",opstring,regptr);
	return (opcode+1);
}

ushort *
_dr_ea(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *regptr;
	register char *eaptr;

	regptr = DREGOFF(*opcode);
	eaptr = getea1(&opcode,opprint);
	sprintf(buf,"%s\t%s,%s",opstring,regptr,eaptr);
	return (opcode+1);
}

ushort *
_dr_op_ea(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *regptr;
	register char *eaptr;
	register char *szptr;
	register ushort ealast = 0;

	szptr = SZCHAR(*opcode);
	regptr = DREGOFF(*opcode);
	if ((*opcode) & 0x0100)
		ealast = 1;
	eaptr = getea1(&opcode,opprint);
	if (ealast)
		sprintf(buf,"%s%s\t%s,%s",opstring,szptr,regptr,eaptr);
	else
		sprintf(buf,"%s%s\t%s,%s",opstring,szptr,eaptr,regptr);
	return (opcode+1);
}

ushort *
_dr_sz_ea(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *regptr;
	register char *eaptr;
	register char *szptr;

	szptr = SZCHAR(*opcode);
	regptr = DREGOFF(*opcode);
	eaptr = getea1(&opcode,opprint);
	sprintf(buf,"%s%s\t%s,%s",opstring,szptr,regptr,eaptr);
	return (opcode+1);
}

ushort *
_ea(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *eaptr;

	eaptr = getea1(&opcode,opprint);
	sprintf(buf,"%s\t%s",opstring,eaptr);
	return (opcode+1);
}

ushort *
_ea_ar(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *regptr;
	register char *eaptr;

	regptr = AREGOFF(*opcode);
	eaptr = getea1(&opcode,opprint);
	sprintf(buf,"%s\t%s,%s",opstring,eaptr,regptr);
	return (opcode+1);
}

ushort *
_ea_dr(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *regptr;
	register char *eaptr;

	regptr = DREGOFF(*opcode);
	sizekludge++;
	eaptr = getea1(&opcode,opprint);
	sizekludge = 0;
	sprintf(buf,"%s\t%s,%s",opstring,eaptr,regptr);
	return (opcode+1);
}

ushort *
_exga(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *regptr1, *regptr2;

	regptr1 = AREGOFF(*opcode);
	regptr2 = areg[(*opcode) & 0x3];
	sprintf(buf,"%s\t%s,%s",opstring,regptr1,regptr2);
	return (opcode+1);
}

ushort *
_exgd(opcode,opstring,buf,opprint)
register ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *regptr1, *regptr2;

	regptr1 = DREGOFF(*opcode);
	regptr2 = dreg[(*opcode) & 0x3];
	sprintf(buf,"%s\t%s,%s",opstring,regptr1,regptr2);
	return (opcode+1);
}

ushort *
_exgm(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *regptr1, *regptr2;

	regptr1 = DREGOFF(*opcode);
	regptr2 = areg[(*opcode) & 0x3];
	sprintf(buf,"%s\t%s,%s",opstring,regptr1,regptr2);
	return (opcode+1);
}

ushort *
_ext(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *regptr;
	register char *szptr;

	if ((*opcode) & 0x0040)
		szptr = "l";
	else
		szptr = "w";
	regptr = dreg[(*opcode) & 0x7];
	sprintf(buf,"%s%s\t%s",opstring,szptr,regptr);
	return (opcode+1);
}

ushort *
_imm(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *eaptr;
	register int val;
	register char *szptr;
	register ushort *retval;

	if (((*opcode) & 0x003c) == 0x003c)
	{
		szptr = "b";
		if ((*opcode) & 0x00400)
			eaptr = "sr";
		else
			eaptr = "ccr";
		retval = opcode+2;
	}
	else
	{
		szptr = SZCHAR(*opcode);
		if (*szptr == 'l')		
		{
			val = *(long *)(opcode+1);
			eaptr = getea3(&opcode,opprint);
		}
		else
		{
			val = *(unsigned short *)(opcode+1);
			eaptr = getea2(&opcode,opprint);
		}
		retval = opcode+1;
	}
	sprintf(buf,"%s%s\t#0x%x,%s",opstring,szptr,val,eaptr);
	return retval;
}

ushort *
_imm_ea(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *eaptr;
	register ushort val;

	val = *(opcode+1);
	eaptr = getea2(&opcode,opprint);
	sprintf(buf,"%s\t#0x%x,%s",opstring,val,eaptr);
	return (opcode+1);
}

ushort *
_imm_sz_ea(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *eaptr;
	register ushort val;
	register char *szptr;

	val = ((*opcode) >> 9) & 0x7;
	val = (val ? val : 8);
	szptr = SZCHAR(*opcode);
	eaptr = getea1(&opcode,opprint);
	sprintf(buf,"%s%s\t#0x%x,%s",opstring,szptr,val,eaptr);
	return (opcode+1);
}

ushort *
_lim_ea(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register int dest,src;

	dest = ((*opcode) >> 9) & 0x7;
	src = (*opcode) & 0x7;
	if ((*opcode) & 0x8)
		sprintf(buf,"%s\t-%s@,-%s@",opstring,areg[src],areg[dest]);
	else
		sprintf(buf,"%s\t%s,%s",opstring,dreg[src],dreg[dest]);
	return (opcode+1);
}

local char movebuf[255];

ushort *
_move(opcode,opstring,buf,opprint)
register ushort *opcode;
char *opstring;
char *buf;
char *(*opprint)();
{
	register char *bufptr;
	ushort *tmpptr, val;
	register int offset;
	ushort tmpbuf[3];

	tmpptr = tmpbuf;
	val = *opcode;
	tmpbuf[0] = (val & 0x3f) | ((val & 0x3000) >> 6);
				/* map this size rep to usual ea size rep */
	if ((tmpbuf[0] & 0x00c0) == 0x00c0)
		tmpbuf[0] &= 0xff7f;	
	tmpbuf[1] = *(opcode+1);
	tmpbuf[2] = *(opcode+2);
	bufptr = getea1(&tmpptr,opprint);
	strcpy(movebuf,bufptr);
	offset = tmpptr - tmpbuf;
	tmpptr = tmpbuf;
	tmpbuf[0] = ((val & 0x3000) >> 6) | ((val & 0x0e00) >> 9)
			| ((val & 0x01c0) >> 3);
	if ((tmpbuf[0] & 0x00c0) == 0x00c0)
		tmpbuf[0] &= 0xff7f;
	tmpbuf[1] = *(opcode+offset+1);
	tmpbuf[2] = *(opcode+offset+2);
	bufptr = getea1(&tmpptr,opprint);
	sprintf(buf,"%s\t%s,%s",opstring,movebuf,bufptr);
	return (opcode + offset + (tmpptr - tmpbuf) + 1);
}

ushort *
_movem(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{

	register int val;
	register char *eaptr;

	val = *(opcode+1);
	strcpy(movebuf,opstring);
	if (*opcode & 0x0040)
		strcat(movebuf,"l");
	else
		strcat(movebuf,"w");
	if (*opcode & 0x0400)
	{
		eaptr = getea2(&opcode,opprint);
		sprintf(buf,"%s\t%s,0x%x",movebuf,eaptr,val);
	}
	else
	{
		eaptr = getea2(&opcode,opprint);
		sprintf(buf,"%s\t0x%x,%s",movebuf,val,eaptr);
	}
	return (opcode+1);
}

ushort *
_movep(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *arptr, *drptr; 
	register int val;

	drptr = DREGOFF(*opcode);
	arptr = areg[(*opcode) & 0x3];
	val = *(opcode+1);
	strcpy(movebuf,opstring);
	if (*opcode & 0x0040)
		strcat(movebuf,"l");
	else
		strcat(movebuf,"w");
	if (*opcode & 0x0080)
		sprintf(buf,"%s\t%s,0x%x(%s)",movebuf,drptr,arptr);
	else
		sprintf(buf,"%s\t0x%x(%s),%s",movebuf,arptr,drptr);
	return (opcode+2);
}

ushort *
_moveq(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *drptr; 
	register int val;

	drptr = DREGOFF(*opcode);
	val = (*opcode) & 0xff;
	sprintf(buf,"%s\t#0x%x,%s",opstring,val,drptr);
	return (opcode+1);
}

ushort *
_mover(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *eaptr;
	register char *spec;
	register int val;

	val = *opcode & 0x0600; 
	if (val == 0x0600 || val == 0)
		spec = "sr";
	else
		spec = "ccr";
	sizekludge++;
	eaptr = getea1(&opcode,opprint);
	sizekludge= 0;
	if (val & 0x0400)
		sprintf(buf,"%s\t%s,%s",opstring,eaptr,spec);
	else
		sprintf(buf,"%s\t%s,%s",opstring,spec,eaptr);
	return (opcode+1);
}

ushort *
_mvusp(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *arptr;

	arptr = areg[*opcode & 0x3];
	if (*opcode & 0x0008)
		sprintf(buf,"%s\t%s,%s",opstring,"usp",arptr);
	else
		sprintf(buf,"%s\t%s,%s",opstring,arptr,"usp");
	return (opcode+1);
}

ushort *
_noop(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	sprintf(buf,"%s",opstring);
	return (opcode+1);
}

ushort *
_scc(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *ccptr, *eaptr;

	ccptr = cctab[((*opcode) >> 8) & 0xf];
	eaptr = getea1(&opcode,opprint);
	sprintf(buf,"%s%s\t%s,%s",opstring,ccptr,eaptr);
	return (opcode+1);
}

ushort *
_sh_dr(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *regptr, *szptr, *drptr, *ptr;
	register int count;

	drptr = ((*opcode) & 0x0100 ? "l" : "r");
	szptr = SZCHAR(*opcode);
	regptr = dreg[(*opcode) & 0x7];
	if ((*opcode) & 0x0020)
		sprintf(buf,"%s%s%s\t%s,%s",opstring,drptr,szptr,
					dreg[((*opcode) >> 9) & 0x7],regptr);
	else
	{
		count = ((*opcode) >> 9) & 0x7;
		if (count == 0)
			count = 8;
		sprintf(buf,"%s%s%s\t#0x%x,%s",opstring,drptr,szptr,
					count,regptr);
	}
	return (opcode+1);
}

ushort *
_shmem(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *drptr, *eaptr;

	drptr = ((*opcode) & 0x0100 ? "l" : "r");
	eaptr = getea1(&opcode,opprint);
	sprintf(buf,"%s%s\t%s",opstring,drptr,eaptr);
	return (opcode+1);
}

ushort *
_sz_ea(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	register char *eaptr;
	register char *szptr;

	szptr = SZCHAR(*opcode);
	eaptr = getea1(&opcode,opprint);
	sprintf(buf,"%s%s\t%s",opstring,szptr,eaptr);
	return (opcode+1);
}

ushort *
_trap(opcode,opstring,buf,opprint)
ushort *opcode;
char *opstring;
char * buf;
char * (*opprint)();
{
	sprintf(buf,"%s\t#0x%x",opstring,((*opcode) & 0x0f));
	return (opcode+1);
}
#define STANDALONE
