/* tstrap.s: First block on a bootable tape */
/*
 * This strap goes in front of the /boot image.
 * This strap loads the rest of the tape file
 * starting at location 0x300000.  It then looks at the header and
 * It then branches to location 0x300020 which is the entry point
 * to /boot.
 * This code should be written to run anywhere.
 *
 * On entry the register look as follows:
 *	d0-d1-d2	scsi cdb to read from current tape in .5k blks
 *
 */

	.set	SCSIADDR,0xfffe4000		/* location of WD33C93 */
	.set	SCSIDATA,SCSIADDR+1
	.set	SCSIPICR,0xfffe102a
	.set	BOOTLOC, 0

	movw	#0x2700,sr		/* turn off interrupts */
	movl	#0x300000,sp		/* where our stack is located */
	movl	#BOOTLOC,d5		/* into bootstrap location */
1:
	bsr	scsiio
	addl	#512,d5			/* place to put next block */
	cmpb	#0x85,d7		/* target disconnect */
	beqs	1b			/*  if target disc - do again */
	jmp	BOOTLOC			/* yes, branch to it! */



/*
 * scsiio: do scsi io.
 *
 *	d0 = cdb0-3
 *	d1 = cdb4-7
 *	d2 = cdb8-11
 *	d3 = transfer length in bytes
 *	d4 = destination id
 *	d5 = data address
 *  on return
 *	d6 = scsi bus status
 *	d7 = chip status
 */

scsiio:
	movl	a0,sp@-
	movb	#1,SCSIADDR
	movb	#4,SCSIDATA		/* dma mode 4, int on disconn */
	movb	#62,SCSIDATA		/* time out - 500ms */

	/* load the 12 bytes of cdb into the chip */

	movl	#2,d7		/* register counter */
1:
	movl	#3,d6		/* byte counter */
2:
	roll	#8,d0
	movb	d0,SCSIDATA
	dbra	d6, 2b

	exg	d0,d1
	exg	d1,d2
	dbra	d7, 1b

	movb	#0,SCSIDATA	/* target unit */
	movb	#0,SCSIDATA	/* command phase */
	movb	#0,SCSIDATA	/* sync transfer */

	/* load transfer count */

	movl	#2, d6
	rorl	#8, d3		/* get byte 1 into position */
	rorl	#8, d3
1:
	movb	d3,SCSIDATA
	roll	#8, d3
	dbra	d6, 1b
	rorl	#8, d3		/* get back as it was */

	movb	d4, SCSIDATA	/* destination id */
	movb	#7, SCSIDATA	/* source id -reconnect */
	movb	#0, SCSIDATA	/* scsi status -- no op to bump pointer */
	bsr	delay		/* can't touch command too soon */
	movb	#9, SCSIDATA	/* command */

	/* watch the aux status and xfer the data */

	movl	d5, a0		/* set up the data pointer */
	movl	d3, d6		/* set counter */
2:
	movb	SCSIADDR, d7	/* let's have a look at the status */
	btst	#0,d7		/* do we need to move some data? */
	beqs	1f		/* no, next check */
	tstl	d6		/* do we owe him any more bytes? */
	bles	1f		/* no, next check */
	movb	#0x19,SCSIADDR	/* we just want to use the data reg */
	movb	SCSIDATA,a0@+	/* stash byte */
	subl	#1, d6		/* decrement counter */
1:
	btst	#7,SCSIADDR	/* interrupt happen? */
	beqs	1f		/* no, keep looking */
	movb	#0x17, SCSIADDR	/* let's have a look at the chip status */
	movb	SCSIDATA, d7	/* we need to keep a copy in case we leave */
	cmpb	#0x16, d7	/* ignore select-and-transfer completes */
	bnes	2f		/* anything else, bail out */
	nop			/* debugging--break point */
1:
	bras	2b		/* no, do it all again */
2:
	movb	#0x0f,SCSIADDR	/* fetch the scsi status byte */
	movb	SCSIDATA,d6
	movl	sp@+,a0
	rts


	.set	TIMERCR, 0xfffe101b
	.set	TIMERPRL, 0xfffe1014

delay:
	movb	#0, TIMERCR
	movw	#0-2,TIMERPRL
	movb	#07, TIMERCR
1:
	btst	#4, TIMERCR
	beqs	1b
	movb	#0, TIMERCR
	rts
