/* rom.s: Working copy: rom unix boot */
/*
 *	This will live in the timekeeper chip and is ferreted out by
 * 	the Mot boot rom.  Later, it may live in the real rom
 *	It's job is to find something to boot.  It first looks at
 *	the tape device (scsi id four).  If no unit is ready there
 *	it goes to the disc (scsi id zero).
 *	When is has found a ready device, it loads the first 512 byte block
 *	into memory and checks for the magic number 0407.  If no number
 *	is found it increments the scsi id by one and keeps looking.
 *	When the scsi number reaches 7 it starts at zero again. (We are
 *	seven.)
 *
 */


	.set	SCSIADDR,0xfffe4000		/* location of WD33C93 */
	.set	SCSIDATA,SCSIADDR+1
	.set	SCSIPICR,0xfffe102a

	.set	BOOTLOC, 0x300000
/*
 * Header for mvme147 romboot function
 */

top:
	.ascii	"BOOT"			/* magic number for 147bug */
	.long	start-top		/* entry point offset */
	.long	bottom-top		/* size of code */

start:
	bra	1f
scsientry:
	bra	scsiio
	/* reset the scsi bus */
1:
	movb	#0x10,SCSIPICR		/* port interrupt control reg */
	movl	#50,d0
1:
	bsr	delay
	dbra	d0,1b			/* wait for everything to settle */
	movb	#0,SCSIPICR		/* clear reset bit */
	movl	#50,d0
1:
	bsr	delay
	dbra	d0,1b

/*
 *	Reset the scsi bus
 */
init:

	movb	#0,SCSIADDR
	movb	#0x7,SCSIDATA		/* set own id to 7, no par, 10MHz */
	movb	#0x18,SCSIADDR
	bsr	delay
	clrb	SCSIDATA		/* reset command */
	bsr	delay
1:
	btst	#7,SCSIADDR		/* watch the int bit */
	beqs	1b			/* loop while it is zero */
	movb	#0x17,SCSIADDR
	movb	SCSIDATA,d0		/* Clear the int bit */
1:
	btst	#7,SCSIADDR		/* Watch to see the bit clear */
	bnes	1b

/*
 *	Test unit ready
 */
unit_ready:		/* find something to boot */
	clrl	d0
	clrl	d1
	clrl	d2
	clrl	d3
	clrl	d4
/*	movb	#4,d4*/
	movb	#0,d4
1:
	bsr	scsiio
	bsr	scsiio			/* try twice */
	cmpb	#0x42,d7		/* that that time out? */
	bnes	1f			/* a drive is there, is it ready? */
2:
	movb	#0,d4			/* Tape wasn't ready-try disc */
	bra	1b
again:
1:
	andl	#036,d6			/* did we get a check condition? */
	beqs	1f			/* no, must be readalbe */
	bra	2b			/* yes, try again later */

1:

/*
 *	Read the first block into memory
 */

	movl	#0x08000000,d0		/* set up for disc load */
	tstb	d4			/* is this a tape read? */
	beqs	1f			/* skip if not */
	movl	#0x08010000,d0		/* else set up for tape */
1:
	movl	#0x01000000,d1		/* one block */
	clrl	d2
	movl	#0x200,d3		/* read 512 bytes */
	movl	#BOOTLOC,d5		/* into bootstrap location */
	bsr	scsiio
	cmpw	#0407,BOOTLOC+2		/* Is that a magic number? */
	beqs	1f
	movb	#0,d4			/* try the disc now */
	bnes	again			/*  no, do it all again */
1:
	jmp	BOOTLOC+0x20


/*
 * scsiio: do scsi io.
 *
 *	d0 = cdb0-3
 *	d1 = cdb4-7
 *	d2 = cdb8-11
 *	d3 = transfer length in bytes
 *	d4 = destination id
 *	d5 = data address
 *  on return
 *	d6 = scsi bus status
 *	d7 = chip status
 */

scsiio:
	movl	a0,sp@-
	movb	#1,SCSIADDR
	movb	#4,SCSIDATA		/* dma mode 4, int on disconn */
	movb	#62,SCSIDATA		/* time out - 500ms */

	/* load the 12 bytes of cdb into the chip */

	movl	#2,d7		/* register counter */
1:
	movl	#3,d6		/* byte counter */
2:
	roll	#8,d0
	movb	d0,SCSIDATA
	dbra	d6, 2b

	exg	d0,d1
	exg	d1,d2
	dbra	d7, 1b

	movb	#0,SCSIDATA	/* target unit */
	movb	#0,SCSIDATA	/* command phase */
	movb	#0,SCSIDATA	/* sync transfer */

	/* load transfer count */

	movl	#2, d6
	rorl	#8, d3		/* get byte 1 into position */
	rorl	#8, d3
1:
	movb	d3,SCSIDATA
	roll	#8, d3
	dbra	d6, 1b
	rorl	#8, d3		/* get back as it was */

	movb	d4, SCSIDATA	/* destination id */
	movb	#7, SCSIDATA	/* source id -reconnect */
	movb	#0, SCSIDATA	/* scsi status -- no op to bump pointer */
	bsr	delay		/* can't touch command too soon */
	movb	#9, SCSIDATA	/* command */

	/* watch the aux status and xfer the data */

	movl	d5, a0		/* set up the data pointer */
	movl	d3, d6		/* set counter */
2:
	movb	SCSIADDR, d7	/* let's have a look at the status */
	btst	#0,d7		/* do we need to move some data? */
	beqs	1f		/* no, next check */
	tstl	d6		/* do we owe him any more bytes? */
	bles	1f		/* no, next check */
	movb	#0x19,SCSIADDR	/* we just want to use the data reg */
	movb	SCSIDATA,a0@+	/* stash byte */
	subl	#1, d6		/* decrement counter */
1:
	btst	#7,SCSIADDR	/* interrupt happen? */
	beqs	1f		/* no, keep looking */
	movb	#0x17, SCSIADDR	/* let's have a look at the chip status */
	movb	SCSIDATA, d7	/* we need to keep a copy in case we leave */
	cmpb	#0x85,d7	/* was it a disconnect ? */
	beqs	2f		/* yes, let's get out of here! */
1:
	bras	2b		/* no, do it all again */
2:
	movb	#0x0f,SCSIADDR	/* fetch the scsi status byte */
	movb	SCSIDATA,d6
	movl	sp@+,a0
	rts


	.set	TIMERCR, 0xfffe101b
	.set	TIMERPRL, 0xfffe1014

delay:
	movb	#0, TIMERCR
	movw	#0-2,TIMERPRL
	movb	#07, TIMERCR
1:
	btst	#4, TIMERCR
	beqs	1b
	movb	#0, TIMERCR
	rts

	.align	1
chksum:	.word	0			/* where the check sum goes */
bottom:	.word	0			/* some Mot junk */
