/*
 *	The typedef type is an enum used to store the type of a symbol.
 */

typedef enum {
	UNDEFINED,	SCALAR,		ARRAY,		FUNCTION
} type;


/*
 *	The typedef func is a struct used to hold all the information
 *	about a function definition.
 */

typedef struct {
	code	*body;		/* body of function */
	int	nparams;	/* number of parameters */
	int	nautos;		/* number of auto variables */
	int	fcsize;		/* size of function body */
	type	*types;		/* vector of parameter and auto types */
} func;


/*
 *	The typedef globalv is a union used to store the global value of
 *	a symbol.
 */

typedef union {
	array	arvalue;
	rvalue	rvalue;
	func	fvalue;
}	globalv;


/*
 *	The typedef dicent is a struct used to maintain a string table which
 *	contains all identifiers ever seen.
 */

typedef struct dicent {
	struct dicent *left, *right;
	type	globalt, localt;	/* global and local type */
	globalv	globalv;
	int	localv;			/* frame pointer offset */
	char	word[];
} dicent;
