/*
 * Opcode table.
 */
#ifdef   vax
#include	"INC$LIB:cc2.h"
#else
#include	"cc2.h"
#endif

/*
 * Opcode table.
 * Indexed by opcode number, as defined in header file h/i8086/opcode.h.
 * Contains the number of address expressions,
 * the opcode and the basic format (style) of each instruction.
 * This table is parallel to the table in cc3/i8086/icode.c
 * and to the definitions of machine ops in h/i8086/opcode.h;
 * modifications must be made in parallel.
 */
OPINFO	opinfo[]		= {
	/* aaa */		0,	0,		0x37,	OF_INH,
	/* aad */		0,	0,		0xD5,	OF_INH2,
	/* aam */		0,	0,		0xD4,	OF_INH2,
	/* aas */		0,	0,		0x3F,	OF_INH,
	/* adc */		2,	0,		0x11,	OF_DOPS,
	/* adcb */		2,	OP_BYTE,	0x10,	OF_DOP,
	/* add */		2,	0,		0x01,	OF_DOPS,
	/* addb */		2,	OP_BYTE,	0x00,	OF_DOP,
	/* and */		2,	0,		0x21,	OF_DOP,
	/* andb */		2,	OP_BYTE,	0x20,	OF_DOP,
	/* call */		1,	OP_NPTR,	0xE8,	OF_CALL,
	/* cbw */		0,	0,		0x98,	OF_INH,
	/* clc */		0,	0,		0xF8,	OF_INH,
	/* cld */		0,	0,		0xFC,	OF_INH,
	/* cli */		0,	0,		0xFA,	OF_INH,
	/* cmc */		0,	0,		0xF5,	OF_INH,
	/* cmp */		2,	0,		0x39,	OF_DOPS,
	/* cmpb */		2,	OP_BYTE,	0x38,	OF_DOP,
	/* cmpsw */		0,	0,		0xA7,	OF_INH,
	/* cmpsb */		0,	0,		0xA6,	OF_INH,
	/* cwd */		0,	0,		0x99,	OF_INH,
	/* daa */		0,	0,		0x27,	OF_INH,
	/* das */		0,	0,		0x2F,	OF_INH,
	/* dec */		1,	0,		0x09,	OF_SOP,
	/* decb */		1,	OP_BYTE,	0x08,	OF_SOP,
	/* div */		1,	0,		0x31,	OF_MUL,
	/* divb */		1,	OP_BYTE,	0x30,	OF_MUL,
	/* hlt */		0,	0,		0xF4,	OF_INH,
#if AS_FORMAT
	/* icall */		1,	0,		0x10,	OF_ICALL,
#else
	/* call */		1,	0,		0x10,	OF_ICALL,
#endif
	/* idiv */		1,	0,		0x39,	OF_MUL,
	/* idivb */		1,	OP_BYTE,	0x38,	OF_MUL,
#if AS_FORMAT
	/* ijmp */		1,	0,		0x20,	OF_ICALL,
#else
	/* jmp */		1,	0,		0x20,	OF_ICALL,
#endif
	/* imul */		1,	0,		0x29,	OF_MUL,
	/* imulb */		1,	OP_BYTE,	0x28,	OF_MUL,
	/* in */		1,	0,		0xE5,	OF_IN,
	/* inb */		1,	OP_BYTE,	0xE4,	OF_IN,
	/* inc */		1,	0,		0x01,	OF_SOP,
	/* incb */		1,	OP_BYTE,	0x00,	OF_SOP,
	/* int */		1,	OP_NPTR,	0xCD,	OF_INT,
	/* into */		0,	0,		0xCE,	OF_INH,
	/* iret */		0,	0,		0xCF,	OF_INH,
#if AS_FORMAT
	/* xicall */		1,	OP_DWORD,	0x18,	OF_ICALL,
	/* xijmp */		1,	OP_NPTR,	0x28,	OF_ICALL,
#else
	/* call */		1,	OP_DWORD,	0x18,	OF_ICALL,
	/* jmp */		1,	OP_NPTR,	0x28,	OF_ICALL,
#endif
	/* ja */		1,	OP_JUMP,	0x77,	OF_JMP,
	/* jae */		1,	OP_JUMP,	0x73,	OF_JMP,
	/* jb */		1,	OP_JUMP,	0x72,	OF_JMP,
	/* jbe */		1,	OP_JUMP,	0x76,	OF_JMP,
	/* jcxz */		1,	OP_JUMP,	0xE3,	OF_REL,
	/* je */		1,	OP_JUMP,	0x74,	OF_JMP,
	/* jg */		1,	OP_JUMP,	0x7F,	OF_JMP,
	/* jge */		1,	OP_JUMP,	0x7D,	OF_JMP,
	/* jl */		1,	OP_JUMP,	0x7C,	OF_JMP,
	/* jle */		1,	OP_JUMP,	0x7E,	OF_JMP,
	/* jmp */		1,	OP_JUMP,	0xEB,	OF_JMP,
	/* jne */		1,	OP_JUMP,	0x75,	OF_JMP,
	/* jno */		1,	OP_JUMP,	0x71,	OF_JMP,
	/* jns */		1,	OP_JUMP,	0x79,	OF_JMP,
	/* jo */		1,	OP_JUMP,	0x70,	OF_JMP,
	/* jpe */		1,	OP_JUMP,	0x7A,	OF_JMP,
	/* jpo */		1,	OP_JUMP,	0x7B,	OF_JMP,
	/* js */		1,	OP_JUMP,	0x78,	OF_JMP,
	/* lahf */		0,	0,		0x9F,	OF_INH,
	/* lds */		2,	OP_DWORD,	0xC5,	OF_LEA,
	/* lea */		2,	0,		0x8D,	OF_LEA,
	/* les */		2,	OP_DWORD,	0xC4,	OF_LEA,
	/* lock */		0,	0,		0xF0,	OF_INH,
	/* lodsw */		0,	0,		0xAD,	OF_INH,
	/* lodsb */		0,	0,		0xAC,	OF_INH,
	/* loop */		1,	OP_JUMP,	0xE2,	OF_REL,
	/* loope */		1,	OP_JUMP,	0xE1,	OF_REL,
	/* loopne */		1,	OP_JUMP,	0xE0,	OF_REL,
	/* mov */		2,	0,		0x89,	OF_MOV,
	/* movb */		2,	OP_BYTE,	0x88,	OF_MOV,
	/* movsw */		0,	0,		0xA5,	OF_INH,
	/* movsb */		0,	0,		0xA4,	OF_INH,
	/* mul */		1,	0,		0x21,	OF_MUL,
	/* mulb */		1,	OP_BYTE,	0x20,	OF_MUL,
	/* neg */		1,	0,		0x19,	OF_SOP,
	/* negb */		1,	OP_BYTE,	0x18,	OF_SOP,
	/* not */		1,	0,		0x11,	OF_SOP,
	/* notb */		1,	OP_BYTE,	0x10,	OF_SOP,
	/* ret */		1,	OP_NPTR,	0xC2,	OF_NRET,
	/* ret */		1,	OP_NPTR,	0xCB,	OF_NRET,
	/* or */		2,	0,		0x09,	OF_DOP,
	/* orb */		2,	OP_BYTE,	0x08,	OF_DOP,
	/* out */		1,	0,		0xE7,	OF_OUT,
	/* outb */		1,	OP_BYTE,	0xE6,	OF_OUT,
	/* pop */		1,	0,		0x8F,	OF_POP,
	/* popf */		0,	0,		0x9D,	OF_INH,
	/* push */		1,	0,		0xFF,	OF_PUSH,
	/* pushf */		0,	0,		0x9C,	OF_INH,
	/* rcl */		2,	0,		0x11,	OF_SHR,
	/* rclb */		2,	OP_BYTE,	0x10,	OF_SHR,
	/* rcr */		2,	0,		0x19,	OF_SHR,
	/* rcrb */		2,	OP_BYTE,	0x18,	OF_SHR,
	/* repe */		0,	0,		0xF3,	OF_INH,
	/* repne */		0,	0,		0xF2,	OF_INH,
	/* ret */		0,	0,		0xC3,	OF_INH,
	/* rol */		2,	0,		0x01,	OF_SHR,
	/* rolb */		2,	OP_BYTE,	0x00,	OF_SHR,
	/* ror */		2,	0,		0x09,	OF_SHR,
	/* rorb */		2,	OP_BYTE,	0x08,	OF_SHR,
	/* sahf */		0,	0,		0x9E,	OF_INH,
	/* sal */		2,	0,		0x21,	OF_SHR,
	/* salb */		2,	OP_BYTE,	0x20,	OF_SHR,
	/* sar */		2,	0,		0x39,	OF_SHR,
	/* sarb */		2,	OP_BYTE,	0x38,	OF_SHR,
	/* sbb */		2,	0,		0x19,	OF_DOPS,
	/* sbbb */		2,	OP_BYTE,	0x18,	OF_DOP,
	/* scasw */		0,	0,		0xAF,	OF_INH,
	/* scasb */		0,	0,		0xAE,	OF_INH,
	/* shl */		2,	0,		0x21,	OF_SHR,
	/* shlb */		2,	OP_BYTE,	0x20,	OF_SHR,
	/* shr */		2,	0,		0x29,	OF_SHR,
	/* shrb */		2,	OP_BYTE,	0x28,	OF_SHR,
	/* stc */		0,	0,		0xF9,	OF_INH,
	/* std */		0,	0,		0xFD,	OF_INH,
	/* sti */		0,	0,		0xFB,	OF_INH,
	/* stosw */		0,	0,		0xAB,	OF_INH,
	/* stosb */		0,	0,		0xAA,	OF_INH,
	/* sub */		2,	0,		0x29,	OF_DOPS,
	/* subb */		2,	OP_BYTE,	0x28,	OF_DOP,
	/* test */		2,	0,		0x85,	OF_DOP,
	/* testb */		2,	OP_BYTE,	0x84,	OF_DOP,
	/* wait */		0,	0,		0x9B,	OF_INH,
#if AS_FORMAT
	/* xcall */		1,	OP_NPTR,	0x9A,	OF_XCALL,
#else
	/* call */		1,	OP_NPTR,	0x9A,	OF_XCALL,
#endif
	/* xchg */		2,	0,		0x87,	OF_DOP,
	/* xchgb */		2,	OP_BYTE,	0x86,	OF_DOP,
#if AS_FORMAT
	/* xjmp */		1,	OP_NPTR,	0xEA,	OF_XCALL,
#else
	/* jmp */		1,	OP_NPTR,	0xEA,	OF_XCALL,
#endif
	/* xlat */		0,	0,		0xD7,	OF_INH,
	/* xor */		2,	0,		0x31,	OF_DOP,
	/* xorb */		2,	OP_BYTE,	0x30,	OF_DOP,
#if AS_FORMAT
	/* xret */		0,	0,		0xCB,	OF_INH,
#else
	/* ret */		0,	0,		0xCB,	OF_INH,
#endif

#if AS_FORMAT
	/* .byte */		1,	OP_DD|OP_NPTR,	0x00,	OF_BYTE,
	/* .word */		1,	OP_DD|OP_NPTR,	0x00,	OF_WORD,
	/* .word */		1,	OP_DD|OP_NPTR,	0x00,	OF_LPTR,
	/* .long */		1,	OP_DD|OP_NPTR,	0x00,	OF_GPTR,
#else
	/* db */		1,	OP_DD|OP_NPTR,	0x00,	OF_BYTE,
	/* dw */		1,	OP_DD|OP_NPTR,	0x00,	OF_WORD,
	/* dw */		1,	OP_DD|OP_NPTR,	0x00,	OF_LPTR,
	/* dd */		1,	OP_DD|OP_NPTR,	0x00,	OF_GPTR,
#endif

	/* fadd */		0,	0,		0xC1,	OF_FDE,
	/* faddf */		1,	0,		0x00,	OF_FRM,
	/* faddd */		1,	0,		0x04,	OF_FRM,
	/* faddi */		1,	0,		0x06,	OF_FRM,
	/* faddl */		1,	0,		0x02,	OF_FRM,
	/* fsub */		0,	0,		0xE1,	OF_FDE,
	/* fsubf */		1,	0,		0x20,	OF_FRM,
	/* fsubd */		1,	0,		0x24,	OF_FRM,
	/* fsubi */		1,	0,		0x26,	OF_FRM,
	/* fsubl */		1,	0,		0x22,	OF_FRM,
	/* frsub */		0,	0,		0xE9,	OF_FDE,
	/* frsubf */		1,	0,		0x28,	OF_FRM,
	/* frsubd */		1,	0,		0x2C,	OF_FRM,
	/* frsubi */		1,	0,		0x2E,	OF_FRM,
	/* frsubl */		1,	0,		0x2A,	OF_FRM,
	/* fcompp */		0,	0,		0xD9,	OF_FDE,
	/* fcompf */		1,	0,		0x18,	OF_FRM,
	/* fcompd */		1,	0,		0x1C,	OF_FRM,
	/* fcompi */		1,	0,		0x1E,	OF_FRM,
	/* fcompl */		1,	0,		0x1A,	OF_FRM,
	/* fmul */		0,	0,		0xC9,	OF_FDE,
	/* fmulf */		1,	0,		0x08,	OF_FRM,
	/* fmuld */		1,	0,		0x0C,	OF_FRM,
	/* fmuli */		1,	0,		0x0E,	OF_FRM,
	/* fmull */		1,	0,		0x0A,	OF_FRM,
	/* fdiv */		0,	0,		0xF1,	OF_FDE,
	/* fdivf */		1,	0,		0x30,	OF_FRM,
	/* fdivd */		1,	0,		0x34,	OF_FRM,
	/* fdivi */		1,	0,		0x36,	OF_FRM,
	/* fdivl */		1,	0,		0x32,	OF_FRM,
	/* frdiv */		0,	0,		0xF9,	OF_FDE,
	/* frdivf */		1,	0,		0x38,	OF_FRM,
	/* frdivd */		1,	0,		0x3C,	OF_FRM,
	/* frdivi */		1,	0,		0x3E,	OF_FRM,
	/* frdivl */		1,	0,		0x3A,	OF_FRM,
	/* fchs */		0,	0,		0xE0,	OF_FD9,
	/* ftst */		0,	0,		0xE4,	OF_FD9,
	/* fldz */		0,	0,		0xEE,	OF_FD9,
	/* fld1 */		0,	0,		0xE8,	OF_FD9,
	/* fstsw */		1,	0,		0x3D,	OF_FRM,
	/* fldf */		1,	0,		0x01,	OF_FRM,
	/* fldd */		1,	0,		0x05,	OF_FRM,
	/* fldi */		1,	0,		0x07,	OF_FRM,
	/* fldl */		1,	0,		0x03,	OF_FRM,
	/* fldt */		1,	0,		0x2B,	OF_FRM,
	/* fstf */		1,	0,		0x11,	OF_FRM,
	/* fstd */		1,	0,		0x15,	OF_FRM,
	/* fsti */		1,	0,		0x17,	OF_FRM,
	/* fstl */		1,	0,		0x13,	OF_FRM,
	/* fstpf */		1,	0,		0x19,	OF_FRM,
	/* fstpd */		1,	0,		0x1D,	OF_FRM,
	/* fstpi */		1,	0,		0x1F,	OF_FRM,
	/* fstpl */		1,	0,		0x1B,	OF_FRM,
	/* fstpt */		1,	0,		0x3B,	OF_FRM,
	/* fwait */		0,	0,		0x9B,	OF_FWAIT,
	/* fdrop */		0,	0,		0xD8,	OF_FDD,
	/* fsqrt */		0,	0,		0xFA,	OF_FD9,
	/* fabs */		0,	0,		0xE1,	OF_FD9,
	/* fprem */		0,	0,		0xF8,	OF_FD9,
	/* frnd */		0,	0,		0xFC,	OF_FD9,
 	/* ldes */		0,	0, 		0, 	0,
 	/* imul immediate */	3,	0,		0x69,	OF_MUL3,
 	/* enter */		2,	0,		0xC8,	OF_INH,
 	/* leave */		0,	0,		0xC9,	OF_INH
};
