/* (-lgl
 *	Coherent 386 release 4.2
 *	Copyright (c) 1982, 1993 by Mark Williams Company.
 *	All rights reserved. May not be copied without permission.
 *	For copying permission and licensing info, write licensing@mwc.com
 -lgl) */

#ifndef	__NETDB_H__
#define	__NETDB_H__

/*
 * Structure definitions and function prototypes for the socket interface
 * network name database routines.
 *
 * Coherent does not yet implement a kernel socket emulation; however, a
 * freely-redistributable socket emulation library includes implementations of
 * these routines for use in that emulation.
 */

#include <common/ccompat.h>

struct hostent {
	char	      *	h_name;		/* official name of host */
	char	     **	h_aliases;	/* alias list */
	int		h_addrtype;	/* host address type (eg, AF_INET) */
	int		h_length;	/* host address length */
	char	     **	h_addr_list;	/* list of network addresses */
};


/*
 * For compatibility with old Berkeley sources. Do not use!
 */

#define	h_addr		h_addr_list [0]


struct netent {
	char	      *	n_name;		/* official name of net */
	char	     **	n_aliases;	/* alias list */
	int		n_addrtype;	/* net address type (eg, AF_INET) */
	unsigned long	n_net;		/* network number */
};


struct protoent {
	char	      *	p_name;		/* official protocol name */
	char	     **	p_aliases;	/* alias list */
	int		p_proto;	/* protocol number */
};


struct servent {
	char	      *	s_name;		/* official service name */
	char	     **	s_aliases;	/* alias list */
	int		s_port;		/* port for service */
	char	      *	s_proto;	/* protocol for service */
};


/*
 * Error codes returned from gethostbyaddr () and gethostbyname () are left in
 * "h_errno".
 */

#define	HOST_NOT_FOUND	1
#define	TRY_AGAIN	2	/* DNS recoverable failure */
#define	NO_RECOVERY	3	/* DNS fatal lookup error */
#define	NO_DATA		4	/* DNS no matching data */
#define	NO_ADDRESS	NO_DATA

extern	int	h_errno;


__EXTERN_C_BEGIN__

struct hostent *
		gethostent	__PROTO ((void));
struct hostent *
		gethostbyaddr	__PROTO ((char * _addrp, int _len,
					 int _type));
struct hostent *
		gethostbyname	__PROTO ((char * _name));
void		sethostent	__PROTO ((int _stayopen));
void		endhostent	__PROTO ((void));

struct netent *	getnetend	__PROTO ((void));
struct netent *	getnetbyaddr	__PROTO ((unsigned long _net, int _type));
struct netent *	getnetbyname	__PROTO ((char * _name));
void		setnetent	__PROTO ((int _stayopen));
void		endhostent	__PROTO ((void));

struct protoent *
		getprotoent	__PROTO ((void));
struct protoent *
		getprotobynumber __PROTO ((int _proto));
struct protoent *
		getprotobyname	__PROTO ((char * _name));
void		setprotoent	__PROTO ((int _stayopen));
void		endprotoent	__PROTO ((void));

struct servent *
		getservent	__PROTO ((void));
struct servent *
		getservbyport	__PROTO ((int _port, char * _proto));
struct servent *
		getservbyname	__PROTO ((char * _name, char * _proto));
void		setservent	__PROTO ((int _stayopen));
void		endservent	__PROTO ((void));

__EXTERN_C_END__


/*
 * Standard pathnames for files used to implement each database.
 */

#define	_PATH_HOSTS		"/etc/hosts"
#define	_PATH_NETWORKS		"/etc/networks"
#define	_PATH_PROTOCOLS		"/etc/protocols"
#define	_PATH_SERVICES		"/etc/services"


/*
 * Hostnames have this fixed upper limit for binary compatibility. In actual
 * fact, this is not at all necessary, but applications typically use it to
 * blindly allocate buffers.
 */

#define	MAXHOSTNAMELEN		256

#endif	/* ! defined (__NETDB_H__) */

